/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import se.ericsson.cello.atm.atm.ImaLinkMo;
import se.ericsson.cello.atm.atm.fropxy.AetImaLinkMiCreateRsp;
import se.ericsson.cello.atm.atm.fropxy.AetImaLinkMiDeleteRsp;
import se.ericsson.cello.atm.atm.fropxy.AetImaLinkMiGetAttrRsp;
import se.ericsson.cello.atm.atm.fropxy.AetImaLinkMiGetPmCountersRsp;
import se.ericsson.cello.atm.atm.fropxy.AetImaLinkProxy;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.pdhsdhtrans.ImaLinkBuildIF;
import se.ericsson.cello.pdhsdhtrans.ImaReservable;
import se.ericsson.cello.transaction.Coordinator;

public class ImaLinkMoImpl
extends ManagedObjectBase
implements ImaLinkMo,
ImaLinkBuildIF {
    private static AetImaLinkProxy imaLinkProxy = AetImaLinkProxy.instance();
    private MoData data;
    private StringAttribute userLabel;
    private ReferenceAttribute uses;
    private IntegerAttribute imaLinkFroId;
    private static final int MO_DATA_REVISION_36 = 3600;
    private static final int MO_DATA_REVISION_LATEST = 3600;
    private static final String FRO_ID = "froId";
    private static final String IMALINK_PHYCLASS_1 = "se.ericsson.cello.pdhsdhtrans.T1PhysPathTermMoImpl";
    private static final String IMALINK_PHYCLASS_2 = "se.ericsson.cello.pdhsdhtrans.E1PhysPathTermMoImpl";
    private static final String IMALINK_PHYCLASS_3 = "se.ericsson.cello.pdhsdhtrans.J1PhysPathTermMoImpl";
    private static final String IMALINK_PHYCLASS_4 = "se.ericsson.cello.pdhsdhtrans.E1TtpMoImpl";
    private static final String IMALINK_PHYCLASS_5 = "se.ericsson.cello.pdhsdhtrans.T1TtpMoImpl";

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"ImaGroup");
        MoAttributeValidator.checkIdentity((String)"ImaLink", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"ImaLink", (int)128, (int)0);
        String[] stringArray = new String[]{new String(IMALINK_PHYCLASS_1), new String(IMALINK_PHYCLASS_2), new String(IMALINK_PHYCLASS_3), new String(IMALINK_PHYCLASS_4), new String(IMALINK_PHYCLASS_5)};
        ManagedObject managedObject2 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"uses", (AttrList)attrList, (boolean)true, (String[])stringArray, (String)"ImaLink");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"ImaLink");
        return new ImaLinkMoImpl(managedObject, string, string2, managedObject2, coordinator);
    }

    private ImaLinkMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "ImaLink", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.uses = new ReferenceAttribute("uses", false, managedObject2);
        this.data.registerPersistentAttr((Attribute)this.uses);
        int n = 0;
        if (managedObject2 instanceof ImaReservable) {
            n = ((ImaReservable)managedObject2).getFroId(coordinator);
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        int n2 = this.createImaLinkFro(coordinator, n);
        this.imaLinkFroId = new IntegerAttribute(FRO_ID, false, n2);
        this.data.registerPersistentAttr((Attribute)this.imaLinkFroId);
        this.data.setRevision(3600);
        imaLinkProxy.registerForNotifications(coordinator, this, this.imaLinkFroId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public ImaLinkMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3600);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("uses");
        moDataRecoveryHelper.assertAttribute(FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.uses = (ReferenceAttribute)moData.getAttribute("uses");
        this.imaLinkFroId = (IntegerAttribute)moData.getAttribute(FRO_ID);
        imaLinkProxy.registerForNotifications(null, this, this.imaLinkFroId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject managedObject = this.uses.getValue(coordinator);
        ((ImaReservable)managedObject).release((ManagedObject)this, coordinator);
        imaLinkProxy.deregisterForNotifications(coordinator, this.imaLinkFroId.getValue(coordinator));
        AetImaLinkMiDeleteRsp aetImaLinkMiDeleteRsp = imaLinkProxy.sendDeleteReq(coordinator.getTransactionID(), this.imaLinkFroId.getValue(coordinator));
        if (aetImaLinkMiDeleteRsp == null) {
            throw new FroNotAccessibleException("ImaLink", "ImaLink");
        }
        if (aetImaLinkMiDeleteRsp.getResult() != 0) {
            throw new FroRequestFailedException("ImaLink", "ImaLink", "DeleteFroReq: " + imaLinkProxy.getResultMsg(aetImaLinkMiDeleteRsp.getResult()), aetImaLinkMiDeleteRsp.getResult());
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        AetImaLinkMiGetAttrRsp aetImaLinkMiGetAttrRsp = this.getImaLinkAttributes(coordinator);
        return aetImaLinkMiGetAttrRsp.getOperationalState();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        AetImaLinkMiGetAttrRsp aetImaLinkMiGetAttrRsp = this.getImaLinkAttributes(coordinator);
        return AvailConverter.convert((int)aetImaLinkMiGetAttrRsp.getAvailabilityStatus());
    }

    public int getImaLinkFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.imaLinkFroId.getValue(coordinator);
    }

    public int getPmIvIma(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmIvIma();
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"ImaLink", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getPmOifIma(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmOifIma();
    }

    public int getPmSesIma(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmSesIma();
    }

    public int getPmSesImaFe(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmSesImaFe();
    }

    public int getPmUasIma(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmUasIma();
    }

    public int getPmUasImaFe(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmUasImaFe();
    }

    public int getPmTxUusIma(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmTxUusIma();
    }

    public int getPmRxUusIma(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmRxUusIma();
    }

    public int getPmTxUusImaFe(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmTxUusImaFe();
    }

    public int getPmRxUusImaFe(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmRxUusImaFe();
    }

    public int getPmTxFc(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmTxFc();
    }

    public int getPmRxFc(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmRxFc();
    }

    public int getPmTxFcFe(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmTxFcFe();
    }

    public int getPmRxFcFe(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmRxFcFe();
    }

    public int getPmTxStuffIma(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmTxStuffIma();
    }

    public int getPmRxStuffIma(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = this.getImaLinkPmCounters(coordinator);
        return aetImaLinkMiGetPmCountersRsp.getPmRxStuffIma();
    }

    public ManagedObject getUses(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.uses.getValue(coordinator);
    }

    public String getType() {
        return "ImaLink";
    }

    private int createImaLinkFro(Coordinator coordinator, int n) throws MoAccessException {
        AetImaLinkMiCreateRsp aetImaLinkMiCreateRsp = imaLinkProxy.sendCreateReq(coordinator.getTransactionID(), n);
        if (aetImaLinkMiCreateRsp == null) {
            throw new FroNotAccessibleException("ImaLink", "ImaLink");
        }
        if (aetImaLinkMiCreateRsp.getResult() != 0) {
            throw new FroRequestFailedException("ImaLink", "ImaLink", "CreateFroReq: " + imaLinkProxy.getResultMsg(aetImaLinkMiCreateRsp.getResult()), aetImaLinkMiCreateRsp.getResult());
        }
        return aetImaLinkMiCreateRsp.getFroId();
    }

    private AetImaLinkMiGetAttrRsp getImaLinkAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetAttrRsp aetImaLinkMiGetAttrRsp = imaLinkProxy.sendGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.imaLinkFroId.getValue(coordinator));
        if (aetImaLinkMiGetAttrRsp == null) {
            throw new FroNotAccessibleException("ImaLink", "ImaLink");
        }
        if (aetImaLinkMiGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("ImaLink", "ImaLink", "GetAttrReq: " + imaLinkProxy.getResultMsg(aetImaLinkMiGetAttrRsp.getResult()), aetImaLinkMiGetAttrRsp.getResult());
        }
        return aetImaLinkMiGetAttrRsp;
    }

    private AetImaLinkMiGetPmCountersRsp getImaLinkPmCounters(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaLinkMiGetPmCountersRsp aetImaLinkMiGetPmCountersRsp = imaLinkProxy.sendGetPmCountersReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.imaLinkFroId.getValue(coordinator));
        if (aetImaLinkMiGetPmCountersRsp == null) {
            throw new FroNotAccessibleException("ImaLink", "ImaLink");
        }
        if (aetImaLinkMiGetPmCountersRsp.getResult() == 100) {
            aetImaLinkMiGetPmCountersRsp.setPmCountersUnavailable();
        } else if (aetImaLinkMiGetPmCountersRsp.getResult() != 0) {
            throw new FroRequestFailedException("ImaLink", "ImaLink", "GetPmCountersReq: " + imaLinkProxy.getResultMsg(aetImaLinkMiGetPmCountersRsp.getResult()), aetImaLinkMiGetPmCountersRsp.getResult());
        }
        return aetImaLinkMiGetPmCountersRsp;
    }
}

