/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import enea.ose.system.Signal;
import se.ericsson.cello.atm.atm.AlarmReport;
import se.ericsson.cello.atm.atm.AtmCounterMode;
import se.ericsson.cello.atm.atm.AtmNomPmBlkSize;
import se.ericsson.cello.atm.atm.VpcTpMo;
import se.ericsson.cello.atm.atm.VplTpMoImpl;
import se.ericsson.cello.atm.atm.fropxy.AetVpCepMiCreateFroRsp;
import se.ericsson.cello.atm.atm.fropxy.AetVpCepMiDeleteFroRsp;
import se.ericsson.cello.atm.atm.fropxy.AetVpCepMiEteLoopbackRsp;
import se.ericsson.cello.atm.atm.fropxy.AetVpCepMiGetAttrRsp;
import se.ericsson.cello.atm.atm.fropxy.AetVpCepMiGetPmCountersRsp;
import se.ericsson.cello.atm.atm.fropxy.AetVpCepMiProxy;
import se.ericsson.cello.atm.atm.fropxy.AetVpCepMiSetAttrRsp;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class VpcTpMoImpl
extends ManagedObjectBase
implements VpcTpMo {
    private MoData data;
    private StringAttribute userLabel;
    private IntegerAttribute vpcTpFroId;
    private AetVpCepMiProxy roProxy = AetVpCepMiProxy.instance();
    NotificationSender ns = NotificationSender.instance();
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_LATEST = 3000;
    private static final int ATTR_ALARM_MASK = 1;
    private static final int ATTR_CONTCHECK = 2;
    private static final int ATTR_COUNTERMODE = 4;
    private static final int ATTR_NOMPMBLKSIZE = 8;
    private static final int ALARM_REPORT_DEFAULT = 2;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"VpcTp", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"VplTp");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"VpcTp", (int)1);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"VpcTp", (int)128, (int)0);
        int n = VpcTpMoImpl.checkAndGetAlarmReport(attrList);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"continuityCheck", (AttrList)attrList, (boolean)false, (boolean)false, (String)"VpcTp");
        int n2 = VpcTpMoImpl.checkAndGetCounterMode(attrList);
        int n3 = VpcTpMoImpl.checkAndGetNomPmBlkSize(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"VpcTp");
        return new VpcTpMoImpl(managedObject, string, string2, n, bl, n2, n3, coordinator);
    }

    private VpcTpMoImpl(ManagedObject managedObject, String string, String string2, int n, boolean bl, int n2, int n3, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "VpcTp", string, coordinator);
        int n4 = ((VplTpMoImpl)managedObject).getFroId(coordinator);
        int n5 = MaoFroTypeConverter.boolean2int((boolean)bl);
        AetVpCepMiCreateFroRsp aetVpCepMiCreateFroRsp = this.roProxy.sendCreateFroReq(coordinator.getTransactionID(), n4, n, n5, n2, n3);
        this.checkSignal((Signal)aetVpCepMiCreateFroRsp);
        if (aetVpCepMiCreateFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("VpcTp", "VpCep", "CreateFroReq: " + this.roProxy.getResultMsg(aetVpCepMiCreateFroRsp.getResult()), aetVpCepMiCreateFroRsp.getResult());
        }
        this.initMoData(aetVpCepMiCreateFroRsp.getFroId(), string2, coordinator);
        this.roProxy.registerForNotifications(coordinator, this, aetVpCepMiCreateFroRsp.getFroId());
    }

    private void initMoData(int n, String string, Coordinator coordinator) throws MoAccessException {
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.setRevision(3000);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.vpcTpFroId = new IntegerAttribute("VpcTpId", false, n);
        this.data.registerPersistentAttr((Attribute)this.vpcTpFroId);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public VpcTpMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("VpcTpId");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.vpcTpFroId = (IntegerAttribute)moData.getAttribute("VpcTpId");
        this.roProxy.registerForNotifications(null, this, this.vpcTpFroId.getValue(null));
    }

    private void deleteVpcTpFro(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiDeleteFroRsp aetVpCepMiDeleteFroRsp = this.roProxy.sendDeleteFroReq(this.getVpcTpFroId(coordinator), coordinator.getTransactionID());
        this.checkSignal((Signal)aetVpCepMiDeleteFroRsp);
        int n = aetVpCepMiDeleteFroRsp.getResult();
        if (n != 0) {
            throw new FroRequestFailedException("VpcTp", "VpCep", "DeleteFroReq: " + this.roProxy.getResultMsg(aetVpCepMiDeleteFroRsp.getResult()), aetVpCepMiDeleteFroRsp.getResult());
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.roProxy.deregisterForNotifications(coordinator, this.vpcTpFroId.getValue(coordinator));
        this.deleteVpcTpFro(coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"VpcTp", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetVpCepMiGetAttrRsp aetVpCepMiGetAttrRsp = this.getFroAttributes(coordinator);
        return aetVpCepMiGetAttrRsp.getOperState();
    }

    public int getAlarmReport(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetVpCepMiGetAttrRsp aetVpCepMiGetAttrRsp = this.getFroAttributes(coordinator);
        return aetVpCepMiGetAttrRsp.getAlarmReport();
    }

    public void setAlarmReport(int n, Coordinator coordinator) throws MoAccessException {
        AetVpCepMiSetAttrRsp aetVpCepMiSetAttrRsp = this.setFroAttribute(1, n, "alarmReport", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetVpCepMiGetAttrRsp aetVpCepMiGetAttrRsp = this.getFroAttributes(coordinator);
        return AvailConverter.convert((int)aetVpCepMiGetAttrRsp.getAvailabilityStatus());
    }

    public boolean getContinuityCheck(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetVpCepMiGetAttrRsp aetVpCepMiGetAttrRsp = this.getFroAttributes(coordinator);
        boolean bl = MaoFroTypeConverter.int2boolean((int)aetVpCepMiGetAttrRsp.getContinuityCheck());
        return bl;
    }

    public void setContinuityCheck(boolean bl, Coordinator coordinator) throws MoAccessException {
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        AetVpCepMiSetAttrRsp aetVpCepMiSetAttrRsp = this.setFroAttribute(2, n, "continuityCheck", coordinator);
    }

    public int getCounterMode(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetVpCepMiGetAttrRsp aetVpCepMiGetAttrRsp = this.getFroAttributes(coordinator);
        return aetVpCepMiGetAttrRsp.getCounterMode();
    }

    public void setCounterMode(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        AetVpCepMiSetAttrRsp aetVpCepMiSetAttrRsp = this.setFroAttribute(4, n, "counterMode", coordinator);
    }

    public int getNomPmBlkSize(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetVpCepMiGetAttrRsp aetVpCepMiGetAttrRsp = this.getFroAttributes(coordinator);
        return aetVpCepMiGetAttrRsp.getNomPmBlkSize();
    }

    public void setNomPmBlkSize(int n, Coordinator coordinator) throws MoAccessException {
        AetVpCepMiSetAttrRsp aetVpCepMiSetAttrRsp = this.setFroAttribute(8, n, "nomPmBlkSize", coordinator);
    }

    public int getPmFwLostCells(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiGetPmCountersRsp aetVpCepMiGetPmCountersRsp = this.getPmCounters(coordinator);
        return aetVpCepMiGetPmCountersRsp.getFwLostCells();
    }

    public int getPmFwMissinsCells(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiGetPmCountersRsp aetVpCepMiGetPmCountersRsp = this.getPmCounters(coordinator);
        return aetVpCepMiGetPmCountersRsp.getFwMissinsCells();
    }

    public int getPmFwErrBlocks(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiGetPmCountersRsp aetVpCepMiGetPmCountersRsp = this.getPmCounters(coordinator);
        return aetVpCepMiGetPmCountersRsp.getFwErrBlocks();
    }

    public int getPmLostFpmCells(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiGetPmCountersRsp aetVpCepMiGetPmCountersRsp = this.getPmCounters(coordinator);
        return aetVpCepMiGetPmCountersRsp.getLostFpmCells();
    }

    public int getPmBwLostCells(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiGetPmCountersRsp aetVpCepMiGetPmCountersRsp = this.getPmCounters(coordinator);
        return aetVpCepMiGetPmCountersRsp.getBwLostCells();
    }

    public int getVpcTpFroId(Coordinator coordinator) throws MoAccessException {
        return this.vpcTpFroId.getValue(coordinator);
    }

    public int getPmBwMissinsCells(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiGetPmCountersRsp aetVpCepMiGetPmCountersRsp = this.getPmCounters(coordinator);
        return aetVpCepMiGetPmCountersRsp.getBwMissinsCells();
    }

    public int getPmBwErrBlocks(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiGetPmCountersRsp aetVpCepMiGetPmCountersRsp = this.getPmCounters(coordinator);
        return aetVpCepMiGetPmCountersRsp.getBwErrBlocks();
    }

    public int getPmLostBrCells(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiGetPmCountersRsp aetVpCepMiGetPmCountersRsp = this.getPmCounters(coordinator);
        return aetVpCepMiGetPmCountersRsp.getLostBrCells();
    }

    public boolean actionEteLoopBack(Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetVpCepMiEteLoopbackRsp aetVpCepMiEteLoopbackRsp = this.roProxy.SendEteLoopbackReq(this.vpcTpFroId.getValue(coordinator));
        this.checkSignal((Signal)aetVpCepMiEteLoopbackRsp);
        return aetVpCepMiEteLoopbackRsp.getResult() == 0;
    }

    private void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal == null) {
            throw new FroNotAccessibleException("VpcTp", "AET_VPCEPMI_SERVICE_NAME");
        }
    }

    private AetVpCepMiGetAttrRsp getFroAttributes(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiGetAttrRsp aetVpCepMiGetAttrRsp = this.roProxy.sendGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.vpcTpFroId.getValue(coordinator));
        this.checkSignal((Signal)aetVpCepMiGetAttrRsp);
        if (aetVpCepMiGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("VpcTp", "VpCep", "GetAttrReq: " + this.roProxy.getResultMsg(aetVpCepMiGetAttrRsp.getResult()), aetVpCepMiGetAttrRsp.getResult());
        }
        return aetVpCepMiGetAttrRsp;
    }

    private static void checkContinuityCheck(int n) throws MoAccessException {
        if (n != 1 && n != 0) {
            throw new ValueOutOfRangeException("continuityCheck", "VpcTp");
        }
    }

    private static void checkAlarmReport(int n) throws MoAccessException {
        if (!AlarmReport.inRange(n)) {
            throw new ValueOutOfRangeException("alarmReport", "VpcTp");
        }
    }

    private static void checkCounterMode(int n) throws MoAccessException {
        if (!AtmCounterMode.inRange(n)) {
            throw new ValueOutOfRangeException("counterMode", "VpcTp");
        }
    }

    private static void checkNomPmBlkSize(int n) throws MoAccessException {
        if (!AtmNomPmBlkSize.inRange(n)) {
            throw new ValueOutOfRangeException("nomPmBlkSize", "VpcTp");
        }
    }

    private AetVpCepMiSetAttrRsp setFroAttribute(int n, int n2, String string, Coordinator coordinator) throws MoAccessException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (string.equals("alarmReport")) {
            VpcTpMoImpl.checkAlarmReport(n2);
            n3 = n2;
        } else if (string.equals("continuityCheck")) {
            VpcTpMoImpl.checkContinuityCheck(n2);
            n4 = n2;
        } else if (string.equals("counterMode")) {
            VpcTpMoImpl.checkCounterMode(n2);
            n5 = n2;
        } else if (string.equals("nomPmBlkSize")) {
            VpcTpMoImpl.checkNomPmBlkSize(n2);
            n6 = n2;
        } else {
            throw new WrongAttributeTypeException(string, "VpcTp");
        }
        AetVpCepMiSetAttrRsp aetVpCepMiSetAttrRsp = this.roProxy.SendSetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.vpcTpFroId.getValue(coordinator), n, n3, n4, n5, n6);
        this.checkSignal((Signal)aetVpCepMiSetAttrRsp);
        if (aetVpCepMiSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("VpcTp", "VpCep", "SetAttrReq: " + this.roProxy.getResultMsg(aetVpCepMiSetAttrRsp.getResult()), aetVpCepMiSetAttrRsp.getResult());
        }
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{string.equals("continuityCheck") ? (Comparable<Boolean>)new Boolean(MaoFroTypeConverter.int2boolean((int)n2)) : (Comparable<Boolean>)new Integer(n2)};
        this.ns.pushAVC((ManagedObject)this, stringArray, objectArray);
        return aetVpCepMiSetAttrRsp;
    }

    private AetVpCepMiGetPmCountersRsp getPmCounters(Coordinator coordinator) throws MoAccessException {
        AetVpCepMiGetPmCountersRsp aetVpCepMiGetPmCountersRsp = this.roProxy.sendGetPmCountersReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.vpcTpFroId.getValue(coordinator));
        this.checkSignal((Signal)aetVpCepMiGetPmCountersRsp);
        if (aetVpCepMiGetPmCountersRsp.getResult() == 100) {
            aetVpCepMiGetPmCountersRsp.setPmCountersUnavailable();
        } else if (aetVpCepMiGetPmCountersRsp.getResult() != 0) {
            throw new FroRequestFailedException("VpcTp", "VpCep", "GetPmCountersReq: " + this.roProxy.getResultMsg(aetVpCepMiGetPmCountersRsp.getResult()), aetVpCepMiGetPmCountersRsp.getResult());
        }
        return aetVpCepMiGetPmCountersRsp;
    }

    public String getType() {
        return "VpcTp";
    }

    private static int checkAndGetAlarmReport(AttrList attrList) throws MoAccessException {
        int n = -1;
        int n2 = attrList.indexOf("alarmReport");
        if (n2 == -1) {
            return 2;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("alarmReport", "VpcTp");
        }
        n = (Integer)attrList.getValue(n2);
        VpcTpMoImpl.checkAlarmReport(n);
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetCounterMode(AttrList attrList) throws MoAccessException {
        int n = 0;
        int n2 = attrList.indexOf("counterMode");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("counterMode", "VpcTp");
        }
        n = (Integer)attrList.getValue(n2);
        VpcTpMoImpl.checkCounterMode(n);
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetNomPmBlkSize(AttrList attrList) throws MoAccessException {
        int n = 1024;
        int n2 = attrList.indexOf("nomPmBlkSize");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("nomPmBlkSize", "VpcTp");
        }
        n = (Integer)attrList.getValue(n2);
        VpcTpMoImpl.checkNomPmBlkSize(n);
        attrList.removeElementAt(n2);
        return n;
    }
}

