/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.atm.atm.AtmPortMoImpl;
import se.ericsson.cello.atm.atm.AtmTrafficDescriptorMo;
import se.ericsson.cello.atm.atm.AtmTrafficDescriptorMoImpl;
import se.ericsson.cello.atm.atm.VplTpMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.DynamicReserver;
import se.ericsson.cello.mao.DynamicallyReservable;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class VplTpMoImpl
extends CelloMao
implements VplTpMo,
DynamicReserver {
    private MoData data;
    private FroProxy genVpCpProxy = null;
    private static final int MO_DATA_REVISION_60 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;
    private static final int MAX_NUMBER_OF_VPLTP_HOSTS = 999;
    protected static final int MIN_EXTERNAL_VPI = 0;
    protected static final int MAX_EXTERNAL_VPI = 255;
    protected static final String VPL_TP_FRO_ID = "vplTpFroId";
    protected static final String ATMPORT_FRO_ID = "atmPortFroId";
    protected static final String ATMTD_FRO_ID = "atmTdFroId";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$se$ericsson$cello$atm$atm$AtmTrafficDescriptorMoImpl;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"VplTp", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"AtmPort");
        MoAttributeValidator.checkCardinality((String)"VplTp", (int)999);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"VplTp", (int)128, (int)0);
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"atmTrafficDescriptor", (AttrList)attrList, (boolean)true, (Class)AtmTrafficDescriptorMo.class, (String)"VplTp");
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"externalVpi", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)255, (String)"VplTp");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"VplTp");
        return new VplTpMoImpl(managedObject, string, string2, managedObject3, n, coordinator, froProxy);
    }

    private VplTpMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, int n, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "VplTp", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        this.genVpCpProxy = froProxy;
        int n2 = ((AtmTrafficDescriptorMoImpl)managedObject2).getFroId(coordinator);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter(ATMPORT_FRO_ID, ((AtmPortMoImpl)managedObject).getAtmPortFroId(coordinator)));
        arrayList.add(new SignedIntParameter(ATMTD_FRO_ID, n2));
        arrayList.add(new SignedIntParameter("externalVpi", n));
        FroData froData = this.genVpCpProxy.create(coordinator, arrayList);
        this.data.setRevision(6000);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(VPL_TP_FRO_ID, false, froData.getFroId()));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public VplTpMoImpl(MoData moData, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genVpCpProxy = froProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(VPL_TP_FRO_ID);
    }

    public void recoverReservations() throws MoAccessException {
        DynamicallyReservable dynamicallyReservable = (DynamicallyReservable)this.getAtmTrafficDescriptor(null);
        if (dynamicallyReservable != null && dynamicallyReservable instanceof DynamicallyReservable) {
            dynamicallyReservable.recoverReservation((ManagedObject)this);
        }
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = this.genVpCpProxy.getAttributes(coordinator, this.getFroId(coordinator));
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("externalVpi")) {
                signedIntParameter = (SignedIntParameter)map.get("externalVpi");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("atmTrafficDescriptor")) {
                signedIntParameter = (SignedIntParameter)map.get(ATMTD_FRO_ID);
                objectArray[i] = null;
                if (signedIntParameter != null) {
                    objectArray[i] = AtmTrafficDescriptorMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                }
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch atmTrafficDescriptorId reference ", "VplTp", "atmTrafficDescriptorId");
            }
            if (stringArray[i].equalsIgnoreCase("pmTransmittedAtmCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmTransmittedAtmCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmReceivedAtmCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmReceivedAtmCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = super.getCurrentPmRegister(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "VplTp");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? VplTpMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "VplTp");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"VplTp", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("atmTrafficDescriptor")) {
                if (!objectArray[i].getClass().equals(class$se$ericsson$cello$atm$atm$AtmTrafficDescriptorMoImpl == null ? VplTpMoImpl.class$("se.ericsson.cello.atm.atm.AtmTrafficDescriptorMoImpl") : class$se$ericsson$cello$atm$atm$AtmTrafficDescriptorMoImpl)) {
                    throw new WrongAttributeTypeException("atmTrafficDescriptor", "VplTp");
                }
                AtmTrafficDescriptorMoImpl atmTrafficDescriptorMoImpl = (AtmTrafficDescriptorMoImpl)this.getAttribute("atmTrafficDescriptor", coordinator);
                atmTrafficDescriptorMoImpl.release(this, coordinator);
                AtmTrafficDescriptorMoImpl atmTrafficDescriptorMoImpl2 = (AtmTrafficDescriptorMoImpl)objectArray[i];
                atmTrafficDescriptorMoImpl2.reserve(this, coordinator);
                arrayList.add(new SignedIntParameter(ATMTD_FRO_ID, atmTrafficDescriptorMoImpl2.getFroId(coordinator)));
                String[] stringArray2 = new String[]{stringArray[i]};
                Object[] objectArray2 = new Object[]{objectArray[i]};
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray2, objectArray2, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "VplTp");
        }
        if (arrayList.size() > 0) {
            this.genVpCpProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Reservable reservable = (Reservable)this.getAtmTrafficDescriptor(coordinator);
        reservable.release((ManagedObject)this, coordinator);
        this.genVpCpProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public ManagedObject getAtmTrafficDescriptor(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("atmTrafficDescriptor", coordinator);
    }

    public void setAtmTrafficDescriptor(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("atmTrafficDescriptor", managedObject, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getExternalVpi(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("externalVpi", coordinator);
    }

    public int getPmReceivedAtmCells(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmReceivedAtmCells", coordinator);
    }

    public int getPmTransmittedAtmCells(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmTransmittedAtmCells", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return super.getCurrentPmRegister(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(VPL_TP_FRO_ID)).getValue(coordinator);
    }

    public String getType() {
        return "VplTp";
    }
}

