/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.terminations;

import java.util.Vector;
import se.ericsson.cello.atm.atm.AtmInfoExtend;
import se.ericsson.cello.atm.atm.AtmPortMo;
import se.ericsson.cello.atm.atm.ImaGroupMoImpl;
import se.ericsson.cello.atm.terminations.Ds0BundleMo;
import se.ericsson.cello.atm.terminations.Ds0BundleMoEnum;
import se.ericsson.cello.atm.terminations.Ds0BundleMoFactory;
import se.ericsson.cello.atm.terminations.ListOfTimeSlotsNotUniqueException;
import se.ericsson.cello.atm.terminations.fropxy.AetDs0BundleMiCreateRsp;
import se.ericsson.cello.atm.terminations.fropxy.AetDs0BundleMiDeleteRsp;
import se.ericsson.cello.atm.terminations.fropxy.AetDs0BundleMiGetAttrRsp;
import se.ericsson.cello.atm.terminations.fropxy.AetDs0BundleMiProxy;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.MoNotReservedByUserException;
import se.ericsson.cello.mao.MoReservedByOtherUserException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.NotReservedException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pdhsdhtrans.Ds0BundleBuildIF;
import se.ericsson.cello.pdhsdhtrans.E1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.E1TtpMo;
import se.ericsson.cello.pdhsdhtrans.HgTtpMo;
import se.ericsson.cello.pdhsdhtrans.ImaReservable;
import se.ericsson.cello.pdhsdhtrans.J1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.T1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.T1TtpMo;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class Ds0BundleMoImpl
extends ManagedObjectBase
implements Ds0BundleMo,
Ds0BundleMoEnum,
TrafficReservable,
FroInfo,
Ds0BundleBuildIF {
    private static final String DS0BUNDLE_MI_FRO_ID = "ds0BundleMiFroId";
    private static final String PHY_PORT_FRO_ID = "phyPortFroId";
    private MoData data;
    private static AetDs0BundleMiProxy ds0BundleMiProxy = AetDs0BundleMiProxy.instance();
    private AtmInfoExtend atmInfoExtend = new AtmInfoExtend();
    private Ds0BundleMo ds0MaObj;
    private ManagedObject tmpManObject;
    private StringAttribute userLabel;
    private SequenceAttribute reservedBy;
    private IntegerAttribute ds0BundleMiFroId;
    private ReferenceAttribute aal1TpVccTpMo;
    private int physicalPortFroId;
    private IntegerAttribute listOfTimeSlots;
    private BooleanAttribute tdmMode;
    private static TransactionalFroIdMap froIdTable = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private static final int MO_DATA_REVISION_3_2 = 3000;
    private static final int MO_DATA_REVISION_LATEST = 3000;
    private static final int E1_SLOTS_MIN = 1;
    private static final int E1_SLOTS_MAX = 31;
    private static final int E1_DS0BUNDLE_MAXNUM = 31;
    private static final int J1_SLOTS_MIN = 1;
    private static final int J1_SLOTS_MAX = 24;
    private static final int J1_DS0BUNDLE_MAXNUM = 24;
    private static final int E1TTP_SLOTS_MIN = 1;
    private static final int E1TTP_SLOTS_MAX = 31;
    private static final int E1TTP_DS0BUNDLE_MAXNUM = 31;
    private static final int T1TTP_SLOTS_MIN = 1;
    private static final int T1TTP_SLOTS_MAX = 24;
    private static final int T1TTP_DS0BUNDLE_MAXNUM = 24;
    private static final int T1_SLOTS_MIN = 1;
    private static final int T1_SLOTS_MAX = 24;
    private static final int T1_DS0BUNDLE_MAXNUM = 24;
    private static final int HGTTP_SLOTS_MIN = 1;
    private static final int HGTTP_SLOTS_MAX = 6;
    private static final int HGTTP_DS0BUNDLE_MAXNUM = 6;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Ds0Bundle", (String)string);
        Ds0BundleMoImpl.checkParent(managedObject, coordinator);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Ds0Bundle", (int)128, (int)0);
        int n = Ds0BundleMoImpl.checkAndGetListOfTimeSlots(attrList, managedObject);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"tdmMode", (AttrList)attrList, (boolean)true, (boolean)true, (String)"Ds0Bundle");
        Ds0BundleMoImpl.checkOtherAttributes(attrList);
        return new Ds0BundleMoImpl(managedObject, string, string2, n, bl, coordinator);
    }

    private Ds0BundleMoImpl(ManagedObject managedObject, String string, String string2, int n, boolean bl, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Ds0Bundle", string, coordinator);
        ManagedObject managedObject2;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        if (managedObject instanceof J1PhysPathTermMo) {
            this.physicalPortFroId = ((J1PhysPathTermMo)managedObject).getFroId(coordinator);
        } else if (managedObject instanceof E1PhysPathTermMo) {
            this.physicalPortFroId = ((E1PhysPathTermMo)managedObject).getFroId(coordinator);
        } else if (managedObject instanceof T1PhysPathTermMo) {
            this.physicalPortFroId = ((T1PhysPathTermMo)managedObject).getFroId(coordinator);
        } else if (managedObject instanceof E1TtpMo) {
            this.physicalPortFroId = ((E1TtpMo)managedObject).getFroId(coordinator);
        } else if (managedObject instanceof T1TtpMo) {
            this.physicalPortFroId = ((T1TtpMo)managedObject).getFroId(coordinator);
        } else if (managedObject instanceof HgTtpMo) {
            this.physicalPortFroId = ((HgTtpMo)managedObject).getFroId(coordinator);
        } else {
            throw new IllegalParentException("Ds0Bundle");
        }
        this.checkUniqueTimeSlots(coordinator, managedObject, n);
        int n2 = this.createDs0BundleMiFro(coordinator, n, this.physicalPortFroId, MaoFroTypeConverter.boolean2int((boolean)bl));
        this.ds0BundleMiFroId = new IntegerAttribute(DS0BUNDLE_MI_FRO_ID, false, n2);
        this.data.registerPersistentAttr((Attribute)this.ds0BundleMiFroId);
        froIdTable.put(n2, (ManagedObject)this, coordinator);
        this.resolveReservedBy(managedObject, coordinator);
        if (managedObject instanceof TrafficReservable && (managedObject2 = ((TrafficReservable)managedObject).getReservedByTraffic(coordinator)) != null) {
            if (managedObject2.getType().equals("AtmPort")) {
                ((AtmPortMo)managedObject2).setAttribute("uses", this, coordinator);
            } else {
                throw new MoCanNotBeCreatedException("Ds0Bundle");
            }
        }
        this.data.setRevision(3000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public Ds0BundleMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute(DS0BUNDLE_MI_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.reservedBy = (SequenceAttribute)this.data.getAttribute("reservedBy");
        this.ds0BundleMiFroId = (IntegerAttribute)moData.getAttribute(DS0BUNDLE_MI_FRO_ID);
        froIdTable.put(this.ds0BundleMiFroId.getValue(null), (ManagedObject)this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedNotDeletableException("Ds0Bundle");
        }
        this.deleteDs0BundleFro(coordinator);
        froIdTable.remove(this.ds0BundleMiFroId.getValue(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("Ds0Bundle", (Object)managedObject);
        }
        ManagedObject[] managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)this.reservedBy, (Coordinator)coordinator);
        String string = managedObject.getType();
        if (managedObjectArray.length >= 1) {
            if (managedObjectArray.length > 1) {
                MessageLog.traceError(this.getClass(), (String)"Faulty configuration of Ds0Bundle");
            }
            if (managedObject != managedObjectArray[0]) {
                throw new MoReservedByOtherUserException(managedObject.getLocalDistinguishedName(), managedObjectArray[0].getLocalDistinguishedName());
            }
            return;
        }
        if (string.startsWith("Mtp2Tp") || string.equals("TdmCrossConnection")) {
            if (this.getListOfTimeSlots(coordinator).length != 1) {
                throw new MoNotPossibleToReserveException("Attribute listOfTimeSlots can only contain one timeSlot to allow reservation of the user " + managedObject.getType(), "Ds0Bundle");
            }
            if (string.startsWith("Mtp2Tp") && !this.getTdmMode(coordinator)) {
                throw new MoNotPossibleToReserveException("Ds0Bundle is not in TDM mode and should only be used for circuit emulation. ", string);
            }
        }
        ReferenceAttribute referenceAttribute = new ReferenceAttribute("", false);
        referenceAttribute.setValue(managedObject);
        this.reservedBy.addElement((Attribute)referenceAttribute);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("Ds0Bundle", (Object)managedObject);
        }
        ReferenceAttribute referenceAttribute = this.getRefAttrib(managedObject, coordinator);
        if (referenceAttribute != null) {
            this.reservedBy.removeElement((Attribute)referenceAttribute);
        }
    }

    public void trafficReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        int n;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (managedObject == null) {
            MessageLog.trace((int)5, this.getClass(), (String)"reserve: userId is null");
            throw new InvalidReferenceException("Ds0Bundle", (Object)managedObject);
        }
        String string = managedObject.getType();
        ManagedObject[] managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)this.reservedBy, (Coordinator)coordinator);
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (!managedObjectArray[n].getType().equals(string) || managedObject == managedObjectArray[n]) continue;
            throw new MoReservedByOtherUserException(managedObject.getLocalDistinguishedName(), managedObjectArray[n].getLocalDistinguishedName());
        }
        if (managedObject instanceof AtmPortMo) {
            for (n = 0; n < managedObjectArray.length; ++n) {
                String string2 = managedObjectArray[n].getType();
                if (!string2.startsWith("Mtp2Tp") && !string2.equals("Aal1TpVccTp")) continue;
                throw new MoReservedByOtherUserException(string, string2);
            }
        }
        ReferenceAttribute referenceAttribute = new ReferenceAttribute("", false);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        referenceAttribute.setValue(managedObject);
        this.reservedBy.addElement((Attribute)referenceAttribute);
    }

    public void trafficRelease(Coordinator coordinator, ManagedObject managedObject) throws MoNotReservedByUserException, InvalidReferenceException, TransactionRequiredException, MoRemovedException, MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (managedObject == null) {
            MessageLog.trace((int)5, this.getClass(), (String)"release: userId is null");
            throw new InvalidReferenceException("Ds0Bundle", (Object)managedObject);
        }
        ReferenceAttribute referenceAttribute = this.getRefAttrib(managedObject, coordinator);
        if (referenceAttribute == null) {
            throw new NotReservedException("NotReserved", "Ds0Bundle");
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.reservedBy.removeElement((Attribute)referenceAttribute);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return this.getDs0BundleMiFroId(coordinator);
    }

    private ReferenceAttribute getRefAttrib(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        for (int i = 0; i < attributeArray.length; ++i) {
            ReferenceAttribute referenceAttribute = (ReferenceAttribute)attributeArray[i];
            if (managedObject != referenceAttribute.getValue(coordinator)) continue;
            return referenceAttribute;
        }
        return null;
    }

    public ManagedObject getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject[] managedObjectArray = new ManagedObject[this.reservedBy.size()];
        managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)this.reservedBy, (Coordinator)coordinator);
        if (managedObjectArray.length != 0) {
            return managedObjectArray[0];
        }
        return null;
    }

    public ManagedObject getReservedByTraffic(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
            if (!managedObjectArray[i].getType().equals("AtmPort")) continue;
            return managedObjectArray[i];
        }
        return null;
    }

    public int getDs0BundleMiFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.ds0BundleMiFroId.getValue(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Ds0Bundle", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int[] getListOfTimeSlots(Coordinator coordinator) throws MoAccessException {
        int n;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetDs0BundleMiGetAttrRsp aetDs0BundleMiGetAttrRsp = this.getDs0BundleMiAttributes(coordinator);
        String string = Integer.toBinaryString(aetDs0BundleMiGetAttrRsp.getTimeSlotList());
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            n = string.charAt(n3);
            if (n != 48) {
                vector.addElement(new Integer(n2));
            }
            --n3;
            ++n2;
        }
        int[] nArray = new int[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            nArray[n] = (Integer)vector.elementAt(n);
        }
        return nArray;
    }

    private void checkUniqueTimeSlots(Coordinator coordinator, ManagedObject managedObject, int n) throws MoAccessException {
        int n2;
        String string = Integer.toBinaryString(n);
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        int n4 = string.length() - 1;
        while (n4 >= 0) {
            n2 = string.charAt(n4);
            if (n2 != 48) {
                vector.addElement(new Integer(n3));
            }
            --n4;
            ++n3;
        }
        int[] nArray = new int[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            nArray[n2] = (Integer)vector.elementAt(n2);
        }
        MoIterator moIterator = MoRepository.instance().lookupType(Ds0BundleMoFactory.instance().getMoTypeName());
        while (moIterator.hasMoreElements()) {
            Ds0BundleMoImpl ds0BundleMoImpl = (Ds0BundleMoImpl)moIterator.nextElement();
            if (!managedObject.getLocalDistinguishedName().equals(ds0BundleMoImpl.getParent().getLocalDistinguishedName()) || this.getLocalDistinguishedName().equals(ds0BundleMoImpl.getLocalDistinguishedName())) continue;
            int[] nArray2 = ds0BundleMoImpl.getListOfTimeSlots(coordinator);
            for (int i = 0; i < nArray2.length; ++i) {
                int n5 = nArray2[i];
                for (int j = 0; j < nArray.length; ++j) {
                    if (n5 != nArray[j]) continue;
                    throw new ListOfTimeSlotsNotUniqueException(n5, "Ds0Bundle");
                }
            }
        }
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetDs0BundleMiGetAttrRsp aetDs0BundleMiGetAttrRsp = this.getDs0BundleMiAttributes(coordinator);
        return AvailConverter.convert((int)aetDs0BundleMiGetAttrRsp.getAvailStatus());
    }

    public String getDs0BundleId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getNamingAttributeValue();
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetDs0BundleMiGetAttrRsp aetDs0BundleMiGetAttrRsp = this.getDs0BundleMiAttributes(coordinator);
        return aetDs0BundleMiGetAttrRsp.getOperState();
    }

    public boolean getTdmMode(Coordinator coordinator) throws MoAccessException {
        AetDs0BundleMiGetAttrRsp aetDs0BundleMiGetAttrRsp = this.getDs0BundleMiAttributes(coordinator);
        return MaoFroTypeConverter.int2boolean((int)aetDs0BundleMiGetAttrRsp.getTdmMode());
    }

    public Struct getAtmInfo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.atmInfoExtend.getDs0BundleData(coordinator, this);
    }

    public String getType() {
        return "Ds0Bundle";
    }

    void resolveReservedBy(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2;
        if (managedObject instanceof ImaReservable && (managedObject2 = ((ImaReservable)managedObject).getReservedByImaLink(coordinator)) != null) {
            if (((ImaGroupMoImpl)managedObject2.getParent()).getReservedBy(coordinator) != null) {
                ((ImaReservable)managedObject).release(managedObject2, coordinator);
                AtmPortMo atmPortMo = (AtmPortMo)((ImaGroupMoImpl)managedObject2.getParent()).getReservedBy(coordinator);
                atmPortMo.setAttribute("uses", this, coordinator);
            } else {
                throw new MoCanNotBeCreatedException("Ds0Bundle");
            }
        }
    }

    static void checkParent(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof J1PhysPathTermMo) {
            if (!Ds0BundleMoImpl.canCreateOnemore(managedObject, "J1PhysPathTerm", "Ds0Bundle", 24)) {
                throw new MaxNumberExceededException("Max number of Ds0Bundles is exceeded", "Ds0Bundle");
            }
        } else if (managedObject instanceof E1PhysPathTermMo) {
            if (!Ds0BundleMoImpl.canCreateOnemore(managedObject, "E1PhysPathTerm", "Ds0Bundle", 31)) {
                throw new MaxNumberExceededException("Max number of Ds0Bundles is exceeded", "Ds0Bundle");
            }
        } else if (managedObject instanceof T1PhysPathTermMo) {
            if (!Ds0BundleMoImpl.canCreateOnemore(managedObject, "T1PhysPathTerm", "Ds0Bundle", 24)) {
                throw new MaxNumberExceededException("Max number of Ds0Bundles is exceeded", "Ds0Bundle");
            }
        } else if (managedObject instanceof E1TtpMo) {
            if (!Ds0BundleMoImpl.canCreateOnemore(managedObject, "E1Ttp", "Ds0Bundle", 31)) {
                throw new MaxNumberExceededException("Max number of Ds0Bundles is exceeded", "Ds0Bundle");
            }
        } else if (managedObject instanceof T1TtpMo) {
            if (!Ds0BundleMoImpl.canCreateOnemore(managedObject, "T1Ttp", "Ds0Bundle", 24)) {
                throw new MaxNumberExceededException("Max number of Ds0Bundles is exceeded", "Ds0Bundle");
            }
        } else if (managedObject instanceof HgTtpMo) {
            if (!Ds0BundleMoImpl.canCreateOnemore(managedObject, "HgTtp", "Ds0Bundle", 6)) {
                throw new MaxNumberExceededException("Max number of Ds0Bundles is exceeded", "Ds0Bundle");
            }
        } else {
            throw new IllegalParentException("Ds0Bundle");
        }
    }

    private static int checkAndGetListOfTimeSlots(AttrList attrList, ManagedObject managedObject) throws MoAccessException {
        int n;
        int n2;
        int n3 = attrList.indexOf("listOfTimeSlots");
        if (n3 == -1) {
            throw new AttrMissingAtCreateException("listOfTimeSlots", "Ds0Bundle");
        }
        if (!(attrList.getValue(n3) instanceof int[])) {
            throw new WrongAttributeTypeException("listOfTimeSlots", "Ds0Bundle");
        }
        int[] nArray = (int[])attrList.getValue(n3);
        int n4 = 0;
        for (n2 = 0; n2 < nArray.length - 1; ++n2) {
            n4 = nArray[n2];
            for (n = n2 + 1; n < nArray.length; ++n) {
                if (n4 != nArray[n]) continue;
                throw new ListOfTimeSlotsNotUniqueException(n4, "Ds0Bundle");
            }
        }
        if (managedObject.getType().equals("E1PhysPathTerm")) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] >= 1 && nArray[n2] <= 31) continue;
                throw new ValueOutOfRangeException("listOfTimeSlots", "Ds0Bundle");
            }
        }
        if (managedObject.getType().equals("J1PhysPathTerm")) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] >= 1 && nArray[n2] <= 24) continue;
                throw new ValueOutOfRangeException("listOfTimeSlots", "Ds0Bundle");
            }
        }
        if (managedObject.getType().equals("T1PhysPathTerm")) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] >= 1 && nArray[n2] <= 24) continue;
                throw new ValueOutOfRangeException("listOfTimeSlots", "Ds0Bundle");
            }
        }
        if (managedObject.getType().equals("E1Ttp")) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] >= 1 && nArray[n2] <= 31) continue;
                throw new ValueOutOfRangeException("listOfTimeSlots", "Ds0Bundle");
            }
        }
        if (managedObject.getType().equals("T1Ttp")) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] >= 1 && nArray[n2] <= 24) continue;
                throw new ValueOutOfRangeException("listOfTimeSlots", "Ds0Bundle");
            }
        }
        if (managedObject.getType().equals("HgTtp")) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] >= 1 && nArray[n2] <= 6) continue;
                throw new ValueOutOfRangeException("listOfTimeSlots", "Ds0Bundle");
            }
        }
        n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += 1 << nArray[n];
        }
        attrList.removeElementAt(n3);
        return n2;
    }

    private int createDs0BundleMiFro(Coordinator coordinator, int n, int n2, int n3) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        AetDs0BundleMiCreateRsp aetDs0BundleMiCreateRsp = ds0BundleMiProxy.sendCreateFroReq(coordinator.getTransactionID(), n, n2, n3);
        if (aetDs0BundleMiCreateRsp == null) {
            throw new FroNotAccessibleException("Ds0Bundle", "ds0BundleMi");
        }
        if (aetDs0BundleMiCreateRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ds0Bundle", "Ds0Bundle", "CreateFroReq: " + ds0BundleMiProxy.getResultMsg(aetDs0BundleMiCreateRsp.getResult()), aetDs0BundleMiCreateRsp.getResult());
        }
        return aetDs0BundleMiCreateRsp.getFroId();
    }

    private AetDs0BundleMiGetAttrRsp getDs0BundleMiAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetDs0BundleMiGetAttrRsp aetDs0BundleMiGetAttrRsp = ds0BundleMiProxy.sendGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.ds0BundleMiFroId.getValue(coordinator));
        if (aetDs0BundleMiGetAttrRsp == null) {
            throw new FroNotAccessibleException("Ds0Bundle", "ds0BundleMi");
        }
        if (aetDs0BundleMiGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ds0Bundle", "Ds0Bundle", "GetAttrReq: " + ds0BundleMiProxy.getResultMsg(aetDs0BundleMiGetAttrRsp.getResult()), aetDs0BundleMiGetAttrRsp.getResult());
        }
        return aetDs0BundleMiGetAttrRsp;
    }

    private void deleteDs0BundleFro(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        AetDs0BundleMiDeleteRsp aetDs0BundleMiDeleteRsp = ds0BundleMiProxy.sendDeleteFroReq(coordinator.getTransactionID(), this.ds0BundleMiFroId.getValue(coordinator));
        if (aetDs0BundleMiDeleteRsp == null) {
            throw new FroNotAccessibleException("Ds0Bundle", "ds0BundleMi");
        }
        if (aetDs0BundleMiDeleteRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ds0Bundle", "Ds0Bundle", "DeleteFroReq: " + ds0BundleMiProxy.getResultMsg(aetDs0BundleMiDeleteRsp.getResult()), aetDs0BundleMiDeleteRsp.getResult());
        }
    }

    private static void checkOtherAttributes(AttrList attrList) throws NoSuchAttributeException {
        int n = attrList.size();
        if (n != 0) {
            throw new NoSuchAttributeException(attrList.getName(0), "Ds0Bundle");
        }
    }

    private static boolean canCreateOnemore(ManagedObject managedObject, String string, String string2, int n) {
        if (!managedObject.getType().equals(string)) {
            return false;
        }
        int n2 = 0;
        MoIterator moIterator = managedObject.getChildren();
        ManagedObject managedObject2 = null;
        while (moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            if (!managedObject2.getType().equals(string2)) continue;
            ++n2;
        }
        return n2 < n;
    }

    public static Ds0BundleMoImpl lookupInstance(int n, Coordinator coordinator) throws MoAccessException {
        return (Ds0BundleMoImpl)froIdTable.get(n, coordinator);
    }
}

