/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.etf.ListenerBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPLoopback;
import org.jacorb.orb.iiop.IIOPLoopbackConnection;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackRegistry;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.listener.AcceptorExceptionEvent;
import org.jacorb.orb.listener.AcceptorExceptionListener;
import org.jacorb.orb.listener.SSLListenerUtil;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.ETF.Connection;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class IIOPListener
extends ListenerBase {
    private static final int MAX_SSL_OPTIONS = 126;
    private static final int MIN_SSL_OPTIONS = 26;
    private SocketFactoryManager socketFactoryManager = null;
    private SSLAcceptor sslAcceptor = null;
    private LoopbackAcceptor loopbackAcceptor;
    private boolean supportSSL = false;
    private int serverTimeout = 0;
    private IIOPAddress address = null;
    private IIOPAddress sslAddress = null;
    private int target_supports = 0;
    private int target_requires = 0;
    private boolean generateSSLComponents = true;
    static /* synthetic */ Class class$org$jacorb$orb$listener$DefaultAcceptorExceptionListener;

    public void configure(Configuration configuration) throws ConfigurationException {
        ProtocolAddressBase addr;
        super.configure(configuration);
        this.socketFactoryManager = this.orb.getTransportManager().getSocketFactoryManager();
        String address_str = configuration.getAttribute("OAAddress", null);
        if (address_str != null) {
            addr = this.orb.createAddress(address_str);
            if (addr instanceof IIOPAddress) {
                this.address = (IIOPAddress)addr;
            }
        } else {
            int oaPort = configuration.getAttributeAsInteger("OAPort", 0);
            String oaHost = configuration.getAttribute("OAIAddr", "");
            this.address = new IIOPAddress(oaHost, oaPort);
        }
        if (this.address != null) {
            this.address.configure(configuration);
        }
        if ((address_str = configuration.getAttribute("OASSLAddress", null)) != null) {
            addr = this.orb.createAddress(address_str);
            if (addr instanceof IIOPAddress) {
                this.sslAddress = (IIOPAddress)addr;
            }
        } else {
            int sslPort = configuration.getAttributeAsInteger("OASSLPort", 0);
            String sslHost = configuration.getAttribute("OAIAddr", "");
            this.sslAddress = new IIOPAddress(sslHost, sslPort);
        }
        if (this.sslAddress != null) {
            this.sslAddress.configure(configuration);
        }
        this.serverTimeout = configuration.getAttributeAsInteger("jacorb.connection.server.timeout", 0);
        this.supportSSL = configuration.getAttributeAsBoolean("jacorb.security.support_ssl", false);
        this.target_supports = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.target_supports |= 0x1A;
        this.target_requires = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
        this.generateSSLComponents = configuration.getAttributeAsBoolean("jacorb.security.ssl_components_added_by_ior_interceptor", true);
        if (!this.isSSLRequired() || configuration.getAttributeAsBoolean("jacorb.security.ssl.always_open_unsecured_address", false)) {
            this.acceptor = new Acceptor("ServerSocketListener");
            ((Acceptor)this.acceptor).init();
        }
        if (this.supportSSL) {
            this.sslAcceptor = new SSLAcceptor();
            this.sslAcceptor.init();
        }
        this.profile = this.createAddressProfile();
        if (configuration.getAttributeAsBoolean("jacorb.iiop.enable_loopback", true)) {
            this.loopbackAcceptor = new LoopbackAcceptor();
        }
    }

    public void listen() {
        super.listen();
        if (this.sslAcceptor != null) {
            this.sslAcceptor.start();
        }
        if (this.loopbackAcceptor != null) {
            this.loopbackAcceptor.start();
        }
    }

    public void destroy() {
        if (this.loopbackAcceptor != null) {
            this.loopbackAcceptor.terminate();
        }
        if (this.sslAcceptor != null) {
            this.sslAcceptor.terminate();
        }
        super.destroy();
    }

    public void renewSSLServerSocket() {
        if (this.sslAcceptor != null) {
            this.sslAcceptor.renewSSLServerSocket();
        }
    }

    private boolean isSSLSupported() {
        return this.supportSSL;
    }

    private boolean isSSLRequired() {
        if (this.isSSLSupported()) {
            return (this.target_requires & 0x7E) != 0;
        }
        return false;
    }

    private IIOPProfile createAddressProfile() throws ConfigurationException {
        if (this.acceptor != null) {
            if (this.address.getPort() == 0) {
                this.address.setPort(((Acceptor)this.acceptor).getLocalAddress().getPort());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using port " + this.address.getPort());
            }
        } else if (this.sslAcceptor == null) {
            throw new INITIALIZE("no acceptors found, cannot create address profile");
        }
        IIOPProfile result = new IIOPProfile(this.address, null, this.orb.getGIOPMinorVersion());
        if (this.sslAcceptor != null && this.generateSSLComponents) {
            result.addComponent(20, this.createSSL(), SSLHelper.class);
        }
        result.configure(this.configuration);
        return result;
    }

    private SSL createSSL() {
        return new SSL((short)this.target_supports, (short)this.target_requires, (short)this.sslAcceptor.getLocalAddress().getPort());
    }

    private void deliverConnection(Socket socket, boolean isSSL) {
        Connection result = null;
        try {
            result = this.createServerConnection(socket, isSSL);
        }
        catch (IOException ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Could not create connection from socket: ", ex);
            }
            return;
        }
        this.deliverConnection(result);
    }

    protected Connection createServerConnection(Socket socket, boolean is_ssl) throws IOException {
        TCPConnectionListener tcpListener = this.socketFactoryManager.getTCPListener();
        ServerIIOPConnection result = new ServerIIOPConnection(socket, is_ssl, tcpListener);
        if (tcpListener.isListenerEnabled()) {
            tcpListener.connectionOpened(new TCPConnectionEvent(result, socket.getInetAddress().getHostAddress(), socket.getPort(), socket.getLocalPort(), this.getLocalhost()));
        }
        try {
            result.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            throw new INTERNAL("ConfigurationException: " + ce.toString());
        }
        return result;
    }

    private String getLocalhost() {
        String localhost;
        try {
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to resolve local host - using default 127.0.0.1");
            }
            localhost = "127.0.0.1";
        }
        return localhost;
    }

    private class LoopbackAcceptor
    implements IIOPLoopback {
        private final IIOPAddress listenerAddress;
        private final IIOPAddress loopbackAddress;
        private final boolean isSSL;

        public LoopbackAcceptor() {
            IIOPProfile iiopProfile = (IIOPProfile)IIOPListener.this.profile;
            this.listenerAddress = (IIOPAddress)iiopProfile.getAddress().copy();
            this.loopbackAddress = (IIOPAddress)this.listenerAddress.copy();
            this.loopbackAddress.setHostname("127.0.0.1");
            boolean bl = this.isSSL = iiopProfile.getSSL() != null;
            if (this.isSSL) {
                this.listenerAddress.setPort(iiopProfile.getSSLPort());
                this.loopbackAddress.setPort(iiopProfile.getSSLPort());
            }
        }

        public void start() {
            IIOPLoopbackRegistry.getRegistry().register(this.listenerAddress, this);
            IIOPLoopbackRegistry.getRegistry().register(this.loopbackAddress, this);
        }

        public void terminate() {
            IIOPLoopbackRegistry.getRegistry().unregister(this.listenerAddress);
            IIOPLoopbackRegistry.getRegistry().unregister(this.loopbackAddress);
        }

        public void initLoopback(final String connectionInfo, IIOPLoopbackInputStream lis, IIOPLoopbackOutputStream los) {
            IIOPLoopbackConnection connection = new IIOPLoopbackConnection(lis, los){
                {
                    super(x0, x1);
                    this.connection_info = connectionInfo;
                }

                public boolean isSSL() {
                    return isSSL;
                }
            };
            try {
                connection.configure(IIOPListener.this.configuration);
            }
            catch (ConfigurationException e2) {
                throw new RuntimeException("should never happen", e2);
            }
            IIOPListener.this.deliverConnection(connection);
        }
    }

    private class SSLAcceptor
    extends Acceptor {
        private final Object renewSocketSync;
        private boolean renewingSocket;
        private boolean blockedOnAccept;

        private SSLAcceptor() {
            super("SSLServerSocketListener", IIOPListener.this.sslAddress);
            this.renewSocketSync = new Object();
            this.info = "SSL";
        }

        protected ServerSocketFactory getServerSocketFactory() {
            return IIOPListener.this.socketFactoryManager.getSSLServerSocketFactory();
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void beginAccept() throws InterruptedException {
            Object object = this.renewSocketSync;
            synchronized (object) {
                while (this.renewingSocket) {
                    this.renewSocketSync.wait();
                }
                this.blockedOnAccept = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void endAccept() {
            Object object = this.renewSocketSync;
            synchronized (object) {
                this.blockedOnAccept = false;
                this.renewSocketSync.notifyAll();
            }
        }

        protected void doHandleExceptionInRunLoop(Exception exception, boolean isTerminated) {
            if (!(exception instanceof InterruptedException)) {
                return;
            }
            if (this.soTimeout > 0) {
                return;
            }
            if (isTerminated) {
                return;
            }
            IIOPListener.this.logger.warn("InterruptedException should only occur if soTimeout > 0", exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renewSSLServerSocket() {
            Object object;
            InetAddress oldAddress = this.serverSocket.getInetAddress();
            int oldPort = this.serverSocket.getLocalPort();
            try {
                Object object2 = this.renewSocketSync;
                synchronized (object2) {
                    this.renewingSocket = true;
                    while (this.blockedOnAccept) {
                        try {
                            this.renewSocketSync.wait();
                        }
                        catch (InterruptedException e2) {}
                    }
                }
                try {
                    this.serverSocket.close();
                }
                catch (Exception e3) {
                    IIOPListener.this.logger.warn("failed to close SSLServerSocket", e3);
                }
                this.serverSocket = this.createServerSocket(oldAddress, oldPort);
                Object var7_7 = null;
                object = this.renewSocketSync;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                Object object3 = this.renewSocketSync;
                synchronized (object3) {
                    this.renewingSocket = false;
                    this.renewSocketSync.notifyAll();
                }
                throw throwable;
            }
            synchronized (object) {
                this.renewingSocket = false;
                this.renewSocketSync.notifyAll();
            }
        }
    }

    public class Acceptor
    extends ListenerBase.Acceptor {
        private final boolean keepAlive;
        private final IIOPAddress addressToUse;
        protected final int soTimeout;
        protected final boolean reuseAddress;
        protected ServerSocket serverSocket;
        protected String info = "";
        private volatile boolean terminated = false;
        private final AcceptorExceptionListener acceptorExceptionListener;
        private boolean firstPass;

        protected Acceptor(String name, IIOPAddress target) {
            this.setDaemon(true);
            this.setName(name);
            this.keepAlive = IIOPListener.this.configuration.getAttributeAsBoolean("jacorb.connection.server.keepalive", false);
            this.soTimeout = IIOPListener.this.configuration.getAttributeAsInteger("jacorb.listener.server_socket_timeout", 0);
            this.reuseAddress = IIOPListener.this.configuration.getAttributeAsBoolean("jacorb.connection.server.reuse_address", false);
            try {
                this.acceptorExceptionListener = (AcceptorExceptionListener)IIOPListener.this.configuration.getAttributeAsObject("jacorb.acceptor_exception_listener", (class$org$jacorb$orb$listener$DefaultAcceptorExceptionListener == null ? (class$org$jacorb$orb$listener$DefaultAcceptorExceptionListener = IIOPListener.class$("org.jacorb.orb.listener.DefaultAcceptorExceptionListener")) : class$org$jacorb$orb$listener$DefaultAcceptorExceptionListener).getName());
            }
            catch (ConfigurationException e2) {
                IIOPListener.this.logger.error("couldn't create a AcceptorExceptionListener", e2);
                throw new IllegalArgumentException("wrong configuration: " + e2);
            }
            this.addressToUse = target;
        }

        protected Acceptor(String name) {
            this(name, this$0.address);
        }

        public void init() {
            this.serverSocket = this.createServerSocket();
            if (IIOPListener.this.logger.isDebugEnabled()) {
                IIOPListener.this.logger.debug("Created " + this.info + "socket listener on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort());
            }
        }

        protected void beginAccept() throws InterruptedException {
        }

        protected void endAccept() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.runLoop();
                Object var2_1 = null;
                if (!this.terminated) {
                    IIOPListener.this.logger.fatalError(this.info + "Listener is unexpectedly exiting. the ORB is in an non-functional state!");
                } else {
                    IIOPListener.this.logger.info(this.info + "Listener exiting");
                }
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (!this.terminated) {
                    IIOPListener.this.logger.fatalError(this.info + "Listener is unexpectedly exiting. the ORB is in an non-functional state!");
                } else {
                    IIOPListener.this.logger.info(this.info + "Listener exiting");
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runLoop() {
            while (true) {
                try {
                    while (true) {
                        if (this.terminated) {
                            return;
                        }
                        this.beginAccept();
                        try {
                            Socket socket = this.serverSocket.accept();
                            if (this.terminated) {
                                if (!(socket instanceof SSLSocket) && !socket.isClosed()) {
                                    socket.shutdownOutput();
                                }
                                socket.close();
                                if (IIOPListener.this.logger.isInfoEnabled()) {
                                    IIOPListener.this.logger.info("closed Socket " + socket + " as " + this.info + "ServerSocket was closed.");
                                }
                                return;
                            }
                            this.setup(socket);
                            try {
                                this.deliverConnection(socket);
                                this.firstPass = true;
                                continue;
                            }
                            catch (NO_RESOURCES e2) {
                                if (!(socket instanceof SSLSocket) && !socket.isClosed()) {
                                    socket.shutdownOutput();
                                }
                                socket.close();
                                throw e2;
                            }
                        }
                        finally {
                            this.endAccept();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e3) {
                    if (Thread.interrupted() && IIOPListener.this.logger.isDebugEnabled()) {
                        IIOPListener.this.logger.debug("Resetting interrupted status of thread.");
                    }
                    this.handleExceptionInRunLoop(e3, this.terminated);
                    continue;
                }
                catch (OutOfMemoryError e4) {
                    IIOPListener.this.logger.fatalError("OutOfMemory", e4);
                    continue;
                }
                break;
            }
        }

        private void handleExceptionInRunLoop(Exception exception, boolean isTerminated) {
            if (!isTerminated) {
                IIOPListener.this.logger.warn("unexpected exception in " + this.info + "Acceptor runloop", exception);
            }
            this.doHandleExceptionInRunLoop(exception, isTerminated);
            try {
                this.acceptorExceptionListener.exceptionCaught(new AcceptorExceptionEvent(this, ((BasicAdapter)IIOPListener.this.up).getORB(), exception));
            }
            catch (Exception e2) {
                IIOPListener.this.logger.error("error in Acceptor Exception Listener: " + this.acceptorExceptionListener + " while handling exception: " + exception, e2);
            }
        }

        protected void doHandleExceptionInRunLoop(Exception exception, boolean isTerminated) {
        }

        public void terminate() {
            this.terminated = true;
            try {
                this.serverSocket.close();
            }
            catch (IOException e2) {
                IIOPListener.this.logger.warn("failed to close " + this.info + "ServerSocket", e2);
            }
            this.interrupt();
        }

        public IIOPAddress getLocalAddress() {
            IIOPAddress addr = new IIOPAddress(this.serverSocket.getInetAddress().toString(), this.serverSocket.getLocalPort());
            if (IIOPListener.this.configuration != null) {
                try {
                    addr.configure(IIOPListener.this.configuration);
                }
                catch (ConfigurationException ce) {
                    IIOPListener.this.logger.error("ConfigurationException", ce);
                    throw new INTERNAL(ce.toString());
                }
            }
            return addr;
        }

        protected ServerSocket createServerSocket() {
            InetAddress configuredHost = this.addressToUse.getConfiguredHost();
            int port = this.addressToUse.getPort();
            return this.createServerSocket(configuredHost, port);
        }

        protected ServerSocket createServerSocket(InetAddress host, int port) {
            try {
                ServerSocket result = this.getServerSocketFactory().createServerSocket(port, 20, host);
                if (this.soTimeout > 0) {
                    result.setSoTimeout(this.soTimeout);
                }
                if (this.reuseAddress) {
                    result.setReuseAddress(true);
                }
                return result;
            }
            catch (IOException ex) {
                IIOPListener.this.logger.warn("could not create " + this.info + "ServerSocket port: " + port + " host: " + host, ex);
                throw new INITIALIZE("Could not create " + this.info + "ServerSocket (" + port + "): " + ex.toString());
            }
        }

        protected ServerSocketFactory getServerSocketFactory() {
            return IIOPListener.this.socketFactoryManager.getServerSocketFactory();
        }

        protected final void setup(Socket socket) throws IOException {
            socket.setSoTimeout(IIOPListener.this.serverTimeout);
            socket.setKeepAlive(this.keepAlive);
            socket.setTcpNoDelay(true);
            try {
                SSLListenerUtil.addListener(IIOPListener.this.orb, socket);
            }
            catch (Throwable t2) {
                IIOPListener.this.logger.warn("unexpected exception in ssl listener", t2);
            }
            this.doSetup(socket);
        }

        protected void doSetup(Socket socket) {
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, false);
        }

        public boolean getAcceptorSocketLoop() {
            return this.firstPass;
        }
    }
}

