/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.omg.CORBA.INTERNAL;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.GIOP.VersionHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class IIOPProfile
extends ProfileBase
implements Cloneable {
    private IIOPAddress primaryAddress = null;
    private SSL ssl = null;
    private boolean isSSLSet;
    private final boolean checkAlternateAddresses;
    static final /* synthetic */ boolean $assertionsDisabled;

    private IIOPProfile(boolean checkAlternateAddresses) {
        this.checkAlternateAddresses = checkAlternateAddresses;
    }

    public IIOPProfile() {
        this(true);
    }

    public IIOPProfile(byte[] data) {
        this(true);
        this.initFromProfileData(data);
    }

    public IIOPProfile(IIOPAddress address, byte[] objectKey, int minor) {
        this(false);
        this.version = new Version(1, (byte)minor);
        this.primaryAddress = address;
        this.objectKey = objectKey;
        this.components = new TaggedComponentList();
    }

    public IIOPProfile(IIOPAddress address, byte[] objectKey) {
        this(address, objectKey, 2);
    }

    public IIOPProfile(String corbaloc) {
        this(false);
        this.version = null;
        this.primaryAddress = null;
        this.objectKey = null;
        this.components = null;
        this.corbalocStr = corbaloc;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)config;
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.profile");
        if (this.primaryAddress != null) {
            this.primaryAddress.configure(config);
        }
        if (this.corbalocStr != null) {
            this.decode_corbaloc(this.corbalocStr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decode_corbaloc(String address) {
        String addr = address;
        String host = "127.0.0.1";
        int port = 2809;
        int major = 1;
        int minor = 0;
        String errorstr = "Illegal IIOP protocol format in object address format: " + addr;
        int sep = addr.indexOf(58);
        String protocol_identifier = "";
        if (sep != 0) {
            protocol_identifier = addr.substring(0, sep);
        }
        if (sep + 1 == addr.length()) {
            throw new IllegalArgumentException(errorstr);
        }
        if ((sep = (addr = addr.substring(sep + 1)).indexOf(64)) > -1) {
            String ver_str = addr.substring(0, sep);
            addr = addr.substring(sep + 1);
            sep = ver_str.indexOf(46);
            if (sep != -1) {
                try {
                    major = Integer.parseInt(ver_str.substring(0, sep));
                    minor = Integer.parseInt(ver_str.substring(sep + 1));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(errorstr);
                }
            }
        }
        this.version = new Version((byte)major, (byte)minor);
        int ipv6SeperatorStart = -1;
        int ipv6SeperatorEnd = -1;
        ipv6SeperatorStart = addr.indexOf(91);
        if (ipv6SeperatorStart != -1 && (ipv6SeperatorEnd = addr.indexOf(93)) == -1) {
            throw new IllegalArgumentException(errorstr);
        }
        sep = addr.indexOf(58);
        if (sep != -1) {
            if (ipv6SeperatorStart != -1) {
                host = addr.substring(ipv6SeperatorStart + 1, ipv6SeperatorEnd);
                if (addr.charAt(ipv6SeperatorEnd + 1) != ':') throw new IllegalArgumentException(errorstr);
                port = (short)Integer.parseInt(addr.substring(ipv6SeperatorEnd + 2));
            } else {
                try {
                    port = (short)Integer.parseInt(addr.substring(sep + 1));
                    host = addr.substring(0, sep);
                }
                catch (NumberFormatException ill) {
                    throw new IllegalArgumentException(errorstr);
                }
            }
        }
        this.primaryAddress = new IIOPAddress(host, port);
        try {
            this.primaryAddress.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            throw new RuntimeException(ce);
        }
        this.decode_extensions(protocol_identifier.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode_extensions(String ident) {
        this.components = new TaggedComponentList();
        if (ident.equals("ssliop")) {
            this.ssl = new SSL();
            this.ssl.port = (short)this.primaryAddress.getPort();
            this.ssl.target_supports = this.get_ssl_options("jacorb.security.ssl.corbaloc_ssliop.supported_options");
            this.ssl.target_requires = this.get_ssl_options("jacorb.security.ssl.corbaloc_ssliop.required_options");
            this.isSSLSet = true;
            CDROutputStream out = new CDROutputStream();
            try {
                out.beginEncapsulatedArray();
                SSLHelper.write(out, this.ssl);
                this.components.addComponent(new TaggedComponent(20, out.getBufferCopy()));
            }
            finally {
                out.close();
            }
        }
    }

    private short get_ssl_options(String propname) {
        short value = (short)this.configuration.getAttributeAsInteger(propname, 32, 16);
        return value;
    }

    public void writeAddressProfile(CDROutputStream addressProfileStream) {
        VersionHelper.write(addressProfileStream, this.version);
        this.primaryAddress.write(addressProfileStream);
    }

    public void readAddressProfile(CDRInputStream addressProfileStream) {
        this.version = VersionHelper.read(addressProfileStream);
        String hostname = addressProfileStream.read_string();
        short port = addressProfileStream.read_ushort();
        this.primaryAddress = new IIOPAddress(hostname, port);
        if (this.configuration != null) {
            try {
                this.primaryAddress.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                this.logger.warn("ConfigurationException", ce);
            }
        }
    }

    public int hash() {
        return this.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        IIOPProfile result = (IIOPProfile)super.clone();
        result.primaryAddress = new IIOPAddress(this.primaryAddress.getHostname(), this.primaryAddress.getPort());
        if (this.configuration != null) {
            try {
                result.primaryAddress.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                this.logger.warn("ConfigurationException", ce);
            }
        }
        result.version = new Version(this.version.major, this.version.minor);
        if (this.objectKey != null) {
            result.objectKey = new byte[this.objectKey.length];
            System.arraycopy(this.objectKey, 0, result.objectKey, 0, this.objectKey.length);
        }
        if (this.components != null) {
            result.components = (TaggedComponentList)this.components.clone();
        }
        return result;
    }

    public boolean is_match(Profile prof) {
        if (prof == null) {
            return false;
        }
        if (prof instanceof IIOPProfile) {
            IIOPProfile other = (IIOPProfile)prof;
            return this.getSSLPort() == other.getSSLPort() && this.primaryAddress.equals(other.primaryAddress) && ((Object)this.getAlternateAddresses()).equals(other.getAlternateAddresses());
        }
        return false;
    }

    public int tag() {
        return 0;
    }

    public byte[] getAddressProfile() {
        CDROutputStream addressProfileStream = new CDROutputStream();
        addressProfileStream.beginEncapsulatedArray();
        VersionHelper.write(addressProfileStream, this.version);
        addressProfileStream.write_string(this.primaryAddress.getHostname());
        addressProfileStream.write_ushort((short)this.primaryAddress.getPort());
        return addressProfileStream.getBufferCopy();
    }

    public ProtocolAddressBase getAddress() {
        return this.primaryAddress;
    }

    public void patchPrimaryAddress(ProtocolAddressBase replacement) {
        if (replacement instanceof IIOPAddress) {
            this.primaryAddress.replaceFrom((IIOPAddress)replacement);
        }
    }

    public List getAlternateAddresses() {
        if (this.checkAlternateAddresses) {
            return this.components.getComponents(this.configuration, 3, IIOPAddress.class);
        }
        return Collections.EMPTY_LIST;
    }

    public SSL getSSL() {
        if (!this.isSSLSet) {
            this.ssl = (SSL)this.components.getComponent(20, SSLHelper.class);
            this.isSSLSet = true;
        }
        return this.ssl;
    }

    public int getTLSPortFromCSIComponent() {
        CompoundSecMechList csmList = (CompoundSecMechList)this.components.getComponent(33, CompoundSecMechListHelper.class);
        if (csmList != null && csmList.mechanism_list.length > 0) {
            byte[] tlsSecTransData = csmList.mechanism_list[0].transport_mech.component_data;
            CDRInputStream in = new CDRInputStream(tlsSecTransData);
            try {
                int ssl_port;
                in.openEncapsulatedArray();
                TLS_SEC_TRANS tls = TLS_SEC_TRANSHelper.read(in);
                if (tls.addresses.length > 0 && (ssl_port = tls.addresses[0].port) != 0) {
                    if (ssl_port < 0) {
                        ssl_port += 65536;
                    }
                    return ssl_port;
                }
            }
            catch (Exception ex) {
                this.logger.debug("unexpected exception", ex);
                throw new INTERNAL(ex.toString());
            }
        }
        return -1;
    }

    public int getSSLPort() {
        this.getSSL();
        if (this.ssl == null) {
            return this.getTLSPortFromCSIComponent();
        }
        int port = this.ssl.port;
        if (port < 0) {
            port += 65536;
        }
        return port;
    }

    public IIOPProfile to_GIOP_1_0() {
        IIOPProfile result = new IIOPProfile(this.primaryAddress, this.objectKey);
        result.version.minor = 0;
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof Profile) {
            return this.is_match((Profile)other);
        }
        return false;
    }

    public int hashCode() {
        return this.primaryAddress.hashCode();
    }

    public String toString() {
        return this.primaryAddress.toString();
    }

    public Collection asListenPoints() {
        ArrayList<ListenPoint> result = new ArrayList<ListenPoint>();
        if (this.getSSL() == null) {
            result.add(new ListenPoint(this.primaryAddress.getHostname(), (short)this.primaryAddress.getPort()));
        } else if (this.getSSLPort() == 0) {
            result.add(new ListenPoint(this.primaryAddress.getHostname(), (short)this.primaryAddress.getPort()));
        } else {
            result.add(new ListenPoint(this.primaryAddress.getHostname(), (short)this.getSSLPort()));
        }
        Iterator it = this.getAlternateAddresses().iterator();
        while (it.hasNext()) {
            IIOPAddress addr = (IIOPAddress)it.next();
            result.add(new ListenPoint(addr.getHostname(), (short)addr.getPort()));
        }
        return result;
    }

    public IIOPProfile toNonSSL() {
        if (!$assertionsDisabled && this.getSSL() == null) {
            throw new AssertionError();
        }
        IIOPProfile result = new IIOPProfile(new IIOPAddress(this.primaryAddress.getHostname(), this.getSSLPort()), this.objectKey);
        try {
            result.configure(this.configuration);
        }
        catch (ConfigurationException e2) {
            throw new RuntimeException(e2);
        }
        TaggedComponent[] taggedComponents = this.components.asArray();
        for (int i2 = 0; i2 < taggedComponents.length; ++i2) {
            if (taggedComponents[i2].tag == 20) continue;
            result.components.addComponent(taggedComponents[i2]);
        }
        return result;
    }

    static {
        $assertionsDisabled = !IIOPProfile.class.desiredAssertionStatus();
    }
}

