/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.omg.ETF.Profile;

public class ServerIIOPConnection
extends IIOPConnection {
    private final TCPConnectionListener tcpListener;

    public ServerIIOPConnection(Socket socket, boolean is_ssl, TCPConnectionListener tcpListener) throws IOException {
        this.socket = socket;
        this.use_ssl = is_ssl;
        this.in_stream = socket.getInputStream();
        this.out_stream = new BufferedOutputStream(socket.getOutputStream());
        this.tcpListener = tcpListener;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        IIOPAddress address = new IIOPAddress(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
        address.configure(configuration);
        this.profile = new IIOPProfile(address, null);
        this.profile.configure(configuration);
        this.connection_info = address.toString();
        this.connected = true;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Opened new server-side TCP/IP transport to " + this.connection_info);
        }
    }

    public synchronized void close() {
        if (this.socket != null) {
            try {
                try {
                    IOException exception = null;
                    try {
                        if (!(this.socket instanceof SSLSocket) && !this.socket.isClosed()) {
                            this.socket.shutdownOutput();
                        }
                    }
                    catch (IOException ex) {
                        this.logger.warn("Unexpected exception is thrown during shutdownOutput call", ex);
                        exception = ex;
                    }
                    this.socket.close();
                    if (this.in_stream != null) {
                        this.in_stream.close();
                    }
                    if (this.out_stream != null) {
                        this.out_stream.close();
                    }
                    if (exception != null) {
                        throw exception;
                    }
                    Object var4_4 = null;
                    if (this.tcpListener.isListenerEnabled()) {
                        this.tcpListener.connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
                    }
                }
                catch (IOException ex) {
                    throw this.handleCommFailure(ex);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this.tcpListener.isListenerEnabled()) {
                    this.tcpListener.connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
                }
                throw throwable;
            }
        }
        this.socket = null;
        this.connected = false;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Closed server-side transport to " + this.connection_info);
        }
    }

    public void connect(Profile server_profile, long time_out) {
    }
}

