/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.miop;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.miop.ClientMIOPConnection;
import org.jacorb.orb.miop.MIOPListener;
import org.jacorb.orb.miop.MIOPProfile;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Connection;
import org.omg.ETF.Listener;
import org.omg.ETF.Profile;
import org.omg.ETF._FactoriesLocalBase;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.RTCORBA.ProtocolProperties;

public class MIOPFactories
extends _FactoriesLocalBase
implements Configurable {
    private MIOPListener listener = null;
    private Configuration configuration = null;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    public Connection create_connection(ProtocolProperties protocolProperties) {
        ClientMIOPConnection clientConnection = new ClientMIOPConnection();
        try {
            clientConnection.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            throw new INTERNAL("ConfigurationException: " + ce.getMessage());
        }
        return clientConnection;
    }

    public Listener create_listener(ProtocolProperties protocolProperties, int stackSize, short basePriority) {
        if (this.listener == null) {
            this.listener = new MIOPListener();
            try {
                this.listener.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                throw new INTERNAL("ConfigurationException: " + ce.getMessage());
            }
        }
        return this.listener;
    }

    public Profile demarshal_profile(TaggedProfileHolder taggedProfile, TaggedComponentSeqHolder taggedComponentSeq) {
        if (taggedProfile.value.tag != 3) {
            throw new BAD_PARAM("wrong profile for MIOP transport: tag = " + taggedProfile.value.tag);
        }
        MIOPProfile profile = new MIOPProfile(taggedProfile.value.profile_data);
        try {
            profile.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            throw new INTERNAL("ConfigurationException: " + ce.getMessage());
        }
        taggedComponentSeq.value = new TaggedComponent[0];
        return profile;
    }

    public int profile_tag() {
        return 3;
    }

    public Profile decode_corbaloc(String corbaloc) {
        if (corbaloc.toLowerCase().startsWith("miop")) {
            MIOPProfile profile = new MIOPProfile(corbaloc);
            try {
                profile.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                throw new INTERNAL("ConfigurationException: " + ce.getMessage());
            }
            return profile;
        }
        return null;
    }
}

