/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.IORInterceptorIterator;
import org.jacorb.orb.portableInterceptor.PICurrentImpl;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorManager {
    private static final Comparator INTERCEPTOR_COMPARATOR = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            Interceptor left = (Interceptor)arg0;
            Interceptor right = (Interceptor)arg1;
            return left.name().compareTo(right.name());
        }
    };
    private final Interceptor[] client_req_interceptors;
    private final Interceptor[] server_req_interceptors;
    private final Interceptor[] ior_interceptors;
    private int[] profile_tags = null;
    private final org.omg.CORBA.ORB orb;
    private final int current_slots;
    private final Logger logger;
    private static final ThreadLocal piCurrent = new ThreadLocal();
    private static final ThreadLocal localPICurrent = new ThreadLocal();
    public static final PICurrentImpl EMPTY_CURRENT = new PICurrentImpl(null, 0);

    public InterceptorManager(List client_interceptors, List server_interceptors, List ior_intercept, int slot_count, ORB orb) {
        this.logger = orb.getConfiguration().getNamedLogger("jacorb.orb.interceptors");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("InterceptorManager started with " + server_interceptors.size() + " Server Interceptors, " + client_interceptors.size() + " Client Interceptors and " + ior_intercept.size() + " IOR Interceptors");
        }
        this.client_req_interceptors = client_interceptors.toArray(new ClientRequestInterceptor[client_interceptors.size()]);
        Arrays.sort(this.client_req_interceptors, INTERCEPTOR_COMPARATOR);
        this.server_req_interceptors = server_interceptors.toArray(new ServerRequestInterceptor[server_interceptors.size()]);
        Arrays.sort(this.server_req_interceptors, INTERCEPTOR_COMPARATOR);
        this.ior_interceptors = ior_intercept.toArray(new IORInterceptor[ior_intercept.size()]);
        Arrays.sort(this.ior_interceptors, INTERCEPTOR_COMPARATOR);
        this.orb = orb;
        this.current_slots = slot_count;
    }

    public Current getCurrent() {
        Current value = null;
        if (localPICurrent.get() != null) {
            LinkedList localPICurrents = (LinkedList)localPICurrent.get();
            value = (Current)localPICurrents.getFirst();
        }
        if (value == null && (value = (Current)piCurrent.get()) == null) {
            value = this.getEmptyCurrent();
            piCurrent.set(value);
        }
        return value;
    }

    public boolean hasCurrent() {
        return localPICurrent.get() != null || piCurrent.get() != null;
    }

    public void setLocalPICurrent(Current localCurrent) {
        LinkedList<Current> localPICurrents = null;
        if (localPICurrent.get() != null) {
            localPICurrents = (LinkedList<Current>)localPICurrent.get();
        }
        if (localPICurrents == null) {
            localPICurrents = new LinkedList<Current>();
        }
        localPICurrents.addFirst(localCurrent);
        localPICurrent.set(localPICurrents);
    }

    public void updateLocalPICurrent(Current localCurrent) {
        this.removeLocalPICurrent();
        this.setLocalPICurrent(localCurrent);
    }

    public void removeLocalPICurrent() {
        LinkedList localPICurrents = (LinkedList)localPICurrent.get();
        if (localPICurrents != null) {
            localPICurrents.removeFirst();
            if (localPICurrents.isEmpty()) {
                localPICurrent.set(null);
            }
        }
    }

    public void setTSCurrent(Current current) {
        piCurrent.set(current);
    }

    public void removeTSCurrent() {
        piCurrent.set(null);
    }

    public Current getEmptyCurrent() {
        return new PICurrentImpl(this.orb, this.current_slots);
    }

    public ClientInterceptorIterator getClientIterator() {
        return new ClientInterceptorIterator(this.logger, this.client_req_interceptors);
    }

    public ServerInterceptorIterator getServerIterator() {
        return new ServerInterceptorIterator(this.server_req_interceptors);
    }

    public IORInterceptorIterator getIORIterator() {
        return new IORInterceptorIterator(this.logger, this.ior_interceptors, this.profile_tags);
    }

    public void setProfileTags(int[] ptags) {
        this.profile_tags = ptags;
    }

    public boolean hasClientRequestInterceptors() {
        return this.client_req_interceptors.length > 0;
    }

    public boolean hasServerRequestInterceptors() {
        return this.server_req_interceptors.length > 0;
    }

    public boolean hasIORInterceptors() {
        return this.ior_interceptors.length > 0;
    }

    public void destroy() {
        int i2;
        if (this.hasClientRequestInterceptors()) {
            for (i2 = 0; i2 < this.client_req_interceptors.length; ++i2) {
                this.client_req_interceptors[i2].destroy();
            }
        }
        if (this.hasServerRequestInterceptors()) {
            for (i2 = 0; i2 < this.server_req_interceptors.length; ++i2) {
                this.server_req_interceptors[i2].destroy();
            }
        }
        if (this.hasIORInterceptors()) {
            for (i2 = 0; i2 < this.ior_interceptors.length; ++i2) {
                this.ior_interceptors[i2].destroy();
            }
        }
        piCurrent.set(null);
        localPICurrent.set(null);
    }
}

