/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.miop.MIOPProfile;
import org.omg.CORBA.Object;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.MIOP.UIPMC_ProfileBody;
import org.omg.PortableGroup.TagGroupTaggedComponent;

public class CorbaLoc {
    private final ORB orb;
    private String keyString;
    private byte[] key;
    private String bodyString;
    private boolean is_rir;
    public Profile[] profileList;

    public CorbaLoc(ORB orb, String addr) {
        this.orb = orb;
        this.is_rir = false;
        this.parse(addr);
    }

    public boolean rir() {
        return this.is_rir;
    }

    public String toString() {
        return "corbaloc:" + this.body();
    }

    private String body() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.bodyString);
        if (this.keyString != null) {
            buffer.append('/');
            buffer.append(this.keyString);
        }
        return buffer.toString();
    }

    public String getKeyString() {
        return this.keyString;
    }

    public byte[] getKey() {
        return this.key;
    }

    private void defaultKeyString(String defaultKey) {
        if (this.keyString != null) {
            throw new IllegalStateException("KeyString not empty, cannot default to " + defaultKey);
        }
        this.keyString = defaultKey;
    }

    public String toCorbaName(String str_name) {
        if (this.getKeyString() == null) {
            this.defaultKeyString("NameService");
        }
        if (str_name != null && str_name.length() > 0) {
            try {
                return "corbaname:" + this.body() + "#" + str_name;
            }
            catch (Exception e2) {
                return null;
            }
        }
        return "corbaname:" + this.body();
    }

    private void parse(String addr) {
        String sb;
        boolean isMIOP;
        if (addr == null || !addr.startsWith("corbaloc:")) {
            throw new IllegalArgumentException("URL must start with 'corbaloc:'");
        }
        boolean bl = isMIOP = addr.indexOf("miop") != -1;
        if (isMIOP && addr.indexOf(",iiop") != -1) {
            throw new IllegalArgumentException("MIOP Profile does not support Gateway Profiles.");
        }
        if (!isMIOP && addr.indexOf(47) == -1) {
            sb = addr.substring(addr.indexOf(58) + 1);
            if (addr.startsWith("corbaloc:rir:")) {
                this.is_rir = true;
                this.keyString = "NameService";
            } else {
                this.keyString = null;
            }
            this.key = new byte[0];
        } else {
            sb = addr.substring(addr.indexOf(58) + 1, isMIOP ? addr.length() : addr.indexOf(47));
            this.keyString = addr.substring(addr.indexOf(47) + 1);
            this.key = CorbaLoc.parseKey(this.keyString);
        }
        if (!isMIOP && sb.indexOf(44) > 0) {
            StringTokenizer tokenizer = new StringTokenizer(sb, ",");
            this.profileList = new Profile[tokenizer.countTokens()];
            int pIndex = 0;
            for (int i2 = 0; i2 < this.profileList.length; ++i2) {
                Profile p2 = this.parseAddress(tokenizer.nextToken());
                if (p2 == null) continue;
                this.profileList[pIndex] = p2;
                ++pIndex;
            }
            while (pIndex < this.profileList.length) {
                this.profileList[pIndex] = null;
                ++pIndex;
            }
        } else {
            this.profileList = new Profile[]{this.parseAddress(sb)};
        }
        this.bodyString = sb;
    }

    private Profile parseAddress(String addr) {
        int colon = addr.indexOf(58);
        if (colon == -1) {
            throw new IllegalArgumentException("Illegal object address format: " + addr);
        }
        if ("rir:".equals(addr)) {
            this.is_rir = true;
            return null;
        }
        Profile result = null;
        if (this.orb == null && (colon == 0 || addr.startsWith("iiop:") || addr.startsWith("ssliop:"))) {
            result = new IIOPProfile(addr);
        } else if (this.orb != null) {
            List factories = this.orb.getTransportManager().getFactoriesList();
            Iterator i2 = factories.iterator();
            while (result == null && i2.hasNext()) {
                Factories f2 = (Factories)i2.next();
                result = f2.decode_corbaloc(addr);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Unknown protocol in object address format: " + addr);
        }
        return result;
    }

    private static boolean legalChar(char c2) {
        if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
            return true;
        }
        return c2 == ';' || c2 == '/' || c2 == ':' || c2 == '?' || c2 == '@' || c2 == '&' || c2 == '=' || c2 == '+' || c2 == '$' || c2 == ',' || c2 == '_' || c2 == '.' || c2 == '!' || c2 == '~' || c2 == '*' || c2 == '\'' || c2 == '-' || c2 == '(' || c2 == ')';
    }

    private static byte hexValue(char c2) {
        return (byte)(c2 >= 'a' ? 10 + c2 - 97 : (c2 >= 'A' ? 10 + c2 - 65 : c2 - 48));
    }

    private static char hexDigit(byte b2) {
        if ((b2 & 0xF0) != 0) {
            throw new IllegalArgumentException("Hex digit out of range " + b2);
        }
        return (char)(b2 < 10 ? 48 + (char)b2 : 65 + (char)b2 - 10);
    }

    private static boolean isHex(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
    }

    public static byte[] parseKey(String s2) {
        char[] tmp = s2.toCharArray();
        int count = tmp.length;
        for (int i2 = 0; i2 < tmp.length; ++i2) {
            if (CorbaLoc.legalChar(tmp[i2])) continue;
            if (tmp[i2] == '%') {
                if (CorbaLoc.isHex(tmp[i2 + 1]) && CorbaLoc.isHex(tmp[i2 + 2])) {
                    count -= 2;
                    i2 += 2;
                    continue;
                }
                throw new IllegalArgumentException("Illegal escape in URL character");
            }
            throw new IllegalArgumentException("URL character out of range: " + tmp[i2]);
        }
        byte[] result = new byte[count];
        int idx = 0;
        for (int i3 = 0; i3 < count; ++i3) {
            if (CorbaLoc.legalChar(tmp[idx])) {
                result[i3] = (byte)tmp[idx++];
                continue;
            }
            result[i3] = (byte)(CorbaLoc.hexValue(tmp[idx + 1]) << 4 | CorbaLoc.hexValue(tmp[idx + 2]));
            idx += 3;
        }
        return result;
    }

    public static String parseKey(byte[] key) {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < key.length; ++i2) {
            if (!CorbaLoc.legalChar((char)key[i2])) {
                buffer.append('%');
                buffer.append(CorbaLoc.hexDigit((byte)((key[i2] & 0xFF) >> 4)));
                buffer.append(CorbaLoc.hexDigit((byte)(key[i2] & 0xF)));
                continue;
            }
            buffer.append((char)key[i2]);
        }
        return buffer.toString();
    }

    public static String generateCorbaloc(org.omg.CORBA.ORB orb, Object ref) {
        ParsedIOR pior = new ParsedIOR((ORB)orb, orb.object_to_string(ref));
        Profile profile = pior.getEffectiveProfile();
        if (profile instanceof IIOPProfile) {
            return CorbaLoc.createCorbalocForIIOPProfile((IIOPProfile)profile);
        }
        if (profile instanceof MIOPProfile) {
            return CorbaLoc.createCorbalocForMIOPProfile((MIOPProfile)profile);
        }
        throw new IllegalArgumentException("Profile type not suported: tag number=" + profile.tag());
    }

    private static String createCorbalocForIIOPProfile(IIOPProfile profile) {
        StringBuffer sb = new StringBuffer("iiop:");
        sb.append(CorbaLoc.createString(profile.version()));
        sb.append("@");
        sb.append(((IIOPAddress)profile.getAddress()).getIP());
        sb.append(":");
        sb.append(((IIOPAddress)profile.getAddress()).getPort());
        sb.append("/");
        sb.append(CorbaLoc.parseKey(profile.get_object_key()));
        return sb.toString();
    }

    private static String createCorbalocForMIOPProfile(MIOPProfile profile) {
        StringBuffer sb = new StringBuffer("miop:");
        sb.append(CorbaLoc.createString(profile.version()));
        sb.append("@");
        sb.append(CorbaLoc.createString(profile.getTagGroup()));
        sb.append("/");
        sb.append(CorbaLoc.createString(profile.getUIPMCProfile()));
        sb.append(";");
        sb.append(CorbaLoc.createCorbalocForIIOPProfile(profile.getGroupIIOPProfile()));
        return sb.toString();
    }

    private static String createString(TagGroupTaggedComponent groupInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append(CorbaLoc.createString(groupInfo.component_version));
        sb.append("-");
        sb.append(groupInfo.group_domain_id);
        sb.append("-");
        sb.append(groupInfo.object_group_id);
        if (groupInfo.object_group_ref_version != 0) {
            sb.append("-");
            sb.append(groupInfo.object_group_ref_version);
        }
        return sb.toString();
    }

    private static String createString(UIPMC_ProfileBody uipmc) {
        StringBuffer sb = new StringBuffer();
        sb.append(uipmc.the_address);
        sb.append(":");
        sb.append(uipmc.the_port);
        return sb.toString();
    }

    private static String createString(Version version) {
        StringBuffer sb = new StringBuffer();
        sb.append(version.major);
        sb.append(".");
        sb.append(version.minor);
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] noarg = new String[]{};
        ORB orb = (ORB)ORB.init(noarg, null);
        for (int i2 = 0; i2 < args.length; ++i2) {
            System.out.println(new CorbaLoc(orb, args[i2]).toString());
        }
    }
}

