/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import org.jacorb.util.ObjectUtil;

public class KeyStoreUtil {
    static KeyStore getKeyStore(String file_name, char[] storepass, String keystoreType) throws IOException, GeneralSecurityException {
        return KeyStoreUtil.getKeyStore(file_name, storepass, keystoreType, null, null);
    }

    public static synchronized KeyStore getKeyStore(String file_name, char[] storepass, String keystoreType, String keystoreProvider, String providerImpl) throws IOException, GeneralSecurityException {
        KeyStore ks = null;
        if (keystoreProvider != null && keystoreProvider.length() > 0) {
            KeyStoreUtil.checkProvider(keystoreProvider, providerImpl);
            ks = KeyStore.getInstance(keystoreType, keystoreProvider);
        } else {
            ks = KeyStore.getInstance(keystoreType);
        }
        InputStream in = null;
        if ("JKS".equalsIgnoreCase(keystoreType)) {
            URL url = ObjectUtil.getResource(file_name);
            if (url != null) {
                in = url.openStream();
            } else {
                File f2 = new File(file_name);
                if (!f2.exists()) {
                    String name = System.getProperty("user.home") + System.getProperty("file.separator") + file_name;
                    f2 = new File(name);
                    if (f2.exists()) {
                        in = new FileInputStream(f2);
                    }
                } else {
                    in = new FileInputStream(f2);
                }
            }
            if (in == null) {
                throw new IOException("Unable to find keystore file " + file_name);
            }
        }
        if ("WINDOWS-MY".equalsIgnoreCase(keystoreType)) {
            storepass = null;
        }
        ks.load(in, storepass);
        if (in != null) {
            in.close();
        }
        return ks;
    }

    public static Provider checkProvider(String providerName, String providerImpl) throws GeneralSecurityException {
        try {
            Provider provider = Security.getProvider(providerName);
            if (provider == null && providerImpl != null) {
                Security.addProvider((Provider)ObjectUtil.classForName(providerImpl).newInstance());
            }
            return Security.getProvider(providerName);
        }
        catch (Exception e2) {
            throw new GeneralSecurityException("Cannot use the provider: " + providerName + " implemented by " + providerImpl + ". Cause: " + e2.getMessage());
        }
    }
}

