/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.bluez.crypto;

import com.ibm.j9.bluez.crypto.ASN1;
import com.ibm.j9.bluez.crypto.BigInteger;
import com.ibm.j9.bluez.crypto.CL3Exception;
import java.util.Random;

public class CL3 {
    public static final int ENCRYPT = 0;
    public static final int DECRYPT = 1;
    public static final int ALGID = 7;
    public static final int PKCS1 = 1;
    public static final int PKCS8 = 2;
    public static final int SPKI = 3;
    public static final int SPKAC = 4;
    public static final int PKCS10 = 5;
    public static final int X509CERT = 6;
    public static final int TLS = 8;
    public static final int MD2 = 1;
    public static final int MD5 = 2;
    public static final int SHA = 3;
    public static final int SHA256 = 4;
    public static final int SHA384 = 5;
    public static final int SHA512 = 6;
    public static final int MD5SHA = 7;
    static final int DIGEST_INFO = 16384;
    protected int type;
    protected Object obj;
    public static final int VERSION;
    public static final String RELEASE;
    public static final boolean jCLiC = false;
    private static final String jCLiC_RELEASE;
    private static CL3 rngState;
    private long ptr;
    private static final short[] logtab;
    private static BigInteger P64;
    private static final int[] syms;
    private static final byte[] sbuf;
    private static int nsam;
    private static int bits;
    private static long accu;
    private static final byte[] Pmd2;
    protected static int[] Pi;
    public static final int T_DH_PARAMS = 12;
    public static final int T_DH_PUBLIC_KEY = 13;
    public static final int T_DH_PRIVATE_KEY = 14;
    public static final int DH_SHARED_PARAMS_512 = -1;
    public static final int DH_SHARED_PARAMS_1024 = -2;
    public static final int DH_SHARED_PARAMS_2048 = -3;
    private static final BigInteger[] dhSP;
    private static final String BF = "\u0012\u000fm(D\u0016F\biDc\u0018Q8\u0006p9Q\u0014@I`D)OL:\u0000A;u\u0018v\u0013MHJ\u0014P!s\u000e\u001a\u0001\u001b^|T33fNH1Y@V\n6|Kq!]\u001fa\u001a[-U\u000e\t\u000bdBm.f\u0012y}Fz\u0013\b.M\u0018om5B\u007fue[h\u0006[{=cC/vZDgtZt|H\u0011>\u0012c~2$Pf({\u001cEYw\u0004\u0000>.\u0014\u0016\u001d|\u000b\u0018m\u0012\u0006abW'\u001a4EGzGtIO/`lUi\u000f9#VeCF\u0017M, BTW9vTR\u00078%Rfk\u001c\u00185'\u0012WI@\u0013bt6\u0002\u0019!A\u0005x2H\u0017Hbq[\u001c;qgNr``\u001d\u0006\u0001fdx\u001d\u000bX\u0007Q#v\\*w`o&\u0014Y\u001dq/\u0017vJV\u0002qAf*I>:RVW\u0014+R\u0013\u0006\u0013\u000fP\u0014 \u00159#K(U+\b-VLbph\u0011 z\u0019j\nR\r/>\u001c]\u0019\u001dO\\\u0014\bXm{a(W)bW.AAGmN.\u000fBi\\\u001e&\u001eWuW#\u001b0IO.\u001eF%\u001c\u0004Q\u0015C\u001dg8z\"0k%n5|%\u007fP\u001b3\n\u0004\u0019\u001b\u00070\tf>d\u001aLE\u0010|V\u0018\u000b^d\u0000eoB\u0017+^L\u0015k1n\tD0\u0017-J\u001bD\bq\u0013t\u0007'\u0016V1!vk?g\u0003z\u0010G\u0012p-\t\u0002R!\u0004\u0000#'\u0011p%'CyZxCF4\u0010^nK24g\u0006'\f\u001a^N\u0011p5\u00144\r\u0016a(/4%Az9\"VQ\u0019hmnx-X\u0013=\u000e|KQo`P?>e)E\u0007be\u000eN5p\u000bYMJ,OP$\u0018:\u0011\fw!C\u0014+>?4>a\u0014\\\u0019n\u0016^_8\rw.b\u000bA\u0010\u001ch\u0001R\u0012>V`ZTdvNTb\u001b\u000fnp0o}_9\u0010S0\u0011toPkI\u001a\u0000PI\u0011[\u0007zZ4OG\u0001\u001b\u0003Tn,L\u00022\u001b=I:GNcmho=|?r@56<S\u00079;3A=\u00020\u0000kV\u0006RO[\u0010\u0013v\u0006\u0011<\\O0C\u0016Q\u0011Fh}[uss1'5\tN6.Ym%l7[?E\b~60JK\u0019H\n\u0015\t///!\u001bw\u000f \u0004o\fi/k\u0018\u001e(\u0003F%d]O\u0001KT\u0015h\\CP\u001fR\u0005Wg\u001bNOw[*^8\u000bhi@2\u00055T\u0010\u0006\u0019\u0000,9\u001e,yy\u0017}{\u000fhyHu\u0017SxmLD/Aqj\u0016o\u007f,\u0016XT^P\u000f2\u0015P*JV2\u001em?/i\u000e\u000e`)L/4Ax\u0001_A'KE=o\u0014oF(\u0003(:X]_\u000bZ;=*\nQv\u0014\u001f_|\u001d1N2c#\tu+MR[\u0013l\u0017<Rc\u0011a\u007fhk[G@# \b>GYGtC\u0003\\\u0012_K+0[QiVs%\u001f\u0011s6|\u0011,]\u00149\u0013<%~ry\u0007\u0007;rm)\u00197qME{\tP9n&\u001bQo\u00102[#3]\u0018\u0001h\u001fSoq/b\u001fZ%;=R6]\u0010Hf\u001d*l9bkIu4\r\u0004;#PWqd^\u00048x[\u0017cNY%^\u001fvq>~!\u0011-I\bD.\u0002)\u00007`\u001c'k+j\u0003\"\u001fC\u000e49\u007f\fFg(`k%ry\b1>\u0007\u0005n~ST[~E@Cz\u000f\u0016AL\u0007m-w' 1,yuYhO\n34T\u0013|\u000fhOA7>1\u00078\u000eJ[(lEKz\u0013\u001a\u0001\u0015;A2<cL(!\r\u0005\u000e~54@e;m?(6\u001d(Bz~sS.?WMWC\u000f3t&AV Fz:py|I\u0000\t!bi\u0001c3/\bM\u0000\u0005m/8p+dF!Z7p\u0004n#e+\u000e\"\u001d,wtjSc\u0002CDv+%\u001b|@}-h@.-g\u000b\u0003\u0013\u0000nf\u0014W\u001f)\br\u0003\u0016B9fJ lhrn)v\u0014TRC5\b\u0001%\u001a)J\"]0=.?^&xn!-A$; <g \u0000\u0011:7m*q_$?rK;\r2P72\u0015[\u0018lR\u000f\u001esy[?f@);\u000b\u0005+\u0019\n;\u00015;)Oct\u0010Ei\u000f\u00197! vR-tptm62J\u00136u\u0004KXAI\u0018G-7)V\u0004M\u001f>}N;L\u000bD?[23;\u0015(cES\u001a\u000b\u007fjf\"IYBXg\\\u0011IX\u0005%:B)BM\u00012\u0013 9\u0003\u0003Qx~TL&K4\u0014uJkGy\u001aiO\\\u007fVPtS@??P0zS%SG\u001b`%.p)Mi\u0002\r\u00048:df\u001c\u000bSF\u0001\u0007YEp%Pk\u001fOW.~$y\u0017\f\u0005\r6SBBh?M0E\u0015\u0003E\u0006[g\n0-) \u0007\u001bO@x q\u007f^W\u0017\u0011gj\u0013XW\u000b<W\u000b\u0001k47x\u0014\u0001@o@8\u001f\u0002\u0000@\u000b\u001f~\\\fzFGK+Rd%A^K\r`$C=hd\"?KrR/{%\u0006$;LEu#@'./\u0016\u00027a6[LEUl4M<{Z=%\ba#\u0003z\u0000\u0018;YHcOTG(y\u0003b\u001c33\u0013_(\u001c/\u0019 \u0017:\b`}3\u0018SJHYa\u001em\\B\rt\u00104\u0007v\u0005\u0001\u0017re`%\u0010\u0012%oGJYs09/\u0015xM?=\u001a;G{\u0019\u0018 !3EkB-f<~.*DN!y9Vq\u0012\u0014\u0003-o\u001a?\u0004fao%B\u001c0t\u00046B{d~5<tRoXg1ul\u001d6pQoiF\t!YXF&\u000f%o\u000e\u0006\bs\u0010W2\bnPg39\u0013\u0005:\u000b\u0004T\u0014j\fTeb\u0014*\t \u0000\u0004\u0013\u001d9\u001bW\u000e\u007fq\u001e\b\f)e,\u0006Xwk\u0017b\u0011Ll\b5+<:z\u001e\u001dV<\bF\u00075I\u0012J\ty#|nl_c{}'W+y0<\u0015\u001e\u001bPn\u001a\u0015ajt[v\u001809<\n-\u000fE+\u001b\\?g\u000e\u0013GP7hRen.3\u001e8t\u001f\u0000\u001f\":e\u0013\u001b\u0010%\u0017\u0013\u0019\u0017Dp!351BPuj)bu\u001e\u0014_aq&\u001e\u0005\u000b>O\u0017]\u001d'\u001b\u0007%3hdr&\u0007F8'K\u0001$#SB\u001eq\u0018JmkV\u007fMnV\f>fqo\bY-\u0019wHAl/s>D\u0003\f\u007fJ\u00183\u0016w_>6\u0016TV*`C\u00054*s\u0000\u0017;\u001d%\u0007vey)lUo>k+6q>\b\u0015\u0010mE\u0002H\u001dBpv7(w+\u0006>\u0015\b\u0004yJACVa^e@3'x=*\u0001Xy{+M9\u0010&\u001c\u0014#NV=\u001e\u0005ru-pS]LC/\f\u0006\u00112O\u001cUW\u0015;\u0017N\bn2\"cjxf{pe(\u00046MeJZ]T\b\u0006Bhd<\u0015-\u00163\f{SU`\b7\u000f<m(\u000b\fakz\u0004f+wL_L#kvQx\u001bb\u0013)?\fZw\b{25xYP\u0012@CFXA'\u000ff\u000fuRmv~Bx,.S\u0015?V\t%\rHN&\u001cn\u0007C\u007fFX$4[\u001b3\u0005:j2qA)\u000flR\u001cFmpb(,:~.yS\r\u007fu?E\u000ek\u0007\\|\u001e\u001ckTPS3h2-|4\u0010A:\u0014\u0010\u000fB>\u0002\u0017]b[(u*_+6l'E?,Z?!G!=\b.{*w52Sg1j\u0007\u001a!\u0002v\u0003gLz\r\u0005&q|DZ\u001dT=@XJ\f{\nCr-c$d7r\u0011\u0003P08{5\r~\u0015\u00120m\u001c[R$GB\"A54Je\u0005\u0004Vwp\u000542HNE\f+\u000bPG\u0002\u0007\u0000\u000b\u0004\u00144T\f*}=!m7h>\u0011On\u0006\tMepI#27r\u0007,_v<-B\u0011o6|o\rk\u001c_9h` !>*>9n27)@x\u0004\u00103x(']\u000e~a*alefZK&O*bC\u0000l\u0012h\t+~ \u0001<Vr<D=\u000bX4)R\t}jY`Ppz=Im\\{=\u0018A+\bfYk}SgFg!P\u0018\\!QJq\u001f\u000e\u001b\u0003i#q\u001ex[?r\u0000T|!scv\u0003j+McOJ{8\u001d7oi\u001eVM\t$\u0005\u0001w{\u0013\u0004adQR)\u001a\u0010\"R\u0007]l\u0002j=wO#,]TQ\u0000\r\r  Hq\u0019H\u001eFR\u000eoT[T\u0000\u0006\r<<9{\u000bRr\"\u0015\f\u0014\u0010SnK|.\u0010@&e?AlZk\u0011W\\\u001eMnMM \u0017Q7{`'X\u0003^epW}1[P\u0018rpP$[V'YU?SJ\u00074%#yU<P*4((\u001e\u0004U\u0018\u0010St\u0005\u000b\u0010mW&lm}Z\u001bA#\u000b.H4@\r\u0000v\u0002H'Pc=dy\u007f}\"t!uXeV\u0019`\u0003\u001e^M5ZUN\u000f\u001f\u001a3:\u007fYN<(s\u0014\u0003,TB\u0010?Sc.gg\u0005\\{G\u001d=,v\u0012'\"c\\OknK6F\nb5\rL1u8r{\u0011i]z:7+4\u0019IPAs}y'A\u0003w{\u0005=)mGzg\u0017\"P\njei\u0011\u0015\u0013U*3QhA\u0003Fa\u007ff]&oPK%)5-!O<PE3%F2R)1f<\u001dYNL*%\u0015Gs\t\u0017r^z\u001fCI\u0001$b|~~\u001d\u0000\u0010\u0010N/8 \u00171*p\n(\u00168r\\\bU\u0011dc\u001b$$F\u0004&?cCpm`\u001fsIw\u0010 Ax=\u0000G<i\u000bXC8.2/T==,o\u0001Qy/\u0018\u0018z\u0004\"52\t/7AQ@*N\u0018\u001b\u007fG\"F\u001f1[\u00030pJiB\u00018&)u=LOhrZ\u0018\bUV#Jx\u00063tKB;\u0012\u0002l.uzr\"BlT w\u001at\rLwN d0[\"{J\u001a\u0001\u0013a\u000b\u0015[e\u001fV#t\u0010bss\u001e_\u0002Q\u0013#7aoTGk\u0007\u001d~I~3t4<\n#Xh\u0019I;~t\u001d\u001bmj_Sq}\u001bj\u0002-c\u0002Ckn~\u0013\u0011_\u0005\u0019[7\u001aa\\3m*\u00106YeC9\u001dKT\u001dw\u001a\u000e@\u0013b)\u0006qy@\u0007~G5\u001cCr&H?Z\u000b3\u001es\u007f^;6}N(\u0012\u001cx/2\u0015/(w1\u0019>\u0010Q-k$G\\Qs?;\u000eznY\\r.Ys\u0002\u0015Kf\u0000&q%~BqDZh!+4|3(V;\t\u001d)Lc`]q\u000e\u001aB$\u0011^o\u0012(y`j\roLK}Xj\u0001S, \u0018\br]_QtK=l8\\\u001c\u001e%\bB\u000b\u0016!!\u0010N\rY\u0006;\rm-/T*2+ltvj\r(/oW~L!Ida\u007fS[d\u0001/p{p\u0010f\u0003awx0\u0000l\u0004nG{\u0003#=G\u0001}AnEW\u0001\u001as7s\u0019\u0003!\u001af?\u0000zVqX \b\u00189p\u0000^/]t\u0005=z{hW\t\nT2\n3?,\u000bL\u0014rci\u000fy7?Z\u0017Qio\u001c!q\u001bn\t&f|py\u000b\u001c9i4:|JT7s39=:df\f,;_B!\r sf\"_JxHfrf\u001c Z\u0015n\bfU+\u0011d@[ded\u0017,pnp .@#(1\u0012\u000eW%&=7?F6n\u0005'8\t3\u000b!\u001a\u000e\u0010dF\u0019z\u000b!x\b\u0013p_#\t)M\u0000J\u001d7?B\u0001Udz\u001d\u0005i4M}\u0006\rr\u0007J\r\u000f\u000b'97m jsH\u001b}!q3S4~5~R(\u0004+`\r\u001c\r\u0003}(\u0000+.\u0010\u001bfh\ts/D0Nw\u001faH\u001c\u001b\u0001\u0018\u00060j\u0000k/@.z\u00140\u001eX7\u0000\u0000`,*F\rcuD\u0011s'Zr\u0019cTc)p[Y&\u000b\u0004\u0016\u001a.y>rZ!<[7]?cvCN,G.fx\u0017H\t%_\u0000\u0018Aed\n\u001e_\u0012'a\u0012\rc9\u0017n$lvr\u001a`VvM\u001czq|vU\nW@#y%Zv\u0007WfM\u001b-\u0007q\u0003e\u0007==10y_\n\u0014\u0014)Y6\u0014\"3c?+GsU\\\u0014v\u0010l*_s[\\6 oWM\fFI\u0013\u000e\u0004\u00123C_(r\u0001@\u0000p\u000eG\u001cq_'zzsu<\u0013\\nZbK#5eAO\u001e'hft\u0016N\u0004' &7I]{*\u0011G'7p{L+V\u0016G\u000fl8\u0003\b{[c\u00036Y\u0006C\u0010\"lMk\ryT67-\ntE,_<J\u001bO\u001c5\rmR2R8,BL\u001fxw\u0011Q]sw*s\u0005\u0007)M\u00027\f)\u001cn{:Mi\fPV%$nEy=c\u0002(?-/AT-(fL>|3E\u001aC;D,\u0004'\u00058!I\u0005o5\u0014<\u0003U'\u001e-\u0005\u0012\u0007@0nS>K)\u001b\u000frE*\u000bS\u00117V\u0014\tT/M\u001ct:pRu\u0019,\u001b^U1:8r\u007f?'w)={#x\u0011^i;~A%L\u0003I)\nav\b0\u00066\ts+'3w\u0016'iH?+)qS/\u0017\u0016<\u0016}H\bW\u000b(eZZah\u0002}S\u001f:\u001cy{,|>K%\u0001||KOV|W\tZk-49\u0016Q\u000f*3@)V\u001c<\u0001M\u0017LGX+\u001f^lOu\u001bt4xHi vWf>\u001aV1%r\u0013\u0017\n\u000f\u0005x\u0006#m:X\n_<X\u001cDqtkh`T\nmj\"\u001eFmh\u0007!0I V'B{CugBSdA/\"KIc.e$t\u0007\u0015\u0006gvll<c\u0010}>Yc\u001bv&n<c\u0017)O2(XU?_(\r,4A\"W#elPQ;D8 Vgq+f\u0014,|e6$_&z\u0002u\t`a\\G\rsUC\n& |d='TC\u0005{\u001f\u001eye\t\u0007\u001cd;Swc\u0015\"mc?0e\u0013j\u0019\u0011^)Z,A\u001f\u001a\u0001\"W\u0002\u0002\rk6d$4a%_h$\u000e!3,s$0)HE`7+\u0006f{\u001e\u001c\u00102\u0015e]{o]\rV\u0011T\u00063$\u0001?ZvN\u001do;\"5\u001fG%O}\n>\u001aBHKeS\u001bU9:YjGiI\u0004]c,a\u0015:~<7Qz)_\u0011FT\u0017W3jv\tn\u001b{\u0013L7\u0003P\u001c\rFyk1\u001a_pr\u000b\u001c5u\u001bu:@ 2a\u0004uSEL\u001a4HfP\u0004+/B86\u0000!\"+\u0018\u001d\u0007 kD~iN7(\t\u0006y|w\u0002\u001aH\u00158\u0010\u00044\u001d%In\"?aB\u00150,<y\u0019\u007f9;\u001d\u001e%3\"\u0014K=P\"\u0007\u001e\nG\u001cy%Kf,M^@\u001f]2<\u0001f!}<ct>lx\u0004#CPz\u0015,8j!\u0007$u\t{lk!Zo2zPVhp\u0003\u001cpe,4DlgF~&\u0017g\u0002b+'}seM]\u0007u]N^-(g~'lQ3K|\\D,\ny_BP>#|8frA)\u0017ueIX9k4sWBT\u0019\u000b\u0011\u0015jQQ[0 uw\f\nj\u0006\u0004\u001a%\u0003\u0017\u0016\u0003R\u0010\\\u000ec8\u001c\u0016L6g4dbA>\u0019\u001e\u001d\u0016$|?\u0015\u00198\u001a9\u0016\u007f' \u001a\nq\u0017\u000fH<\u001b\u0005\u001d\b\u0014]\fi\fboN\u0012\u0006\rl2l7fY|67\u0019\u0017K\\`[=\u000e\u000fq|#^*34T\u000f6[\t\u000e9Dygs'gs<,\u0018XY_R`t\u000b\u0004GtX_7lE\u0019zH~5=\u0018dv\u0011du\u0003)E-Lf@UO\u0004\u0005DZ:zvVpXm\u0017D4N<fz,bI 7\u0014NA\u0018PH\u0006n\u001c2X)fc1wS\u0013h(\n\"x:\u00006\u000fd{M25%\u001fuE(\u0007@\u00172-\u007fD5^t^g\bIR\u0005Y\u0001\u0000\"\u0015[\u0017O>3.ia-&\u0011\u001f0\u0002d\u0007\u000f&8Uo,\u0002*\u001e[p]\u000e\u0004\tg]\rN;\u001duz\u000e\u0014@u0\u0018\u0010\\_y\u001d\nt#;\u0007U+s0&>5'pe\u0011B.\u0000_8T0\u0003C59\u001an_\u0007s\u0010j>\r\u001a2s= \u001fB$Rn\b\u0011fOmif\tK\u001cwq\u0016jx~\u007fF:a\\\\`";
    private static final byte[] Prc2;
    public static final int T_DSA_PARAMS = 8;
    public static final int T_DSA_PUBLIC_KEY = 9;
    public static final int T_DSA_PRIVATE_KEY = 10;
    public static final int DSA_HASH = 3;
    public static final int DSA_RAW = 0;
    public static final int DSA_SHA = 1;
    public static final int DSA_ASN = 4;

    static {
        jCLiC_RELEASE = null;
        RELEASE = "CryptoLite 3.11.3373 (BlueZ/MIDP)";
        VERSION = 311;
        rngState = CL3.rngNew(128, 30);
        short[] sArray = new short[64];
        sArray[1] = 22;
        sArray[2] = 44;
        sArray[3] = 66;
        sArray[4] = 87;
        sArray[5] = 109;
        sArray[6] = 129;
        sArray[7] = 150;
        sArray[8] = 170;
        sArray[9] = 190;
        sArray[10] = 209;
        sArray[11] = 229;
        sArray[12] = 248;
        sArray[13] = 267;
        sArray[14] = 285;
        sArray[15] = 304;
        sArray[16] = 322;
        sArray[17] = 340;
        sArray[18] = 358;
        sArray[19] = 375;
        sArray[20] = 392;
        sArray[21] = 409;
        sArray[22] = 426;
        sArray[23] = 443;
        sArray[24] = 459;
        sArray[25] = 476;
        sArray[26] = 492;
        sArray[27] = 508;
        sArray[28] = 524;
        sArray[29] = 539;
        sArray[30] = 555;
        sArray[31] = 570;
        sArray[32] = 585;
        sArray[33] = 600;
        sArray[34] = 615;
        sArray[35] = 629;
        sArray[36] = 644;
        sArray[37] = 658;
        sArray[38] = 672;
        sArray[39] = 687;
        sArray[40] = 700;
        sArray[41] = 714;
        sArray[42] = 728;
        sArray[43] = 741;
        sArray[44] = 755;
        sArray[45] = 768;
        sArray[46] = 781;
        sArray[47] = 794;
        sArray[48] = 807;
        sArray[49] = 820;
        sArray[50] = 833;
        sArray[51] = 845;
        sArray[52] = 858;
        sArray[53] = 870;
        sArray[54] = 883;
        sArray[55] = 895;
        sArray[56] = 907;
        sArray[57] = 919;
        sArray[58] = 931;
        sArray[59] = 943;
        sArray[60] = 954;
        sArray[61] = 966;
        sArray[62] = 977;
        sArray[63] = 989;
        logtab = sArray;
        byte[] p64 = new byte[9];
        p64[0] = 1;
        p64[8] = 13;
        P64 = new BigInteger(1, p64);
        syms = new int[32];
        sbuf = new byte[256];
        nsam = 64;
        bits = -1;
        Pmd2 = CL3.getBytes("\u0014KH<M\u000b0|\u0000O&e%\u0007Yp\u0003\u0004l*8\u0017g@c\\qIDLWY^\u0013\u0010,Pz6W\u001e?:N\u0000YNB7F\u0011!?\u0014%>'1\u001amT{<IP>~Xul_n=*-\u0007LD+2\u0003OrL\u0010B\u0012\u000b\u0011\u0017d\u0018\u0003};\u001a-$\u0006\"9T}Lso~y8\u000f~\u0019\u0018,i\n-W#W/$E*bZUF'n\u0007\r\u0014ZH}[\u001d_F_\n8t\u0002<(YkA2d8ad\b2o\u001ees\u000b5\u0000\u0010m@%VkV\u000bOX8F0Z&D\u0003x\u001eU#hd=jF^:aW\u001f\u001cuk\u000bj\u0013\u000b\n0k:\n(B\u0002:=~7hA@S*&VpoH605?Q\u0013B{\u0004\u0003\u0017[\n)q\bJb|6\u001f![ieu?cX\u0000:9y;vps\u00191Pr)Nw\u0017cVu%BF\u0014\"Bi\u000fvGc-\\f\u001a3OD01 ");
        dhSP = new BigInteger[3];
        Prc2 = CL3.getBytes("l^\u001f\u001c g;5vJ\u001d\u001fke\u0015 l'8gq^\u0006+;\u0014qf\u00121I\b\"\"\u007f:\u0010^4Yzav4xMBE6c!\u0018\u000bte=GP\u001d85]v\u000bx%$\u0012\u0012qVNA\u0015\u001af,O\u001c`Y\u0007\u000e56\u0000)'F<;A\u0013W\u0014\u001f\u001do\\M\n\b{T\u0018(gK1\u0019_?\u00076HfH\u001d.'y\u00073;dQ\u0006\u0003|\u00048\u007f4C^>sAX=)?\u0010f\u000f5a\u000eG+=\u0000);^x%)e,\u001aS-\"TX5R8VBTKQ\u0017\u001fh\u0017@AE\u0013YBp\u0010-`zG\u0017L\u0012$5u\u0005\u0007hp\u001cf/CT\u0014G8Z\u001e_@\u0011Y6%*ef\u0012jwu\u0018qbR*p\u0017>)\b\u0019mKV'&\u0000s3|\u0019u Xc\u000b\u0000'uG\n\u0013)\u0006N\u0006A],g\u007fX.i\u0000b~s1fKX_\u001em\u000feRg\u000epU\u0018@h\u007f\u001fx\u001ah");
    }

    protected CL3(Object obj, int type) {
        this.obj = obj;
        this.type = type;
    }

    protected final void finalize() {
    }

    /*
     * Unable to fully structure code
     */
    private static final int log2(int v) {
        l = 6;
        if (v != 0) ** GOTO lbl6
        return 0;
lbl-1000:
        // 1 sources

        {
            v <<= 1;
            --l;
lbl6:
            // 2 sources

            ** while (v < 64)
        }
lbl7:
        // 2 sources

        while (v >= 128) {
            v >>= 1;
            ++l;
        }
        return l * 1000 + CL3.logtab[v & 63];
    }

    private static final long trng(int[] syms, byte[] sbuf) {
        long accu = 0L;
        int i = 0;
        do {
            syms[i] = 0;
        } while (++i < 32);
        int n = sbuf.length - 1;
        int l = 0;
        int k = 0;
        int v = 0;
        while (true) {
            BigInteger I;
            long t;
            int s = 0;
            do {
                t = System.currentTimeMillis();
                while (t == System.currentTimeMillis()) {
                    ++s;
                }
            } while (s == 0);
            sbuf[n--] = (byte)s;
            if ((l - s) * (l - s) != 1) {
                l = s;
            }
            int n2 = l % 32;
            syms[n2] = syms[n2] + v;
            v |= 1;
            if (n < 0) {
                I = new BigInteger(1, sbuf);
                accu ^= I.multiply(I).remainder(P64).longValue();
                n += sbuf.length;
                v = 0;
            }
            if (++k < nsam) continue;
            i = 0;
            int info = 0;
            int log2k = CL3.log2(k);
            do {
                v = syms[i];
                info += v * (log2k - CL3.log2(v));
            } while (++i < 32);
            if (info != 0 && (nsam = 96000 * k / info) <= k) {
                I = new BigInteger(1, sbuf);
                return accu ^= I.multiply(I).remainder(P64).longValue() ^ t;
            }
            nsam = info > k ? nsam + 3 : k + 32;
            v = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int trngNextByte() {
        byte[] byArray = sbuf;
        synchronized (sbuf) {
            if (bits <= 0) {
                accu = CL3.trng(syms, sbuf);
                bits = 64;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return (int)(accu >>> (bits -= 8) & 0xFFL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rng(CL3 state, byte[] to, int off, int n) {
        byte[] S;
        byte[] byArray = S = (byte[])(state == null ? CL3.rngState : state).obj;
        synchronized (S) {
            int ri;
            while ((ri = S[0]) == 0) {
                CL3.rngSeed(state, null, 0, 20);
            }
            while (--n >= 0) {
                if (ri >= 45) {
                    int mix = CL3.msbf4(S, 13);
                    if (mix > 0) {
                        long stime = ((long)CL3.msbf4(S, 5) << 32) + ((long)CL3.msbf4(S, 9) & 0xFFFFFFFFL);
                        int c = CL3.msbf4(S, 1);
                        int e = c + 20;
                        if (e < c) {
                            c = 0;
                            e = 0 + 20;
                        }
                        CL3.msbf4(e, S, 1);
                        c += mix - c % mix;
                        while (c < e) {
                            if (bits > 0 || System.currentTimeMillis() >= stime) {
                                int n2 = 65 + c / mix % 20;
                                S[n2] = (byte)(S[n2] ^ CL3.trngNextByte());
                                stime = (long)CL3.msbf4(S, 17) * 1000L + System.currentTimeMillis();
                                CL3.msbf4((int)(stime >>> 32), S, 5);
                                CL3.msbf4((int)stime, S, 9);
                            }
                            c += mix;
                        }
                    }
                    int c = 0;
                    int i = 19;
                    while (i >= 0) {
                        c = (c >> 8) + (S[45 + i] & 0xFF) + (S[65 + i] & 0xFF);
                        S[25 + i] = (byte)c;
                        --i;
                    }
                    CL3.sha(null, S, 25, 20, S, 25);
                    c = 256;
                    i = 19;
                    while (i >= 0) {
                        c = (c >> 8) + (S[25 + i] & 0xFF) + (S[45 + i] & 0xFF);
                        S[45 + i] = (byte)c;
                        --i;
                    }
                    ri = 25;
                }
                to[off++] = S[ri++];
            }
            S[0] = (byte)ri;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rngSeed(CL3 state, byte[] seed, int off, int len) {
        byte[] S;
        byte[] byArray = S = (byte[])(state == null ? CL3.rngState : state).obj;
        synchronized (S) {
            if (seed == null) {
                while (--len >= 0) {
                    int n = 65 + len % 20;
                    S[n] = (byte)(S[n] ^ CL3.trngNextByte());
                }
                long t = (long)CL3.msbf4(S, 17) * 1000L + System.currentTimeMillis();
                CL3.msbf4((int)(t >>> 32), S, 5);
                CL3.msbf4((int)t, S, 9);
            } else {
                if (len > 40) {
                    byte[] byArray2 = seed;
                    int n = off;
                    int n2 = len;
                    len = 20;
                    seed = new byte[20];
                    off = 0;
                    CL3.sha(null, byArray2, n, n2, seed, 0);
                }
                while (--len >= 0) {
                    int n = 65 + len % 20;
                    S[n] = (byte)(S[n] ^ seed[off + len]);
                }
            }
            if (S[0] == 0) {
                S[0] = 46;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static CL3 rngNew(int mix, int time) {
        byte[] S = new byte[85];
        CL3.msbf4(mix < 0 ? 0 : mix, S, 13);
        CL3.msbf4(time < 0 ? 0 : time, S, 17);
        return new CL3(S, 30);
    }

    public static void dispose(CL3 key) {
        block9: {
            Object obj;
            block12: {
                block11: {
                    block10: {
                        block8: {
                            if (key == null) {
                                return;
                            }
                            obj = key.obj;
                            if (obj == null) {
                                return;
                            }
                            key.obj = null;
                            if (!(obj instanceof byte[])) break block8;
                            byte[] K = (byte[])obj;
                            int i = K.length - 1;
                            while (i >= 0) {
                                K[i] = 0;
                                --i;
                            }
                            break block9;
                        }
                        if (!(obj instanceof int[])) break block10;
                        int[] K = (int[])obj;
                        int i = K.length - 1;
                        while (i >= 0) {
                            K[i] = 0;
                            --i;
                        }
                        break block9;
                    }
                    if (!(obj instanceof long[])) break block11;
                    long[] K = (long[])obj;
                    int i = K.length - 1;
                    while (i >= 0) {
                        K[i] = 0L;
                        --i;
                    }
                    break block9;
                }
                if (!(obj instanceof BigInteger[])) break block12;
                BigInteger[] K = (BigInteger[])obj;
                BigInteger zero = BigInteger.valueOf(0);
                int i = K.length - 1;
                while (i >= 0) {
                    K[i] = zero;
                    --i;
                }
                break block9;
            }
            if (!(obj instanceof Object[])) break block9;
            Object[] o = (Object[])obj;
            int i = 0;
            while (i < o.length) {
                if (o[i] instanceof CL3) {
                    CL3.dispose((CL3)o[i]);
                }
                ++i;
            }
        }
    }

    public static byte[] encodeKeyMaterial(Object keyElems) {
        BigInteger[] key;
        if (keyElems instanceof byte[][]) {
            byte[][] k = (byte[][])keyElems;
            key = new BigInteger[k.length];
            int i = 0;
            while (i < key.length) {
                key[i] = k[i] == null ? null : new BigInteger(1, k[i]);
                ++i;
            }
        } else {
            key = (BigInteger[])keyElems;
        }
        int n = key.length;
        int t = n == 8 ? 6 : (n == 2 ? 5 : (n == 4 || n == 5 && key[4] == null ? (key[1] == null ? 13 : 9) : (n == 5 ? (key[1] == null ? 14 : 10) : 0)));
        return CL3.exportKey(new CL3(key, t), t == 6 || t == 10 || t == 14 ? 2 : 3);
    }

    public static CL3 importKey(int format, byte[] data, int beg, int len) {
        if (len < 0) {
            len = data.length;
        }
        ASN1[] args = new ASN1[9];
        if (format == 6 || format == 5 || format == 4) {
            ASN1.scan(format == 6 ? "30(30(A0?:02:30:30:30:30:30[0+]A1?:A2?:A3?:)30:03:)" : (format == 5 ? "30(30(02[1]30:30[0+]A0:)30:03:)" : "30(30(30[0+]X:)30:03:)"), data, beg, len, args);
            if (format == 5 && (args[1].len != 1 || data[args[1].beg] != 0)) {
                throw new CL3Exception(-2147483647);
            }
            format = 3;
            beg = args[0].beg;
            len = args[0].len;
        }
        if (format == 7) {
            ASN1.scan("30(06[0]X[1+])", data, beg, len, args);
        } else if (format == 3) {
            ASN1.scan("30(30(06[0]X[1+])03(00*[2]))", data, beg, len, args);
        } else if (format == 2) {
            ASN1.scan("30(02[4]30(06[0]X[1+])04[2]A0?[3])", data, beg, len, args);
            if (args[4].len != 1 || data[args[4].beg] != 0) {
                throw new CL3Exception(-2147483647);
            }
        } else if (format == 1) {
            args[2] = new ASN1();
            args[2].beg = beg;
            args[2].len = len;
        } else {
            if (format == 8) {
                int end = beg + len;
                BigInteger[] k = new BigInteger[2];
                int i = 0;
                do {
                    if ((beg += 2 + (len = CL3.msbf2(data, beg))) > end) {
                        throw new CL3Exception(-2147483640);
                    }
                    byte[] b = new byte[len];
                    System.arraycopy((Object)data, beg - len, (Object)b, 0, len);
                    if (i == 1 && beg < end) {
                        BigInteger[] bigIntegerArray = k;
                        k = new BigInteger[5];
                        System.arraycopy((Object)bigIntegerArray, 0, (Object)k, 0, 1);
                        i = 2;
                    }
                    k[i++] = new BigInteger(1, b);
                } while (beg < end);
                return new CL3(k, i == 2 ? 5 : 13);
            }
            throw new CL3Exception(-2147483645);
        }
        if (format == 1 || args[0].oidCRC() == -863830301) {
            if (format == 3) {
                BigInteger[] k = new BigInteger[2];
                ASN1.scan("30(02[0&i]02[1&i])", data, args[2].beg, args[2].len, args);
                k[0] = (BigInteger)args[0].obj;
                k[1] = (BigInteger)args[1].obj;
                return new CL3(k, 5);
            }
            if (format == 1 || format == 2) {
                ASN1.scan("30(02[0]02[1&i]02[2&i]02[3&i]02[4&i]02[5&i]02[6&i]02[7&i]02[8&i])", data, args[2].beg, args[2].len, args);
                if (args[0].len != 1 || data[args[0].beg] != 0) {
                    throw new CL3Exception(-2147483647);
                }
                BigInteger[] k = new BigInteger[8];
                int i = 0;
                while (i < 8) {
                    k[i] = (BigInteger)args[1 + i].obj;
                    ++i;
                }
                return new CL3(k, 6);
            }
        } else {
            int oidcrc = args[0].oidCRC();
            if (oidcrc == 1744466510 || oidcrc == -863830179) {
                if (format != 2 && format != 3 && format != 7) {
                    throw new CL3Exception(-2147483645);
                }
                ASN1.scan(oidcrc == 1744466510 ? "30(02[4&i]02[5&i]02[6&i])" : "30(02[4&i]02[6&i])", data, args[1].beg, args[1].len, args);
                if (format != 7) {
                    ASN1.scan("02[7&i]", data, args[2].beg, args[2].len, args);
                }
                int t = 12;
                BigInteger[] k = new BigInteger[5];
                k[0] = (BigInteger)args[4].obj;
                int l = k[0].bitLength();
                if (l % 64 != 0 || l < 512) {
                    throw new CL3Exception(-2147483640);
                }
                if (oidcrc == 1744466510) {
                    k[1] = (BigInteger)args[5].obj;
                    t = 8;
                }
                k[2] = (BigInteger)args[6].obj;
                if (format == 2) {
                    k[4] = (BigInteger)args[7].obj;
                    k[3] = k[2].modPow(k[4], k[0]);
                    t += 2;
                } else if (format == 3) {
                    k[3] = (BigInteger)args[7].obj;
                    ++t;
                }
                return new CL3(k, t);
            }
            throw new CL3Exception(-2147483646);
        }
        throw new CL3Exception(-2147483645);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] exportKey(CL3 key, int format) {
        if (!(key.obj instanceof BigInteger[])) throw new CL3Exception(-2147483636);
        BigInteger[] k = (BigInteger[])key.obj;
        int kl = k.length;
        ASN1[] args = new ASN1[9];
        int n = 0;
        int i = 0;
        while (i < kl) {
            if (k[i] != null) {
                args[i] = new ASN1(1, k[i]);
                n += k[i].bitLength();
            }
            ++i;
        }
        byte[] buf = new byte[kl * n / 8 + 128];
        if (format == 8) {
            if (key.type != 5 && key.type != 6 && key.type != 13 && key.type != 14) {
                throw new CL3Exception(-2147483645);
            }
            int c = k.length == 5 ? 61475 : 3841;
            n = buf.length;
            do {
                byte[] b = k[c & 0xF].toByteArray();
                int j = n;
                System.arraycopy((Object)b, 0, (Object)buf, n -= b.length, b.length);
                if (buf[n] == 0) {
                    ++n;
                }
                CL3.msbf2(j - n, buf, n -= 2);
            } while ((c >>= 4) != 15);
        } else {
            if (format != 3 && format != 1 && format != 2 && format != 7 || format == 1 && kl != 8 || (format == 2 || format == 1) && kl != 8 && kl != 5) {
                throw new CL3Exception(-2147483645);
            }
            if (kl == 8 || kl == 2) {
                args[8] = new ASN1(3, "1.2.840.113549.1.1.1");
                n = ASN1.format(format == 3 ? "30(30(06[8&]0500)03(00 30(02[0&]02[1&])))" : (format == 1 ? "30(02010002[0&]02[1&]02[2&]02[3&]02[4&]02[5&]02[6&]02[7&])" : "30(02010030(06[8&]0500)04(30(02010002[0&]02[1&]02[2&]02[3&]02[4&]02[5&]02[6&]02[7&])))"), buf, -1, args);
            } else {
                if (kl != 5) throw new CL3Exception(-2147483645);
                args[8] = new ASN1(3, k[1] != null ? "1.2.840.10040.4.1" : "1.2.840.113549.1.3.1");
                n = ASN1.format(format == 2 ? "30(020100 30(06[8&]30(02[0&]02?[1&]02[2&]))04(02[4&]))" : (format == 3 ? "30(30(06[8&]30(02[0&]02?[1&]02[2&]))03(00 02[3&]))" : "30(06[8&]30(02[0&]02?[1&]02[2&]))"), buf, -1, args);
            }
        }
        byte[] b = new byte[buf.length - n];
        System.arraycopy((Object)buf, n, (Object)b, 0, b.length);
        return b;
    }

    public static final int getSize(CL3 obj) {
        if (obj.obj instanceof BigInteger[]) {
            return (((BigInteger[])obj.obj)[0].bitLength() + 7) / 8;
        }
        throw new CL3Exception(-2147483645);
    }

    static final int msbf(byte[] data, int off, int n) {
        int v = 0;
        do {
            v |= (data[off++] & 0xFF) << --n * 8;
        } while (n > 0);
        return v;
    }

    static final int msbf2(byte[] data, int i) {
        return (data[i] & 0xFF) << 8 | data[i + 1] & 0xFF;
    }

    static final void msbf(int v, byte[] data, int off, int n) {
        do {
            data[off++] = (byte)(v >>> --n * 8);
        } while (n > 0);
    }

    static final void lsbf2(int v, byte[] data, int i) {
        data[i] = (byte)v;
        data[i + 1] = (byte)(v >>> 8);
    }

    static final void msbf2(int v, byte[] data, int i) {
        data[i] = (byte)(v >>> 8);
        data[i + 1] = (byte)v;
    }

    static final int msbf4(byte[] data, int i) {
        return data[i] << 24 | (data[i + 1] & 0xFF) << 16 | (data[i + 2] & 0xFF) << 8 | data[i + 3] & 0xFF;
    }

    static final void msbf4(int v, byte[] data, int i) {
        data[i] = (byte)(v >>> 24);
        data[i + 1] = (byte)(v >>> 16);
        data[i + 2] = (byte)(v >>> 8);
        data[i + 3] = (byte)v;
    }

    static final int lsbf(byte[] data, int i, int n) {
        int v = 0;
        do {
            v |= (data[i + --n] & 0xFF) << n * 8;
        } while (n > 0);
        return v;
    }

    static final int lsbf4(byte[] data, int i) {
        return data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
    }

    static final void lsbf4(int v, byte[] data, int i) {
        data[i] = (byte)v;
        data[i + 1] = (byte)(v >>> 8);
        data[i + 2] = (byte)(v >>> 16);
        data[i + 3] = (byte)(v >>> 24);
    }

    static final byte[] getBytes(String s) {
        int n = s.length();
        byte[] d = new byte[n * 7 / 8];
        int j = 0;
        int i = 0;
        int b = 0;
        int a = 0;
        do {
            a = (a << 7) + s.charAt(i);
            if ((b += 7) < 8) continue;
            d[j++] = (byte)(a >> (b -= 8));
        } while (++i < n);
        return d;
    }

    public static CL3 md2Init(CL3 state) {
        if (state == null) {
            state = new CL3(new byte[64], 16);
        } else {
            int i = 63;
            byte[] x = (byte[])state.obj;
            do {
                x[i] = 0;
            } while (--i >= 0);
        }
        return state;
    }

    public static void md2(CL3 state, byte[] data, int off, int len, byte[] to, int pos) {
        if (to == null && (len &= 0xFFFFFFF0) == 0) {
            return;
        }
        byte[] S = Pmd2;
        byte[] x = state == null ? new byte[64] : (byte[])state.obj;
        int pad = 0;
        len += off;
        do {
            int i;
            int o = off;
            int j = 16;
            if ((off += 16) > len) {
                if (pad == 0) {
                    pad = off - len;
                    j = i = len - o;
                    do {
                        x[16 + i] = (byte)pad;
                    } while (++i < 16);
                } else {
                    data = x;
                    o = 48;
                    pad = 48;
                }
            }
            System.arraycopy((Object)data, o, (Object)x, 16, j);
            i = 0;
            int t = x[63] & 0xFF;
            do {
                int bi = x[16 + i] & 0xFF;
                int n = 48 + i;
                byte by = (byte)(x[n] ^ S[bi ^ t]);
                x[n] = by;
                t = by & 0xFF;
                x[32 + i] = (byte)(x[i] ^ bi);
            } while (++i < 16);
            t = 0;
            i = 0;
            do {
                j = 0;
                do {
                    int n = j + 2;
                    int n2 = j + 1;
                    int n3 = j;
                    byte by = (byte)(x[n3] ^ S[t]);
                    x[n3] = by;
                    byte by2 = (byte)(x[n2] ^ S[by & 0xFF]);
                    x[n2] = by2;
                    byte by3 = (byte)(x[n] ^ S[by2 & 0xFF]);
                    x[n] = by3;
                    t = by3 & 0xFF;
                } while ((j += 3) < 48);
                t = t + i & 0xFF;
            } while (++i < 18);
        } while (off < len || to != null && pad != 48);
        if (to != null) {
            System.arraycopy((Object)x, 0, (Object)to, pos, 16);
        }
    }

    public static CL3 md5CopyState(CL3 state) {
        CL3 result = new CL3(new int[21], 17);
        int[] newST = (int[])result.obj;
        int[] oldST = (int[])state.obj;
        System.arraycopy((Object)oldST, 0, (Object)newST, 0, oldST.length);
        return result;
    }

    public static CL3 md5Init(CL3 state) {
        int[] st;
        if (state == null) {
            st = new int[21];
            state = new CL3(st, 17);
        } else {
            st = (int[])state.obj;
        }
        st[0] = 1732584193;
        st[1] = -271733879;
        st[2] = -1732584194;
        st[3] = 271733878;
        st[4] = 0;
        return state;
    }

    public static void md5(CL3 state, byte[] data, int off, int len, byte[] to, int pos) {
        int d;
        int c;
        int b;
        int a;
        int[] W;
        int[] st = null;
        int i = 0;
        int originalLength = len;
        int originalOffset = off;
        int lastLeftOver = 0;
        boolean done = false;
        boolean padded = false;
        if (state != null) {
            st = (int[])state.obj;
            W = st;
            a = st[0];
            b = st[1];
            c = st[2];
            d = st[3];
            lastLeftOver = st[4] % 4;
            i = 5 + st[4] / 4 % 16;
            len += st[4];
        } else {
            W = new int[21];
            a = 1732584193;
            b = -271733879;
            c = -1732584194;
            d = 271733878;
            i = 5;
        }
        do {
            int a0;
            if (originalLength > 0 && lastLeftOver != 0) {
                int bytesToFill = originalLength < 4 - lastLeftOver ? originalLength : 4 - lastLeftOver;
                int temp = CL3.lsbf(data, off, bytesToFill);
                W[i] = W[i] | (temp <<= 8 * lastLeftOver);
                if (bytesToFill + lastLeftOver == 4) {
                    ++i;
                }
                off += bytesToFill;
                lastLeftOver = 0;
            }
            while (i < 21 && off <= originalOffset + originalLength - 4) {
                W[i++] = CL3.lsbf4(data, off);
                off += 4;
            }
            if (i < 21) {
                int leftOverBytes = originalOffset + originalLength - off;
                if (to == null) {
                    if (leftOverBytes == 0) break;
                    W[i++] = CL3.lsbf(data, off, leftOverBytes);
                    break;
                }
                if (!padded) {
                    if (originalLength > 0) {
                        a0 = len % 4;
                        W[i++] = a0 != 0 ? CL3.lsbf(data, off, a0) | 128 << a0 * 8 : 128;
                    } else {
                        a0 = len % 4;
                        W[i] = a0 != 0 ? W[i] | 128 << a0 * 8 : 128;
                        ++i;
                    }
                    if (i == 20) {
                        W[20] = 0;
                    }
                    padded = true;
                }
                if (i <= 19) {
                    while (i < 19) {
                        W[i++] = 0;
                    }
                    W[19] = len << 3;
                    W[20] = len >>> 29;
                    done = true;
                }
            }
            a0 = a;
            int d0 = d;
            int c0 = c;
            int b0 = b;
            int W0 = W[5];
            a += ((c ^ d) & b ^ d) + W0 + -680876936;
            a = (a << 7 | a >>> 25) + b;
            int W1 = W[6];
            d += ((b ^ c) & a ^ c) + W1 + -389564586;
            d = (d << 12 | d >>> 20) + a;
            int W2 = W[7];
            c += ((a ^ b) & d ^ b) + W2 + 606105819;
            c = (c << 17 | c >>> 15) + d;
            int W3 = W[8];
            b += ((d ^ a) & c ^ a) + W3 + -1044525330;
            b = (b << 22 | b >>> 10) + c;
            int W4 = W[9];
            a += ((c ^ d) & b ^ d) + W4 + -176418897;
            a = (a << 7 | a >>> 25) + b;
            int W5 = W[10];
            d += ((b ^ c) & a ^ c) + W5 + 1200080426;
            d = (d << 12 | d >>> 20) + a;
            int W6 = W[11];
            c += ((a ^ b) & d ^ b) + W6 + -1473231341;
            c = (c << 17 | c >>> 15) + d;
            int W7 = W[12];
            b += ((d ^ a) & c ^ a) + W7 + -45705983;
            b = (b << 22 | b >>> 10) + c;
            int W8 = W[13];
            a += ((c ^ d) & b ^ d) + W8 + 1770035416;
            a = (a << 7 | a >>> 25) + b;
            int W9 = W[14];
            d += ((b ^ c) & a ^ c) + W9 + -1958414417;
            d = (d << 12 | d >>> 20) + a;
            int W10 = W[15];
            c += ((a ^ b) & d ^ b) + W10 + -42063;
            c = (c << 17 | c >>> 15) + d;
            int W11 = W[16];
            b += ((d ^ a) & c ^ a) + W11 + -1990404162;
            b = (b << 22 | b >>> 10) + c;
            int W12 = W[17];
            a += ((c ^ d) & b ^ d) + W12 + 1804603682;
            a = (a << 7 | a >>> 25) + b;
            int W13 = W[18];
            d += ((b ^ c) & a ^ c) + W13 + -40341101;
            d = (d << 12 | d >>> 20) + a;
            int W14 = W[19];
            c += ((a ^ b) & d ^ b) + W14 + -1502002290;
            c = (c << 17 | c >>> 15) + d;
            int W15 = W[20];
            b += ((d ^ a) & c ^ a) + W15 + 1236535329;
            b = (b << 22 | b >>> 10) + c;
            a += ((b ^ c) & d ^ c) + W1 + -165796510;
            a = (a << 5 | a >>> 27) + b;
            d += ((a ^ b) & c ^ b) + W6 + -1069501632;
            d = (d << 9 | d >>> 23) + a;
            c += ((d ^ a) & b ^ a) + W11 + 643717713;
            c = (c << 14 | c >>> 18) + d;
            b += ((c ^ d) & a ^ d) + W0 + -373897302;
            b = (b << 20 | b >>> 12) + c;
            a += ((b ^ c) & d ^ c) + W5 + -701558691;
            a = (a << 5 | a >>> 27) + b;
            d += ((a ^ b) & c ^ b) + W10 + 38016083;
            d = (d << 9 | d >>> 23) + a;
            c += ((d ^ a) & b ^ a) + W15 + -660478335;
            c = (c << 14 | c >>> 18) + d;
            b += ((c ^ d) & a ^ d) + W4 + -405537848;
            b = (b << 20 | b >>> 12) + c;
            a += ((b ^ c) & d ^ c) + W9 + 568446438;
            a = (a << 5 | a >>> 27) + b;
            d += ((a ^ b) & c ^ b) + W14 + -1019803690;
            d = (d << 9 | d >>> 23) + a;
            c += ((d ^ a) & b ^ a) + W3 + -187363961;
            c = (c << 14 | c >>> 18) + d;
            b += ((c ^ d) & a ^ d) + W8 + 1163531501;
            b = (b << 20 | b >>> 12) + c;
            a += ((b ^ c) & d ^ c) + W13 + -1444681467;
            a = (a << 5 | a >>> 27) + b;
            d += ((a ^ b) & c ^ b) + W2 + -51403784;
            d = (d << 9 | d >>> 23) + a;
            c += ((d ^ a) & b ^ a) + W7 + 1735328473;
            c = (c << 14 | c >>> 18) + d;
            b += ((c ^ d) & a ^ d) + W12 + -1926607734;
            b = (b << 20 | b >>> 12) + c;
            a += (b ^ c ^ d) + W5 + -378558;
            a = (a << 4 | a >>> 28) + b;
            d += (a ^ b ^ c) + W8 + -2022574463;
            d = (d << 11 | d >>> 21) + a;
            c += (d ^ a ^ b) + W11 + 1839030562;
            c = (c << 16 | c >>> 16) + d;
            b += (c ^ d ^ a) + W14 + -35309556;
            b = (b << 23 | b >>> 9) + c;
            a += (b ^ c ^ d) + W1 + -1530992060;
            a = (a << 4 | a >>> 28) + b;
            d += (a ^ b ^ c) + W4 + 1272893353;
            d = (d << 11 | d >>> 21) + a;
            c += (d ^ a ^ b) + W7 + -155497632;
            c = (c << 16 | c >>> 16) + d;
            b += (c ^ d ^ a) + W10 + -1094730640;
            b = (b << 23 | b >>> 9) + c;
            a += (b ^ c ^ d) + W13 + 681279174;
            a = (a << 4 | a >>> 28) + b;
            d += (a ^ b ^ c) + W0 + -358537222;
            d = (d << 11 | d >>> 21) + a;
            c += (d ^ a ^ b) + W3 + -722521979;
            c = (c << 16 | c >>> 16) + d;
            b += (c ^ d ^ a) + W6 + 76029189;
            b = (b << 23 | b >>> 9) + c;
            a += (b ^ c ^ d) + W9 + -640364487;
            a = (a << 4 | a >>> 28) + b;
            d += (a ^ b ^ c) + W12 + -421815835;
            d = (d << 11 | d >>> 21) + a;
            c += (d ^ a ^ b) + W15 + 530742520;
            c = (c << 16 | c >>> 16) + d;
            b += (c ^ d ^ a) + W2 + -995338651;
            b = (b << 23 | b >>> 9) + c;
            a += (c ^ (b | ~d)) + W0 + -198630844;
            a = (a << 6 | a >>> 26) + b;
            d += (b ^ (a | ~c)) + W7 + 1126891415;
            d = (d << 10 | d >>> 22) + a;
            c += (a ^ (d | ~b)) + W14 + -1416354905;
            c = (c << 15 | c >>> 17) + d;
            b += (d ^ (c | ~a)) + W5 + -57434055;
            b = (b << 21 | b >>> 11) + c;
            a += (c ^ (b | ~d)) + W12 + 1700485571;
            a = (a << 6 | a >>> 26) + b;
            d += (b ^ (a | ~c)) + W3 + -1894986606;
            d = (d << 10 | d >>> 22) + a;
            c += (a ^ (d | ~b)) + W10 + -1051523;
            c = (c << 15 | c >>> 17) + d;
            b += (d ^ (c | ~a)) + W1 + -2054922799;
            b = (b << 21 | b >>> 11) + c;
            a += (c ^ (b | ~d)) + W8 + 1873313359;
            a = (a << 6 | a >>> 26) + b;
            d += (b ^ (a | ~c)) + W15 + -30611744;
            d = (d << 10 | d >>> 22) + a;
            c += (a ^ (d | ~b)) + W6 + -1560198380;
            c = (c << 15 | c >>> 17) + d;
            b += (d ^ (c | ~a)) + W13 + 1309151649;
            b = (b << 21 | b >>> 11) + c;
            a += (c ^ (b | ~d)) + W4 + -145523070;
            a = (a << 6 | a >>> 26) + b;
            d += (b ^ (a | ~c)) + W11 + -1120210379;
            d = (d << 10 | d >>> 22) + a;
            c += (a ^ (d | ~b)) + W2 + 718787259;
            c = (c << 15 | c >>> 17) + d;
            b += (d ^ (c | ~a)) + W9 + -343485551;
            b = (b << 21 | b >>> 11) + c;
            a += a0;
            b += b0;
            c += c0;
            d += d0;
            i = 5;
        } while (!done);
        if (to == null) {
            st[0] = a;
            st[1] = b;
            st[2] = c;
            st[3] = d;
            st[4] = len;
        } else {
            CL3.lsbf4(a, to, pos);
            CL3.lsbf4(b, to, pos + 4);
            CL3.lsbf4(c, to, pos + 8);
            CL3.lsbf4(d, to, pos + 12);
        }
    }

    public static CL3 shaInit(CL3 state) {
        int[] st;
        if (state == null) {
            st = new int[86];
            state = new CL3(st, 18);
        } else {
            st = (int[])state.obj;
        }
        st[80] = 1732584193;
        st[81] = -271733879;
        st[82] = -1732584194;
        st[83] = 271733878;
        st[84] = -1009589776;
        st[85] = 0;
        return state;
    }

    public static void sha(CL3 state, byte[] data, int off, int len, byte[] to, int pos) {
        int i;
        int E;
        int E0;
        int D;
        int D0;
        int C;
        int C0;
        int B;
        int B0;
        int A;
        int A0;
        int[] W;
        int[] st;
        int cfr_ignored_0 = off + (len & 0xFFFFFFFC);
        int padded = 0;
        int lastLeftOver = 0;
        int originalLength = len;
        int originalOffset = off;
        if (state != null) {
            W = st = (int[])state.obj;
            A = A0 = st[80];
            B = B0 = st[81];
            C = C0 = st[82];
            D = D0 = st[83];
            E = E0 = st[84];
            lastLeftOver = st[85] % 4;
            i = st[85] / 4 % 16;
            len += st[85];
        } else {
            st = null;
            W = new int[80];
            A0 = 1732584193;
            A = 1732584193;
            B0 = -271733879;
            B = -271733879;
            C0 = -1732584194;
            C = -1732584194;
            D0 = 271733878;
            D = 271733878;
            E0 = -1009589776;
            E = -1009589776;
            i = 0;
        }
        while (true) {
            int x;
            if (padded < 0) {
                CL3.msbf4(A, to, pos);
                CL3.msbf4(B, to, pos + 4);
                CL3.msbf4(C, to, pos + 8);
                CL3.msbf4(D, to, pos + 12);
                CL3.msbf4(E, to, pos + 16);
                return;
            }
            if (originalLength > 0 && lastLeftOver != 0) {
                int bytesToFill = originalLength < 4 - lastLeftOver ? originalLength : 4 - lastLeftOver;
                int temp = CL3.msbf(data, off, bytesToFill);
                W[i] = W[i] << 8 * bytesToFill;
                W[i] = W[i] | temp;
                if (bytesToFill + lastLeftOver == 4) {
                    ++i;
                }
                off += bytesToFill;
                lastLeftOver = 0;
            }
            while (i < 16 && off <= originalOffset + originalLength - 4) {
                W[i++] = CL3.msbf4(data, off);
                off += 4;
            }
            if (i < 16) {
                int leftOverBytes = originalOffset + originalLength - off;
                if (padded == 0) {
                    int bytesToPad;
                    int bytesLeft;
                    if (to == null) {
                        if (leftOverBytes != 0) {
                            W[i++] = CL3.msbf(data, off, leftOverBytes);
                        }
                        st[80] = A;
                        st[81] = B;
                        st[82] = C;
                        st[83] = D;
                        st[84] = E;
                        st[85] = len;
                        return;
                    }
                    padded = 1;
                    if (originalLength > 0 && (bytesLeft = len % 4) > 0) {
                        W[i] = CL3.msbf(data, off, bytesLeft);
                    }
                    if ((bytesToPad = 4 - len % 4) == 0) {
                        x = Integer.MIN_VALUE;
                        W[++i] = x;
                    } else {
                        W[i] = W[i] << 8 * bytesToPad;
                        x = 1 << bytesToPad * 8 - 1;
                        W[i] = W[i] | x;
                        ++i;
                    }
                    if (i == 14) {
                        W[15] = 0;
                    }
                }
                if (i <= 14) {
                    while (i < 14) {
                        W[i++] = 0;
                    }
                    W[14] = len >>> 29;
                    W[15] = len << 3;
                    padded = -1;
                }
                i = 16;
            }
            do {
                x = W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16];
                W[i] = x << 1 | x >>> 31;
            } while (++i < 80);
            E += 1518500249 + W[0] + (A << 5 | A >>> 27) + ((C ^ D) & B ^ D);
            B = B << 30 | B >>> 2;
            D += 1518500249 + W[1] + (E << 5 | E >>> 27) + ((B ^ C) & A ^ C);
            A = A << 30 | A >>> 2;
            C += 1518500249 + W[2] + (D << 5 | D >>> 27) + ((A ^ B) & E ^ B);
            E = E << 30 | E >>> 2;
            B += 1518500249 + W[3] + (C << 5 | C >>> 27) + ((E ^ A) & D ^ A);
            D = D << 30 | D >>> 2;
            A += 1518500249 + W[4] + (B << 5 | B >>> 27) + ((D ^ E) & C ^ E);
            C = C << 30 | C >>> 2;
            E += 1518500249 + W[5] + (A << 5 | A >>> 27) + ((C ^ D) & B ^ D);
            B = B << 30 | B >>> 2;
            D += 1518500249 + W[6] + (E << 5 | E >>> 27) + ((B ^ C) & A ^ C);
            A = A << 30 | A >>> 2;
            C += 1518500249 + W[7] + (D << 5 | D >>> 27) + ((A ^ B) & E ^ B);
            E = E << 30 | E >>> 2;
            B += 1518500249 + W[8] + (C << 5 | C >>> 27) + ((E ^ A) & D ^ A);
            D = D << 30 | D >>> 2;
            A += 1518500249 + W[9] + (B << 5 | B >>> 27) + ((D ^ E) & C ^ E);
            C = C << 30 | C >>> 2;
            E += 1518500249 + W[10] + (A << 5 | A >>> 27) + ((C ^ D) & B ^ D);
            B = B << 30 | B >>> 2;
            D += 1518500249 + W[11] + (E << 5 | E >>> 27) + ((B ^ C) & A ^ C);
            A = A << 30 | A >>> 2;
            C += 1518500249 + W[12] + (D << 5 | D >>> 27) + ((A ^ B) & E ^ B);
            E = E << 30 | E >>> 2;
            B += 1518500249 + W[13] + (C << 5 | C >>> 27) + ((E ^ A) & D ^ A);
            D = D << 30 | D >>> 2;
            A += 1518500249 + W[14] + (B << 5 | B >>> 27) + ((D ^ E) & C ^ E);
            C = C << 30 | C >>> 2;
            E += 1518500249 + W[15] + (A << 5 | A >>> 27) + ((C ^ D) & B ^ D);
            B = B << 30 | B >>> 2;
            D += 1518500249 + W[16] + (E << 5 | E >>> 27) + ((B ^ C) & A ^ C);
            A = A << 30 | A >>> 2;
            C += 1518500249 + W[17] + (D << 5 | D >>> 27) + ((A ^ B) & E ^ B);
            E = E << 30 | E >>> 2;
            B += 1518500249 + W[18] + (C << 5 | C >>> 27) + ((E ^ A) & D ^ A);
            D = D << 30 | D >>> 2;
            A += 1518500249 + W[19] + (B << 5 | B >>> 27) + ((D ^ E) & C ^ E);
            C = C << 30 | C >>> 2;
            E += 1859775393 + W[20] + (A << 5 | A >>> 27) + (B ^ C ^ D);
            B = B << 30 | B >>> 2;
            D += 1859775393 + W[21] + (E << 5 | E >>> 27) + (A ^ B ^ C);
            A = A << 30 | A >>> 2;
            C += 1859775393 + W[22] + (D << 5 | D >>> 27) + (E ^ A ^ B);
            E = E << 30 | E >>> 2;
            B += 1859775393 + W[23] + (C << 5 | C >>> 27) + (D ^ E ^ A);
            D = D << 30 | D >>> 2;
            A += 1859775393 + W[24] + (B << 5 | B >>> 27) + (C ^ D ^ E);
            C = C << 30 | C >>> 2;
            E += 1859775393 + W[25] + (A << 5 | A >>> 27) + (B ^ C ^ D);
            B = B << 30 | B >>> 2;
            D += 1859775393 + W[26] + (E << 5 | E >>> 27) + (A ^ B ^ C);
            A = A << 30 | A >>> 2;
            C += 1859775393 + W[27] + (D << 5 | D >>> 27) + (E ^ A ^ B);
            E = E << 30 | E >>> 2;
            B += 1859775393 + W[28] + (C << 5 | C >>> 27) + (D ^ E ^ A);
            D = D << 30 | D >>> 2;
            A += 1859775393 + W[29] + (B << 5 | B >>> 27) + (C ^ D ^ E);
            C = C << 30 | C >>> 2;
            E += 1859775393 + W[30] + (A << 5 | A >>> 27) + (B ^ C ^ D);
            B = B << 30 | B >>> 2;
            D += 1859775393 + W[31] + (E << 5 | E >>> 27) + (A ^ B ^ C);
            A = A << 30 | A >>> 2;
            C += 1859775393 + W[32] + (D << 5 | D >>> 27) + (E ^ A ^ B);
            E = E << 30 | E >>> 2;
            B += 1859775393 + W[33] + (C << 5 | C >>> 27) + (D ^ E ^ A);
            D = D << 30 | D >>> 2;
            A += 1859775393 + W[34] + (B << 5 | B >>> 27) + (C ^ D ^ E);
            C = C << 30 | C >>> 2;
            E += 1859775393 + W[35] + (A << 5 | A >>> 27) + (B ^ C ^ D);
            B = B << 30 | B >>> 2;
            D += 1859775393 + W[36] + (E << 5 | E >>> 27) + (A ^ B ^ C);
            A = A << 30 | A >>> 2;
            C += 1859775393 + W[37] + (D << 5 | D >>> 27) + (E ^ A ^ B);
            E = E << 30 | E >>> 2;
            B += 1859775393 + W[38] + (C << 5 | C >>> 27) + (D ^ E ^ A);
            D = D << 30 | D >>> 2;
            A += 1859775393 + W[39] + (B << 5 | B >>> 27) + (C ^ D ^ E);
            C = C << 30 | C >>> 2;
            E += -1894007588 + W[40] + (A << 5 | A >>> 27) + ((B ^ D) & (C ^ D) ^ D);
            B = B << 30 | B >>> 2;
            D += -1894007588 + W[41] + (E << 5 | E >>> 27) + ((A ^ C) & (B ^ C) ^ C);
            A = A << 30 | A >>> 2;
            C += -1894007588 + W[42] + (D << 5 | D >>> 27) + ((E ^ B) & (A ^ B) ^ B);
            E = E << 30 | E >>> 2;
            B += -1894007588 + W[43] + (C << 5 | C >>> 27) + ((D ^ A) & (E ^ A) ^ A);
            D = D << 30 | D >>> 2;
            A += -1894007588 + W[44] + (B << 5 | B >>> 27) + ((C ^ E) & (D ^ E) ^ E);
            C = C << 30 | C >>> 2;
            E += -1894007588 + W[45] + (A << 5 | A >>> 27) + ((B ^ D) & (C ^ D) ^ D);
            B = B << 30 | B >>> 2;
            D += -1894007588 + W[46] + (E << 5 | E >>> 27) + ((A ^ C) & (B ^ C) ^ C);
            A = A << 30 | A >>> 2;
            C += -1894007588 + W[47] + (D << 5 | D >>> 27) + ((E ^ B) & (A ^ B) ^ B);
            E = E << 30 | E >>> 2;
            B += -1894007588 + W[48] + (C << 5 | C >>> 27) + ((D ^ A) & (E ^ A) ^ A);
            D = D << 30 | D >>> 2;
            A += -1894007588 + W[49] + (B << 5 | B >>> 27) + ((C ^ E) & (D ^ E) ^ E);
            C = C << 30 | C >>> 2;
            E += -1894007588 + W[50] + (A << 5 | A >>> 27) + ((B ^ D) & (C ^ D) ^ D);
            B = B << 30 | B >>> 2;
            D += -1894007588 + W[51] + (E << 5 | E >>> 27) + ((A ^ C) & (B ^ C) ^ C);
            A = A << 30 | A >>> 2;
            C += -1894007588 + W[52] + (D << 5 | D >>> 27) + ((E ^ B) & (A ^ B) ^ B);
            E = E << 30 | E >>> 2;
            B += -1894007588 + W[53] + (C << 5 | C >>> 27) + ((D ^ A) & (E ^ A) ^ A);
            D = D << 30 | D >>> 2;
            A += -1894007588 + W[54] + (B << 5 | B >>> 27) + ((C ^ E) & (D ^ E) ^ E);
            C = C << 30 | C >>> 2;
            E += -1894007588 + W[55] + (A << 5 | A >>> 27) + ((B ^ D) & (C ^ D) ^ D);
            B = B << 30 | B >>> 2;
            D += -1894007588 + W[56] + (E << 5 | E >>> 27) + ((A ^ C) & (B ^ C) ^ C);
            A = A << 30 | A >>> 2;
            C += -1894007588 + W[57] + (D << 5 | D >>> 27) + ((E ^ B) & (A ^ B) ^ B);
            E = E << 30 | E >>> 2;
            B += -1894007588 + W[58] + (C << 5 | C >>> 27) + ((D ^ A) & (E ^ A) ^ A);
            D = D << 30 | D >>> 2;
            A += -1894007588 + W[59] + (B << 5 | B >>> 27) + ((C ^ E) & (D ^ E) ^ E);
            C = C << 30 | C >>> 2;
            E += -899497514 + W[60] + (A << 5 | A >>> 27) + (B ^ C ^ D);
            B = B << 30 | B >>> 2;
            D += -899497514 + W[61] + (E << 5 | E >>> 27) + (A ^ B ^ C);
            A = A << 30 | A >>> 2;
            C += -899497514 + W[62] + (D << 5 | D >>> 27) + (E ^ A ^ B);
            E = E << 30 | E >>> 2;
            B += -899497514 + W[63] + (C << 5 | C >>> 27) + (D ^ E ^ A);
            D = D << 30 | D >>> 2;
            A += -899497514 + W[64] + (B << 5 | B >>> 27) + (C ^ D ^ E);
            C = C << 30 | C >>> 2;
            E += -899497514 + W[65] + (A << 5 | A >>> 27) + (B ^ C ^ D);
            B = B << 30 | B >>> 2;
            D += -899497514 + W[66] + (E << 5 | E >>> 27) + (A ^ B ^ C);
            A = A << 30 | A >>> 2;
            C += -899497514 + W[67] + (D << 5 | D >>> 27) + (E ^ A ^ B);
            E = E << 30 | E >>> 2;
            B += -899497514 + W[68] + (C << 5 | C >>> 27) + (D ^ E ^ A);
            D = D << 30 | D >>> 2;
            A += -899497514 + W[69] + (B << 5 | B >>> 27) + (C ^ D ^ E);
            C = C << 30 | C >>> 2;
            E += -899497514 + W[70] + (A << 5 | A >>> 27) + (B ^ C ^ D);
            B = B << 30 | B >>> 2;
            D += -899497514 + W[71] + (E << 5 | E >>> 27) + (A ^ B ^ C);
            A = A << 30 | A >>> 2;
            C += -899497514 + W[72] + (D << 5 | D >>> 27) + (E ^ A ^ B);
            E = E << 30 | E >>> 2;
            B += -899497514 + W[73] + (C << 5 | C >>> 27) + (D ^ E ^ A);
            D = D << 30 | D >>> 2;
            A += -899497514 + W[74] + (B << 5 | B >>> 27) + (C ^ D ^ E);
            C = C << 30 | C >>> 2;
            E += -899497514 + W[75] + (A << 5 | A >>> 27) + (B ^ C ^ D);
            B = B << 30 | B >>> 2;
            D += -899497514 + W[76] + (E << 5 | E >>> 27) + (A ^ B ^ C);
            A = A << 30 | A >>> 2;
            C += -899497514 + W[77] + (D << 5 | D >>> 27) + (E ^ A ^ B);
            E = E << 30 | E >>> 2;
            B += -899497514 + W[78] + (C << 5 | C >>> 27) + (D ^ E ^ A);
            D = D << 30 | D >>> 2;
            A += -899497514 + W[79] + (B << 5 | B >>> 27) + (C ^ D ^ E);
            C = C << 30 | C >>> 2;
            A0 += A;
            A = A0;
            B0 += B;
            B = B0;
            C0 += C;
            C = C0;
            D0 += D;
            D = D0;
            E0 += E;
            E = E0;
            i = 0;
            while (i < 16) {
                W[i++] = 0;
            }
            i = 0;
        }
    }

    public static void smallPrimes() {
        int[] rests = new int[512];
        int[] pi = new int[512];
        int p = 3;
        int i = 0;
        while (i < 512) {
            boolean isPrime = true;
            int j = 0;
            while (j < i) {
                rests[j] = (rests[j] + 2) % pi[j];
                if (rests[j] == 0) {
                    isPrime = false;
                }
                ++j;
            }
            if (isPrime) {
                pi[i++] = p;
            }
            p += 2;
        }
        Pi = pi;
    }

    protected static boolean isProbablePrime(BigInteger candidate, int prob) {
        BigInteger one = BigInteger.valueOf(1);
        BigInteger cand1 = candidate.subtract(one);
        int n = (candidate.bitLength() + 7) / 8;
        byte[] a = new byte[n];
        prob = prob < 2 ? 1 : (prob + 1) / 2;
        int k = 0;
        BigInteger e = candidate.subtract(one);
        k = e.getLowestSetBit();
        if (k < 1) {
            throw new CL3Exception(-2147483645);
        }
        if (k > 0) {
            e = e.shiftRight(k);
        }
        block0: while (--prob >= 0) {
            BigInteger z;
            do {
                CL3.rng(null, a, 0, n);
            } while ((z = new BigInteger(1, a).remainder(candidate)).compareTo(one) <= 0);
            z = z.modPow(e, candidate);
            int i = 0;
            while (true) {
                if (z.equals(one)) {
                    if (i == 0) continue block0;
                    return false;
                }
                if (z.equals(cand1)) continue block0;
                if (++i >= k) {
                    return false;
                }
                z = z.multiply(z).remainder(candidate);
            }
        }
        return true;
    }

    public static int dh(CL3 key, byte[] in, int inOff, int inLen, byte[] to, int pos) {
        BigInteger base;
        block5: {
            BigInteger[] k;
            block6: {
                block3: {
                    block4: {
                        k = (BigInteger[])key.obj;
                        int cfr_ignored_0 = (k[0].bitLength() + 7) / 8;
                        if (in != null) break block3;
                        if (k[3] == null) break block4;
                        base = k[3];
                        break block5;
                    }
                    base = k[2];
                    break block6;
                }
                if (inOff != 0 || inLen != in.length) {
                    byte[] byArray = in;
                    in = new byte[inLen];
                    System.arraycopy((Object)byArray, inOff, (Object)in, 0, inLen);
                }
                base = new BigInteger(1, in);
            }
            base = base.modPow(k[4], k[0]);
            if (in == null) {
                k[3] = base;
            }
        }
        in = base.toByteArray();
        if (in[0] == 0) {
            System.arraycopy((Object)in, 1, (Object)to, 0, in.length - 1);
            return in.length - 1;
        }
        System.arraycopy((Object)in, 0, (Object)to, 0, in.length);
        return in.length;
    }

    private static BigInteger[] dhSharedParam(int keySize) {
        int n;
        int k;
        int v;
        BigInteger[] key = new BigInteger[5];
        if (keySize == -1) {
            v = 16739099;
            k = 0;
            n = 64;
        } else if (keySize == -2) {
            v = 15683879;
            k = 1;
            n = 128;
        } else if (keySize == -3) {
            v = 14834927;
            k = 2;
            n = 256;
        } else {
            throw new CL3Exception(-2147483645);
        }
        key[0] = dhSP[k];
        if (key[0] == null) {
            byte[] d = new byte[n];
            int i = n - 4;
            while (i >= 0) {
                d[i] = -1;
                --i;
            }
            CL3.msbf(v, d, n - 3, 3);
            key[0] = CL3.dhSP[k] = new BigInteger(1, d);
        }
        key[2] = BigInteger.valueOf(7);
        return key;
    }

    public static CL3 dhImportParams(byte[] pAsBytes, byte[] gAsBytes) {
        BigInteger[] params = new BigInteger[]{new BigInteger(pAsBytes), null, new BigInteger(gAsBytes)};
        return new CL3(params, 12);
    }

    public static CL3 dhParamGen(int primeSize, Random random) {
        if (primeSize < 0) {
            return new CL3(CL3.dhSharedParam(primeSize), 12);
        }
        CL3 p = CL3.dsaParamGen(primeSize, null, random);
        ((BigInteger[])p.obj)[1] = null;
        p.type = 12;
        return p;
    }

    public static CL3 dhKeyGen(CL3 params, int primeSize, int keySize, Random random) {
        BigInteger[] k;
        CL3 key;
        if (params == null) {
            key = CL3.dhParamGen(primeSize, random);
            CL3.dhParamGen(primeSize, random).type = 14;
            k = (BigInteger[])key.obj;
        } else {
            BigInteger[] p = (BigInteger[])params.obj;
            k = new BigInteger[5];
            key = new CL3(k, 14);
            k[0] = p[0];
            k[2] = p[2];
        }
        int keySizeBytes = keySize / 8;
        byte[] x = new byte[keySizeBytes];
        CL3.rng(null, x, 0, keySizeBytes);
        k[4] = new BigInteger(1, x);
        k[3] = k[2].modPow(k[4], k[0]);
        return key;
    }

    /*
     * Unable to fully structure code
     */
    public static CL3 dsaParamGen(int keySize, byte[] seed, Random random) {
        if (keySize < 512 || keySize % 64 != 0) {
            throw new CL3Exception(-2147483645);
        }
        counter = -1;
        S = seed;
        if (seed == null) {
            S = new byte[24];
        } else {
            counter = CL3.msbf(seed, 0, 4);
        }
        H = CL3.shaInit(null);
        L8 = keySize / 8;
        L160 = (keySize + 159) / 160;
        V = new byte[L160 * 20];
        D = new byte[20];
        one = BigInteger.valueOf(1);
        K = new BigInteger[5];
        block0: while (true) {
            if (counter < 0) {
                if (counter != -2) {
                    if (random == null) {
                        CL3.rng(null, S, 4, 20);
                    } else {
                        randomSeed = new byte[20];
                        random.nextBytes(randomSeed);
                        System.arraycopy((Object)randomSeed, 0, (Object)S, 4, 20);
                    }
                }
                counter = -1;
            }
            while (true) {
                mS = 0;
                iS = 0;
                while (iS < 20) {
                    if (S[iS + 4] != 0) {
                        i = S[iS + 4] & 255;
                        if (i >= 128) {
                            --iS;
                            break;
                        }
                        mS = 1;
                        while ((i & mS) != i) {
                            mS = (mS << 1) + 1;
                        }
                        break;
                    }
                    ++iS;
                }
                if (iS >= 16) continue block0;
                CL3.dsaRandom(H, S, 0, iS, mS, D, 0);
                CL3.dsaRandom(H, S, 1, iS, mS, V, 0);
                i = 0;
                while (i < 20) {
                    v0 = i;
                    D[v0] = (byte)(D[v0] ^ V[i]);
                    ++i;
                }
                D[0] = (byte)(D[0] | 128);
                D[19] = (byte)(D[19] | 1);
                q = new BigInteger(1, D);
                if (seed == null || CL3.isProbablePrime(q, 80)) break;
                if (counter >= 0) {
                    throw new CL3Exception(-2147483643);
                }
                CL3.dsaRandom(H, S, 1, iS, mS, S, 4);
            }
            offset = 2 + (counter < 0 ? 0 : counter * L160);
            newCounter = -1;
            while (true) {
                if (++newCounter < 4096) ** break;
                continue block0;
                k = (L160 - 1) * 20;
                n = 0;
                while (k >= 0) {
                    CL3.dsaRandom(H, S, offset + n, iS, mS, V, k);
                    k -= 20;
                    ++n;
                }
                i = V.length - L8;
                V[i] = (byte)(V[i] | 128);
                while (--i >= 0) {
                    V[i] = 0;
                }
                p = new BigInteger(1, V);
                K[1] = q;
                K[0] = p = p.subtract(p.remainder(K[1].shiftLeft(1))).add(one);
                f = p.divide(q);
                if (p.bitLength() == keySize) {
                    if (seed == null) {
                        CL3.findPrime2(K, f, keySize);
                        break block0;
                    }
                    if (CL3.isProbablePrime(p, 80)) break block0;
                }
                if (counter >= 0) {
                    throw new CL3Exception(-2147483643);
                }
                offset += L160;
            }
            break;
        }
        if (counter < 0 && seed != null) {
            CL3.msbf(newCounter, seed, 0, 4);
            System.arraycopy((Object)S, 4, (Object)seed, 4, 20);
        }
        if (random == null) {
            CL3.rng(null, D, 0, 20);
        } else {
            randomElement = new byte[20];
            random.nextBytes(randomElement);
            System.arraycopy((Object)randomElement, 0, (Object)D, 0, 20);
        }
        D[19] = (byte)(D[19] | 2);
        h = new BigInteger(1, D);
        do {
            h = h.add(one);
            K[2] = h.modPow(f, K[0]);
        } while (K[2].equals(one));
        return new CL3(K, 8);
    }

    public static byte[] dhGetPrivateKey(CL3 dhKey) {
        BigInteger[] keyElems = (BigInteger[])dhKey.obj;
        return keyElems[4].toByteArray();
    }

    public static byte[] dhGetPublicKey(CL3 dhKey) {
        BigInteger[] keyElems = (BigInteger[])dhKey.obj;
        return keyElems[3].toByteArray();
    }

    public static byte[] dhGetBaseGenerator(CL3 dhKey) {
        BigInteger[] keyElems = (BigInteger[])dhKey.obj;
        return keyElems[2].toByteArray();
    }

    public static byte[] dhGetModulus(CL3 dhKey) {
        BigInteger[] keyElems = (BigInteger[])dhKey.obj;
        return keyElems[0].toByteArray();
    }

    public static CL3 dhGetPublicKeyFromComponents(byte[] baseGenerator, byte[] primeModulus, byte[] publicValue) {
        BigInteger[] keyComponents = new BigInteger[]{new BigInteger(1, primeModulus), null, new BigInteger(1, baseGenerator), new BigInteger(1, publicValue), null};
        return new CL3(keyComponents, 14);
    }

    public static CL3 dhGetPrivateKeyFromComponents(byte[] baseGenerator, byte[] primeModulus, byte[] privateValue) {
        BigInteger[] keyComponents = new BigInteger[5];
        keyComponents[0] = new BigInteger(1, primeModulus);
        keyComponents[1] = null;
        keyComponents[2] = new BigInteger(1, baseGenerator);
        keyComponents[4] = new BigInteger(1, privateValue);
        keyComponents[3] = keyComponents[2].modPow(keyComponents[4], keyComponents[0]);
        return new CL3(keyComponents, 14);
    }

    private static void dsaRandom(CL3 H, byte[] seed, int index, int maskIndex, int mask, byte[] hash, int hashOff) {
        int c = 0;
        int i = 19;
        do {
            hash[hashOff + i] = (byte)(c += (seed[i + 4] & 0xFF) + (index & 0xFF));
            index >>>= 8;
            c >>= 8;
        } while (--i >= 0);
        if (maskIndex >= 0) {
            int n = hashOff + maskIndex;
            hash[n] = (byte)(hash[n] & mask);
        }
        if (seed != hash) {
            CL3.sha(CL3.shaInit(H), hash, hashOff, 20, hash, hashOff);
        }
    }

    private static void findPrime2(BigInteger[] key, BigInteger factor, int maxLen) {
        BigInteger prime = key[1];
        if (Pi == null) {
            CL3.smallPrimes();
        }
        int[] sieve1 = new int[512];
        int[] sieve2 = new int[512];
        int i = 0;
        while (i < 512) {
            BigInteger pi = BigInteger.valueOf(Pi[i]);
            sieve1[i] = prime.remainder(pi).intValue();
            sieve2[i] = factor.remainder(pi).intValue();
            ++i;
        }
        BigInteger one = BigInteger.valueOf(1);
        BigInteger.valueOf(2);
        int k = -2;
        int l = 0;
        block1: while ((k += 2) != -2 || l == 0) {
            int i2 = 0;
            while ((sieve1[i2] + k) % Pi[i2] != 0 && ((sieve1[i2] + k) * sieve2[i2] + 1) % Pi[i2] != 0) {
                if (++i2 < 512) continue;
                if ((prime = prime.add(BigInteger.valueOf(k - l))).bitLength() > 160) break block1;
                l = k;
                if (!CL3.isProbablePrime(prime, 80)) continue block1;
                BigInteger prod = prime.multiply(factor).add(one);
                if (prod.bitLength() > maxLen) break block1;
                if (!CL3.isProbablePrime(prod, 12)) continue block1;
                key[1] = prime;
                key[0] = prod;
                return;
            }
        }
        throw new CL3Exception(-2147483640);
    }

    static final int[] getInts(String s) {
        int n = s.length();
        int[] d = new int[n * 7 / 32];
        int j = 0;
        int i = 0;
        int b = 0;
        int a = 0;
        do {
            char c = s.charAt(i);
            if ((b += 7) >= 32) {
                d[j++] = a << 39 - b | c >> (b -= 32);
                a = c;
                continue;
            }
            a = (a << 7) + c;
        } while (++i < n);
        return d;
    }

    public static CL3 blowfishKey(byte[] rawKey, int off, int len) {
        int l;
        int r;
        int i = 0;
        int[] key = CL3.getInts(BF);
        i = 0;
        int j = -1;
        do {
            r = 0;
            l = 0;
            do {
                j = (j + 1) % len;
                l = l << 8 | rawKey[off + j] & 0xFF;
            } while (++r < 4);
            int n = i++;
            key[n] = key[n] ^ l;
        } while (i < 18);
        j = 0;
        r = 0;
        l = 0;
        do {
            l ^= key[0];
            i = 1;
            do {
                l ^= (key[18 + ((r ^= (key[18 + (l >>> 24)] + key[274 + (l >>> 16 & 0xFF)] ^ key[530 + (l >>> 8 & 0xFF)]) + key[786 + (l & 0xFF)] ^ key[i]) >>> 24)] + key[274 + (r >>> 16 & 0xFF)] ^ key[530 + (r >>> 8 & 0xFF)]) + key[786 + (r & 0xFF)] ^ key[i + 1];
            } while ((i += 2) < 16);
            int t = l;
            key[j] = l = r ^ key[17];
            key[j + 1] = r = t;
        } while ((j += 2) < 1042);
        return new CL3(key, 33);
    }

    public static void blowfish(CL3 key, int mode, byte[] iv, int ivOff, byte[] data, int off, byte[] to, int pos, int len) {
        int[] K = (int[])key.obj;
        int il = 0;
        int ir = 0;
        int ll = 0;
        int rr = 0;
        int K0 = K[0];
        int K17 = K[17];
        if (iv != null) {
            il = CL3.msbf4(iv, ivOff);
            ir = CL3.msbf4(iv, ivOff + 4);
        }
        len += off;
        while (off < len) {
            int i;
            int l = CL3.msbf4(data, off);
            int r = CL3.msbf4(data, off + 4);
            off += 8;
            if (iv != null) {
                if (mode == 0) {
                    l ^= il;
                    r ^= ir;
                } else {
                    ll = l;
                    rr = r;
                }
            }
            if (mode == 0) {
                l ^= K0;
                i = 1;
                do {
                    l ^= K[i + 1] ^ (K[18 + ((r ^= K[i] ^ (K[18 + (l >>> 24)] + K[274 + (l >>> 16 & 0xFF)] ^ K[530 + (l >>> 8 & 0xFF)]) + K[786 + (l & 0xFF)]) >>> 24)] + K[274 + (r >>> 16 & 0xFF)] ^ K[530 + (r >>> 8 & 0xFF)]) + K[786 + (r & 0xFF)];
                } while ((i += 2) < 16);
                r ^= K17;
            } else {
                l ^= K17;
                i = 16;
                do {
                    l ^= K[i - 1] ^ (K[18 + ((r ^= K[i] ^ (K[18 + (l >>> 24)] + K[274 + (l >>> 16 & 0xFF)] ^ K[530 + (l >>> 8 & 0xFF)]) + K[786 + (l & 0xFF)]) >>> 24)] + K[274 + (r >>> 16 & 0xFF)] ^ K[530 + (r >>> 8 & 0xFF)]) + K[786 + (r & 0xFF)];
                } while ((i -= 2) > 0);
                r ^= K0;
            }
            if (iv != null) {
                if (mode == 0) {
                    ir = r;
                    il = l;
                } else {
                    l ^= ir;
                    r ^= il;
                    il = rr;
                    ir = ll;
                }
            }
            if (to == null) continue;
            CL3.msbf4(r, to, pos);
            CL3.msbf4(l, to, pos + 4);
            pos += 8;
        }
        if (iv != null) {
            CL3.msbf4(il, iv, ivOff);
            CL3.msbf4(ir, iv, ivOff + 4);
        }
    }

    public static CL3 rc2Key(byte[] rawKey, int off, int len, int ekb) {
        int[] k = new int[64];
        byte[] L = new byte[128];
        int t8 = (ekb + 7) / 8;
        System.arraycopy((Object)rawKey, off, (Object)L, 0, len);
        int i = len;
        do {
            L[i] = Prc2[L[i - 1] + L[i - len] & 0xFF];
        } while (++i < 128);
        L[128 - t8] = Prc2[L[128 - t8] & 255 % (1 << 8 + ekb - 8 * t8)];
        i = 127 - t8;
        do {
            L[i] = Prc2[(L[i + 1] ^ L[i + t8]) & 0xFF];
        } while (--i >= 0);
        i = 0;
        do {
            k[i / 2] = (L[i] & 0xFF) + 256 * (L[i + 1] & 0xFF);
        } while ((i += 2) < 128);
        return new CL3(k, 34);
    }

    public static void rc2(CL3 key, int mode, byte[] iv, int ivOff, byte[] data, int off, byte[] to, int pos, int len) {
        int ia = 0;
        int ib = 0;
        int ic = 0;
        int id = 0;
        int aa = 0;
        int ab = 0;
        int ac = 0;
        int ad = 0;
        int[] K = (int[])key.obj;
        if (iv != null) {
            ia = CL3.lsbf(iv, ivOff + 0, 2);
            ib = CL3.lsbf(iv, ivOff + 2, 2);
            ic = CL3.lsbf(iv, ivOff + 4, 2);
            id = CL3.lsbf(iv, ivOff + 6, 2);
        }
        len += off;
        while (off < len) {
            int p;
            int j;
            int n;
            int a = data[off] & 0xFF | (data[off + 1] & 0xFF) << 8;
            int b = data[off + 2] & 0xFF | (data[off + 3] & 0xFF) << 8;
            int c = data[off + 4] & 0xFF | (data[off + 5] & 0xFF) << 8;
            int d = data[off + 6] & 0xFF | (data[off + 7] & 0xFF) << 8;
            off += 8;
            if (mode == 0) {
                if (iv != null) {
                    a ^= ia;
                    b ^= ib;
                    c ^= ic;
                    d ^= id;
                }
                n = 0;
                j = 0;
                p = 2;
                while (true) {
                    a += K[j] + (d & c) + (~d & b);
                    a = a << 1 | (a & 0xFFFF) >>> 15;
                    b += K[j + 1] + (a & d) + (~a & c);
                    b = b << 2 | (b & 0xFFFF) >>> 14;
                    c += K[j + 2] + (b & a) + (~b & d);
                    c = c << 3 | (c & 0xFFFF) >>> 13;
                    d += K[j + 3] + (c & b) + (~c & a);
                    d = d << 5 | (d & 0xFFFF) >>> 11;
                    j += 4;
                    if ((n += p) < 10) continue;
                    n -= 11;
                    if (j == 64) break;
                    c += K[(b += K[(a += K[d & 0x3F]) & 0x3F]) & 0x3F];
                    d += K[c & 0x3F];
                }
                if (iv != null) {
                    ia = a;
                    ib = b;
                    ic = c;
                    id = d;
                }
            } else {
                if (iv != null) {
                    aa = a;
                    ab = b;
                    ac = c;
                    ad = d;
                }
                j = 63;
                n = 0;
                p = 2;
                while (true) {
                    d = (d << 11 | (d & 0xFFFF) >>> 5) - K[j] - ((c & b) + (~c & a));
                    c = (c << 13 | (c & 0xFFFF) >>> 3) - K[j - 1] - ((b & a) + (~b & d));
                    b = (b << 14 | (b & 0xFFFF) >>> 2) - K[j - 2] - ((a & d) + (~a & c));
                    a = (a << 15 | (a & 0xFFFF) >>> 1) - K[j - 3] - ((d & c) + (~d & b));
                    j -= 4;
                    if ((n += p) < 10) continue;
                    n -= 11;
                    if (j < 0) break;
                    d -= K[c & 0x3F];
                    c -= K[b & 0x3F];
                    b -= K[a & 0x3F];
                    a -= K[d & 0x3F];
                }
                if (iv != null) {
                    a ^= ia;
                    b ^= ib;
                    c ^= ic;
                    d ^= id;
                    ia = aa;
                    ib = ab;
                    ic = ac;
                    id = ad;
                }
            }
            if (to == null) continue;
            CL3.lsbf2(a, to, pos);
            CL3.lsbf2(b, to, pos + 2);
            CL3.lsbf2(c, to, pos + 4);
            CL3.lsbf2(d, to, pos + 6);
            pos += 8;
        }
        if (iv != null) {
            CL3.lsbf2(ia, iv, ivOff + 0);
            CL3.lsbf2(ib, iv, ivOff + 2);
            CL3.lsbf2(ic, iv, ivOff + 4);
            CL3.lsbf2(id, iv, ivOff + 6);
        }
    }

    public static int dsaSign(CL3 key, int format, Object params, byte[] data, int off, int len, byte[] sig, int pos) {
        BigInteger k;
        BigInteger[] K = (BigInteger[])key.obj;
        if ((format & 3) == 1) {
            byte[] byArray = data;
            int n = off;
            int n2 = len;
            len = 20;
            data = new byte[20];
            off = 0;
            CL3.sha(null, byArray, n, n2, data, 0);
        } else {
            if ((format & 3) != 0 || len != 20) {
                throw new CL3Exception(-2147483645);
            }
            byte[] byArray = data;
            data = new byte[20];
            System.arraycopy((Object)byArray, off, (Object)data, 0, 20);
        }
        BigInteger h = new BigInteger(1, data);
        do {
            CL3.rng(null, data, 0, 20);
            data[0] = (byte)(data[0] & 0x7F);
        } while ((k = new BigInteger(1, data)).signum() == 0);
        BigInteger r = K[2].modPow(k, K[0]).remainder(K[1]);
        BigInteger s = k.modInverse(K[1]).multiply(K[4].multiply(r).add(h)).remainder(K[1]);
        byte[] b = r.toByteArray();
        byte[] t = s.toByteArray();
        if ((format & 4) == 0) {
            int i = 39;
            int j = t.length;
            do {
                if (i == 19) {
                    t = b;
                    j = b.length;
                }
                byte by = sig[pos + i] = --j < 0 ? (byte)0 : t[j];
            } while (--i >= 0);
            return 40;
        }
        sig[pos] = 48;
        int i = b.length;
        len = 6 + i + t.length;
        sig[pos + 1] = (byte)(len - 2);
        pos += 4;
        while (true) {
            byte by = (byte)i;
            sig[pos - 1] = by;
            System.arraycopy((Object)b, 0, (Object)sig, pos, (int)by);
            sig[pos - 2] = 2;
            pos += 2 + i;
            if (b == t) {
                return len;
            }
            b = t;
            i = t.length;
        }
    }

    public static boolean dsaVerify(CL3 key, int format, Object params, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen) {
        BigInteger[] K = (BigInteger[])key.obj;
        byte[] buf = new byte[20];
        BigInteger s = null;
        BigInteger r = null;
        int i = 0;
        while (true) {
            byte j;
            byte[] b;
            if ((format & 4) == 0) {
                b = buf;
                System.arraycopy((Object)sig, sigOff + i, (Object)buf, 0, 20);
            } else if (sig[sigOff += 2] == 2 && (j = sig[sigOff + 1]) > 0) {
                b = j == 20 ? buf : new byte[j];
                System.arraycopy((Object)sig, sigOff + 2, (Object)b, 0, (int)j);
                sigOff += j;
            } else {
                return false;
            }
            s = new BigInteger(1, b);
            if (i != 0) break;
            r = s;
            i += 20;
        }
        if ((format & 3) == 1) {
            CL3.sha(null, data, off, len, buf, 0);
        } else {
            if ((format & 3) != 0 || len != 20) {
                throw new CL3Exception(-2147483645);
            }
            System.arraycopy((Object)data, off, (Object)buf, 0, 20);
        }
        BigInteger w = s.modInverse(K[1]);
        BigInteger u1 = new BigInteger(1, buf).multiply(w).remainder(K[1]);
        BigInteger u2 = r.multiply(w).remainder(K[1]);
        s = K[2].modPow(u1, K[0]).multiply(K[3].modPow(u2, K[0])).remainder(K[0]).remainder(K[1]);
        return s.equals(r);
    }

    public static CL3 dsaKeyGen(CL3 params, int keySize) {
        BigInteger[] k;
        CL3 keyobj;
        if (params == null) {
            keyobj = CL3.dsaParamGen(keySize, null, null);
            keyobj.type = 10;
            k = (BigInteger[])keyobj.obj;
        } else {
            k = new BigInteger[5];
            keyobj = new CL3(k, 10);
            System.arraycopy((Object)((BigInteger[])params.obj), 0, (Object)k, 0, 5);
        }
        byte[] b = new byte[20];
        CL3.rng(null, b, 0, 20);
        k[4] = new BigInteger(1, b);
        k[3] = k[2].modPow(k[4], k[0]);
        return keyobj;
    }
}

