/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.bluez.crypto;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.bluez.crypto.CL3Exception;
import com.ibm.j9.bluez.crypto.CL3State;

public class HMAC {
    private static final byte[] HASH_BS;
    protected static final byte[] HASH_DS;

    static {
        byte[] byArray = new byte[8];
        byArray[1] = 16;
        byArray[2] = 64;
        byArray[3] = 64;
        byArray[4] = 64;
        byArray[5] = -128;
        byArray[6] = -128;
        byArray[7] = 64;
        HASH_BS = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[1] = 16;
        byArray2[2] = 16;
        byArray2[3] = 20;
        byArray2[4] = 32;
        byArray2[5] = 48;
        byArray2[6] = 64;
        byArray2[7] = 36;
        HASH_DS = byArray2;
    }

    public static CL3State hmacInit(CL3State state, int hashAlg, byte[] key, int off, int len) {
        byte[] byArray;
        Object[] istate;
        if (state == null) {
            istate = new Object[3];
            state = new CL3State(istate, hashAlg + 23);
        } else {
            istate = (Object[])state.obj;
            if (hashAlg != (((byte[])istate[2])[0] & 0xFF)) {
                throw new CL3Exception(-2147483645);
            }
        }
        CL3 st = null;
        CL3 eo = null;
        CL3 ei = null;
        int i = 0;
        while (i < 2) {
            ei = eo;
            eo = (CL3)istate[i];
            switch (hashAlg) {
                case 2: {
                    eo = CL3.md5Init(eo);
                    break;
                }
                case 3: {
                    eo = CL3.shaInit(eo);
                    break;
                }
                default: {
                    throw new CL3Exception(-2147483624);
                }
            }
            istate[i] = eo;
            ++i;
        }
        int bs = HASH_BS[hashAlg] & 0xFF;
        int x = 54;
        if (istate[2] == null) {
            byte[] byArray2 = new byte[bs + 1];
            istate[2] = byArray2;
            byArray = byArray2;
        } else {
            byArray = (byte[])istate[2];
        }
        byte[] data = byArray;
        data[0] = (byte)hashAlg;
        if (len <= bs) {
            System.arraycopy((Object)key, off, (Object)data, 1, len);
            i = 1;
        } else {
            i = 0;
        }
        do {
            if (i == 1) {
                while (++len <= bs) {
                    data[len] = 0;
                }
                key = data;
                off = 1;
                len = bs;
                data = null;
                st = ei;
            }
            if (i != 0) {
                int j = bs;
                do {
                    int n = j--;
                    key[n] = (byte)(key[n] ^ x);
                } while (j > 0);
                x = 106;
            }
            switch (hashAlg) {
                case 2: {
                    CL3.md5(st, key, off, len, data, 1);
                    break;
                }
                case 3: {
                    CL3.sha(st, key, off, len, data, 1);
                }
            }
            if (i == 0) {
                len = HASH_DS[hashAlg];
            }
            st = eo;
        } while (++i <= 2);
        return state;
    }

    public static int hmac(CL3State state, byte[] data, int off, int len, byte[] to, int pos) {
        Object[] istate = (Object[])state.obj;
        byte[] buf = (byte[])istate[2];
        byte[] tmp = to == null ? null : buf;
        CL3 e1 = (CL3)istate[0];
        CL3 e2 = (CL3)istate[1];
        int alg = buf[0] & 0xFF;
        switch (alg) {
            case 2: {
                CL3.md5(e1, data, off, len, tmp, 1);
                if (to == null) break;
                CL3.md5(e2, tmp, 1, 16, to, pos);
                return 16;
            }
            case 3: {
                CL3.sha(e1, data, off, len, tmp, 1);
                if (to == null) break;
                CL3.sha(e2, tmp, 1, 20, to, pos);
                return 20;
            }
            default: {
                throw new CL3Exception(-2147483624);
            }
        }
        return HASH_BS[alg] & 0xFF;
    }
}

