/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.bluez.crypto;

import com.ibm.j9.bluez.crypto.BigInteger;
import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.bluez.crypto.CL3Exception;
import java.util.Random;

public class RSACipher {
    private static final long P_HighNibbles = -73301893889L;
    private static final long Q_HighNibbles = -7296712466775684130L;
    private static final long PERM = 2064737499334935870L;
    public static final int RSA_HASH_DATA = 4096;
    public static final int RSA_HASH_ALG = 7;
    public static final int RSA_SCHEME = 224;
    public static final int RSA_RAW = 0;
    public static final int RSA_PKCS1 = 32;
    public static final int RSA_ISO9796 = 64;
    public static final int RSA_OAEP = 96;
    public static final int RSA_PKCS1_MD2 = 33;
    public static final int RSA_PKCS1_SHA = 35;
    public static final int RSA_PKCS1_MD5 = 34;
    protected static final byte[] HASH_DS;
    protected static final byte[] DIGEST_INFOS;
    public static final int T_RSA_PUBLIC_KEY = 5;
    public static final int T_RSA_PRIVATE_KEY = 6;

    static {
        byte[] byArray = new byte[8];
        byArray[1] = 16;
        byArray[2] = 16;
        byArray[3] = 20;
        byArray[4] = 32;
        byArray[5] = 48;
        byArray[6] = 64;
        byArray[7] = 36;
        HASH_DS = byArray;
        byte[] byArray2 = new byte[123];
        byArray2[1] = 104;
        byArray2[2] = 9;
        byArray2[3] = 28;
        byArray2[4] = 44;
        byArray2[5] = 64;
        byArray2[6] = 84;
        byArray2[7] = 8;
        byArray2[9] = 18;
        byArray2[10] = 48;
        byArray2[11] = 32;
        byArray2[12] = 48;
        byArray2[13] = 12;
        byArray2[14] = 6;
        byArray2[15] = 8;
        byArray2[16] = 42;
        byArray2[17] = -122;
        byArray2[18] = 72;
        byArray2[19] = -122;
        byArray2[20] = -9;
        byArray2[21] = 13;
        byArray2[22] = 2;
        byArray2[23] = 5;
        byArray2[24] = 5;
        byArray2[26] = 4;
        byArray2[27] = 16;
        byArray2[28] = 15;
        byArray2[29] = 48;
        byArray2[30] = 33;
        byArray2[31] = 48;
        byArray2[32] = 9;
        byArray2[33] = 6;
        byArray2[34] = 5;
        byArray2[35] = 43;
        byArray2[36] = 14;
        byArray2[37] = 3;
        byArray2[38] = 2;
        byArray2[39] = 26;
        byArray2[40] = 5;
        byArray2[42] = 4;
        byArray2[43] = 20;
        byArray2[44] = 19;
        byArray2[45] = 48;
        byArray2[46] = 49;
        byArray2[47] = 48;
        byArray2[48] = 13;
        byArray2[49] = 6;
        byArray2[50] = 9;
        byArray2[51] = 96;
        byArray2[52] = -122;
        byArray2[53] = 72;
        byArray2[54] = 1;
        byArray2[55] = 101;
        byArray2[56] = 3;
        byArray2[57] = 4;
        byArray2[58] = 2;
        byArray2[59] = 1;
        byArray2[60] = 5;
        byArray2[62] = 4;
        byArray2[63] = 32;
        byArray2[64] = 19;
        byArray2[65] = 48;
        byArray2[66] = 65;
        byArray2[67] = 48;
        byArray2[68] = 13;
        byArray2[69] = 6;
        byArray2[70] = 9;
        byArray2[71] = 96;
        byArray2[72] = -122;
        byArray2[73] = 72;
        byArray2[74] = 1;
        byArray2[75] = 101;
        byArray2[76] = 3;
        byArray2[77] = 4;
        byArray2[78] = 2;
        byArray2[79] = 2;
        byArray2[80] = 5;
        byArray2[82] = 4;
        byArray2[83] = 48;
        byArray2[84] = 19;
        byArray2[85] = 48;
        byArray2[86] = 81;
        byArray2[87] = 48;
        byArray2[88] = 13;
        byArray2[89] = 6;
        byArray2[90] = 9;
        byArray2[91] = 96;
        byArray2[92] = -122;
        byArray2[93] = 72;
        byArray2[94] = 1;
        byArray2[95] = 101;
        byArray2[96] = 3;
        byArray2[97] = 4;
        byArray2[98] = 2;
        byArray2[99] = 3;
        byArray2[100] = 5;
        byArray2[102] = 4;
        byArray2[103] = 64;
        byArray2[104] = 18;
        byArray2[105] = 48;
        byArray2[106] = 32;
        byArray2[107] = 48;
        byArray2[108] = 12;
        byArray2[109] = 6;
        byArray2[110] = 8;
        byArray2[111] = 42;
        byArray2[112] = -122;
        byArray2[113] = 72;
        byArray2[114] = -122;
        byArray2[115] = -9;
        byArray2[116] = 13;
        byArray2[117] = 2;
        byArray2[118] = 2;
        byArray2[119] = 5;
        byArray2[121] = 4;
        byArray2[122] = 16;
        DIGEST_INFOS = byArray2;
    }

    public static int rsaSign(CL3 key, int format, Object param, byte[] data, int off, int len, byte[] sig, int pos) {
        block12: {
            byte[] buf;
            int n;
            BigInteger[] K;
            block15: {
                int i;
                block17: {
                    block16: {
                        int sLen;
                        block13: {
                            block14: {
                                K = (BigInteger[])key.obj;
                                n = (K[0].bitLength() + 7) / 8;
                                buf = new byte[n];
                                if (n < 64) break block12;
                                if ((format & 0x1000) != 0) {
                                    int n2 = len;
                                    len = HASH_DS[format & 7];
                                    RSACipher.digest(format, 0, data, off, n2, buf, n - len);
                                    data = buf;
                                    off = n - len;
                                }
                                if (data != buf) {
                                    int n3 = off;
                                    off = n - len;
                                    System.arraycopy((Object)data, n3, (Object)buf, off, len);
                                }
                                if ((i = format & 0xE0) != 32) break block13;
                                i = format & 7;
                                if (i == 0) break block14;
                                if (len == 0 || HASH_DS[i] != len) break block12;
                                byte k = DIGEST_INFOS[i];
                                if (k != 0) {
                                    byte l = DIGEST_INFOS[k];
                                    System.arraycopy((Object)DIGEST_INFOS, k + 1, (Object)buf, off -= l, (int)l);
                                }
                            }
                            if (off < 11) {
                                throw new CL3Exception(-2147483640);
                            }
                            buf[1] = 1;
                            buf[--off] = 0;
                            while (--off > 1) {
                                buf[off] = -1;
                            }
                            break block15;
                        }
                        if (i != 128) break block16;
                        byte[] salt = new byte[20];
                        if ((format & 0x2000) != 0) {
                            sLen = salt.length;
                            CL3.rng(null, salt, 0, sLen);
                        } else {
                            sLen = 0;
                        }
                        if (8 + len + sLen > n) break block12;
                        int j = 0;
                        while (j < 8) {
                            buf[j] = 0;
                            ++j;
                        }
                        System.arraycopy((Object)buf, off, (Object)buf, 8, len);
                        System.arraycopy((Object)salt, 0, (Object)buf, 8 + len, sLen);
                        int n4 = j = 8 + len + sLen;
                        j = n - 1 - HASH_DS[format & 7];
                        RSACipher.digest(format, 6, buf, 0, n4, buf, j);
                        buf[n - 1] = -68;
                        i = j - sLen;
                        System.arraycopy((Object)salt, 0, (Object)buf, i, sLen);
                        buf[--i] = 1;
                        while (--i >= 0) {
                            buf[i] = 0;
                        }
                        RSACipher.MGF1(buf, 0, j, j, n - j - 1);
                        buf[0] = (byte)(buf[0] & (1 << (K[0].bitLength() - 1) % 8) - 1);
                        break block15;
                    }
                    if (i != 64) break block17;
                    i = K[0].bitLength();
                    if (len * 16 > i + 4) break block12;
                    RSACipher.padISO9796(buf, n, len, i);
                    break block15;
                }
                if (i != 0) break block12;
            }
            RSACipher.rsa(K, RSACipher.isPrivateKey(key), format, buf, sig, pos, n);
            return n;
        }
        throw new CL3Exception(-2147483645);
    }

    public static int rsaDecrypt(CL3 key, int format, Object param, byte[] data, int off, int len, byte[] to, int pos) {
        block6: {
            byte[] buf;
            int n;
            block8: {
                int i;
                block9: {
                    block7: {
                        BigInteger[] K = (BigInteger[])key.obj;
                        n = (K[0].bitLength() + 7) / 8;
                        buf = new byte[n];
                        i = format & 0xE0;
                        if (i != format || len != n || n < 64) break block6;
                        System.arraycopy((Object)data, off, (Object)buf, 0, len);
                        RSACipher.rsa(K, RSACipher.isPrivateKey(key), 0, buf, buf, 0, n);
                        if (i != 32) break block7;
                        off = 2;
                        while (off < n && buf[off] != 0) {
                            ++off;
                        }
                        if (buf[0] != 0 || buf[1] != 2 || i == n || ++off < 11) {
                            throw new CL3Exception(-2147483643);
                        }
                        break block8;
                    }
                    if (i != 96) break block9;
                    byte[] phash = new byte[20];
                    RSACipher.MGF1(buf, 1, 20, 21, n - 21);
                    RSACipher.MGF1(buf, 21, n - 21, 1, 20);
                    CL3.sha(null, phash, 0, 0, phash, 0);
                    off = 41;
                    while (off < n && buf[off] == 0) {
                        ++off;
                    }
                    if (!RSACipher.cmp(buf, 21, phash, 0, 20) || off == n || buf[off++] != 1 || buf[0] != 0) {
                        throw new CL3Exception(-2147483643);
                    }
                    break block8;
                }
                if (i == 0) {
                    off = 0;
                    while (off < n && buf[off] == 0) {
                        ++off;
                    }
                }
                break block6;
            }
            System.arraycopy((Object)buf, off, (Object)to, pos, n - off);
            int n2 = pos + n - 1;
            to[n2] = (byte)(to[n2] + 0);
            return n - off;
        }
        throw new CL3Exception(-2147483645);
    }

    protected static void rsa(BigInteger[] key, boolean usePrivate, int mode, byte[] data, byte[] to, int pos, int len) {
        BigInteger b = new BigInteger(1, data);
        if (usePrivate) {
            BigInteger d;
            if (key[3].bitLength() == 0) {
                b = b.modPow(key[2], key[0]);
            } else {
                if (key.length == 2) {
                    throw new CL3Exception(-2147483625);
                }
                BigInteger m1 = b.remainder(key[3]).modPow(key[5], key[3]);
                BigInteger m2 = b.remainder(key[4]).modPow(key[6], key[4]);
                b = m1.add(key[3]).subtract(m2).multiply(key[7]).remainder(key[3]).multiply(key[4]).add(m2);
            }
            if ((mode & 0x40) != 0 && (d = key[0].subtract(b)).compareTo(b) <= 0) {
                b = d;
            }
        } else {
            b = b.modPow(key[1], key[0]);
            if ((mode & 0x40) != 0 && (b.intValue() & 0xF) != 6) {
                b = key[0].subtract(b);
            }
        }
        if ((len = (data = b.toByteArray()).length - len) < 0) {
            do {
                to[pos++] = 0;
            } while (++len < 0);
        }
        System.arraycopy((Object)data, len, (Object)to, pos, data.length - len);
    }

    public static int rsaEncrypt(CL3 key, int format, Object param, byte[] data, int off, int len, byte[] to, int pos) {
        block7: {
            byte[] buf;
            int n;
            BigInteger[] K;
            block9: {
                int i;
                block10: {
                    block8: {
                        K = (BigInteger[])key.obj;
                        n = (K[0].bitLength() + 7) / 8;
                        buf = new byte[n];
                        i = format & 0xE0;
                        if (i != format || len > n || n < 64) break block7;
                        System.arraycopy((Object)data, off, (Object)buf, n - len, len);
                        if (i != 32) break block8;
                        i = n - len - 1;
                        if (i < 10) {
                            throw new CL3Exception(-2147483640);
                        }
                        buf[0] = 0;
                        buf[i] = 0;
                        buf[1] = 2;
                        CL3.rng(null, buf, 2, i - 3);
                        int v = CL3.msbf(buf, 2, 4) | 1;
                        while (--i > 1) {
                            if (buf[i] != 0) continue;
                            v *= v;
                            buf[i] = (byte)v;
                        }
                        break block9;
                    }
                    if (i != 96) break block10;
                    if (len + 20 + 20 + 2 > n) {
                        throw new CL3Exception(-2147483640);
                    }
                    CL3.sha(null, buf, 0, 0, buf, 21);
                    buf[0] = 0;
                    i = n - len - 1;
                    buf[i] = 1;
                    while (--i > 40) {
                        buf[i] = 0;
                    }
                    CL3.rng(null, buf, 1, 20);
                    RSACipher.MGF1(buf, 21, n - 21, 1, 20);
                    RSACipher.MGF1(buf, 1, 20, 21, n - 21);
                    break block9;
                }
                if (i != 0) break block7;
            }
            RSACipher.rsa(K, RSACipher.isPrivateKey(key), 0, buf, to, pos, n);
            return n;
        }
        throw new CL3Exception(-2147483645);
    }

    public static boolean rsaVerify(CL3 key, int format, Object param, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen) {
        block19: {
            byte[] buf;
            block17: {
                int i;
                int n;
                block20: {
                    BigInteger[] K;
                    block18: {
                        block16: {
                            byte k;
                            K = (BigInteger[])key.obj;
                            n = (K[0].bitLength() + 7) / 8;
                            if (n != sigLen) {
                                return false;
                            }
                            buf = new byte[n];
                            System.arraycopy((Object)sig, sigOff, (Object)buf, 0, sigLen);
                            sigOff = 0;
                            sigLen = n;
                            RSACipher.rsa(K, RSACipher.isPrivateKey(key), format, buf, buf, 0, sigLen);
                            if ((format & 0x1000) != 0) {
                                data = RSACipher.digest(format, 0, data, off, len, null, 0);
                                off = 0;
                                len = data.length;
                            }
                            if ((i = format & 0xE0) != 32) break block16;
                            i = 2;
                            while (i < n && buf[i] == -1) {
                                if (buf[i] != -1) {
                                    return false;
                                }
                                ++i;
                            }
                            if (buf[0] != 0 || buf[1] != 1 || i == n || buf[i] != 0 || ++i < 11) {
                                return false;
                            }
                            sigOff = i;
                            sigLen = n - i;
                            i = format & 7;
                            if (i != 0 && (k = DIGEST_INFOS[i]) != 0) {
                                byte l = DIGEST_INFOS[k];
                                if (l + HASH_DS[i] != sigLen || !RSACipher.cmp(DIGEST_INFOS, k + 1, buf, sigOff, l)) {
                                    return false;
                                }
                                sigOff += l;
                                sigLen -= l;
                            }
                            break block17;
                        }
                        if (i != 128) break block18;
                        byte hLen = HASH_DS[format & 7];
                        if (hLen >= 0) {
                            int j = n - hLen - 1;
                            RSACipher.MGF1(buf, 0, j, j, hLen);
                            buf[0] = (byte)(buf[0] & (1 << (K[0].bitLength() - 1) % 8) - 1);
                            j = 0;
                            while (j < n && buf[j] == 0) {
                                ++j;
                            }
                            if (j == n || buf[j++] != 1 || buf[n - 1] != -68) {
                                return false;
                            }
                            int sLen = n - j - 1 - hLen;
                            byte[] buf2 = new byte[8 + len + sLen];
                            System.arraycopy((Object)data, off, (Object)buf2, 8, len);
                            System.arraycopy((Object)buf, j, (Object)buf2, 8 + len, sLen);
                            RSACipher.digest(format, 0, buf2, 0, buf2.length, buf, 0);
                            return RSACipher.cmp(buf, 0, buf, n - hLen - 1, hLen);
                        }
                        break block19;
                    }
                    if (i != 64) break block20;
                    i = K[0].bitLength();
                    if (len * 16 > i + 4) break block19;
                    byte[] byArray = data;
                    data = new byte[n];
                    System.arraycopy((Object)byArray, off, (Object)data, n - len, len);
                    RSACipher.padISO9796(data, n, len, i);
                    len = n;
                    break block17;
                }
                if (i != 0) break block19;
                i = n - len - 1;
                while (i >= 0) {
                    if (buf[i] != 0) {
                        return false;
                    }
                    --i;
                }
                sigLen = len;
                sigOff += n - sigLen;
            }
            return sigLen == len && RSACipher.cmp(buf, sigOff, data, off, len);
        }
        throw new CL3Exception(-2147483645);
    }

    public static int rsaDecryptSignature(CL3 key, int format, Object param, byte[] sig, int sigOff, int sigLen, byte[] to, int pos) {
        BigInteger[] K = (BigInteger[])key.obj;
        int n = (K[0].bitLength() + 7) / 8;
        if (n != sigLen) {
            return -1;
        }
        byte[] buf = new byte[n];
        System.arraycopy((Object)sig, sigOff, (Object)buf, 0, sigLen);
        sigOff = 0;
        sigLen = n;
        RSACipher.rsa(K, RSACipher.isPrivateKey(key), format, buf, buf, 0, sigLen);
        int i = format & 0xE0;
        if (i == 32) {
            i = 2;
            while (i < n && buf[i] == -1) {
                if (buf[i] != -1) {
                    return -1;
                }
                ++i;
            }
            if (buf[0] != 0 || buf[1] != 1 || i == n || buf[i] != 0 || ++i < 11) {
                return -1;
            }
            sigOff = i;
            sigLen = n - i;
        }
        System.arraycopy((Object)buf, sigOff, (Object)to, pos, sigLen);
        return 16;
    }

    public static CL3 rsaKeyGen(int keySize, byte[] pubExp, Random random) {
        if (keySize % 16 != 0) {
            throw new CL3Exception(-2147483645);
        }
        BigInteger[] key = new BigInteger[8];
        BigInteger one = BigInteger.valueOf(1);
        int len = keySize / 16;
        byte[] b = new byte[len];
        BigInteger e = pubExp == null ? BigInteger.valueOf(65537) : new BigInteger(1, pubExp);
        BigInteger q = null;
        BigInteger p = null;
        long h = -73301893889L;
        int topBits = -1;
        while (true) {
            if (random == null) {
                CL3.rng(null, b, 0, len);
            } else {
                random.nextBytes(b);
            }
            if (topBits < 0) {
                topBits = b[0] >> 2 & 0x3C;
            }
            b[0] = (byte)((long)(b[0] & 0xF) + (h >> topBits << 4));
            int n = len - 1;
            b[n] = (byte)(b[n] | 1);
            q = RSACipher.findPrime(new BigInteger(1, b), false);
            if (q.bitLength() > len * 8 || !e.gcd(q.subtract(one)).equals(one)) continue;
            if (p == null) {
                p = q;
                h = -7296712466775684130L;
                continue;
            }
            key[0] = p.multiply(q);
            if (key[0].bitLength() == keySize) break;
        }
        BigInteger d = e.modInverse(p.subtract(one).multiply(q.subtract(one)));
        key[1] = e;
        key[2] = d;
        key[3] = p;
        key[4] = q;
        key[5] = d.remainder(p.subtract(one));
        key[6] = d.remainder(q.subtract(one));
        key[7] = q.modInverse(p);
        return new CL3(key, 6);
    }

    protected static void MGF1(byte[] buf, int toBeMaskedOff, int maskLen, int seedOff, int seedLen) {
        int i;
        if (maskLen > 5120) {
            throw new CL3Exception(-2147483625);
        }
        CL3 shaState = CL3.shaInit(null);
        if (seedLen >= 64) {
            i = seedLen % 64;
            CL3.sha(shaState, buf, seedOff, seedLen - i, null, 0);
            seedOff += seedLen - i;
            seedLen = i;
        }
        byte[] temp = new byte[84];
        System.arraycopy((Object)buf, seedOff, (Object)temp, 0, seedLen);
        i = 0;
        while (i < 3) {
            temp[seedLen++] = 0;
            if (seedLen == 64) {
                CL3.sha(shaState, temp, 0, 64, null, 0);
                seedLen = 0;
            }
            ++i;
        }
        if (maskLen > 0) {
            temp[seedLen] = -1;
            block1: while (true) {
                int n = seedLen;
                temp[n] = (byte)(temp[n] + 1);
                CL3.sha(shaState, temp, 0, seedLen + 1, temp, 64);
                i = 64;
                while (true) {
                    if (i >= 84) continue block1;
                    int n2 = toBeMaskedOff++;
                    buf[n2] = (byte)(buf[n2] ^ temp[i]);
                    if (--maskLen == 0) {
                        return;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    static final byte[] digest(int format, int excludeAlgs, byte[] data, int off, int len, byte[] hashBuf, int hashOff) {
        block9: {
            int h = format & 7;
            if ((excludeAlgs & 1 << h) == 0) {
                byte k;
                byte l = HASH_DS[h];
                if ((format & 0x4000) != 0 && (k = DIGEST_INFOS[h]) != 0) {
                    if (hashBuf == null) {
                        byte by = l;
                        l = DIGEST_INFOS[k];
                        hashBuf = new byte[by + l];
                    }
                    System.arraycopy((Object)DIGEST_INFOS, k + 1, (Object)hashBuf, hashOff, (int)l);
                    hashOff += l;
                } else if (hashBuf == null) {
                    hashBuf = new byte[l];
                }
                switch (h) {
                    case 3: {
                        CL3.sha(null, data, off, len, hashBuf, hashOff);
                        break;
                    }
                    case 2: {
                        CL3.md5(null, data, off, len, hashBuf, hashOff);
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                return hashBuf;
            }
        }
        throw new CL3Exception(-2147483645);
    }

    static void padISO9796(byte[] buf, int padlen, int len, int sigbits) {
        int k = -1;
        int j = padlen + -1;
        int i = -padlen;
        while (++i < 0) {
            if (k < 0) {
                k = buf[j + i / 2 % len] & 0xFF;
            }
            if ((i & 1) != 0) {
                buf[j + i] = (byte)(2064737499334935870L >> (k << 2 & 0x3C) & 0xFL | (2064737499334935870L >> (k >> 2 & 0x3C) & 0xFL) << 4);
                continue;
            }
            buf[j + i] = (byte)k;
            k = -1;
        }
        int n = padlen - 2 * len;
        buf[n] = (byte)(buf[n] ^ 1);
        if ((sigbits = (sigbits - 1) % 8) > 0) {
            buf[0] = (byte)(buf[0] & (1 << sigbits) - 1);
        }
        buf[0] = (byte)(buf[0] | 1 << (sigbits + 7) % 8);
        buf[j] = (byte)(buf[j] << 4 | 6);
    }

    static final boolean cmp(byte[] b1, int off1, byte[] b2, int off2, int n) {
        while (--n >= 0) {
            if (b1[off1 + n] == b2[off2 + n]) continue;
            return false;
        }
        return true;
    }

    public static byte[][] exportRSAKeyMaterial(CL3 rsaKeyPair) {
        if (rsaKeyPair.type != 6) {
            throw new CL3Exception();
        }
        byte[][] result = new byte[2][];
        BigInteger[] keyElems = (BigInteger[])rsaKeyPair.obj;
        result[0] = keyElems[3].toByteArray();
        result[1] = keyElems[4].toByteArray();
        return result;
    }

    private static BigInteger findPrime(BigInteger n, boolean strongPrime) {
        BigInteger P;
        BigInteger one = BigInteger.valueOf(1);
        if (CL3.Pi == null) {
            CL3.smallPrimes();
        }
        int[] rests = new int[512];
        int i = 0;
        while (i < 512) {
            rests[i] = n.remainder(BigInteger.valueOf(CL3.Pi[i])).intValue();
            ++i;
        }
        int p = -2;
        block1: while (true) {
            int t;
            BigInteger P2;
            p += 2;
            i = 0;
            while (i < 512) {
                if ((rests[i] + p) % CL3.Pi[i] == 0 || strongPrime && (2 * (rests[i] + p) + 1) % CL3.Pi[i] == 0) continue block1;
                ++i;
            }
            P = strongPrime ? P2.shiftLeft(1).add(one) : P2;
            if (CL3.isProbablePrime(P, t = (P2 = n.add(BigInteger.valueOf(p))).bitLength() < 512 ? 80 : 12) && (P == P2 || CL3.isProbablePrime(P2, t))) break;
        }
        return P;
    }

    private static boolean isPrivateKey(CL3 key) {
        return key.type == 1 || key.type == 2 || key.type == 6;
    }
}

