/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.ssl.ConnectionState;
import com.ibm.j9.ssl.HashingAlgorithm;
import com.ibm.j9.ssl.Util;
import com.ibm.oti.crypto.Key;
import com.ibm.oti.crypto.Provider;
import com.ibm.oti.util.Msg;
import java.io.IOException;

public class CipherAlgorithm {
    public static final int CIPHER_TYPE_STREAM = 1;
    public static final int CIPHER_TYPE_BLOCK = 2;
    private ConnectionState connectionState;
    private Provider provider;
    private Key clientKey;
    private Key serverKey;
    private boolean keysInitialized;

    public CipherAlgorithm(Provider provider) {
        this.provider = provider;
    }

    private void initializeKeys() throws IOException {
        if (this.keysInitialized) {
            return;
        }
        this.serverKey = this.provider.createKey(this.connectionState.serverWriteKey);
        this.clientKey = this.provider.createKey(this.connectionState.clientWriteKey);
        this.keysInitialized = true;
    }

    public void setConnectionState(ConnectionState state) throws IOException {
        this.connectionState = state;
    }

    public int getKeyMaterialSize() {
        return this.provider.getKeyLength();
    }

    public int getBlockSize() {
        return this.provider.getBlockLength();
    }

    public int getIVSize() {
        return this.provider.getIVLength();
    }

    protected int getCipherType() {
        if (this.provider.getIVLength() > 0) {
            return 2;
        }
        return 1;
    }

    private byte[] computeMACHash(byte[] content, byte contentType, int sequenceNumber, byte[] macSecret) {
        if (this.connectionState.isTLS()) {
            return this.computeTLSMACHash(content, contentType, sequenceNumber, macSecret);
        }
        return this.computeSSLMACHash(content, contentType, sequenceNumber, macSecret);
    }

    private byte[] computeTLSMACHash(byte[] content, byte contentType, int sequenceNumber, byte[] macSecret) {
        HashingAlgorithm hashAlg = this.connectionState.getHashingAlgorithm();
        if (hashAlg == null || hashAlg.getHashSize() == 0) {
            return new byte[0];
        }
        byte[] hMacData = Util.concatenate(Util.getBytes(sequenceNumber, 8), Util.getBytes(contentType, 1), this.connectionState.getSessionState().getProtocolVersion(), Util.getBytes(content.length, 2), content);
        return hashAlg.hashTLS(macSecret, hMacData);
    }

    private byte[] computeSSLMACHash(byte[] content, byte contentType, int sequenceNumber, byte[] macSecret) {
        HashingAlgorithm hashAlg = this.connectionState.getHashingAlgorithm();
        if (hashAlg == null || hashAlg.getHashSize() == 0) {
            return new byte[0];
        }
        byte[] hMacData = Util.concatenate(macSecret, hashAlg.getPad1(), Util.getBytes(sequenceNumber, 8), Util.getBytes(contentType, 1), Util.getBytes(content.length, 2), content);
        byte[] innerHash = hashAlg.hashSSL(hMacData);
        byte[] outerData = Util.concatenate(macSecret, hashAlg.getPad2(), innerHash);
        return hashAlg.hashSSL(outerData);
    }

    public byte[] decipher(byte contentType, boolean useClientMode, byte[] encryptedData) throws IOException {
        byte[] operationMACSecret;
        byte[] operationIV;
        Key operationKey;
        this.initializeKeys();
        if (useClientMode) {
            operationKey = this.serverKey;
            operationIV = this.connectionState.serverWriteIV;
            operationMACSecret = this.connectionState.serverWriteMACSecret;
        } else {
            operationKey = this.clientKey;
            operationIV = this.connectionState.clientWriteIV;
            operationMACSecret = this.connectionState.clientWriteMACSecret;
        }
        operationKey.cryptInit(2, this.connectionState.getPadType(), operationIV);
        operationKey.cryptUpdate(encryptedData, 0, encryptedData.length);
        byte[] unencrypted = operationKey.cryptFinish();
        byte[] hash = new byte[this.connectionState.getHashingAlgorithm().getHashSize()];
        System.arraycopy((Object)unencrypted, unencrypted.length - hash.length, (Object)hash, 0, hash.length);
        byte[] data = new byte[unencrypted.length - hash.length];
        System.arraycopy((Object)unencrypted, 0, (Object)data, 0, data.length);
        byte[] hashPrime = this.computeMACHash(data, contentType, this.connectionState.receiveSequenceNumber, operationMACSecret);
        if (!Util.equals(hash, hashPrime)) {
            throw new IOException(Msg.getString("K01d3"));
        }
        System.arraycopy((Object)encryptedData, encryptedData.length - operationIV.length, (Object)operationIV, 0, operationIV.length);
        ++this.connectionState.receiveSequenceNumber;
        return data;
    }

    public byte[] encipher(byte contentType, boolean useClientMode, byte[] plainText) throws IOException {
        byte[] operationIV;
        Key operationKey;
        byte[] operationMACSecret;
        this.initializeKeys();
        if (useClientMode) {
            operationMACSecret = this.connectionState.clientWriteMACSecret;
            operationKey = this.clientKey;
            operationIV = this.connectionState.clientWriteIV;
        } else {
            operationMACSecret = this.connectionState.serverWriteMACSecret;
            operationKey = this.serverKey;
            operationIV = this.connectionState.serverWriteIV;
        }
        byte[] hash = this.computeMACHash(plainText, contentType, this.connectionState.transmitSequenceNumber, operationMACSecret);
        ++this.connectionState.transmitSequenceNumber;
        byte[] unencrypted = Util.concatenate(plainText, hash);
        operationKey.cryptInit(1, this.connectionState.getPadType(), operationIV);
        operationKey.cryptUpdate(unencrypted, 0, unencrypted.length);
        byte[] encrypted = operationKey.cryptFinish();
        System.arraycopy((Object)encrypted, encrypted.length - operationIV.length, (Object)operationIV, 0, operationIV.length);
        return encrypted;
    }
}

