/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.j9.ssl.SessionState;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class J9SSLSessionContext {
    private Hashtable sessionTable = new Hashtable();
    private Hashtable hostTable = new Hashtable();
    private int timeOutMilliSeconds;
    private int maxCacheSize;
    private static final int NO_LIMIT = 0;
    private static final String DEFAULT_TIMEOUT_SECONDS = "86400";
    private static final String DEFAULT_CACHE_SIZE = "0";

    public J9SSLSessionContext() {
        this.initialize();
    }

    private void initialize() {
        String value = DEFAULT_TIMEOUT_SECONDS;
        value = (String)AccessController.doPrivileged(new PriviAction("javax.net.ssl.SSLSessionContext.timeout", DEFAULT_TIMEOUT_SECONDS));
        this.timeOutMilliSeconds = Integer.parseInt(value) * 1000;
        if (this.timeOutMilliSeconds < 0) {
            this.timeOutMilliSeconds = Integer.parseInt(DEFAULT_TIMEOUT_SECONDS) * 1000;
        }
        value = DEFAULT_CACHE_SIZE;
        value = (String)AccessController.doPrivileged(new PriviAction("javax.net.ssl.SSLSessionContext.cahcesize", DEFAULT_CACHE_SIZE));
        this.maxCacheSize = Integer.parseInt(value);
        if (this.maxCacheSize < 0) {
            this.maxCacheSize = Integer.parseInt(DEFAULT_CACHE_SIZE);
        }
    }

    public synchronized void addSession(SessionState state) {
        if (state.getSessionID() == null || state.getSessionID().length == 0) {
            return;
        }
        if (this.maxCacheSize != 0 && this.sessionTable.size() >= this.maxCacheSize) {
            this.purgeExpiredSessions();
            if (this.sessionTable.size() >= this.maxCacheSize) {
                return;
            }
        }
        this.sessionTable.put(new String(state.getSessionID()), state);
        this.hostTable.put(state.getHostName(), state.getSessionID());
    }

    public synchronized void removeSession(SessionState state) {
        this.sessionTable.remove(new String(state.getSessionID()));
        this.hostTable.remove(state.getHostName());
    }

    public synchronized SessionState getSession(byte[] sessionID) {
        SessionState session = (SessionState)this.sessionTable.get(new String(sessionID));
        if (session == null) {
            return session;
        }
        if (!session.isValid()) {
            this.removeSession(session);
            return null;
        }
        long expireTime = session.getCreationTime() + (long)this.timeOutMilliSeconds;
        if (System.currentTimeMillis() > expireTime) {
            this.removeSession(session);
            return null;
        }
        return session;
    }

    public synchronized SessionState getSession(String hostName) {
        byte[] sessionID = (byte[])this.hostTable.get(hostName);
        if (sessionID == null) {
            return null;
        }
        return this.getSession(sessionID);
    }

    public synchronized Enumeration getIDs() {
        Vector result = new Vector(this.sessionTable.size());
        Enumeration sessions = this.sessionTable.elements();
        while (sessions.hasMoreElements()) {
            result.addElement(((SessionState)sessions.nextElement()).getSessionID());
        }
        return result.elements();
    }

    public synchronized int getSessionCacheSize() {
        return this.maxCacheSize;
    }

    public synchronized void setSessionCacheSize(int cacheSize) {
        if (this.maxCacheSize < 0) {
            throw new IllegalArgumentException(Msg.getString("K002f"));
        }
        this.maxCacheSize = cacheSize;
    }

    public synchronized int getSessionTimeoutSeconds() {
        return this.timeOutMilliSeconds / 1000;
    }

    public synchronized void setSessionTimeoutSeconds(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException(Msg.getString("K002f"));
        }
        this.timeOutMilliSeconds = seconds * 1000;
        this.purgeExpiredSessions();
    }

    private void purgeExpiredSessions() {
        if (this.timeOutMilliSeconds == 0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Enumeration sessions = this.sessionTable.elements();
        while (sessions.hasMoreElements()) {
            SessionState session = (SessionState)sessions.nextElement();
            long timeoutTime = session.getCreationTime() + (long)this.timeOutMilliSeconds;
            if (currentTime > timeoutTime) {
                session.invalidate();
            }
            if (session.isValid()) continue;
            this.removeSession(session);
        }
    }

    public SessionState createSession(String hostName) {
        return new SessionState(hostName);
    }

    public SessionState createSession(byte[] sessionID) {
        return this.createSession(new String(sessionID));
    }
}

