/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.ssl;

import com.ibm.oti.security.provider.X509Certificate;
import javax.microedition.pki.Certificate;

public class LimitedX509Certificate
implements Certificate {
    private X509Certificate certImpl = null;

    public LimitedX509Certificate(X509Certificate cert) {
        this.certImpl = cert;
    }

    public String getIssuer() {
        return this.certImpl.getIssuerDN().getName();
    }

    public long getNotAfter() {
        return this.certImpl.getNotAfter().getTime();
    }

    public long getNotBefore() {
        return this.certImpl.getNotBefore().getTime();
    }

    public String getSerialNumber() {
        String hex = this.certImpl.getSerialNumber().toString(16).toUpperCase();
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        String result = "";
        int i = 0;
        while (i < hex.length()) {
            result = String.valueOf(result) + hex.substring(i, i + 2);
            if ((i += 2) >= hex.length()) continue;
            result = String.valueOf(result) + ":";
        }
        return result;
    }

    public String getSigAlgName() {
        return this.certImpl.getSigAlgName();
    }

    public String getSubject() {
        return this.certImpl.getSubjectDN().getName();
    }

    public String getType() {
        return "X.509";
    }

    public String getVersion() {
        return Integer.toString(this.certImpl.getVersion());
    }
}

