/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.ssl;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.ssl.CipherSpec;
import com.ibm.j9.ssl.ConnectionState;
import com.ibm.j9.ssl.HandshakeHandler;
import com.ibm.j9.ssl.HandshakeSocket;
import com.ibm.j9.ssl.J9DefaultSSLContext;
import com.ibm.j9.ssl.J9HandshakeException;
import com.ibm.j9.ssl.J9SSLContext;
import com.ibm.j9.ssl.LimitedX509Certificate;
import com.ibm.j9.ssl.Record;
import com.ibm.j9.ssl.StreamQueue;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.security.provider.X509Certificate;
import com.ibm.oti.util.Msg;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import javax.microedition.io.SecureConnection;
import javax.microedition.io.SecurityInfo;
import javax.microedition.io.StreamConnection;
import javax.microedition.pki.Certificate;

public class Connection
implements CreateConnection,
StreamConnection,
SecureConnection,
HandshakeSocket {
    com.ibm.oti.connection.socket.Connection socket = null;
    InputStream inputStream = null;
    OutputStream outputStream = null;
    private static final int UNOPENED = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    int inputStatus = 0;
    int outputStatus = 0;
    private String host;
    private int port;
    private static J9SSLContext context = new J9DefaultSSLContext();
    HandshakeHandler handshakeHandler = new HandshakeHandler(this, context);
    private static boolean rngInitialised = false;
    final StreamQueue applicationDataInputQueue = new StreamQueue();
    private SecurityInfo securityInfo = new SecurityInfo(){

        public String getCipherSuite() {
            return "TLS_" + Connection.this.handshakeHandler.getSessionState().getCipherSpec().toString();
        }

        public String getProtocolName() {
            return CipherSpec.getProtocolName(Connection.this.getConnectionState().getProtocolVersion()).substring(0, 3);
        }

        public String getProtocolVersion() {
            byte[] bytes = Connection.this.getConnectionState().getProtocolVersion();
            return String.valueOf(String.valueOf(bytes[0])) + "." + String.valueOf(bytes[1]);
        }

        public Certificate getServerCertificate() {
            return new LimitedX509Certificate(Connection.this.getCertificate());
        }
    };

    public Connection() {
    }

    public Connection(com.ibm.oti.connection.socket.Connection socket, String host) throws IOException {
        this.host = host;
        this.socket = socket;
        this.connect();
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public InputStream openInputStream() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.getAddress(), this.getPort());
        }
        if (this.inputStatus == 2) {
            throw new IOException(Msg.getString("K0059"));
        }
        this.inputStatus = 1;
        return new SSLInputStream(this.applicationDataInputQueue);
    }

    public OutputStream openOutputStream() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.getAddress(), this.getPort());
        }
        if (this.outputStatus == 2) {
            throw new IOException(Msg.getString("K0059"));
        }
        this.outputStatus = 1;
        return new SSLOutputStream();
    }

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
        String hostPart = null;
        if (!spec.startsWith("//")) {
            throw new IllegalArgumentException();
        }
        int index = (spec = spec.substring(2)).indexOf(47);
        hostPart = index == -1 ? spec : spec.substring(0, index);
        index = hostPart.indexOf(58);
        if (index != -1) {
            this.host = hostPart.substring(0, index);
            String portString = hostPart.substring(index + 1);
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Msg.getString("K00b1"));
            }
            if (this.port < 0 || this.port > 65535) {
                throw new IllegalArgumentException(Msg.getString("K0325", this.port));
            }
        } else {
            throw new IllegalArgumentException(Msg.getString("K03a1"));
        }
        String socketSpec = "//" + this.host + ":" + this.port;
        this.socket = new com.ibm.oti.connection.socket.Connection();
        this.socket.setParameters2(socketSpec, 3, timeout);
        this.connect();
        return this;
    }

    public void close() throws IOException {
        this.closeConnection();
    }

    void closeConnection() throws IOException {
        this.inputStatus = 2;
        if (this.outputStatus != 2) {
            this.sendAlert((byte)1, (byte)0);
            this.outputStatus = 2;
        }
        if (this.socket != null) {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            this.socket.close();
            this.socket = null;
        }
    }

    private void connect() throws IOException {
        if (this.socket == null) {
            throw new IOException();
        }
        this.inputStream = this.socket.openInputStream();
        this.outputStream = this.socket.openOutputStream();
        if (!rngInitialised) {
            CL3.rng(null, new byte[1], 0, 1);
            rngInitialised = true;
        }
        try {
            this.handshakeHandler.run();
        }
        catch (J9HandshakeException e) {
            throw new javax.microedition.pki.CertificateException(e.getMessage(), null, 14);
        }
        catch (IOException e) {
            this.closeSocketStreams();
            throw e;
        }
    }

    ConnectionState getConnectionState() {
        return this.handshakeHandler.getConnectionState();
    }

    public String getServerCertSubject() {
        if (!this.getConnectionState().hasPeerCertificates()) {
            return null;
        }
        try {
            X509Certificate cert = X509Certificate.certificateFromASN1Object(this.handshakeHandler.getSessionState().getPeerCertificates()[0].getEncoded());
            return cert.getSubjectDN().getName();
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public X509Certificate getCertificate() {
        X509Certificate result;
        if (!this.getConnectionState().hasPeerCertificates()) {
            return null;
        }
        try {
            result = X509Certificate.certificateFromASN1Object(this.handshakeHandler.getSessionState().getPeerCertificates()[0].getEncoded());
        }
        catch (CertificateException certificateException) {
            return null;
        }
        return result;
    }

    public SecurityInfo getSecurityInfo() throws IOException {
        if (this.inputStatus == 2 && this.outputStatus == 2) {
            throw new IOException();
        }
        return this.securityInfo;
    }

    private void writeRecord(byte[] data, byte contentType) throws IOException {
        byte[] cipherData = this.getConnectionState().encipher(contentType, true, data);
        Record record = new Record(contentType, this.getConnectionState().getProtocolVersion(), cipherData);
        record.writeRecord(this.outputStream);
        if (contentType == 20) {
            this.handshakeHandler.processChangeCipherSpec(false);
        }
    }

    protected Record readRecord() throws IOException {
        if (this.inputStream == null) {
            return null;
        }
        Record record = Record.readRecord(this.inputStream);
        if (record == null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
            this.inputStream = null;
        }
        return record;
    }

    public void writeData(byte[] data, int offset, int length, byte contentType) throws IOException {
        if (contentType == 23 && !this.handshakeHandler.isHandShakeCompleted()) {
            this.handshakeHandler.run();
        }
        int i = 0;
        while (i < length) {
            byte[] writedata = new byte[length - i < 16384 ? length - i : 16384];
            System.arraycopy((Object)data, offset + i, (Object)writedata, 0, writedata.length);
            this.writeRecord(writedata, contentType);
            i += 16384;
        }
    }

    public boolean readData() throws IOException {
        Record record = this.readRecord();
        if (record == null) {
            return false;
        }
        byte[] recordData = this.getConnectionState().decipher(record.getContentType(), true, record.getData());
        switch (record.getContentType()) {
            case 23: {
                this.applicationDataInputQueue.getWriteStream().write(recordData);
                break;
            }
            case 20: {
                this.handshakeHandler.processChangeCipherSpec(true);
                break;
            }
            case 21: {
                this.handleAlert(recordData);
                break;
            }
            case 22: {
                this.handshakeHandler.notifyReceived(recordData);
            }
        }
        return true;
    }

    void sendAlert(byte level, byte description) throws IOException {
        byte[] data = new byte[]{level, description};
        this.writeRecord(data, (byte)21);
    }

    public void sendSocketAlert(byte level, byte description) {
        if (this.getConnectionState() == null) {
            return;
        }
        try {
            this.sendAlert(level, description);
        }
        catch (IOException iOException) {}
    }

    public String getHostName() {
        return this.host;
    }

    private void handleAlert(byte[] message) throws IOException {
        if (message[0] == 2) {
            String msgstr = message[1] == 42 ? Msg.getString("K01d5") : (message[1] == 20 ? Msg.getString("K01d6") : (message[1] == 30 ? Msg.getString("K01d7") : (message[1] == 40 ? Msg.getString("K01d8") : (message[1] == 47 ? Msg.getString("K01d9") : (message[1] == 41 ? Msg.getString("K01da") : (message[1] == 10 ? Msg.getString("K01db") : Msg.getString("K01dc", message[1])))))));
            throw new IOException(Msg.getString("K01dd", msgstr));
        }
    }

    public String getLocalAddress() throws IOException {
        if (this.inputStatus == 2 && this.outputStatus == 2) {
            throw new IOException();
        }
        return this.socket.getLocalAddress();
    }

    private void closeSocketStreams() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public long getTimeoutLength() {
        return this.socket.getTimeout() * 2;
    }

    public String getAddress() throws IOException {
        if (this.inputStatus == 2 && this.outputStatus == 2) {
            throw new IOException();
        }
        return this.socket.getAddress();
    }

    public int getPort() throws IOException {
        if (this.inputStatus == 2 && this.outputStatus == 2) {
            throw new IOException();
        }
        return this.socket.getPort();
    }

    public int getLocalPort() throws IOException {
        if (this.inputStatus == 2 && this.outputStatus == 2) {
            throw new IOException();
        }
        return this.socket.getLocalPort();
    }

    public int getSocketOption(byte optname) throws IllegalArgumentException, IOException {
        if (this.inputStatus == 2 && this.outputStatus == 2) {
            throw new IOException();
        }
        return this.socket.getSocketOption(optname);
    }

    public void setSocketOption(byte optname, int optval) throws IllegalArgumentException, IOException {
        if (this.inputStatus == 2 && this.outputStatus == 2) {
            throw new IOException();
        }
        this.socket.setSocketOption(optname, optval);
    }

    public CipherSpec[] getEnabledCipherSpecs() {
        return CipherSpec.SUPPORTED_SPECS;
    }

    public String[] getEnabledProtocols() {
        return new String[]{"SSLv3", "TLSv1"};
    }

    public boolean getUseClientMode() {
        return true;
    }

    public void sendChangeCipherSpec() throws IOException {
        this.writeData(new byte[]{1}, 0, 1, (byte)20);
    }

    public boolean getNeedClientAuth() {
        return false;
    }

    public boolean getWantClientAuth() {
        return false;
    }

    public boolean wasResumed() {
        return this.handshakeHandler.wasResumed();
    }

    private final class SSLOutputStream
    extends OutputStream {
        SSLOutputStream() {
        }

        public void write(byte[] buffer, int offset, int count) throws IOException {
            if (Connection.this.outputStatus == 2) {
                throw new IOException(Msg.getString("K0059"));
            }
            Connection.this.writeData(buffer, offset, count, (byte)23);
        }

        public void write(byte[] buffer) throws IOException {
            if (Connection.this.outputStatus == 2) {
                throw new IOException(Msg.getString("K0059"));
            }
            Connection.this.writeData(buffer, 0, buffer.length, (byte)23);
        }

        public void write(int oneByte) throws IOException {
            if (Connection.this.outputStatus == 2) {
                throw new IOException(Msg.getString("K0059"));
            }
            this.write(new byte[]{(byte)oneByte});
        }

        public void close() throws IOException {
            if (Connection.this.outputStatus != 2) {
                Connection.this.outputStatus = 2;
                Connection.this.outputStream.close();
                if (Connection.this.inputStatus == 2) {
                    Connection.this.closeConnection();
                }
            }
        }
    }

    private final class SSLInputStream
    extends InputStream {
        SSLInputStream(StreamQueue applicationDataInputQueue) {
        }

        /*
         * Unable to fully structure code
         */
        public int available() throws IOException {
            if (Connection.this.inputStatus == 2) {
                throw new IOException(Msg.getString("K0059"));
            }
            if (Connection.this.applicationDataInputQueue.getReadStream().available() != 0 || Connection.this.inputStream != null) ** GOTO lbl7
            return -1;
lbl-1000:
            // 1 sources

            {
                Connection.this.readData();
lbl7:
                // 2 sources

                ** while (Connection.this.applicationDataInputQueue.getReadStream().available() == 0 && Connection.this.inputStream != null && Connection.this.inputStream.available() > 0)
            }
lbl8:
            // 1 sources

            return Connection.this.applicationDataInputQueue.getReadStream().available();
        }

        /*
         * Unable to fully structure code
         */
        public int read() throws IOException {
            if (Connection.this.inputStatus != 2) ** GOTO lbl5
            throw new IOException(Msg.getString("K0059"));
lbl-1000:
            // 1 sources

            {
                Connection.this.readData();
lbl5:
                // 2 sources

                ** while (Connection.this.applicationDataInputQueue.getReadStream().available() == 0 && Connection.this.inputStream != null)
            }
lbl6:
            // 1 sources

            if (Connection.this.applicationDataInputQueue.getReadStream().available() == 0 && Connection.this.inputStream == null) {
                return -1;
            }
            return Connection.this.applicationDataInputQueue.getReadStream().read();
        }

        /*
         * Unable to fully structure code
         */
        public int read(byte[] b, int offset, int length) throws IOException {
            if (Connection.this.inputStatus != 2) ** GOTO lbl5
            throw new IOException(Msg.getString("K0059"));
lbl-1000:
            // 1 sources

            {
                Connection.this.readData();
lbl5:
                // 2 sources

                ** while (Connection.this.applicationDataInputQueue.getReadStream().available() == 0 && Connection.this.inputStream != null)
            }
lbl6:
            // 2 sources

            while (Connection.this.inputStream != null && Connection.this.inputStream.available() > 0 && Connection.this.applicationDataInputQueue.getReadStream().available() < length) {
                Connection.this.readData();
            }
            if (Connection.this.inputStream == null && Connection.this.applicationDataInputQueue.getReadStream().available() == 0) {
                return -1;
            }
            return Connection.this.applicationDataInputQueue.getReadStream().read(b, offset, length);
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public void close() throws IOException {
            if (Connection.this.inputStatus != 2) {
                Connection.this.inputStatus = 2;
                if (Connection.this.inputStream != null) {
                    Connection.this.inputStream.close();
                }
                if (Connection.this.outputStatus == 2) {
                    Connection.this.closeConnection();
                }
            }
        }
    }
}

