/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.jce.support;

import java.util.StringTokenizer;

public class CipherTransformation {
    private String transformation = null;
    private String algorithm = null;
    private String mode = null;
    private String paddingScheme = null;
    private boolean algorithmOnly = false;
    private boolean mustSetMode = false;
    private boolean mustSetPadding = false;

    public boolean mustSetMode() {
        return this.mustSetMode;
    }

    public void setMustSetMode() {
        this.mustSetMode = true;
    }

    public boolean mustSetPadding() {
        return this.mustSetPadding;
    }

    public void setMustSetPadding() {
        this.mustSetPadding = true;
    }

    public CipherTransformation(String transformation) {
        this.transformation = transformation;
        this.parseTransformation();
    }

    public String getTransformation() {
        return this.transformation;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getMode() {
        return this.mode;
    }

    public String getPaddingScheme() {
        return this.paddingScheme;
    }

    public boolean specifiesAlgorithmOnly() {
        return this.algorithmOnly;
    }

    private void parseTransformation() {
        StringTokenizer st = new StringTokenizer(this.transformation, "/");
        int elementCount = st.countTokens();
        if (elementCount == 1) {
            this.algorithmOnly = true;
            this.algorithm = this.transformation;
            return;
        }
        if (elementCount == 3) {
            this.algorithm = st.nextToken();
            this.mode = st.nextToken();
            this.paddingScheme = st.nextToken();
            return;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return this.transformation;
    }
}

