/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.CertPathX509;
import com.ibm.oti.security.provider.PKCS7;
import com.ibm.oti.security.provider.X509CRL;
import com.ibm.oti.security.provider.X509CertImpl;
import com.ibm.oti.security.provider.X509Certificate;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Exception;
import com.ibm.oti.util.BASE64Decoder;
import com.ibm.oti.util.Msg;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class CertificateFactoryX509
extends CertificateFactorySpi {
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static final String BEGIN_PKCS7 = "-----BEGIN PKCS7-----";
    private static final String END_PKCS7 = "-----END PKCS7-----";

    public Certificate engineGenerateCertificate(InputStream in) throws CertificateException {
        try {
            in = new BufferedInputStream(in);
            try {
                return this.parseDERCertificate(in);
            }
            catch (CertificateException certificateException) {
                return this.parsePEMCertificate(in);
            }
        }
        catch (IOException iOException) {
            throw new CertificateException();
        }
    }

    public Collection engineGenerateCertificates(InputStream in) throws CertificateException {
        Vector certificates = new Vector();
        try {
            in = new BufferedInputStream(in);
            try {
                while (true) {
                    certificates.add(this.parseDERCertificate(in));
                }
            }
            catch (CertificateException certificateException) {
                if (certificates.size() > 0) {
                    return certificates;
                }
                try {
                    while (true) {
                        certificates.add(this.parsePEMCertificate(in));
                    }
                }
                catch (CertificateException certificateException2) {
                    if (certificates.size() > 0) {
                        return certificates;
                    }
                    PKCS7 pkcs7data = this.parsePKCS7(in);
                    if (pkcs7data != null && pkcs7data.isSignedData()) {
                        return pkcs7data.signedData().certificates();
                    }
                }
            }
        }
        catch (IOException iOException) {}
        throw new CertificateException();
    }

    public CRL engineGenerateCRL(InputStream in) throws CRLException {
        try {
            in = new BufferedInputStream(in);
            in.mark(1024);
            try {
                return X509CRL.CRLFromASN1Object(in);
            }
            catch (CRLException e) {
                in.reset();
                throw e;
            }
        }
        catch (IOException iOException) {
            throw new CRLException();
        }
    }

    public Collection engineGenerateCRLs(InputStream in) throws CRLException {
        Vector crls = new Vector();
        try {
            in = new BufferedInputStream(in);
            in.mark(1024);
            try {
                while (true) {
                    crls.add(this.engineGenerateCRL(in));
                }
            }
            catch (CRLException cRLException) {
                in.reset();
                if (crls.size() > 0) {
                    return crls;
                }
                PKCS7 pkcs7data = this.parsePKCS7(in);
                if (pkcs7data != null && pkcs7data.isSignedData()) {
                    return pkcs7data.signedData().CRLs();
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {}
        throw new CRLException();
    }

    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        if (encoding.equals("PKCS7")) {
            return this.genCertPathFromPKCS7(inStream);
        }
        if (encoding.equals("PkiPath")) {
            return this.genCertPathFromPkiPath(inStream);
        }
        throw new CertificateException(Msg.getString("K0300"));
    }

    private CertPath genCertPathFromPkiPath(InputStream inStream) throws CertificateEncodingException, CertificateException {
        ASN1Decoder dec = new ASN1Decoder(inStream);
        dec.collectBytes(true);
        dec.configureTypeRedirection(3, X509CertImpl.X509_MAPPER);
        ASN1Decoder.Node node = null;
        try {
            node = dec.readContents();
        }
        catch (ASN1Exception e) {
            throw new CertificateEncodingException(e.getMessage());
        }
        if (node == null) {
            throw new CertificateEncodingException(Msg.getString("K039a"));
        }
        ASN1Decoder.Node[] certNodes = (ASN1Decoder.Node[])node.data;
        LinkedList certList = new LinkedList();
        int i = 0;
        while (i < certNodes.length) {
            X509Certificate newCert = X509Certificate.certificateFromASN1Object(certNodes[i], dec.collectedBytes());
            certList.add(newCert);
            ++i;
        }
        CertPath cp = this.engineGenerateCertPath(certList);
        return cp;
    }

    private CertPath genCertPathFromPKCS7(InputStream inStream) throws CertificateException, CertificateEncodingException {
        PKCS7 pkcs7data;
        try {
            pkcs7data = this.parsePKCS7(inStream);
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException();
        }
        if (pkcs7data != null && pkcs7data.isSignedData()) {
            return new CertPathX509(pkcs7data.signedData().certificates());
        }
        throw new CertificateEncodingException(Msg.getString("K0301"));
    }

    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        return this.engineGenerateCertPath(inStream, CertPathX509.getDefaultEncoding());
    }

    public CertPath engineGenerateCertPath(List certificates) throws CertificateException {
        int i = 0;
        while (i < certificates.size()) {
            if (!(certificates.get(i) instanceof X509Certificate)) {
                throw new CertificateException("Type not supported by CertificateFactory");
            }
            ++i;
        }
        return new CertPathX509(certificates);
    }

    public Iterator engineGetCertPathEncodings() {
        return CertPathX509.getSupportedEncodings();
    }

    private Certificate parsePEMCertificate(InputStream in) throws CertificateException, IOException {
        in.mark(1024);
        try {
            byte[] line = this.readLine(in);
            if (line == null || !CertificateFactoryX509.equals(BEGIN_CERTIFICATE, line)) {
                throw new CertificateException();
            }
            ByteArrayOutputStream certificateBase64 = new ByteArrayOutputStream();
            while (!CertificateFactoryX509.equals(END_CERTIFICATE, line = this.readLine(in))) {
                certificateBase64.write(line);
            }
            byte[] certificateBytes = null;
            try {
                certificateBytes = BASE64Decoder.decode(certificateBase64.toByteArray());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CertificateEncodingException();
            }
            return X509Certificate.certificateFromASN1Object(certificateBytes);
        }
        catch (CertificateException e) {
            in.reset();
            throw e;
        }
        catch (RuntimeException e1) {
            in.reset();
            throw new CertificateException(e1.getMessage());
        }
    }

    private Certificate parseDERCertificate(InputStream in) throws CertificateException, IOException {
        in.mark(1024);
        try {
            return X509Certificate.certificateFromASN1Object(in);
        }
        catch (CertificateException e) {
            in.reset();
            throw e;
        }
        catch (RuntimeException e1) {
            in.reset();
            throw new CertificateException(e1.getMessage());
        }
    }

    private PKCS7 parsePKCS7(InputStream in) throws CertificateException, IOException {
        in.mark(1024);
        try {
            return new PKCS7(in);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            in.reset();
        }
        catch (RuntimeException runtimeException) {
            in.reset();
        }
        in.mark(1024);
        byte[] line = this.readLine(in);
        if (line == null || !CertificateFactoryX509.equals(BEGIN_PKCS7, line)) {
            throw new CertificateException();
        }
        ByteArrayOutputStream pkcs7Base64 = new ByteArrayOutputStream();
        while (!CertificateFactoryX509.equals(END_PKCS7, line = this.readLine(in))) {
            pkcs7Base64.write(line);
        }
        byte[] pkcs7Bytes = BASE64Decoder.decode(pkcs7Base64.toByteArray());
        try {
            return new PKCS7(pkcs7Bytes);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            in.reset();
            throw new CertificateException();
        }
        catch (RuntimeException e1) {
            in.reset();
            throw new CertificateException(e1.getMessage());
        }
    }

    private static boolean equals(String s, byte[] bytes) throws CertificateException {
        if (bytes == null) {
            throw new CertificateException();
        }
        if (bytes.length != s.length()) {
            return false;
        }
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] != (byte)s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private byte[] readLine(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(80);
        while (true) {
            int nextByte = in.read();
            switch (nextByte) {
                case -1: {
                    if (out.size() == 0) {
                        return null;
                    }
                    return out.toByteArray();
                }
                case 13: {
                    out.size();
                    return out.toByteArray();
                }
                case 10: {
                    out.size();
                    return out.toByteArray();
                }
            }
            out.write(nextByte);
        }
    }
}

