/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.ASN1Exception;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.util.Arrays;

public class DSAPublicKey
implements java.security.interfaces.DSAPublicKey {
    static final String ENCODING_FORMAT = "X.509";
    private DSAParams parametersDSA;
    private BigInteger y;
    private byte[] encoded;
    static final int[] OID = new int[]{1, 2, 840, 10040, 4, 1};
    static final int[] OIDalt = new int[]{1, 3, 14, 3, 2, 12};

    public BigInteger getY() {
        return this.y;
    }

    public DSAParams getParams() {
        return this.parametersDSA;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    byte[] keyToX509Encoding() throws ASN1Exception {
        Object[] algIdentifier;
        Object[] toEncode = new Object[2];
        toEncode[0] = algIdentifier = new Object[2];
        ByteArrayOutputStream yStream = new ByteArrayOutputStream();
        ASN1Encoder yEncoder = new ASN1Encoder(yStream);
        yEncoder.writeObject(this.getY());
        toEncode[1] = new ASN1Decoder.BitString(0, yStream.toByteArray());
        algIdentifier[0] = OID;
        if (this.parametersDSA != null) {
            Object[] parameters = new Object[]{this.parametersDSA.getP(), this.parametersDSA.getQ(), this.parametersDSA.getG()};
            algIdentifier[1] = parameters;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ASN1Encoder encoder = new ASN1Encoder(stream);
        encoder.writeObject(toEncode);
        return stream.toByteArray();
    }

    public ASN1Decoder.Node toASN1Node() {
        ASN1Decoder.Node[] algIdentifier;
        ASN1Decoder.Node[] encodedNodes;
        ASN1Decoder.Node sequence = new ASN1Decoder.Node();
        sequence.type = 16;
        sequence.data = encodedNodes = new ASN1Decoder.Node[2];
        ASN1Decoder.Node[] params = null;
        if (this.parametersDSA != null) {
            ASN1Decoder.Node paramSequence = new ASN1Decoder.Node();
            paramSequence.type = 16;
            paramSequence.data = params = new ASN1Decoder.Node[3];
            params[0] = new ASN1Decoder.Node();
            params[0].type = 2;
            params[0].data = this.parametersDSA.getP();
            params[1] = new ASN1Decoder.Node();
            params[1].type = 2;
            params[1].data = this.parametersDSA.getQ();
            params[2] = new ASN1Decoder.Node();
            params[2].type = 2;
            params[2].data = this.parametersDSA.getG();
        }
        encodedNodes[0] = new ASN1Decoder.Node();
        encodedNodes[0].type = 16;
        encodedNodes[0].data = algIdentifier = new ASN1Decoder.Node[2];
        algIdentifier[0] = new ASN1Decoder.Node();
        algIdentifier[0].type = 6;
        algIdentifier[0].data = OID;
        algIdentifier[1] = new ASN1Decoder.Node();
        if (params != null) {
            algIdentifier[1].type = 16;
            algIdentifier[1].data = params;
        } else {
            algIdentifier[1].type = 5;
        }
        ASN1Decoder.Node publicKey = new ASN1Decoder.Node();
        publicKey.type = 2;
        publicKey.data = this.y;
        encodedNodes[1] = new ASN1Decoder.Node();
        encodedNodes[1].type = 3;
        encodedNodes[1].data = new ASN1Decoder.BitString(0, ASN1Encoder.encodeNode(publicKey));
        return sequence;
    }

    static Object[] decodeX509(byte[] encoded) throws ASN1Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(encoded);
        ASN1Decoder decoder = new ASN1Decoder(stream);
        Object[] result = new Object[2];
        try {
            ASN1Decoder.Node[] decodedStructure = (ASN1Decoder.Node[])decoder.readContents().data;
            ASN1Decoder.Node[] algIdentifier = (ASN1Decoder.Node[])decodedStructure[0].data;
            if (!Arrays.equals(OID, (int[])algIdentifier[0].data) && !Arrays.equals(OIDalt, (int[])algIdentifier[0].data)) {
                throw new ASN1Exception();
            }
            ASN1Decoder.BitString y = (ASN1Decoder.BitString)decodedStructure[1].data;
            stream = new ByteArrayInputStream(y.data);
            decoder = new ASN1Decoder(stream);
            result[1] = (BigInteger)decoder.readContents().data;
            ASN1Decoder.Node[] params = (ASN1Decoder.Node[])algIdentifier[1].data;
            if (params != null) {
                BigInteger p = (BigInteger)params[0].data;
                BigInteger q = (BigInteger)params[1].data;
                BigInteger g = (BigInteger)params[2].data;
                result[0] = new DSAParameterSpec(p, q, g);
            }
            return result;
        }
        catch (ClassCastException classCastException) {
            throw new ASN1Exception();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ASN1Exception();
        }
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            try {
                this.encoded = this.keyToX509Encoding();
            }
            catch (ASN1Exception aSN1Exception) {}
        }
        return this.encoded;
    }

    public String getFormat() {
        return ENCODING_FORMAT;
    }

    public DSAPublicKey(DSAParams params, BigInteger y) {
        this.parametersDSA = params;
        this.y = y;
    }

    public String toString() {
        BigInteger p = this.parametersDSA.getP();
        BigInteger q = this.parametersDSA.getQ();
        BigInteger g = this.parametersDSA.getG();
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName());
        result.append("\n\t");
        result.append("Y: ");
        result.append(this.getY().toString(16));
        result.append("\n\t");
        result.append("p: ");
        result.append(p.toString(16));
        result.append("\n\t");
        result.append("q: ");
        result.append(q.toString(16));
        result.append("\n\t");
        result.append("g: ");
        result.append(g.toString(16));
        result.append("\n");
        return result.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getEncoded());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.encoded = (byte[])stream.readObject();
        Object[] result = DSAPublicKey.decodeX509(this.encoded);
        this.parametersDSA = (DSAParameterSpec)result[0];
        this.y = (BigInteger)result[1];
    }

    public DSAPublicKey(byte[] encoded) throws IllegalArgumentException {
        this.encoded = encoded;
        try {
            Object[] result = DSAPublicKey.decodeX509(encoded);
            this.parametersDSA = (DSAParameterSpec)result[0];
            this.y = (BigInteger)result[1];
        }
        catch (ASN1Exception aSN1Exception) {
            throw new IllegalArgumentException();
        }
    }
}

