/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.ASN1OID;
import com.ibm.oti.security.provider.MD5OutputStream;
import com.ibm.oti.security.provider.RSAPrivateCrtKey;
import com.ibm.oti.security.provider.RSAPrivateKey;
import com.ibm.oti.security.provider.RSAPublicKey;
import com.ibm.oti.security.provider.X509Certificate;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.SHAOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;

public class PKCS1 {
    public static final int[] OID_RSA = new int[]{1, 2, 840, 113549, 1, 1, 1};
    public static final int[] OID_SHA1 = new int[]{1, 3, 14, 3, 2, 26};
    public static final int[] OID_MD5 = new int[]{1, 2, 840, 113549, 2, 5};
    private SHAOutputStream sha = null;
    private MD5OutputStream md5 = null;
    private static final int NULL_HASH = -1;
    private static final int SHA1_HASH = 1;
    private static final int MD5_HASH = 2;
    private static final int MD2_HASH = 3;
    private int hashAlg = -1;

    public PKCS1(String digestAlgorithmName) throws IllegalArgumentException {
        this.SECU_initialiser(digestAlgorithmName);
    }

    private void SECU_initialiser(String digestAlgorithmName) throws IllegalArgumentException {
        if (digestAlgorithmName.equals("SHA1")) {
            this.sha = new SHAOutputStream();
            this.hashAlg = 1;
        } else if (digestAlgorithmName.equals("MD5")) {
            this.md5 = new MD5OutputStream();
            this.hashAlg = 2;
        } else if (digestAlgorithmName.equals("MD2")) {
            this.hashAlg = 3;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public byte[] encryptPKCS_15(RSAPublicKey publicKey, byte[] M, Random random) throws IOException {
        return this.SECU_encryptPKCS_15(publicKey, M, random);
    }

    private byte[] SECU_encryptPKCS_15(RSAPublicKey publicKey, byte[] M, Random random) throws IOException {
        int k = this.countOctets(publicKey);
        if (M.length > k - 11) {
            throw new IOException("Message too long");
        }
        byte[] PS = new byte[k - M.length - 3];
        int i = 0;
        while (i < PS.length) {
            PS[i] = (byte)random.nextInt();
            if (PS[i] == 0) continue;
            ++i;
        }
        byte[] byArray = new byte[2];
        byArray[1] = 2;
        byte[] EM = this.concatenate(byArray, PS, new byte[1], M);
        BigInteger m = this.OS2IP(EM);
        BigInteger c = this.RSAEP(publicKey, m);
        byte[] C = this.I2OSP(c, k);
        return C;
    }

    public boolean verifySSA_PKCS1_v15(RSAPublicKey K, InputStream msgStream, byte[] S) throws IOException {
        return this.verifySSA_PKCS1_v15Impl(K, this.digest(msgStream), S);
    }

    public boolean verifySSA_PKCS1_v15(RSAPublicKey K, byte[] M, byte[] S) {
        return this.verifySSA_PKCS1_v15Impl(K, this.digest(M), S);
    }

    public boolean verifySSA_PKCS1_v15Impl(RSAPublicKey K, byte[] H, byte[] S) {
        int k = this.countOctets(K);
        if (S.length != k) {
            return false;
        }
        BigInteger s = this.OS2IP(S);
        try {
            BigInteger m = this.RSAEP(K, s);
            byte[] EMprime = this.I2OSP(m, k);
            byte[] EM = this.EMSA_PKCS1_v15_ENCODE(H, k);
            return Arrays.equals(EM, EMprime);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public byte[] signSSA_PKCS1_v15(RSAPrivateKey K, InputStream msgStream) throws IOException {
        return this.signSSA_PKCS1_v15Impl(K, this.digest(msgStream));
    }

    public byte[] signSSA_PKCS1_v15(RSAPrivateKey K, byte[] M) throws IOException {
        return this.signSSA_PKCS1_v15Impl(K, this.digest(M));
    }

    public byte[] signSSA_PKCS1_v15Impl(RSAPrivateKey K, byte[] H) throws IOException {
        int k = this.countOctets(K);
        byte[] EM = this.EMSA_PKCS1_v15_ENCODE(H, k);
        byte[] S = this.completeSignSSA_PKCS1_v15Impl(K, k, EM);
        return S;
    }

    private byte[] completeSignSSA_PKCS1_v15Impl(RSAPrivateKey K, int k, byte[] EM) throws IOException {
        BigInteger m = this.OS2IP(EM);
        BigInteger s = this.RSADP(K, m);
        byte[] S = this.I2OSP(s, k);
        return S;
    }

    public byte[] signSSA_PKCS1_v15Impl_NO_DER(RSAPrivateKey K, byte[] H) throws IOException {
        int k = this.countOctets(K);
        byte[] EM = this.form_EM(H, k);
        byte[] S = this.completeSignSSA_PKCS1_v15Impl(K, k, EM);
        return S;
    }

    public boolean verifySSA_PKCS1_v15Impl_NO_DER(java.security.interfaces.RSAPublicKey K, byte[] H, byte[] S) {
        RSAPublicKey keyImpl = new RSAPublicKey(K.getModulus(), K.getPublicExponent());
        return this.verifySSA_PKCS1_v15Impl_NO_DER(keyImpl, H, S);
    }

    public boolean verifySSA_PKCS1_v15Impl_NO_DER(RSAPublicKey K, byte[] H, byte[] S) {
        int k = this.countOctets(K);
        if (S.length != k) {
            return false;
        }
        BigInteger s = this.OS2IP(S);
        try {
            BigInteger m = this.RSAEP(K, s);
            byte[] EMprime = this.I2OSP(m, k);
            byte[] EM = this.form_EM(H, k);
            return Arrays.equals(EM, EMprime);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public BigInteger RSAEP(RSAPublicKey publicKey, BigInteger message) throws IOException {
        if (message.min(BigInteger.ZERO) == message) {
            throw new IOException("Message representative out of range");
        }
        if (publicKey.getModulus().subtract(message).min(BigInteger.ONE) != BigInteger.ONE) {
            throw new IOException("Message representative out of range");
        }
        return message.modPow(publicKey.getPublicExponent(), publicKey.getModulus());
    }

    public BigInteger RSADP(RSAPrivateKey privateKey, BigInteger c) throws IOException {
        if (c.min(BigInteger.ZERO) == c) {
            throw new IOException("Ciphertext representative out of range");
        }
        if (privateKey.getModulus().subtract(c).min(BigInteger.ONE) != BigInteger.ONE) {
            throw new IOException("Ciphertext representative out of range");
        }
        return c.modPow(privateKey.getPrivateExponent(), privateKey.getModulus());
    }

    public BigInteger RSADP(RSAPrivateCrtKey privateKey, BigInteger c) throws IOException {
        if (c.min(BigInteger.ZERO) == c) {
            throw new IOException("Ciphertext representative out of range");
        }
        if (privateKey.getModulus().subtract(c).min(BigInteger.ONE) != BigInteger.ONE) {
            throw new IOException("Ciphertext representative out of range");
        }
        BigInteger m1 = c.modPow(privateKey.getPrimeExponentP(), privateKey.getPrimeP());
        BigInteger m2 = c.modPow(privateKey.getPrimeExponentQ(), privateKey.getPrimeQ());
        BigInteger h = m1.subtract(m2).multiply(privateKey.getCrtCoefficient()).mod(privateKey.getPrimeP());
        BigInteger m = m2.add(privateKey.getPrimeQ().multiply(h));
        return m;
    }

    private byte[] EMSA_PKCS1_v15_ENCODE(byte[] H, int emLen) throws IOException {
        ASN1Decoder.Node nodeDigestAlgorithmOID = new ASN1Decoder.Node();
        nodeDigestAlgorithmOID.type = 6;
        nodeDigestAlgorithmOID.data = this.getDigestAlgorithmOID();
        ASN1Decoder.Node nodeDigestAlgorithmType = new ASN1Decoder.Node();
        nodeDigestAlgorithmType.type = 5;
        nodeDigestAlgorithmType.data = null;
        ASN1Decoder.Node nodeDigestAlgorithm = new ASN1Decoder.Node();
        nodeDigestAlgorithm.type = 16;
        nodeDigestAlgorithm.data = new ASN1Decoder.Node[]{nodeDigestAlgorithmOID, nodeDigestAlgorithmType};
        ASN1Decoder.Node nodeDigest = new ASN1Decoder.Node();
        nodeDigest.type = 4;
        nodeDigest.data = H;
        ASN1Decoder.Node nodeDigestInfo = new ASN1Decoder.Node();
        nodeDigestInfo.type = 16;
        nodeDigestInfo.data = new ASN1Decoder.Node[]{nodeDigestAlgorithm, nodeDigest};
        byte[] T = ASN1Encoder.encodeNode(nodeDigestInfo);
        return this.form_EM(T, emLen);
    }

    private byte[] form_EM(byte[] T, int emLen) throws IOException {
        if (emLen < T.length + 11) {
            throw new IOException("Intended encoded message too short");
        }
        byte[] PS = this.repeat((byte)-1, emLen - T.length - 3);
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        byte[] EM = this.concatenate(byArray, PS, new byte[1], T);
        return EM;
    }

    private byte[] I2OSP(long x, int xLen) {
        return this.I2OSP(BigInteger.valueOf(x), xLen);
    }

    public byte[] I2OSP(BigInteger x, int xLen) {
        byte[] bytes = x.toByteArray();
        if (bytes.length == xLen) {
            return bytes;
        }
        byte[] result = new byte[xLen];
        if (bytes.length < xLen) {
            System.arraycopy((Object)bytes, 0, (Object)result, xLen - bytes.length, bytes.length);
        } else {
            System.arraycopy((Object)bytes, bytes.length - xLen, (Object)result, 0, xLen);
        }
        return result;
    }

    public BigInteger OS2IP(byte[] x) {
        return new BigInteger(1, x);
    }

    private byte[] MGF1(byte[] mgfSeed, int maskLen) throws IOException {
        if (maskLen > 32768) {
            throw new IOException("Mask too long");
        }
        byte[] T = new byte[]{};
        long counterMax = (long)Math.ceil((double)maskLen / (double)this.getDigestLength()) - 1L;
        long counter = 0L;
        while (counter <= counterMax) {
            byte[] C = this.I2OSP(counter, 4);
            T = this.concatenate(T, this.digest(this.concatenate(mgfSeed, C)));
            ++counter;
        }
        byte[] mask = new byte[maskLen];
        System.arraycopy((Object)T, 0, (Object)mask, 0, maskLen);
        return mask;
    }

    private byte[] exclusiveOr(byte[] b1, byte[] b2) throws IOException {
        if (b1.length != b2.length) {
            throw new IOException("Different argument lengths");
        }
        byte[] result = new byte[b1.length];
        int i = 0;
        while (i < b1.length) {
            result[i] = (byte)(b1[i] ^ b2[i]);
            ++i;
        }
        return result;
    }

    private byte[] concatenate(byte[] b1, byte[] b2) {
        byte[] result = new byte[b1.length + b2.length];
        System.arraycopy((Object)b1, 0, (Object)result, 0, b1.length);
        System.arraycopy((Object)b2, 0, (Object)result, b1.length, b2.length);
        return result;
    }

    private byte[] concatenate(byte[] b1, byte[] b2, byte[] b3) {
        byte[] result = new byte[b1.length + b2.length + b3.length];
        int startPos = 0;
        System.arraycopy((Object)b1, 0, (Object)result, startPos, b1.length);
        System.arraycopy((Object)b2, 0, (Object)result, startPos += b1.length, b2.length);
        System.arraycopy((Object)b3, 0, (Object)result, startPos += b2.length, b3.length);
        return result;
    }

    private byte[] concatenate(byte[] b1, byte[] b2, byte[] b3, byte[] b4) {
        byte[] result = new byte[b1.length + b2.length + b3.length + b4.length];
        int startPos = 0;
        System.arraycopy((Object)b1, 0, (Object)result, startPos, b1.length);
        System.arraycopy((Object)b2, 0, (Object)result, startPos += b1.length, b2.length);
        System.arraycopy((Object)b3, 0, (Object)result, startPos += b2.length, b3.length);
        System.arraycopy((Object)b4, 0, (Object)result, startPos += b3.length, b4.length);
        return result;
    }

    private byte[] repeat(byte input, int i) {
        byte[] output = new byte[i];
        while (--i >= 0) {
            output[i] = input;
        }
        return output;
    }

    private int[] getDigestAlgorithmOID() {
        String digestAlgorithmName;
        switch (this.hashAlg) {
            case 1: {
                digestAlgorithmName = "SHA";
                break;
            }
            case 3: {
                digestAlgorithmName = "MD2";
                break;
            }
            case 2: {
                digestAlgorithmName = "MD5";
                break;
            }
            default: {
                digestAlgorithmName = "NULL";
            }
        }
        Enumeration e = X509Certificate.OID_DATABASE.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!X509Certificate.OID_DATABASE.get(key).equals(digestAlgorithmName)) continue;
            return ASN1OID.stringToIntOID(key);
        }
        return null;
    }

    private byte[] digest(byte[] input) {
        try {
            if (this.sha != null) {
                this.sha.reset();
                this.sha.write(input);
                return this.sha.getHashAsBytes();
            }
            this.md5.reset();
            this.md5.write(input);
            return this.md5.getHashAsBytes();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private byte[] digest(InputStream input) throws IOException {
        int readlen;
        if (this.sha != null) {
            this.sha.reset();
        } else {
            this.md5.reset();
        }
        byte[] buff = new byte[800];
        while ((readlen = input.read(buff)) > 0) {
            if (this.sha != null) {
                this.sha.write(buff, 0, readlen);
                continue;
            }
            this.md5.write(buff, 0, readlen);
        }
        return this.sha != null ? this.sha.getHashAsBytes() : this.md5.getHashAsBytes();
    }

    private int getDigestLength() {
        if (this.sha != null) {
            return 20;
        }
        return 16;
    }

    private int countOctets(RSAPublicKey key) {
        return this.countOctets(key.getModulus());
    }

    private int countOctets(RSAPrivateKey key) {
        return this.countOctets(key.getModulus());
    }

    private int countOctets(BigInteger modulus) {
        return (modulus.bitLength() + 7) / 8;
    }
}

