/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.oti.util.SHAOutputStream;
import java.security.SecureRandomSpi;

public class SecureRandomSHA1PRNG
extends SecureRandomSpi {
    private static final long serialVersionUID = -8317122602129140312L;
    private static final int SHA_SIZE = 20;
    private transient SHAOutputStream sha = new SHAOutputStream();
    private int count = 20;
    private byte[] state;

    protected synchronized byte[] engineGenerateSeed(int numBytes) {
        if (numBytes < 0) {
            throw new IllegalArgumentException();
        }
        byte[] result = new byte[numBytes];
        int i = 0;
        while (i < result.length) {
            result[i] = (byte)CL3.trngNextByte();
            ++i;
        }
        return result;
    }

    protected synchronized void engineNextBytes(byte[] bytes) {
        if (this.state == null) {
            this.state = this.engineGenerateSeed(20);
        }
        int toGenerate = bytes.length;
        int generated = 0;
        int size = 20 - this.count;
        while (generated < toGenerate) {
            int toCopy;
            if (this.count >= this.state.length) {
                this.digestData(this.state);
                this.count = 0;
                size = 20;
            }
            if ((toCopy = toGenerate - generated) > size) {
                toCopy = size;
            }
            System.arraycopy((Object)this.state, this.count, (Object)bytes, generated, toCopy);
            generated += toCopy;
            this.count += toCopy;
        }
    }

    protected synchronized void engineSetSeed(byte[] seedBytes) {
        if (this.state != null) {
            this.sha.write(this.state, 0, this.state.length);
        }
        this.digestData(seedBytes);
        this.count = 20;
    }

    private synchronized void digestData(byte[] data) {
        this.sha.write(data, 0, data.length);
        this.state = this.sha.getHashAsBytes();
    }
}

