/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.ASN1Exception;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.SHAOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class SignatureDSA
extends Signature {
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_SIGN = 1;
    private static final int STATE_VERIFY = 2;
    private int state = 0;
    private DSAPrivateKey privateKey;
    private DSAPublicKey publicKey;
    private SHAOutputStream sha = new SHAOutputStream();
    private static final String[] STATE_DESCRIPTION = new String[]{"UNINITIALIZED", "SIGN", "VERIFY"};

    public SignatureDSA() {
        super("SHA1withDSA");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        boolean valid = privateKey != null;
        try {
            this.privateKey = (DSAPrivateKey)privateKey;
        }
        catch (ClassCastException classCastException) {
            valid = false;
        }
        if (!valid) {
            throw new InvalidKeyException(Msg.getString("K00a5", privateKey));
        }
        this.state = 1;
        this.sha.reset();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        boolean valid = publicKey != null;
        try {
            this.publicKey = (DSAPublicKey)publicKey;
        }
        catch (ClassCastException classCastException) {
            valid = false;
        }
        if (!valid) {
            throw new InvalidKeyException(Msg.getString("K00a5", publicKey));
        }
        this.state = 2;
        this.sha.reset();
    }

    private BigInteger multiplicativeInverse(BigInteger n, BigInteger q) {
        boolean hGreaterThanZero;
        BigInteger i = q;
        BigInteger h = n;
        BigInteger v = BigInteger.ZERO;
        BigInteger d = BigInteger.ONE;
        do {
            BigInteger t = i.divide(h);
            BigInteger x = h;
            h = i.subtract(t.multiply(x));
            i = x;
            x = d;
            d = v.subtract(t.multiply(x));
            v = x;
        } while (hGreaterThanZero = h.compareTo(BigInteger.ZERO) > 0);
        return v.mod(q);
    }

    protected byte[] engineSign() throws SignatureException {
        int bitsIn_q;
        BigInteger k;
        BigInteger x = this.privateKey.getX();
        DSAParams params = this.privateKey.getParams();
        BigInteger g = params.getG();
        BigInteger p = params.getP();
        BigInteger q = params.getQ();
        byte[] digest = this.sha.getHashAsBytes();
        boolean found_k = false;
        SecureRandom random = new SecureRandom();
        while (!(found_k = (k = new BigInteger(bitsIn_q = q.bitLength(), random)).compareTo(q) < 0 && k.compareTo(BigInteger.ONE) > 0)) {
        }
        BigInteger kMultiplicativeInverse = this.multiplicativeInverse(k, q);
        BigInteger r = g.modPow(k, p).mod(q);
        BigInteger SHAM = new BigInteger(1, digest);
        BigInteger temp = SHAM.add(x.multiply(r));
        temp = temp.multiply(kMultiplicativeInverse);
        BigInteger s = temp.mod(q);
        BigInteger[] rs = new BigInteger[]{r, s};
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ASN1Encoder encoder = new ASN1Encoder(out);
        try {
            encoder.writeIntegers(rs);
        }
        catch (IOException ioe) {
            throw new Error(ioe.toString());
        }
        return out.toByteArray();
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.sha.write(b);
    }

    protected void engineUpdate(byte[] buffer, int offset, int length) throws SignatureException {
        this.sha.write(buffer, offset, length);
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger sPrime;
        BigInteger rPrime;
        ASN1Decoder.Node[] integerNodes;
        ByteArrayInputStream in = new ByteArrayInputStream(sigBytes);
        ASN1Decoder decoder = new ASN1Decoder(in);
        try {
            integerNodes = (ASN1Decoder.Node[])decoder.readContents().data;
        }
        catch (ASN1Exception e) {
            throw new SignatureException(e.toString());
        }
        if (integerNodes.length != 2) {
            throw new SignatureException();
        }
        try {
            rPrime = (BigInteger)integerNodes[0].data;
            sPrime = (BigInteger)integerNodes[1].data;
        }
        catch (ClassCastException cce) {
            throw new SignatureException(cce.toString());
        }
        BigInteger p = this.publicKey.getParams().getP();
        BigInteger q = this.publicKey.getParams().getQ();
        BigInteger g = this.publicKey.getParams().getG();
        if (rPrime.compareTo(BigInteger.ZERO) <= 0) {
            return false;
        }
        if (sPrime.compareTo(BigInteger.ZERO) <= 0) {
            return false;
        }
        if (rPrime.compareTo(q) >= 0) {
            return false;
        }
        if (sPrime.compareTo(q) >= 0) {
            return false;
        }
        BigInteger y = this.publicKey.getY();
        byte[] digest = this.sha.getHashAsBytes();
        BigInteger SHAMPrime = new BigInteger(1, digest);
        BigInteger w = sPrime.modInverse(q);
        BigInteger u1 = SHAMPrime.multiply(w).mod(q);
        BigInteger u2 = rPrime.multiply(w).mod(q);
        BigInteger v = g.modPow(u1, p).multiply(y.modPow(u2, p)).mod(p).mod(q);
        return v.compareTo(rPrime) == 0;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        result.append(" DSA Signature (");
        result.append(STATE_DESCRIPTION[this.state]);
        result.append(')');
        if (this.state == 0) {
            return result.toString();
        }
        BigInteger p = null;
        BigInteger q = null;
        BigInteger g = null;
        if (this.state == 1) {
            p = this.privateKey.getParams().getP();
            q = this.privateKey.getParams().getQ();
            g = this.privateKey.getParams().getG();
        } else if (this.state == 2) {
            p = this.publicKey.getParams().getP();
            q = this.publicKey.getParams().getQ();
            g = this.publicKey.getParams().getG();
        }
        result.append("\n\t");
        result.append("p: ");
        result.append(p.toString(16));
        result.append("\n\t");
        result.append("q: ");
        result.append(q.toString(16));
        result.append("\n\t");
        result.append("g: ");
        result.append(g.toString(16));
        result.append("\n");
        return result.toString();
    }
}

