/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.security.provider;

import com.ibm.oti.security.provider.ASN1OID;
import com.ibm.oti.security.provider.UnparsedX509PublicKey;
import com.ibm.oti.security.provider.X500Principal;
import com.ibm.oti.security.provider.X509CertImpl;
import com.ibm.oti.security.provider.X509Certificate;
import com.ibm.oti.security.provider.X509Extension;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.ASN1Exception;
import com.ibm.oti.util.Msg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class X509CertImpl {
    byte[] encoded;
    int originalOffsetIntoRawBytes;
    ASN1Decoder.Node tbsNode;
    int version;
    BigInteger serialNumber;
    X500Principal issuer;
    X500Principal subject;
    Date notBefore;
    Date notAfter;
    String sigAlgOID;
    byte[] sigAlgParams;
    byte[] rawSignature;
    String signatureName;
    String signatureProviderName;
    String subjectAlgOID;
    ASN1Decoder.Node subjectPublicKeyASN1DER;
    PublicKey subjectPublicKey;
    boolean[] subjectUniqueID;
    boolean[] issuerUniqueID;
    Hashtable extensions;
    static final String extendedKeyUsageOID = "2.5.29.37";
    static final String subjectAltNamesOID = "2.5.29.17";
    static final String issuerAltNamesOID = "2.5.29.18";
    public static final Hashtable OID_DATABASE = new Hashtable(5);
    private static final String OID_BasicConstraints = "2.5.29.19";
    private static final String OID_KeyUsage = "2.5.29.15";
    private static final String[] SUPPORTED_CRITICAL_EXTENSIONS;
    protected static final ASN1Decoder.TypeMapper X509_MAPPER;
    static final Hashtable KEYALGORITHM_OID;
    static final Hashtable SIGNALGORITHM_OID;

    static {
        OID_DATABASE.put("1.2.840.113549.1.1.2", "MD2withRSA");
        OID_DATABASE.put("1.2.840.113549.1.1.4", "MD5withRSA");
        OID_DATABASE.put("1.2.840.113549.1.1.5", "SHA1withRSA");
        OID_DATABASE.put("1.2.840.10040.4.3", "SHA1withDSA");
        OID_DATABASE.put("1.3.14.3.2.26", "SHA");
        OID_DATABASE.put("1.2.840.113549.2.5", "MD5");
        OID_DATABASE.put("1.2.840.113549.1.1.1", "RSA");
        OID_DATABASE.put("1.2.840.10040.4.1", "DSA");
        OID_DATABASE.put("1.3.14.3.2.12", "DSA");
        OID_DATABASE.put("1.2.840.10046.2.1", "DiffieHellman");
        SUPPORTED_CRITICAL_EXTENSIONS = new String[]{OID_BasicConstraints, OID_KeyUsage};
        X509_MAPPER = new ASN1Decoder.TypeMapper(){

            public int map(int originalType, int nesting, int sequenceItem) {
                switch (originalType) {
                    case 1: 
                    case 2: {
                        return 2;
                    }
                    case 0: 
                    case 3: {
                        return 16;
                    }
                }
                return originalType;
            }
        };
        KEYALGORITHM_OID = new Hashtable(7);
        KEYALGORITHM_OID.put("RSA", "1.2.840.113549.1.1.1");
        KEYALGORITHM_OID.put("DSA", "1.2.840.10040.4.1");
        KEYALGORITHM_OID.put("DiffieHellman", "1.2.840.10046.2.1");
        SIGNALGORITHM_OID = new Hashtable(7);
        SIGNALGORITHM_OID.put("MD2withRSA", "1.2.840.113549.1.1.2");
        SIGNALGORITHM_OID.put("MD5withRSA", "1.2.840.113549.1.1.4");
        SIGNALGORITHM_OID.put("SHA1withRSA", "1.2.840.113549.1.1.5");
        SIGNALGORITHM_OID.put("SHA1withDSA", "1.2.840.10040.4.3");
    }

    protected X509CertImpl() {
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() < this.notBefore.getTime()) {
            String errorMessage = Msg.getString("K0328");
            throw new CertificateNotYetValidException(errorMessage);
        }
        if (date.getTime() > this.notAfter.getTime()) {
            String errorMessage = Msg.getString("K0329");
            throw new CertificateExpiredException(errorMessage);
        }
    }

    public int getBasicConstraints() {
        if (this.extensions == null) {
            return -1;
        }
        X509Extension extn = (X509Extension)this.extensions.get(OID_BasicConstraints);
        if (extn == null) {
            return -1;
        }
        byte[] value = extn.value();
        if (value == null) {
            return -1;
        }
        ASN1Decoder decoder = new ASN1Decoder(new ByteArrayInputStream(value));
        try {
            ASN1Decoder.Node node = decoder.readContents();
            ASN1Decoder.Node firstChild = node.subnode(0);
            boolean cA = false;
            if (firstChild == null) {
                return -1;
            }
            if (firstChild.type == 1) {
                cA = (Boolean)firstChild.data;
            }
            if (!cA) {
                return -1;
            }
            ASN1Decoder.Node lastChild = node.subnode(Integer.MAX_VALUE);
            if (lastChild == null) {
                return -1;
            }
            if (lastChild.type != 2) {
                return -2;
            }
            return ((BigInteger)lastChild.data).intValue();
        }
        catch (ASN1Exception aSN1Exception) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return -1;
    }

    public Principal getIssuerDN() {
        return this.issuer;
    }

    public javax.security.auth.x500.X500Principal getIssuerX500Principal() {
        return new javax.security.auth.x500.X500Principal(this.issuer.getName());
    }

    public boolean[] getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public boolean[] getKeyUsage() {
        if (this.extensions == null) {
            return null;
        }
        X509Extension extn = (X509Extension)this.extensions.get(OID_KeyUsage);
        if (extn == null) {
            return null;
        }
        byte[] value = extn.value();
        if (value == null) {
            return null;
        }
        if (value.length < 1) {
            return null;
        }
        ASN1Decoder decoder = new ASN1Decoder(new ByteArrayInputStream(value));
        try {
            ASN1Decoder.Node bitStringNode = decoder.readContents();
            if (bitStringNode.type != 3) {
                return null;
            }
            ASN1Decoder.BitString bitString = (ASN1Decoder.BitString)bitStringNode.data;
            int bitStringLength = bitString.bitLength();
            boolean[] result = new boolean[Math.max(bitStringLength, 9)];
            int i = 0;
            while (i < bitStringLength) {
                result[i] = bitString.bitAt(i);
                ++i;
            }
            return result;
        }
        catch (ASN1Exception aSN1Exception) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return null;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public String getSigAlgName() {
        return this.signatureName;
    }

    public String getSigAlgOID() {
        return this.sigAlgOID;
    }

    public byte[] getSigAlgParams() {
        return this.sigAlgParams;
    }

    public byte[] getSignature() {
        return this.rawSignature;
    }

    public Principal getSubjectDN() {
        return this.subject;
    }

    public javax.security.auth.x500.X500Principal getSubjectX500Principal() {
        return new javax.security.auth.x500.X500Principal(this.subject.getName());
    }

    public boolean[] getSubjectUniqueID() {
        return this.subjectUniqueID;
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        byte[] result = new byte[this.tbsNode.endPosition - this.tbsNode.startPosition + 1];
        System.arraycopy((Object)this.encoded, this.tbsNode.startPosition - this.originalOffsetIntoRawBytes, (Object)result, 0, result.length);
        return result;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set critical = this.getCriticalExtensionOIDs();
        if (critical == null) {
            return false;
        }
        if (critical.size() > SUPPORTED_CRITICAL_EXTENSIONS.length) {
            return true;
        }
        int i = 0;
        while (i < SUPPORTED_CRITICAL_EXTENSIONS.length) {
            critical.remove(SUPPORTED_CRITICAL_EXTENSIONS[i]);
            ++i;
        }
        return critical.size() != 0;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        X509Extension extn = (X509Extension)this.extensions.get(oid);
        if (extn == null) {
            return null;
        }
        byte[] extnValue = extn.value();
        if (extnValue == null) {
            extnValue = new byte[]{};
        }
        ASN1Decoder.Node node = new ASN1Decoder.Node();
        node.type = 4;
        node.data = extn.value();
        return ASN1Encoder.encodeNode(node);
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] extensionBytes = this.getExtensionValue(extendedKeyUsageOID);
        ByteArrayInputStream extensionIS = new ByteArrayInputStream(extensionBytes);
        ASN1Decoder decoder = new ASN1Decoder(extensionIS);
        ASN1Decoder.Node node = null;
        try {
            node = decoder.readContents();
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CertificateParsingException();
        }
        byte[] data = (byte[])node.data;
        decoder = new ASN1Decoder(new ByteArrayInputStream(data));
        try {
            node = decoder.readContents();
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CertificateParsingException();
        }
        ArrayList result = new ArrayList();
        ASN1Decoder.Node[] OIDs = (ASN1Decoder.Node[])node.data;
        int i = 0;
        while (i < OIDs.length) {
            if (OIDs[i].type != 6) {
                throw new CertificateParsingException();
            }
            int[] oidData = (int[])OIDs[i].data;
            ASN1OID id = new ASN1OID(oidData);
            result.add(id.toString());
            ++i;
        }
        return Collections.unmodifiableList(result);
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.encoded;
    }

    public PublicKey getPublicKey() {
        return this.subjectPublicKey;
    }

    private byte[] getSubjectPublicKeyInfoAsBytes() {
        byte[] encodedSubjectPublicKeyINfo = new byte[this.subjectPublicKeyASN1DER.endPosition - this.subjectPublicKeyASN1DER.startPosition + 1];
        System.arraycopy((Object)this.encoded, this.subjectPublicKeyASN1DER.startPosition - this.originalOffsetIntoRawBytes, (Object)encodedSubjectPublicKeyINfo, 0, encodedSubjectPublicKeyINfo.length);
        return encodedSubjectPublicKeyINfo;
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.signatureProviderName != null) {
            this.verify(key, this.signatureProviderName);
        } else {
            if (this.signatureName == null) {
                throw new NoSuchAlgorithmException(this.sigAlgOID);
            }
            Signature signature = Signature.getInstance(this.signatureName);
            this.verify(key, signature);
        }
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.signatureName == null) {
            throw new NoSuchAlgorithmException(this.sigAlgOID);
        }
        Signature signature = Signature.getInstance(this.signatureName, sigProvider);
        this.verify(key, signature);
    }

    private void verify(PublicKey key, Signature signature) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        signature.initVerify(key);
        signature.update(this.getTBSCertificate());
        boolean ok = signature.verify(this.getSignature());
        if (!ok) {
            throw new SignatureException();
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("X.509 Certificate v");
        result.append(this.getVersion());
        result.append("\nSubjectDN: ");
        result.append(this.getSubjectDN());
        result.append("\n\tNot Before: ");
        result.append(this.getNotBefore());
        result.append("\n\tNot After: ");
        result.append(this.getNotAfter());
        result.append("\nIssuerDN: ");
        result.append(this.getIssuerDN());
        result.append("\nSerialNumber: ");
        result.append(this.getSerialNumber().toString(16));
        result.append("\nSigAlgName: ");
        result.append(this.getSigAlgName());
        result.append(", SigAlgOID: ");
        result.append(this.getSigAlgOID());
        return result.toString();
    }

    private void configureSignature(ASN1Decoder.Node[] asn1Certificate) {
        ASN1Decoder.Node[] signatureAlgorithm = (ASN1Decoder.Node[])asn1Certificate[1].data;
        ASN1Decoder.BitString signature = (ASN1Decoder.BitString)asn1Certificate[2].data;
        this.rawSignature = signature.data;
        this.sigAlgOID = ASN1OID.OIDToString((int[])signatureAlgorithm[0].data);
        String[] found = new String[1];
        this.signatureName = X509CertImpl.getAlias("Alg.Alias.Signature.", this.sigAlgOID, found);
        this.signatureProviderName = found[0];
        ASN1Decoder.Node algParams = null;
        if (signatureAlgorithm.length > 1) {
            algParams = signatureAlgorithm[1];
        }
        if (algParams != null && algParams.type != 5) {
            this.sigAlgParams = new byte[algParams.endPosition - algParams.startPosition + 1];
            System.arraycopy((Object)this.encoded, algParams.startPosition - this.originalOffsetIntoRawBytes, (Object)this.sigAlgParams, 0, this.sigAlgParams.length);
        }
    }

    static String getAlias(String key, String oid, String[] providerName) {
        String alias = String.valueOf(key) + oid;
        String algName = null;
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Provider provider = providers[i];
            algName = (String)provider.get(alias);
            if (algName != null) {
                if (providerName != null) {
                    providerName[0] = provider.getName();
                }
                return algName;
            }
            ++i;
        }
        return (String)X509Certificate.OID_DATABASE.get(oid);
    }

    private void configureSubjectPublicKeyInfo(ASN1Decoder.Node[] tbsCertificate, int tbsFieldOffset) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        ASN1Decoder.Node subjectPublicKeyInfo = tbsCertificate[tbsFieldOffset + 6];
        ASN1Decoder.Node[] subjectPublicKeyInfoSequence = (ASN1Decoder.Node[])subjectPublicKeyInfo.data;
        ASN1Decoder.Node subjectAlgorithm = subjectPublicKeyInfoSequence[0];
        ASN1Decoder.Node[] subjectAlgorithmSequence = (ASN1Decoder.Node[])subjectAlgorithm.data;
        this.subjectAlgOID = ASN1OID.OIDToString((int[])subjectAlgorithmSequence[0].data);
        this.subjectPublicKeyASN1DER = subjectPublicKeyInfo;
        String algName = X509CertImpl.getAlias("Alg.Alias.KeyFactory.", this.subjectAlgOID, null);
        byte[] publicKeyBytes = this.getSubjectPublicKeyInfoAsBytes();
        this.subjectPublicKey = this.createPublicKeyUsingProviders(algName, publicKeyBytes);
        if (this.subjectPublicKey != null) {
            return;
        }
        UnparsedX509PublicKey publicKey = new UnparsedX509PublicKey(publicKeyBytes);
        publicKey.algorithm = algName == null ? this.subjectAlgOID : algName;
        this.subjectPublicKey = publicKey;
    }

    protected PublicKey createPublicKeyUsingProviders(String algName, byte[] publicKeyBytes) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        KeyFactory fact = null;
        try {
            if (algName != null) {
                fact = KeyFactory.getInstance(algName);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        if (fact != null) {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
            return fact.generatePublic(keySpec);
        }
        return null;
    }

    private Set getExtensionOIDs(boolean isCritical) {
        if (this.extensions == null) {
            return null;
        }
        HashSet result = new HashSet();
        Enumeration elements = this.extensions.elements();
        while (elements.hasMoreElements()) {
            X509Extension extension = (X509Extension)elements.nextElement();
            if (extension.isCritical() != isCritical) continue;
            result.add(extension.name());
        }
        return result;
    }

    private boolean[] computeUniqueID(ASN1Decoder.Node node) {
        byte[] data = node.data instanceof ASN1Decoder.BitString ? ((ASN1Decoder.BitString)node.data).data : ((BigInteger)node.data).toByteArray();
        boolean[] result = new boolean[data.length * 8];
        int i = 0;
        while (i < data.length * 8) {
            result[i] = (data[i / 8] & 128 >> i % 8) != 0;
            ++i;
        }
        return result;
    }

    private void configureExtensions(ASN1Decoder.Node extensionsNode) {
        ASN1Decoder.Node[] allExtensions = (ASN1Decoder.Node[])extensionsNode.data;
        ASN1Decoder.Node[] actualExtensions = (ASN1Decoder.Node[])allExtensions[0].data;
        this.extensions = new Hashtable();
        int i = 0;
        while (i < actualExtensions.length) {
            ASN1Decoder.Node extension = actualExtensions[i];
            ASN1Decoder.Node[] extensionParts = (ASN1Decoder.Node[])extension.data;
            boolean isCritical = false;
            if (extensionParts.length > 2) {
                isCritical = (Boolean)extensionParts[1].data;
            }
            ASN1OID extnID = new ASN1OID((int[])extensionParts[0].data);
            byte[] extnValue = (byte[])extensionParts[extensionParts.length - 1].data;
            X509Extension extn = new X509Extension(extnID, extnValue, isCritical);
            this.extensions.put(extn.name(), extn);
            ++i;
        }
    }

    private void configureOptionalParts(ASN1Decoder.Node[] tbsCertificate, int tbsFieldOffset) {
        int index = tbsFieldOffset + 7;
        while (index < tbsCertificate.length) {
            ASN1Decoder.Node optionalNode = tbsCertificate[index];
            ++index;
            switch (optionalNode.originalType) {
                case 1: {
                    this.issuerUniqueID = this.computeUniqueID(optionalNode);
                    break;
                }
                case 2: {
                    this.subjectUniqueID = this.computeUniqueID(optionalNode);
                    break;
                }
                case 3: {
                    this.configureExtensions(optionalNode);
                }
            }
        }
    }

    public static X509CertImpl certificateFromASN1Object(byte[] certificateBytes) throws CertificateException {
        ByteArrayInputStream in = new ByteArrayInputStream(certificateBytes);
        return X509CertImpl.certificateFromASN1Object(in);
    }

    public static X509CertImpl certificateFromASN1Object(ASN1Decoder.Node node, byte[] rawBytes) throws CertificateException {
        X509CertImpl cert = new X509CertImpl();
        final class PrinFactory
        implements PrincipalFactory {
            PrinFactory() {
            }

            public X500Principal getInstance(ASN1Decoder.Node principal) {
                return new X500Principal(principal);
            }
        }
        return X509CertImpl.certificateFromASN1Object(node, rawBytes, cert, new PrinFactory());
    }

    public static X509CertImpl certificateFromASN1Object(ASN1Decoder.Node node, byte[] rawBytes, X509CertImpl cert, PrincipalFactory principalFactory) throws CertificateException {
        try {
            X500Principal subject;
            X500Principal issuer;
            int tbsFieldOffset;
            ASN1Decoder.Node[] asn1Certificate = (ASN1Decoder.Node[])node.data;
            int start = node.startPosition;
            int end = node.endPosition;
            if (start == 0 && end == rawBytes.length - 1) {
                cert.encoded = rawBytes;
            } else {
                cert.encoded = new byte[end - start + 1];
                System.arraycopy((Object)rawBytes, start, (Object)cert.encoded, 0, cert.encoded.length);
            }
            cert.originalOffsetIntoRawBytes = start;
            cert.configureSignature(asn1Certificate);
            ASN1Decoder.Node tbsNode = asn1Certificate[0];
            ASN1Decoder.Node[] tbsCertificate = (ASN1Decoder.Node[])tbsNode.data;
            cert.tbsNode = tbsNode;
            if (tbsCertificate[0].originalType == 0) {
                ASN1Decoder.Node[] explicitVersion = (ASN1Decoder.Node[])tbsCertificate[0].data;
                BigInteger first = (BigInteger)explicitVersion[0].data;
                cert.version = first.intValue() + 1;
                tbsFieldOffset = 0;
            } else {
                cert.version = 1;
                tbsFieldOffset = -1;
            }
            cert.serialNumber = (BigInteger)tbsCertificate[tbsFieldOffset + 1].data;
            ASN1Decoder.Node validityNode = tbsCertificate[tbsFieldOffset + 4];
            ASN1Decoder.Node[] validity = (ASN1Decoder.Node[])validityNode.data;
            cert.notBefore = (Date)validity[0].data;
            cert.notAfter = (Date)validity[1].data;
            cert.issuer = issuer = principalFactory.getInstance(tbsCertificate[tbsFieldOffset + 3]);
            cert.subject = subject = principalFactory.getInstance(tbsCertificate[tbsFieldOffset + 5]);
            cert.configureSubjectPublicKeyInfo(tbsCertificate, tbsFieldOffset);
            cert.configureOptionalParts(tbsCertificate, tbsFieldOffset);
            return cert;
        }
        catch (ClassCastException classCastException) {
            throw new CertificateException();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CertificateException();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CertificateException();
        }
    }

    public static X509CertImpl certificateFromASN1Object(InputStream in) throws CertificateException {
        try {
            ASN1Decoder decoder = new ASN1Decoder(in);
            decoder.configureTypeRedirection(2, X509_MAPPER);
            decoder.collectBytes(true);
            ASN1Decoder.Node node = decoder.readContents();
            if (node == null) {
                throw new CertificateException();
            }
            X509CertImpl cert = X509CertImpl.certificateFromASN1Object(node, decoder.collectedBytes());
            return cert;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CertificateException();
        }
    }

    public static X509CertImpl certificateFromData(PublicKey publicKey, String principal, Date notBefore, Date notAfter, BigInteger serialNumber) throws CertificateException {
        X509CertImpl result = X509CertImpl.certificateFromData(publicKey, principal, notBefore, notAfter);
        result.serialNumber = serialNumber;
        return result;
    }

    public static X509CertImpl certificateFromData(PublicKey publicKey, String principal, Date notBefore, Date notAfter) throws CertificateException {
        try {
            X509CertImpl cert = new X509CertImpl();
            cert.encoded = null;
            cert.subjectPublicKey = publicKey;
            cert.notBefore = notBefore;
            cert.notAfter = notAfter;
            cert.version = 1;
            cert.serialNumber = new BigInteger(String.valueOf(cert.notBefore.getTime() / 1000L));
            if (principal != null) {
                X500Principal subject;
                X500Principal issuer;
                cert.issuer = issuer = new X500Principal(principal);
                cert.subject = subject = new X500Principal(principal);
            }
            return cert;
        }
        catch (ClassCastException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public byte[] getSignedAndEncoded(String signalg, PrivateKey privateKey) throws CertificateException {
        try {
            int tbsFieldOffset = -1;
            Object[] tbsCertificate = new Object[tbsFieldOffset + 7];
            tbsCertificate[tbsFieldOffset + 1] = this.serialNumber;
            Object[] sign = new Object[2];
            String signOID = (String)SIGNALGORITHM_OID.get(signalg);
            sign[0] = ASN1OID.stringToIntOID(signOID);
            sign[1] = null;
            tbsCertificate[tbsFieldOffset + 2] = sign;
            tbsCertificate[tbsFieldOffset + 3] = new ASN1Decoder.Data(this.issuer.getEncoded());
            Object[] validity = new Object[]{new ASN1Decoder.UTCTime(this.notBefore), new ASN1Decoder.UTCTime(this.notAfter)};
            tbsCertificate[tbsFieldOffset + 4] = validity;
            tbsCertificate[tbsFieldOffset + 5] = new ASN1Decoder.Data(this.subject.getEncoded());
            tbsCertificate[tbsFieldOffset + 6] = new ASN1Decoder.Data(this.subjectPublicKey.getEncoded());
            ByteArrayOutputStream tbsOutput = new ByteArrayOutputStream();
            ASN1Encoder tbsEncoder = new ASN1Encoder(tbsOutput);
            tbsEncoder.writeObject(tbsCertificate);
            Signature signature = Signature.getInstance(signalg);
            signature.initSign(privateKey);
            signature.update(tbsOutput.toByteArray());
            Object[] signatureAlgorithm = new Object[2];
            signOID = (String)SIGNALGORITHM_OID.get(signalg);
            signatureAlgorithm[0] = ASN1OID.stringToIntOID(signOID);
            signatureAlgorithm[1] = null;
            ASN1Decoder.BitString signatureValue = new ASN1Decoder.BitString(0, signature.sign());
            Object[] asn1Certificate = new Object[]{new ASN1Decoder.Data(tbsOutput.toByteArray()), signatureAlgorithm, signatureValue};
            ByteArrayOutputStream encoderOutput = new ByteArrayOutputStream();
            ASN1Encoder encoder = new ASN1Encoder(encoderOutput);
            encoder.writeObject(asn1Certificate);
            return encoderOutput.toByteArray();
        }
        catch (ASN1Exception e) {
            throw new CertificateException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new CertificateException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException(e.getMessage());
        }
        catch (SignatureException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return this.getAlternativeNames(subjectAltNamesOID);
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return this.getAlternativeNames(issuerAltNamesOID);
    }

    private Collection getAlternativeNames(String altNameOID) throws CertificateParsingException {
        try {
            byte[] subjectAltNameBytes = this.getExtensionValue(altNameOID);
            if (subjectAltNameBytes == null) {
                return null;
            }
            ASN1Decoder decoder = new ASN1Decoder(new ByteArrayInputStream(subjectAltNameBytes));
            ASN1Decoder.Node subjectAltName = decoder.readContents();
            if (subjectAltName.type != 4) {
                throw new CertificateParsingException();
            }
            decoder = new ASN1Decoder(new ByteArrayInputStream((byte[])subjectAltName.data));
            ASN1Decoder.Node generalNamesSequence = decoder.readContents();
            if (generalNamesSequence.type != 16) {
                throw new CertificateParsingException();
            }
            LinkedList result = new LinkedList();
            ASN1Decoder.Node[] generalNames = (ASN1Decoder.Node[])generalNamesSequence.data;
            int i = 0;
            while (i < generalNames.length) {
                ByteArrayInputStream bis = new ByteArrayInputStream((byte[])subjectAltName.data, generalNames[i].startPosition, generalNames[i].endPosition);
                decoder = new ASN1Decoder(bis);
                decoder.configureTypeRedirection(0, new GeneralNamesMapper());
                ASN1Decoder.Node genNameNode = decoder.readContents();
                int type = generalNames[i].type;
                ArrayList element = new ArrayList(2);
                element.add(new Integer(type));
                switch (type) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 6: {
                        element.add(new String((String)genNameNode.data));
                        result.add(element);
                        break;
                    }
                    case 3: 
                    case 5: {
                        byte[] data = (byte[])genNameNode.data;
                        byte[] copy = new byte[data.length];
                        System.arraycopy((Object)data, 0, (Object)copy, 0, data.length);
                        element.add(copy);
                        result.add(element);
                        break;
                    }
                    case 7: {
                        byte[] addrBytes = (byte[])genNameNode.data;
                        InetAddress addr = null;
                        addr = InetAddress.getByAddress(addrBytes);
                        element.add(addr.getHostAddress());
                        result.add(element);
                        break;
                    }
                    case 8: {
                        element.add(ASN1OID.OIDToString((int[])genNameNode.data));
                        result.add(element);
                        break;
                    }
                    default: {
                        throw new CertificateParsingException(Msg.getString("K0414", type));
                    }
                }
                ++i;
            }
            return Collections.unmodifiableList(result);
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CertificateParsingException();
        }
        catch (UnknownHostException unknownHostException) {
            throw new CertificateParsingException();
        }
    }

    public void setIssuerDN(Principal principal) {
        this.issuer = new X500Principal(principal.getName());
    }

    public void setSubjectDN(Principal principal) {
        this.subject = new X500Principal(principal.getName());
    }

    public static interface PrincipalFactory {
        public X500Principal getInstance(ASN1Decoder.Node var1);
    }

    private static class GeneralNamesMapper
    implements ASN1Decoder.TypeMapper {
        public int map(int originalType, int nesting, int sequenceItem) {
            switch (originalType) {
                case 1: 
                case 2: 
                case 6: {
                    return 22;
                }
                case 4: {
                    return 19;
                }
                case 7: {
                    return 4;
                }
                case 8: {
                    return 6;
                }
            }
            return 4;
        }
    }
}

