/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream out) {
        super(out);
        this.buf = new byte[512];
    }

    public BufferedOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException(Msg.getString("K0058"));
        }
        this.buf = new byte[size];
    }

    public synchronized void flush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
        }
        this.count = 0;
        this.out.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void write(byte[] buffer, int offset, int length) throws IOException {
        if (buffer == null) throw new NullPointerException(Msg.getString("K0047"));
        if (offset < 0 || offset > buffer.length || length < 0 || length > buffer.length - offset) throw new ArrayIndexOutOfBoundsException(Msg.getString("K002f"));
        if (this.count == 0 && length >= this.buf.length) {
            this.out.write(buffer, offset, length);
            return;
        }
        int available = this.buf.length - this.count;
        if (length < available) {
            available = length;
        }
        if (available > 0) {
            System.arraycopy((Object)buffer, offset, (Object)this.buf, this.count, available);
            this.count += available;
        }
        if (this.count != this.buf.length) return;
        this.out.write(this.buf, 0, this.buf.length);
        this.count = 0;
        if (length <= available) return;
        offset += available;
        if ((available = length - available) >= this.buf.length) {
            this.out.write(buffer, offset, available);
            return;
        } else {
            System.arraycopy((Object)buffer, offset, (Object)this.buf, this.count, available);
            this.count += available;
        }
    }

    public synchronized void write(int oneByte) throws IOException {
        if (this.count == this.buf.length) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
        this.buf[this.count++] = (byte)oneByte;
    }
}

