/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.io.CharacterConverter;
import com.ibm.oti.io.NativeCharacterConverter;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;

public class OutputStreamWriter
extends Writer {
    private OutputStream out;
    CharacterConverter converter;
    private byte[] buf = new byte[8192];
    private int pos;

    public OutputStreamWriter(OutputStream out) {
        super(out);
        this.out = out;
        String encoding = (String)AccessController.doPrivileged(new PriviAction("file.encoding", "ISO8859_1"));
        this.converter = CharacterConverter.getDefaultConverter(encoding);
    }

    public OutputStreamWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        super(out);
        this.out = out;
        this.converter = CharacterConverter.getConverter(enc);
        if (this.converter == null) {
            throw new UnsupportedEncodingException(enc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                byte[] bytes = this.converter.getClosingBytes();
                if (bytes.length > 0) {
                    this.writeBytes(bytes);
                }
                this.flush();
                this.out.flush();
                this.out.close();
                this.buf = null;
                this.converter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.pos > 0) {
                    this.out.write(this.buf, 0, this.pos);
                }
            } else {
                throw new IOException(Msg.getString("K0073"));
            }
            this.out.flush();
            this.pos = 0;
        }
    }

    public String getEncoding() {
        if (this.converter == null) {
            return null;
        }
        if (this.converter instanceof NativeCharacterConverter) {
            return ((NativeCharacterConverter)this.converter).getJavaEncoding();
        }
        String name = this.converter.getClass().getName();
        int index = name.indexOf(95);
        if (index < 0) {
            return "ISO8859_1";
        }
        return name.substring(index + 1);
    }

    private boolean isOpen() {
        return this.converter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int offset, int count) throws IOException {
        if (offset >= 0 && offset <= buf.length && count >= 0 && count <= buf.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isOpen()) {
                    throw new IOException(Msg.getString("K0073"));
                }
                byte[] converted = this.converter.convert(buf, offset, count);
                this.writeBytes(converted);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private void writeBytes(byte[] converted) throws IOException {
        if (this.pos + converted.length > this.buf.length) {
            this.out.write(this.buf, 0, this.pos);
            this.out.write(converted, 0, converted.length);
            this.out.flush();
            this.pos = 0;
            return;
        }
        System.arraycopy((Object)converted, 0, (Object)this.buf, this.pos, converted.length);
        this.pos += converted.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                char[] convert = new char[]{(char)oneChar};
                byte[] converted = this.converter.convert(convert, 0, 1);
                if (this.pos + converted.length > this.buf.length) {
                    this.out.write(this.buf, 0, this.pos);
                    this.out.write(converted, 0, converted.length);
                    this.out.flush();
                    this.pos = 0;
                    return;
                }
                System.arraycopy((Object)converted, 0, (Object)this.buf, this.pos, converted.length);
                this.pos += converted.length;
            } else {
                throw new IOException(Msg.getString("K0073"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int count) throws IOException {
        if (offset >= 0 && offset <= str.length() && count >= 0 && count <= str.length() - offset) {
            Object object = this.lock;
            synchronized (object) {
                char[] convert = new char[count];
                str.getChars(offset, offset + count, convert, 0);
                this.write(convert, 0, convert.length);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }
}

