/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedWriter;
import java.io.Reader;

public class PipedReader
extends Reader {
    private Thread lastReader;
    private Thread lastWriter;
    private boolean isClosed = false;
    private char[] data = new char[1024];
    private int in = -1;
    private int out = 0;
    private static final int PIPE_SIZE = 1024;
    private boolean isConnected = false;

    public PipedReader() {
    }

    public PipedReader(PipedWriter out) throws IOException {
        this();
        this.connect(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.data != null) {
                this.data = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(PipedWriter src) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            src.connect(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void establishConnection(PipedWriter src) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.data == null) {
                throw new IOException(Msg.getString("K0078"));
            }
            if (this.isConnected) {
                throw new IOException(Msg.getString("K007a"));
            }
            this.isConnected = true;
        }
    }

    public int read() throws IOException {
        char[] carray = new char[1];
        int result = this.read(carray, 0, 1);
        return result != -1 ? carray[0] : result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] buffer, int offset, int count) throws IOException {
        if (offset >= 0 && offset <= buffer.length && count >= 0 && count <= buffer.length - offset) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isConnected && this.data != null) {
                    if (count == 0) {
                        return 0;
                    }
                    this.lastReader = Thread.currentThread();
                    try {
                        boolean first = true;
                        while (this.in == -1) {
                            if (this.isClosed) {
                                return -1;
                            }
                            if (!first && this.lastWriter != null && !this.lastWriter.isAlive()) {
                                throw new IOException(Msg.getString("K0076"));
                            }
                            first = false;
                            this.notifyAll();
                            this.lock.wait(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                    int copyLength = 0;
                    if (this.out >= this.in) {
                        copyLength = count > this.data.length - this.out ? this.data.length - this.out : count;
                        System.arraycopy((Object)this.data, this.out, (Object)buffer, offset, copyLength);
                        this.out += copyLength;
                        if (this.out == this.data.length) {
                            this.out = 0;
                        }
                        if (this.out == this.in) {
                            this.in = -1;
                            this.out = 0;
                        }
                    }
                    if (copyLength == count || this.in == -1) {
                        return copyLength;
                    }
                    int charsCopied = copyLength;
                    copyLength = this.in - this.out > count - copyLength ? count - copyLength : this.in - this.out;
                    System.arraycopy((Object)this.data, this.out, (Object)buffer, offset + charsCopied, copyLength);
                    this.out += copyLength;
                    if (this.out == this.in) {
                        this.in = -1;
                        this.out = 0;
                    }
                    return charsCopied + copyLength;
                }
                if (!this.isConnected) {
                    throw new IOException(Msg.getString("K007b"));
                }
                throw new IOException(Msg.getString("K0078"));
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isConnected) {
                if (this.data != null) {
                    return this.in != -1;
                }
                throw new IOException(Msg.getString("K0078"));
            }
            throw new IOException(Msg.getString("K007b"));
        }
    }

    void receive(char oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.data != null) {
                this.lastWriter = Thread.currentThread();
                try {
                    while (this.data != null && this.out == this.in) {
                        this.notifyAll();
                        this.wait(1000L);
                        if (this.lastReader == null || this.lastReader.isAlive()) continue;
                        throw new IOException(Msg.getString("K0076"));
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                if (this.data != null) {
                    if (this.in == -1) {
                        this.in = 0;
                    }
                    this.data[this.in++] = oneChar;
                    if (this.in == this.data.length) {
                        this.in = 0;
                    }
                    return;
                }
            }
            throw new IOException(Msg.getString("K0078"));
        }
    }

    void receive(char[] chars, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.data != null) {
                this.lastWriter = Thread.currentThread();
                while (count > 0) {
                    int length;
                    try {
                        while (this.data != null && this.out == this.in) {
                            this.notifyAll();
                            this.wait(1000L);
                            if (this.lastReader == null || this.lastReader.isAlive()) continue;
                            throw new IOException(Msg.getString("K0076"));
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                    if (this.data == null) break;
                    if (this.in == -1) {
                        this.in = 0;
                    }
                    if (this.in >= this.out) {
                        length = this.data.length - this.in;
                        if (count < length) {
                            length = count;
                        }
                        System.arraycopy((Object)chars, offset, (Object)this.data, this.in, length);
                        offset += length;
                        count -= length;
                        this.in += length;
                        if (this.in == this.data.length) {
                            this.in = 0;
                        }
                    }
                    if (count <= 0 || this.in == this.out) continue;
                    length = this.out - this.in;
                    if (count < length) {
                        length = count;
                    }
                    System.arraycopy((Object)chars, offset, (Object)this.data, this.in, length);
                    offset += length;
                    count -= length;
                    this.in += length;
                }
                if (count == 0) {
                    return;
                }
            }
            throw new IOException(Msg.getString("K0078"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done() {
        Object object = this.lock;
        synchronized (object) {
            this.isClosed = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.notifyAll();
        }
    }
}

