/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;

public class ThreadGroup {
    private String name;
    private int maxPriority = 10;
    ThreadGroup parent = null;
    int numThreads = 0;
    private Thread[] childrenThreads = new Thread[5];
    int numGroups = 0;
    private ThreadGroup[] childrenGroups = new ThreadGroup[3];
    private Object childrenGroupsLock = new ChildrenGroupsLock();
    private Object childrenThreadsLock = new ChildrenThreadsLock();
    private boolean isDaemon = false;
    private boolean isDestroyed = false;
    private int addedNotStartedThreads = 0;
    private long memorySpace;

    private ThreadGroup() {
        this.name = "system";
    }

    public ThreadGroup(String name) {
        this(Thread.currentThread().getThreadGroup(), name);
    }

    public ThreadGroup(ThreadGroup parent, String name) {
        if (Thread.currentThread() != null) {
            parent.checkAccess();
        }
        this.name = name;
        this.setParent(parent);
        if (parent != null) {
            this.setMaxPriority(parent.getMaxPriority());
            if (parent.isDaemon()) {
                this.setDaemon(true);
            }
        }
    }

    ThreadGroup(ThreadGroup parent) {
        this.name = "main";
        this.setParent(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeCount() {
        int i;
        int count = 0;
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            i = this.numThreads;
            while (--i >= 0) {
                if (!this.childrenThreads[i].isAlive()) continue;
                ++count;
            }
        }
        object = this.childrenGroupsLock;
        synchronized (object) {
            i = 0;
            while (i < this.numGroups) {
                count += this.childrenGroups[i].activeCount();
                ++i;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeGroupCount() {
        int count = 0;
        Object object = this.childrenGroupsLock;
        synchronized (object) {
            int i = 0;
            while (i < this.numGroups) {
                count += 1 + this.childrenGroups[i].activeGroupCount();
                ++i;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkNewThread(Thread thread) throws IllegalThreadStateException {
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            if (this.isDestroyed) {
                throw new IllegalThreadStateException();
            }
            ++this.addedNotStartedThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void add(Thread thread) throws IllegalThreadStateException {
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            if (!this.isDestroyed) {
                if (this.childrenThreads.length == this.numThreads) {
                    Thread[] newThreads = new Thread[this.childrenThreads.length * 2];
                    System.arraycopy((Object)this.childrenThreads, 0, (Object)newThreads, 0, this.numThreads);
                    newThreads[this.numThreads++] = thread;
                    this.childrenThreads = newThreads;
                } else {
                    this.childrenThreads[this.numThreads++] = thread;
                }
                --this.addedNotStartedThreads;
            } else {
                throw new IllegalThreadStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ThreadGroup g) throws IllegalThreadStateException {
        Object object = this.childrenGroupsLock;
        synchronized (object) {
            if (!this.isDestroyed) {
                if (this.childrenGroups.length == this.numGroups) {
                    ThreadGroup[] newGroups = new ThreadGroup[this.childrenGroups.length * 2];
                    System.arraycopy((Object)this.childrenGroups, 0, (Object)newGroups, 0, this.numGroups);
                    newGroups[this.numGroups++] = g;
                    this.childrenGroups = newGroups;
                } else {
                    this.childrenGroups[this.numGroups++] = g;
                }
            } else {
                throw new IllegalThreadStateException();
            }
        }
    }

    public final void checkAccess() {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null) {
            currentManager.checkAccess(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        this.checkAccess();
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            Object object2 = this.childrenGroupsLock;
            synchronized (object2) {
                if (this.isDestroyed) {
                    throw new IllegalThreadStateException(Msg.getString("K0056"));
                }
                if (this.numThreads > 0) {
                    throw new IllegalThreadStateException(Msg.getString("K0057"));
                }
                int toDestroy = this.numGroups;
                int i = 0;
                while (i < toDestroy) {
                    this.childrenGroups[0].destroy();
                    ++i;
                }
                if (this.parent != null) {
                    this.parent.remove(this);
                }
                this.isDestroyed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIfEmptyDaemon() {
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            if (this.isDaemon && !this.isDestroyed && this.addedNotStartedThreads == 0 && this.numThreads == 0) {
                Object object2 = this.childrenGroupsLock;
                synchronized (object2) {
                    if (this.numGroups == 0) {
                        this.destroy();
                    }
                }
            }
        }
    }

    public int enumerate(Thread[] threads) {
        return this.enumerate(threads, true);
    }

    public int enumerate(Thread[] threads, boolean recurse) {
        return this.enumerateGeneric(threads, recurse, 0, true);
    }

    public int enumerate(ThreadGroup[] groups) {
        return this.enumerate(groups, true);
    }

    public int enumerate(ThreadGroup[] groups, boolean recurse) {
        return this.enumerateGeneric(groups, recurse, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerateGeneric(Object[] enumeration, boolean recurse, int enumerationIndex, boolean enumeratingThreads) {
        Object syncLock;
        this.checkAccess();
        Object object = syncLock = enumeratingThreads ? this.childrenThreadsLock : this.childrenGroupsLock;
        synchronized (object) {
            Object[] immediateCollection = enumeratingThreads ? this.childrenThreads : this.childrenGroups;
            int i = enumeratingThreads ? this.numThreads : this.numGroups;
            while (--i >= 0) {
                if (enumeratingThreads && !((Thread)immediateCollection[i]).isAlive()) continue;
                if (enumerationIndex >= enumeration.length) {
                    return enumerationIndex;
                }
                enumeration[enumerationIndex++] = immediateCollection[i];
            }
        }
        if (recurse) {
            object = this.childrenGroupsLock;
            synchronized (object) {
                int i = 0;
                while (i < this.numGroups) {
                    if (enumerationIndex >= enumeration.length) {
                        return enumerationIndex;
                    }
                    enumerationIndex = this.childrenGroups[i].enumerateGeneric(enumeration, recurse, enumerationIndex, enumeratingThreads);
                    ++i;
                }
            }
        }
        return enumerationIndex;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        if (this.parent != null) {
            this.parent.checkAccess();
        }
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        int i;
        this.checkAccess();
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            i = 0;
            while (i < this.numThreads) {
                this.childrenThreads[i].interrupt();
                ++i;
            }
        }
        object = this.childrenGroupsLock;
        synchronized (object) {
            i = 0;
            while (i < this.numGroups) {
                this.childrenGroups[i].interrupt();
                ++i;
            }
        }
    }

    public final boolean isDaemon() {
        return this.isDaemon;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public void list() {
        System.out.println();
        this.list(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void list(int levels) {
        int i;
        int i2 = 0;
        while (i2 < levels) {
            System.out.print("    ");
            ++i2;
        }
        System.out.println(this.toString());
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            i = 0;
            while (i < this.numThreads) {
                int j = 0;
                while (j <= levels) {
                    System.out.print("    ");
                    ++j;
                }
                System.out.println(this.childrenThreads[i]);
                ++i;
            }
        }
        object = this.childrenGroupsLock;
        synchronized (object) {
            i = 0;
            while (i < this.numGroups) {
                this.childrenGroups[i].list(levels + 1);
                ++i;
            }
        }
    }

    public final boolean parentOf(ThreadGroup g) {
        while (g != null) {
            if (this == g) {
                return true;
            }
            g = g.parent;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remove(Thread thread) {
        Object object = this.childrenThreadsLock;
        synchronized (object) {
            int i = 0;
            while (i < this.numThreads) {
                if (this.childrenThreads[i] == thread) {
                    --this.numThreads;
                    System.arraycopy((Object)this.childrenThreads, i + 1, (Object)this.childrenThreads, i, this.numThreads - i);
                    this.childrenThreads[this.numThreads] = null;
                    break;
                }
                ++i;
            }
            if (this.numThreads == 0) {
                ThreadGroup threadGroup = this;
                synchronized (threadGroup) {
                    this.notifyAll();
                }
            }
        }
        this.destroyIfEmptyDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ThreadGroup g) {
        Object object = this.childrenGroupsLock;
        synchronized (object) {
            int i = 0;
            while (i < this.numGroups) {
                if (this.childrenGroups[i] == g) {
                    --this.numGroups;
                    System.arraycopy((Object)this.childrenGroups, i + 1, (Object)this.childrenGroups, i, this.numGroups - i);
                    this.childrenGroups[this.numGroups] = null;
                    break;
                }
                ++i;
            }
        }
        this.destroyIfEmptyDaemon();
    }

    public final void setDaemon(boolean isDaemon) {
        this.checkAccess();
        this.isDaemon = isDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxPriority(int newMax) {
        this.checkAccess();
        if (newMax <= this.maxPriority) {
            if (newMax < 1) {
                newMax = 1;
            }
            int parentPriority = this.parent == null ? newMax : this.parent.getMaxPriority();
            this.maxPriority = parentPriority <= newMax ? parentPriority : newMax;
            Object object = this.childrenGroupsLock;
            synchronized (object) {
                int i = 0;
                while (i < this.numGroups) {
                    this.childrenGroups[i].setMaxPriority(newMax);
                    ++i;
                }
            }
        }
    }

    private void setParent(ThreadGroup parent) {
        if (parent != null) {
            parent.add(this);
        }
        this.parent = parent;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[name=" + this.getName() + ",maxpri=" + this.getMaxPriority() + "]";
    }

    public void uncaughtException(Thread t, Throwable e) {
        if (this.parent != null) {
            this.parent.uncaughtException(t, e);
        } else if (!(e instanceof ThreadDeath)) {
            System.err.print(Msg.getString("K0319", t.getName()));
            e.printStackTrace(System.err);
        }
    }

    private static class ChildrenGroupsLock {
        ChildrenGroupsLock() {
        }
    }

    private static class ChildrenThreadsLock {
        ChildrenThreadsLock() {
        }
    }
}

