/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class JarURLConnection
extends URLConnection {
    protected URLConnection jarFileURLConnection;
    private String entryName;
    private URL fileURL;
    private String file;

    protected JarURLConnection(URL url) throws MalformedURLException {
        super(url);
        this.file = url.getFile();
        int sepIdx = this.file.lastIndexOf("!/");
        if (sepIdx < 0) {
            throw new MalformedURLException();
        }
        if (this.file.length() == sepIdx + 2) {
            return;
        }
        this.entryName = this.file.substring(sepIdx + 2, this.file.length());
    }

    public Attributes getAttributes() throws IOException {
        JarEntry jEntry = this.getJarEntry();
        return jEntry == null ? null : jEntry.getAttributes();
    }

    public Certificate[] getCertificates() throws IOException {
        JarEntry jEntry = this.getJarEntry();
        if (jEntry == null) {
            return null;
        }
        return jEntry.getCertificates();
    }

    public String getEntryName() {
        return this.entryName;
    }

    public JarEntry getJarEntry() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.getJarFile().getJarEntry(this.entryName);
    }

    public Manifest getManifest() throws IOException {
        return this.getJarFile().getManifest();
    }

    public abstract JarFile getJarFile() throws IOException;

    public URL getJarFileURL() {
        if (this.fileURL != null) {
            return this.fileURL;
        }
        try {
            this.fileURL = new URL(this.url.getFile().substring(0, this.url.getFile().lastIndexOf("!/")));
            return this.fileURL;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest m = this.getJarFile().getManifest();
        return m == null ? null : m.getMainAttributes();
    }
}

