/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.oti.util.Msg;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public final class NetworkInterface {
    private static final int CHECK_CONNECT_NO_PORT = -1;
    static final int NO_INTERFACE_INDEX = 0;
    static final int UNSET_INTERFACE_INDEX = -1;
    private String name = null;
    private String displayName = null;
    private InetAddress[] addresses = null;
    private int interfaceIndex = 0;
    private int hashCode = 0;

    private static native NetworkInterface[] getNetworkInterfacesImpl() throws SocketException;

    NetworkInterface(String name, String displayName, InetAddress[] addresses, int interfaceIndex) {
        this.name = name;
        this.displayName = displayName;
        this.addresses = addresses;
        this.interfaceIndex = interfaceIndex;
    }

    int getIndex() {
        return this.interfaceIndex;
    }

    InetAddress getFirstAddress() {
        if (this.addresses != null && this.addresses.length >= 1) {
            return this.addresses[0];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration getInetAddresses() {
        if (this.addresses == null) {
            return new Vector(0).elements();
        }
        Vector accessibleAddresses = new Vector(this.addresses.length);
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return new Vector(Arrays.asList(this.addresses)).elements();
        }
        int i = 0;
        while (i < this.addresses.length) {
            if (security != null) {
                try {
                    security.checkConnect(this.addresses[i].getHostAddress(), -1);
                    accessibleAddresses.add(this.addresses[i]);
                }
                catch (SecurityException securityException) {}
            }
            ++i;
        }
        Enumeration theAccessibleElements = accessibleAddresses.elements();
        if (theAccessibleElements.hasMoreElements()) {
            return accessibleAddresses.elements();
        }
        return new Vector(0).elements();
    }

    public String getDisplayName() {
        if (!this.displayName.equals("")) {
            return this.displayName;
        }
        return this.name;
    }

    public static NetworkInterface getByName(String interfaceName) throws SocketException {
        if (interfaceName == null) {
            throw new NullPointerException(Msg.getString("K0330"));
        }
        Enumeration interfaces = NetworkInterface.getNetworkInterfaces();
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface netif = (NetworkInterface)interfaces.nextElement();
                if (!netif.getName().equals(interfaceName)) continue;
                return netif;
            }
        }
        return null;
    }

    public static NetworkInterface getByInetAddress(InetAddress address) throws SocketException {
        if (address == null) {
            throw new NullPointerException(Msg.getString("K0331"));
        }
        Enumeration interfaces = NetworkInterface.getNetworkInterfaces();
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                Enumeration netifAddresses;
                NetworkInterface netif = (NetworkInterface)interfaces.nextElement();
                if (netif.addresses == null || netif.addresses.length == 0 || (netifAddresses = new Vector(Arrays.asList(netif.addresses)).elements()) == null) continue;
                while (netifAddresses.hasMoreElements()) {
                    if (!address.equals((InetAddress)netifAddresses.nextElement())) continue;
                    return netif;
                }
            }
        }
        return null;
    }

    public static Enumeration getNetworkInterfaces() throws SocketException {
        Object[] interfaces = NetworkInterface.getNetworkInterfacesImpl();
        if (interfaces == null) {
            return null;
        }
        return new Vector(Arrays.asList(interfaces)).elements();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NetworkInterface) {
            NetworkInterface netif = (NetworkInterface)obj;
            if (netif.getIndex() != this.interfaceIndex) {
                return false;
            }
            if (!this.name.equals("") && !netif.getName().equals(this.name)) {
                return false;
            }
            if (this.name.equals("") && !netif.getName().equals(this.displayName)) {
                return false;
            }
            Enumeration netifAddresses = netif.getInetAddresses();
            Enumeration localifAddresses = this.getInetAddresses();
            if (netifAddresses == null && localifAddresses != null) {
                return false;
            }
            if (netifAddresses == null && localifAddresses == null) {
                return true;
            }
            if (netifAddresses != null) {
                while (netifAddresses.hasMoreElements() && localifAddresses.hasMoreElements()) {
                    if (((InetAddress)localifAddresses.nextElement()).equals((InetAddress)netifAddresses.nextElement())) continue;
                    return false;
                }
                if (netifAddresses.hasMoreElements() || localifAddresses.hasMoreElements()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.name.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer stringRepresentation = new StringBuffer("[" + this.name + "][" + this.displayName + "]");
        Enumeration theAddresses = this.getInetAddresses();
        if (theAddresses != null) {
            while (theAddresses.hasMoreElements()) {
                InetAddress nextAddress = (InetAddress)theAddresses.nextElement();
                stringRepresentation.append("[" + nextAddress.toString() + "]");
            }
        }
        return stringRepresentation.toString();
    }
}

