/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

public abstract class URLStreamHandler {
    protected abstract URLConnection openConnection(URL var1) throws IOException;

    protected void parseURL(URL u, String str, int start, int end) {
        int fileEnd;
        int queryIdx;
        if (end < start) {
            return;
        }
        String parseString = "";
        if (start < end) {
            parseString = str.substring(start, end);
        }
        end -= start;
        int fileIdx = 0;
        String host = u.getHost();
        int port = u.getPort();
        String ref = u.getRef();
        String file = u.getPath();
        String query = u.getQuery();
        String authority = u.getAuthority();
        String userInfo = u.getUserInfo();
        int refIdx = parseString.indexOf(35, 0);
        if (parseString.startsWith("//")) {
            int hostIdx = 2;
            int portIdx = -1;
            port = -1;
            fileIdx = parseString.indexOf(47, hostIdx);
            if (fileIdx == -1) {
                fileIdx = end;
                file = "";
            }
            int hostEnd = fileIdx;
            if (refIdx != -1 && refIdx < fileIdx) {
                hostEnd = refIdx;
            }
            int userIdx = parseString.lastIndexOf(64, hostEnd);
            authority = parseString.substring(hostIdx, hostEnd);
            if (userIdx > -1) {
                userInfo = parseString.substring(hostIdx, userIdx);
                hostIdx = userIdx + 1;
            }
            portIdx = parseString.indexOf(58, userIdx == -1 ? hostIdx : userIdx);
            int endOfIPv6Addr = parseString.indexOf(93);
            if (endOfIPv6Addr != -1) {
                try {
                    char c;
                    portIdx = parseString.length() > endOfIPv6Addr + 1 ? ((c = parseString.charAt(endOfIPv6Addr + 1)) == ':' ? endOfIPv6Addr + 1 : -1) : -1;
                }
                catch (Exception exception) {}
            }
            if (portIdx == -1 || portIdx > fileIdx) {
                host = parseString.substring(hostIdx, hostEnd);
            } else {
                host = parseString.substring(hostIdx, portIdx);
                String portString = parseString.substring(portIdx + 1, hostEnd);
                port = portString.length() == 0 ? -1 : Integer.parseInt(portString);
            }
        }
        if (refIdx > -1) {
            ref = parseString.substring(refIdx + 1, end);
        }
        if ((queryIdx = parseString.lastIndexOf(63, fileEnd = refIdx == -1 ? end : refIdx)) > -1) {
            query = parseString.substring(queryIdx + 1, fileEnd);
            if (queryIdx == 0 && file != null) {
                file = "/";
            }
            fileEnd = queryIdx;
        } else if (refIdx != 0) {
            query = null;
        }
        boolean canonicalize = false;
        if (fileIdx > -1) {
            if (fileIdx < end && parseString.charAt(fileIdx) == '/') {
                file = parseString.substring(fileIdx, fileEnd);
            } else if (fileEnd > fileIdx) {
                if (file == null) {
                    file = "";
                } else if (file.equals("")) {
                    file = "/";
                } else if (file.startsWith("/")) {
                    canonicalize = true;
                }
                int last = file.lastIndexOf(47) + 1;
                file = last == 0 ? parseString.substring(fileIdx, fileEnd) : String.valueOf(file.substring(0, last)) + parseString.substring(fileIdx, fileEnd);
            }
        }
        if (file == null) {
            file = "";
        }
        if (host == null) {
            host = "";
        }
        if (canonicalize) {
            int dirIndex;
            while ((dirIndex = file.indexOf("/./")) >= 0) {
                file = String.valueOf(file.substring(0, dirIndex + 1)) + file.substring(dirIndex + 3);
            }
            if (file.endsWith("/.")) {
                file = file.substring(0, file.length() - 1);
            }
            while ((dirIndex = file.indexOf("/../")) >= 0) {
                file = dirIndex != 0 ? String.valueOf(file.substring(0, file.lastIndexOf(47, dirIndex - 1))) + file.substring(dirIndex + 3) : file.substring(dirIndex + 3);
            }
            if (file.endsWith("/..") && file.length() > 3) {
                file = file.substring(0, file.lastIndexOf(47, file.length() - 4) + 1);
            }
        }
        this.setURL(u, u.getProtocol(), host, port, authority, userInfo, file, query, ref);
    }

    protected void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String file, String query, String ref) {
        if (this != u.strmHandler) {
            throw new SecurityException();
        }
        u.set(protocol, host, port, authority, userInfo, file, query, ref);
    }

    protected String toExternalForm(URL url) {
        StringBuffer answer = new StringBuffer(url.getProtocol().length() + url.getFile().length() + 16);
        answer.append(url.getProtocol());
        answer.append(':');
        String authority = url.getAuthority();
        if (authority != null && authority.length() > 0) {
            answer.append("//");
            answer.append(url.getAuthority());
        }
        String file = url.getFile();
        String ref = url.getRef();
        answer.append(file);
        if (ref != null) {
            answer.append('#');
            answer.append(ref);
        }
        return answer.toString();
    }

    protected boolean equals(URL url1, URL url2) {
        String s2;
        if (!this.sameFile(url1, url2)) {
            return false;
        }
        String s1 = url1.getRef();
        if (!(s1 == (s2 = url2.getRef()) || s1 != null && s1.equals(s2))) {
            return false;
        }
        s1 = url1.getQuery();
        return s1 == (s2 = url2.getQuery()) || s1 != null && s1.equals(s2);
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected InetAddress getHostAddress(URL url) {
        try {
            String host = url.getHost();
            if (host == null || host.length() == 0) {
                return null;
            }
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    protected int hashCode(URL url) {
        return this.toExternalForm(url).hashCode();
    }

    protected boolean hostsEqual(URL url1, URL url2) {
        String host2;
        String host1 = url1.getHost();
        return host1 == (host2 = url2.getHost()) || host1 != null && host1.equalsIgnoreCase(host2);
    }

    protected boolean sameFile(URL url1, URL url2) {
        int p2;
        String s2;
        String s1 = url1.getProtocol();
        if (!(s1 == (s2 = url2.getProtocol()) || s1 != null && s1.equals(s2))) {
            return false;
        }
        s1 = url1.getFile();
        if (!(s1 == (s2 = url2.getFile()) || s1 != null && s1.equals(s2))) {
            return false;
        }
        if (!this.hostsEqual(url1, url2)) {
            return false;
        }
        int p1 = url1.getPort();
        if (p1 == -1) {
            p1 = this.getDefaultPort();
        }
        if ((p2 = url2.getPort()) == -1) {
            p2 = this.getDefaultPort();
        }
        return p1 == p2;
    }
}

