/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.io.Serializable;
import java.security.Certificate;
import java.security.IdentityScope;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Vector;

public abstract class Identity
implements Principal,
Serializable {
    private static final long serialVersionUID = 3609922007826600659L;
    String name;
    PublicKey publicKey;
    Vector certificates;
    IdentityScope scope;
    String info;

    protected Identity() {
        this.certificates = new Vector();
    }

    public Identity(String name) {
        this.name = name;
        this.certificates = new Vector();
    }

    public Identity(String name, IdentityScope scope) throws KeyManagementException {
        this(name);
        this.scope = scope;
        if (scope != null) {
            scope.addIdentity(this);
        }
    }

    public final IdentityScope getScope() {
        return this.scope;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) throws KeyManagementException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("setIdentityPublicKey");
        }
        if (this.scope != null && this.scope.getIdentity(publicKey) != null) {
            throw new KeyManagementException(Msg.getString("K0194"));
        }
        this.publicKey = publicKey;
        this.certificates = new Vector();
    }

    public final String getName() {
        return this.name;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("setIdentityInfo");
        }
        this.info = info;
    }

    public Certificate[] certificates() {
        return (Certificate[])this.certificates.toArray(new Certificate[0]);
    }

    public void addCertificate(Certificate cert) throws KeyManagementException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("addIdentityCertificate");
        }
        PublicKey certPublicKey = cert.getPublicKey();
        if (this.publicKey != null && !Arrays.equals(this.publicKey.getEncoded(), certPublicKey.getEncoded())) {
            throw new KeyManagementException(Msg.getString("K0195"));
        }
        this.publicKey = certPublicKey;
        this.certificates.add(cert);
    }

    public void removeCertificate(Certificate cert) throws KeyManagementException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("removeIdentityCertificate");
        }
        if (!this.certificates.contains(cert)) {
            throw new KeyManagementException(Msg.getString("K0196"));
        }
        this.certificates.remove(cert);
    }

    public final boolean equals(Object identity) {
        boolean sameName;
        if (this == identity) {
            return true;
        }
        if (!(identity instanceof Identity)) {
            return false;
        }
        Identity converted = (Identity)identity;
        boolean bl = this.getName() == null ? converted.getName() == null : (sameName = this.getName().equals(converted.getName()));
        if (sameName) {
            boolean sameScope;
            boolean bl2 = this.getScope() == null ? converted.getScope() == null : (sameScope = this.getScope().equals(converted.getScope()));
            if (sameScope) {
                return true;
            }
        }
        return this.identityEquals(converted);
    }

    protected boolean identityEquals(Identity identity) {
        boolean sameName;
        if (identity == null) {
            return false;
        }
        boolean bl = this.getName() == null ? identity.getName() == null : (sameName = this.getName().equals(identity.getName()));
        if (!sameName) {
            return false;
        }
        boolean sameKey = this.getPublicKey() == null ? identity.getPublicKey() == null : this.getPublicKey().equals(identity.getPublicKey());
        return sameKey;
    }

    public String toString() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess("printIdentity");
        }
        return "Name : " + this.getName() + "\nPublic key : " + this.publicKey;
    }

    public String toString(boolean detail) {
        String output = this.toString();
        if (detail) {
            StringBuffer result = new StringBuffer();
            result.append("\nGeneral information : ");
            result.append(this.getInfo());
            result.append("\nCertificates :\n");
            Certificate[] certs = this.certificates();
            int i = 0;
            while (i < certs.length) {
                result.append(certs[i].toString(false));
                ++i;
            }
            output = String.valueOf(output) + result.toString();
        }
        return output;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.name != null) {
            hashCode = this.name.hashCode();
        }
        if (this.publicKey != null) {
            hashCode ^= this.publicKey.hashCode();
        }
        if (this.scope != null) {
            hashCode ^= this.scope.hashCode();
        }
        return hashCode;
    }
}

