/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.text.Normalizer;
import java.text.CharacterIterator;
import java.text.EntryPair;
import java.text.RBCollationTables;
import java.text.RuleBasedCollator;
import java.util.Vector;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    static final int UNMAPPEDCHARVALUE = 0x7FFF0000;
    private Normalizer text = null;
    private int[] buffer = null;
    private int[] ownBuffer = new int[2];
    private int expIndex = 0;
    private StringBuffer key = new StringBuffer(5);
    private int swapOrder = 0;
    private RBCollationTables ordering;
    private RuleBasedCollator owner;

    CollationElementIterator(String sourceText, RuleBasedCollator owner) {
        this.owner = owner;
        this.ordering = owner.getTables();
        if (sourceText.length() != 0) {
            Normalizer.Mode mode = Normalizer.getMode(owner.getDecomposition());
            this.text = new Normalizer(sourceText, mode);
        }
    }

    CollationElementIterator(CharacterIterator sourceText, RuleBasedCollator owner) {
        this.owner = owner;
        this.ordering = owner.getTables();
        Normalizer.Mode mode = Normalizer.getMode(owner.getDecomposition());
        this.text = new Normalizer(sourceText, mode);
    }

    public void reset() {
        if (this.text != null) {
            this.text.reset();
            Normalizer.Mode mode = Normalizer.getMode(this.owner.getDecomposition());
            this.text.setMode(mode);
        }
        this.buffer = null;
        this.expIndex = 0;
    }

    public int next() {
        char ch;
        Normalizer.Mode ownerMode;
        if (this.text == null) {
            return -1;
        }
        Normalizer.Mode textMode = this.text.getMode();
        if (textMode != (ownerMode = Normalizer.getMode(this.owner.getDecomposition()))) {
            this.text.setMode(ownerMode);
        }
        if (this.buffer != null) {
            if (this.expIndex < this.buffer.length) {
                return this.strengthOrder(this.buffer[this.expIndex++]);
            }
            this.buffer = null;
        }
        if ((ch = this.text.next()) == '\uffff') {
            return -1;
        }
        int value = this.ordering.getUnicodeOrder(ch);
        if (value == -1) {
            this.ownBuffer[0] = 0x7FFF0000;
            this.ownBuffer[1] = ch << 16;
            this.buffer = this.ownBuffer;
        } else if (value >= 0x7F000000) {
            value = this.nextContractChar(ch);
        }
        if (value >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(value);
        }
        if (this.ordering.isSEAsianSwapping()) {
            char consonant;
            if (CollationElementIterator.isThaiPreVowel(ch)) {
                consonant = this.text.next();
                if (consonant == '\uffff') {
                    return -1;
                }
                if (CollationElementIterator.isThaiBaseConsonant(consonant)) {
                    this.buffer = this.makeReorderedBuffer(consonant, value, this.buffer, true);
                } else {
                    this.text.previous();
                }
            }
            if (CollationElementIterator.isLaoPreVowel(ch)) {
                consonant = this.text.next();
                if (consonant == '\uffff') {
                    return -1;
                }
                if (CollationElementIterator.isLaoBaseConsonant(consonant)) {
                    this.buffer = this.makeReorderedBuffer(consonant, value, this.buffer, true);
                } else {
                    this.text.previous();
                }
            }
        }
        if (this.buffer != null) {
            this.expIndex = 1;
            value = this.buffer[0];
        }
        return this.strengthOrder(value);
    }

    public int previous() {
        char ch;
        Normalizer.Mode ownerMode;
        if (this.text == null) {
            return -1;
        }
        Normalizer.Mode textMode = this.text.getMode();
        if (textMode != (ownerMode = Normalizer.getMode(this.owner.getDecomposition()))) {
            this.text.setMode(ownerMode);
        }
        if (this.buffer != null) {
            if (this.expIndex > 0) {
                return this.strengthOrder(this.buffer[--this.expIndex]);
            }
            this.buffer = null;
        }
        if ((ch = this.text.previous()) == '\uffff') {
            return -1;
        }
        int value = this.ordering.getUnicodeOrder(ch);
        if (value == -1) {
            this.ownBuffer[0] = 0x7FFF0000;
            this.ownBuffer[1] = ch << 16;
            this.buffer = this.ownBuffer;
        } else {
            if (value >= 0x7F000000) {
                value = this.prevContractChar(ch);
            }
            if (value >= 0x7E000000) {
                this.buffer = this.ordering.getExpandValueList(value);
            }
            if (this.ordering.isSEAsianSwapping()) {
                char vowel = this.text.previous();
                if (CollationElementIterator.isThaiBaseConsonant(ch)) {
                    if (CollationElementIterator.isThaiPreVowel(vowel)) {
                        this.buffer = this.makeReorderedBuffer(vowel, value, this.buffer, false);
                    } else {
                        this.text.next();
                    }
                }
                if (CollationElementIterator.isLaoBaseConsonant(ch)) {
                    vowel = this.text.previous();
                    if (CollationElementIterator.isLaoPreVowel(vowel)) {
                        this.buffer = this.makeReorderedBuffer(vowel, value, this.buffer, false);
                        this.expIndex = this.buffer.length - 1;
                        value = this.buffer[this.expIndex];
                    } else {
                        this.text.next();
                    }
                }
            }
        }
        if (this.buffer != null) {
            this.expIndex = this.buffer.length - 1;
            value = this.buffer[this.expIndex];
        }
        return this.strengthOrder(value);
    }

    public static final int primaryOrder(int order) {
        return (order &= 0xFFFF0000) >>> 16;
    }

    public static final short secondaryOrder(int order) {
        return (short)((order &= 0xFF00) >> 8);
    }

    public static final short tertiaryOrder(int order) {
        return (short)(order &= 0xFF);
    }

    final int strengthOrder(int order) {
        int s = this.owner.getStrength();
        if (s == 0) {
            order &= 0xFFFF0000;
        } else if (s == 1) {
            order &= 0xFFFFFF00;
        }
        return order;
    }

    public void setOffset(int newOffset) {
        if (this.text != null) {
            if (newOffset < this.text.getBeginIndex() || newOffset >= this.text.getEndIndex()) {
                this.text.setIndexOnly(newOffset);
            } else {
                char c = this.text.setIndex(newOffset);
                if (this.ordering.usedInContractSeq(c)) {
                    while (this.ordering.usedInContractSeq(c)) {
                        c = this.text.previous();
                    }
                    int last = this.text.getIndex();
                    while (this.text.getIndex() <= newOffset) {
                        last = this.text.getIndex();
                        this.next();
                    }
                    this.text.setIndexOnly(last);
                }
            }
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public int getOffset() {
        return this.text != null ? this.text.getIndex() : 0;
    }

    public int getMaxExpansion(int order) {
        return this.ordering.getMaxExpansion(order);
    }

    public void setText(String source) {
        this.buffer = null;
        Normalizer.Mode mode = Normalizer.getMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new Normalizer(source, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(source);
        }
    }

    public void setText(CharacterIterator source) {
        this.buffer = null;
        Normalizer.Mode mode = Normalizer.getMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new Normalizer(source, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(source);
        }
    }

    private static final boolean isThaiPreVowel(char ch) {
        return ch >= '\u0e40' && ch <= '\u0e44';
    }

    private static final boolean isThaiBaseConsonant(char ch) {
        return ch >= '\u0e01' && ch <= '\u0e2e';
    }

    private static final boolean isLaoPreVowel(char ch) {
        return ch >= '\u0ec0' && ch <= '\u0ec4';
    }

    private static final boolean isLaoBaseConsonant(char ch) {
        return ch >= '\u0e81' && ch <= '\u0eae';
    }

    private int[] makeReorderedBuffer(char colFirst, int lastValue, int[] lastExpansion, boolean forward) {
        int[] result;
        int firstValue = this.ordering.getUnicodeOrder(colFirst);
        if (firstValue >= 0x7F000000) {
            firstValue = forward ? this.nextContractChar(colFirst) : this.prevContractChar(colFirst);
        }
        int[] firstExpansion = null;
        if (firstValue >= 0x7E000000) {
            firstExpansion = this.ordering.getExpandValueList(firstValue);
        }
        if (!forward) {
            int temp1 = firstValue;
            firstValue = lastValue;
            lastValue = temp1;
            int[] temp2 = firstExpansion;
            firstExpansion = lastExpansion;
            lastExpansion = temp2;
        }
        if (firstExpansion == null && lastExpansion == null) {
            result = new int[]{firstValue, lastValue};
        } else {
            int firstLength = firstExpansion == null ? 1 : firstExpansion.length;
            int lastLength = lastExpansion == null ? 1 : lastExpansion.length;
            result = new int[firstLength + lastLength];
            if (firstExpansion == null) {
                result[0] = firstValue;
            } else {
                System.arraycopy((Object)firstExpansion, 0, (Object)result, 0, firstLength);
            }
            if (lastExpansion == null) {
                result[firstLength] = lastValue;
            } else {
                System.arraycopy((Object)lastExpansion, 0, (Object)result, firstLength, lastLength);
            }
        }
        return result;
    }

    static final boolean isIgnorable(int order) {
        return CollationElementIterator.primaryOrder(order) == 0;
    }

    private int nextContractChar(char ch) {
        Vector list = this.ordering.getContractValues(ch);
        EntryPair pair = (EntryPair)list.firstElement();
        int order = pair.value;
        pair = (EntryPair)list.lastElement();
        int maxLength = pair.entryName.length();
        Normalizer tempText = (Normalizer)this.text.clone();
        tempText.previous();
        this.key.setLength(0);
        char c = tempText.next();
        while (maxLength > 0 && c != '\uffff') {
            this.key.append(c);
            --maxLength;
            c = tempText.next();
        }
        String fragment = this.key.toString();
        maxLength = 1;
        int i = list.size() - 1;
        while (i > 0) {
            pair = (EntryPair)list.elementAt(i);
            if (pair.fwd && fragment.startsWith(pair.entryName) && pair.entryName.length() > maxLength) {
                maxLength = pair.entryName.length();
                order = pair.value;
            }
            --i;
        }
        while (maxLength > 1) {
            this.text.next();
            --maxLength;
        }
        return order;
    }

    private int prevContractChar(char ch) {
        Vector list = this.ordering.getContractValues(ch);
        EntryPair pair = (EntryPair)list.firstElement();
        int order = pair.value;
        pair = (EntryPair)list.lastElement();
        int maxLength = pair.entryName.length();
        Normalizer tempText = (Normalizer)this.text.clone();
        tempText.next();
        this.key.setLength(0);
        char c = tempText.previous();
        while (maxLength > 0 && c != '\uffff') {
            this.key.append(c);
            --maxLength;
            c = tempText.previous();
        }
        String fragment = this.key.toString();
        maxLength = 1;
        int i = list.size() - 1;
        while (i > 0) {
            pair = (EntryPair)list.elementAt(i);
            if (!pair.fwd && fragment.startsWith(pair.entryName) && pair.entryName.length() > maxLength) {
                maxLength = pair.entryName.length();
                order = pair.value;
            }
            --i;
        }
        while (maxLength > 1) {
            this.text.previous();
            --maxLength;
        }
        return order;
    }
}

