/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.locale.Locale;
import com.ibm.oti.util.ExtendedResourceBundle;
import java.io.Serializable;
import java.text.Format;
import java.util.Arrays;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5987973545549424702L;
    private String localPatternChars;
    String[] ampms;
    String[] eras;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    String[][] zoneStrings;

    public DateFormatSymbols() {
        this(java.util.Locale.getDefault());
    }

    public DateFormatSymbols(java.util.Locale locale) {
        ExtendedResourceBundle bundle = (ExtendedResourceBundle)Format.getBundle(locale);
        this.localPatternChars = (String)bundle.getObject(Locale.LOCALE_PATTERN_CHARS);
        this.ampms = (String[])bundle.getObject(Locale.AM_PM);
        this.eras = (String[])bundle.getObject(Locale.ERAS);
        this.months = (String[])bundle.getObject(Locale.MONTHS);
        this.shortMonths = (String[])bundle.getObject(Locale.SHORT_MONTHS);
        this.shortWeekdays = (String[])bundle.getObject(Locale.SHORT_WEEK_DAYS);
        this.weekdays = (String[])bundle.getObject(Locale.WEEK_DAYS);
        this.zoneStrings = (String[][])bundle.getObject(Locale.TIMEZONES);
    }

    public Object clone() {
        try {
            DateFormatSymbols symbols = (DateFormatSymbols)super.clone();
            symbols.ampms = (String[])this.ampms.clone();
            symbols.eras = (String[])this.eras.clone();
            symbols.months = (String[])this.months.clone();
            symbols.shortMonths = (String[])this.shortMonths.clone();
            symbols.shortWeekdays = (String[])this.shortWeekdays.clone();
            symbols.weekdays = (String[])this.weekdays.clone();
            symbols.zoneStrings = new String[this.zoneStrings.length][];
            int i = 0;
            while (i < this.zoneStrings.length) {
                symbols.zoneStrings[i] = (String[])this.zoneStrings[i].clone();
                ++i;
            }
            return symbols;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateFormatSymbols)) {
            return false;
        }
        DateFormatSymbols obj = (DateFormatSymbols)object;
        if (!this.localPatternChars.equals(obj.localPatternChars)) {
            return false;
        }
        if (!Arrays.equals(this.ampms, obj.ampms)) {
            return false;
        }
        if (!Arrays.equals(this.eras, obj.eras)) {
            return false;
        }
        if (!Arrays.equals(this.months, obj.months)) {
            return false;
        }
        if (!Arrays.equals(this.shortMonths, obj.shortMonths)) {
            return false;
        }
        if (!Arrays.equals(this.shortWeekdays, obj.shortWeekdays)) {
            return false;
        }
        if (!Arrays.equals(this.weekdays, obj.weekdays)) {
            return false;
        }
        if (this.zoneStrings.length != obj.zoneStrings.length) {
            return false;
        }
        int i = 0;
        while (i < this.zoneStrings.length) {
            if (this.zoneStrings[i].length != obj.zoneStrings[i].length) {
                return false;
            }
            int j = 0;
            while (j < this.zoneStrings[i].length) {
                if (this.zoneStrings[i][j] != obj.zoneStrings[i][j] && !this.zoneStrings[i][j].equals(obj.zoneStrings[i][j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public String[] getAmPmStrings() {
        return (String[])this.ampms.clone();
    }

    public String[] getEras() {
        return (String[])this.eras.clone();
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return (String[])this.months.clone();
    }

    public String[] getShortMonths() {
        return (String[])this.shortMonths.clone();
    }

    public String[] getShortWeekdays() {
        return (String[])this.shortWeekdays.clone();
    }

    public String[] getWeekdays() {
        return (String[])this.weekdays.clone();
    }

    public String[][] getZoneStrings() {
        String[][] clone = new String[this.zoneStrings.length][];
        int i = this.zoneStrings.length;
        while (--i >= 0) {
            clone[i] = (String[])this.zoneStrings[i].clone();
        }
        return clone;
    }

    public int hashCode() {
        int hashCode = this.localPatternChars.hashCode();
        int i = 0;
        while (i < this.ampms.length) {
            hashCode += this.ampms[i].hashCode();
            ++i;
        }
        i = 0;
        while (i < this.eras.length) {
            hashCode += this.eras[i].hashCode();
            ++i;
        }
        i = 0;
        while (i < this.months.length) {
            hashCode += this.months[i].hashCode();
            ++i;
        }
        i = 0;
        while (i < this.shortMonths.length) {
            hashCode += this.shortMonths[i].hashCode();
            ++i;
        }
        i = 0;
        while (i < this.shortWeekdays.length) {
            hashCode += this.shortWeekdays[i].hashCode();
            ++i;
        }
        i = 0;
        while (i < this.weekdays.length) {
            hashCode += this.weekdays[i].hashCode();
            ++i;
        }
        i = 0;
        while (i < this.zoneStrings.length) {
            int j = 0;
            while (j < this.zoneStrings[i].length) {
                hashCode += this.zoneStrings[i][j].hashCode();
                ++j;
            }
            ++i;
        }
        return hashCode;
    }

    public void setAmPmStrings(String[] data) {
        this.ampms = (String[])data.clone();
    }

    public void setEras(String[] data) {
        this.eras = (String[])data.clone();
    }

    public void setLocalPatternChars(String data) {
        this.localPatternChars = data;
    }

    public void setMonths(String[] data) {
        this.months = (String[])data.clone();
    }

    public void setShortMonths(String[] data) {
        this.shortMonths = (String[])data.clone();
    }

    public void setShortWeekdays(String[] data) {
        this.shortWeekdays = (String[])data.clone();
    }

    public void setWeekdays(String[] data) {
        this.weekdays = (String[])data.clone();
    }

    public void setZoneStrings(String[][] data) {
        this.zoneStrings = (String[][])data.clone();
    }
}

