/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.Serializable;
import java.security.AccessController;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class Format
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -299282585814624189L;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    static ResourceBundle getBundle(Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PriviAction("com.ibm.oti.locale.Locale", locale));
    }

    static ResourceBundle getCollationBundle(Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PriviAction("com.ibm.oti.locale.Collation", locale));
    }

    String convertPattern(String template, String fromChars, String toChars, boolean check) {
        if (!check && fromChars.equals(toChars)) {
            return template;
        }
        boolean quote = false;
        StringBuffer output = new StringBuffer();
        int length = template.length();
        int i = 0;
        while (i < length) {
            int index;
            char next = template.charAt(i);
            if (next == '\'') {
                boolean bl = quote = !quote;
            }
            if (!quote && (index = fromChars.indexOf(next)) != -1) {
                output.append(toChars.charAt(index));
            } else {
                if (check && !quote && (next >= 'a' && next <= 'z' || next >= 'A' && next <= 'Z')) {
                    throw new IllegalArgumentException(Msg.getString("K001c", String.valueOf(next), template));
                }
                output.append(next);
            }
            ++i;
        }
        if (quote) {
            throw new IllegalArgumentException(Msg.getString("K0019"));
        }
        return output.toString();
    }

    public final String format(Object object) {
        return this.format(object, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(Object var1, StringBuffer var2, FieldPosition var3);

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        return new AttributedString(this.format(object)).getIterator();
    }

    public Object parseObject(String string) throws ParseException {
        ParsePosition position = new ParsePosition(0);
        Object result = this.parseObject(string, position);
        if (position.getErrorIndex() != -1 || position.getIndex() == 0) {
            throw new ParseException(null, position.getErrorIndex());
        }
        return result;
    }

    public abstract Object parseObject(String var1, ParsePosition var2);

    static boolean upTo(String string, ParsePosition position, StringBuffer buffer, char stop) {
        int index = position.getIndex();
        int length = string.length();
        boolean lastQuote = false;
        boolean quote = false;
        while (index < length) {
            char ch;
            if ((ch = string.charAt(index++)) == '\'') {
                if (lastQuote) {
                    buffer.append('\'');
                }
                quote = !quote;
                lastQuote = true;
                continue;
            }
            if (ch == stop && !quote) {
                position.setIndex(index);
                return true;
            }
            lastQuote = false;
            buffer.append(ch);
        }
        position.setIndex(index);
        return false;
    }

    static boolean upToWithQuotes(String string, ParsePosition position, StringBuffer buffer, char stop, char start) {
        int index = position.getIndex();
        int length = string.length();
        int count = 1;
        boolean quote = false;
        while (index < length) {
            char ch;
            if ((ch = string.charAt(index++)) == '\'') {
                boolean bl = quote = !quote;
            }
            if (!quote) {
                if (ch == stop) {
                    --count;
                }
                if (count == 0) {
                    position.setIndex(index);
                    return true;
                }
                if (ch == start) {
                    ++count;
                }
            }
            buffer.append(ch);
        }
        throw new IllegalArgumentException(Msg.getString("K0346"));
    }

    public static class Field
    extends AttributedCharacterIterator.Attribute {
        protected Field(String fieldName) {
            super(fieldName);
        }
    }
}

