/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.oti.locale.Locale;
import com.ibm.oti.util.ExtendedResourceBundle;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Currency;

public abstract class NumberFormat
extends Format {
    private static final long serialVersionUID = -2308460125733713944L;
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private boolean groupingUsed = true;
    private boolean parseIntegerOnly = false;
    private int maximumIntegerDigits = 40;
    private int minimumIntegerDigits = 1;
    private int maximumFractionDigits = 3;
    private int minimumFractionDigits = 0;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("groupingUsed", Boolean.TYPE), new ObjectStreamField("maxFractionDigits", Byte.TYPE), new ObjectStreamField("maximumFractionDigits", Integer.TYPE), new ObjectStreamField("maximumIntegerDigits", Integer.TYPE), new ObjectStreamField("maxIntegerDigits", Byte.TYPE), new ObjectStreamField("minFractionDigits", Byte.TYPE), new ObjectStreamField("minimumFractionDigits", Integer.TYPE), new ObjectStreamField("minimumIntegerDigits", Integer.TYPE), new ObjectStreamField("minIntegerDigits", Byte.TYPE), new ObjectStreamField("parseIntegerOnly", Boolean.TYPE), new ObjectStreamField("serialVersionOnStream", Integer.TYPE)};

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberFormat)) {
            return false;
        }
        NumberFormat obj = (NumberFormat)object;
        return this.groupingUsed == obj.groupingUsed && this.parseIntegerOnly == obj.parseIntegerOnly && this.maximumFractionDigits == obj.maximumFractionDigits && this.maximumIntegerDigits == obj.maximumIntegerDigits && this.minimumFractionDigits == obj.minimumFractionDigits && this.minimumIntegerDigits == obj.minimumIntegerDigits;
    }

    public final String format(double value) {
        return this.format(value, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public final String format(long value) {
        return this.format(value, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public final StringBuffer format(Object object, StringBuffer buffer, FieldPosition field) {
        if (object instanceof Number) {
            long lv;
            double dv = ((Number)object).doubleValue();
            if (dv == (double)(lv = ((Number)object).longValue())) {
                return this.format(lv, buffer, field);
            }
            return this.format(dv, buffer, field);
        }
        throw new IllegalArgumentException();
    }

    public static java.util.Locale[] getAvailableLocales() {
        return java.util.Locale.getAvailableLocales();
    }

    public Currency getCurrency() {
        throw new UnsupportedOperationException();
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getCurrencyInstance(java.util.Locale.getDefault());
    }

    public static NumberFormat getCurrencyInstance(java.util.Locale locale) {
        return NumberFormat.getInstance(locale, Locale.CURRENCY);
    }

    public static final NumberFormat getIntegerInstance() {
        return NumberFormat.getIntegerInstance(java.util.Locale.getDefault());
    }

    public static NumberFormat getIntegerInstance(java.util.Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale, Locale.INTEGER);
        format.setParseIntegerOnly(true);
        return format;
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getNumberInstance();
    }

    public static NumberFormat getInstance(java.util.Locale locale) {
        return NumberFormat.getNumberInstance(locale);
    }

    static NumberFormat getInstance(java.util.Locale locale, Integer type) {
        return new DecimalFormat(NumberFormat.getPattern(locale, type), new DecimalFormatSymbols(locale));
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getNumberInstance(java.util.Locale.getDefault());
    }

    public static NumberFormat getNumberInstance(java.util.Locale locale) {
        return NumberFormat.getInstance(locale, Locale.NUMBER);
    }

    static String getPattern(java.util.Locale locale, Integer type) {
        ExtendedResourceBundle bundle = (ExtendedResourceBundle)NumberFormat.getBundle(locale);
        return (String)bundle.getObject(type);
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getPercentInstance(java.util.Locale.getDefault());
    }

    public static NumberFormat getPercentInstance(java.util.Locale locale) {
        return NumberFormat.getInstance(locale, Locale.PERCENT);
    }

    public int hashCode() {
        return (this.groupingUsed ? 1231 : 1237) + (this.parseIntegerOnly ? 1231 : 1237) + this.maximumFractionDigits + this.maximumIntegerDigits + this.minimumFractionDigits + this.minimumIntegerDigits;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public Number parse(String string) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Number number = this.parse(string, pos);
        if (pos.getErrorIndex() != -1 || pos.getIndex() == 0) {
            throw new ParseException(null, pos.getErrorIndex());
        }
        return number;
    }

    public abstract Number parse(String var1, ParsePosition var2);

    public final Object parseObject(String string, ParsePosition position) {
        return this.parse(string, position);
    }

    public void setCurrency(Currency currency) {
        throw new UnsupportedOperationException();
    }

    public void setGroupingUsed(boolean value) {
        this.groupingUsed = value;
    }

    public void setMaximumFractionDigits(int value) {
        int n = this.maximumFractionDigits = value < 0 ? 0 : value;
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
        }
    }

    public void setMaximumIntegerDigits(int value) {
        int n = this.maximumIntegerDigits = value < 0 ? 0 : value;
        if (this.maximumIntegerDigits < this.minimumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
        }
    }

    public void setMinimumFractionDigits(int value) {
        int n = this.minimumFractionDigits = value < 0 ? 0 : value;
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
        }
    }

    public void setMinimumIntegerDigits(int value) {
        int n = this.minimumIntegerDigits = value < 0 ? 0 : value;
        if (this.maximumIntegerDigits < this.minimumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
        }
    }

    public void setParseIntegerOnly(boolean value) {
        this.parseIntegerOnly = value;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("groupingUsed", this.groupingUsed);
        fields.put("maxFractionDigits", this.maximumFractionDigits < 127 ? (byte)this.maximumFractionDigits : (byte)127);
        fields.put("maximumFractionDigits", this.maximumFractionDigits);
        fields.put("maximumIntegerDigits", this.maximumIntegerDigits);
        fields.put("maxIntegerDigits", this.maximumIntegerDigits < 127 ? (byte)this.maximumIntegerDigits : (byte)127);
        fields.put("minFractionDigits", this.minimumFractionDigits < 127 ? (byte)this.minimumFractionDigits : (byte)127);
        fields.put("minimumFractionDigits", this.minimumFractionDigits);
        fields.put("minimumIntegerDigits", this.minimumIntegerDigits);
        fields.put("minIntegerDigits", this.minimumIntegerDigits < 127 ? (byte)this.minimumIntegerDigits : (byte)127);
        fields.put("parseIntegerOnly", this.parseIntegerOnly);
        fields.put("serialVersionOnStream", 1);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.groupingUsed = fields.get("groupingUsed", true);
        this.parseIntegerOnly = fields.get("parseIntegerOnly", false);
        if (fields.get("serialVersionOnStream", 0) == 0) {
            this.maximumFractionDigits = fields.get("maxFractionDigits", (byte)3);
            this.maximumIntegerDigits = fields.get("maxIntegerDigits", (byte)40);
            this.minimumFractionDigits = fields.get("minFractionDigits", (byte)0);
            this.minimumIntegerDigits = fields.get("minIntegerDigits", (byte)1);
        } else {
            this.maximumFractionDigits = fields.get("maximumFractionDigits", 3);
            this.maximumIntegerDigits = fields.get("maximumIntegerDigits", 40);
            this.minimumFractionDigits = fields.get("minimumFractionDigits", 0);
            this.minimumIntegerDigits = fields.get("minimumIntegerDigits", 1);
        }
        if (this.minimumIntegerDigits > this.maximumIntegerDigits || this.minimumFractionDigits > this.maximumFractionDigits) {
            throw new InvalidObjectException(Msg.getString("K00fa"));
        }
        if (this.minimumIntegerDigits < 0 || this.maximumIntegerDigits < 0 || this.minimumFractionDigits < 0 || this.maximumFractionDigits < 0) {
            throw new InvalidObjectException(Msg.getString("K00fb"));
        }
    }

    public static class Field
    extends Format.Field {
        public static final Field SIGN = new Field("sign");
        public static final Field INTEGER = new Field("integer");
        public static final Field FRACTION = new Field("fraction");
        public static final Field EXPONENT = new Field("exponent");
        public static final Field EXPONENT_SIGN = new Field("exponent sign");
        public static final Field EXPONENT_SYMBOL = new Field("exponent symbol");
        public static final Field DECIMAL_SEPARATOR = new Field("decimal separator");
        public static final Field GROUPING_SEPARATOR = new Field("grouping separator");
        public static final Field PERCENT = new Field("percent");
        public static final Field PERMILLE = new Field("per mille");
        public static final Field CURRENCY = new Field("currency");

        protected Field(String fieldName) {
            super(fieldName);
        }

        protected Object readResolve() throws InvalidObjectException {
            String name = this.getName();
            if (name == null) {
                throw new InvalidObjectException(Msg.getString("K0344", "NumberFormat.Field"));
            }
            if (name.equals(INTEGER.getName())) {
                return INTEGER;
            }
            if (name.equals(FRACTION.getName())) {
                return FRACTION;
            }
            if (name.equals(EXPONENT.getName())) {
                return EXPONENT;
            }
            if (name.equals(EXPONENT_SIGN.getName())) {
                return EXPONENT_SIGN;
            }
            if (name.equals(EXPONENT_SYMBOL.getName())) {
                return EXPONENT_SYMBOL;
            }
            if (name.equals(CURRENCY.getName())) {
                return CURRENCY;
            }
            if (name.equals(DECIMAL_SEPARATOR.getName())) {
                return DECIMAL_SEPARATOR;
            }
            if (name.equals(GROUPING_SEPARATOR.getName())) {
                return GROUPING_SEPARATOR;
            }
            if (name.equals(PERCENT.getName())) {
                return PERCENT;
            }
            if (name.equals(PERMILLE.getName())) {
                return PERMILLE;
            }
            if (name.equals(SIGN.getName())) {
                return SIGN;
            }
            throw new InvalidObjectException(Msg.getString("K0344", "NumberFormat.Field"));
        }
    }
}

