/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeMap;

public class TreeSet
extends AbstractSet
implements SortedSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143000061671589L;
    private transient TreeMap backingMap;

    public TreeSet() {
        this.backingMap = new TreeMap();
    }

    public TreeSet(Collection collection) {
        this();
        this.addAll(collection);
    }

    public TreeSet(Comparator comparator) {
        this.backingMap = new TreeMap(comparator);
    }

    public TreeSet(SortedSet set) {
        this(set.comparator());
        Iterator it = set.iterator();
        if (it.hasNext()) {
            TreeMap.Entry last;
            Object object = it.next();
            this.backingMap.root = last = new TreeMap.Entry(object, object);
            this.backingMap.size = 1;
            while (it.hasNext()) {
                object = it.next();
                TreeMap.Entry x = new TreeMap.Entry(object, object);
                x.parent = last;
                last.right = x;
                ++this.backingMap.size;
                this.backingMap.balance(x);
                last = x;
            }
        }
    }

    public boolean add(Object object) {
        return this.backingMap.put(object, object) == null;
    }

    public boolean addAll(Collection collection) {
        return super.addAll(collection);
    }

    public void clear() {
        this.backingMap.clear();
    }

    public Object clone() {
        try {
            TreeSet clone = (TreeSet)super.clone();
            clone.backingMap = (TreeMap)this.backingMap.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Comparator comparator() {
        return this.backingMap.comparator();
    }

    public boolean contains(Object object) {
        return this.backingMap.containsKey(object);
    }

    public Object first() {
        return this.backingMap.firstKey();
    }

    public SortedSet headSet(Object end) {
        Comparator c = this.backingMap.comparator();
        if (c == null) {
            ((Comparable)end).compareTo(end);
        } else {
            c.compare(end, end);
        }
        return new SubSet(this.backingMap, end);
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    public Iterator iterator() {
        return this.backingMap.keySet().iterator();
    }

    public Object last() {
        return this.backingMap.lastKey();
    }

    public boolean remove(Object object) {
        return this.backingMap.remove(object) != null;
    }

    public int size() {
        return this.backingMap.size();
    }

    public SortedSet subSet(Object start, Object end) {
        Comparator c = this.backingMap.comparator();
        if (c == null ? ((Comparable)start).compareTo(end) <= 0 : c.compare(start, end) <= 0) {
            return new SubSet(start, this.backingMap, end);
        }
        throw new IllegalArgumentException();
    }

    public SortedSet tailSet(Object start) {
        Comparator c = this.backingMap.comparator();
        if (c == null) {
            ((Comparable)start).compareTo(start);
        } else {
            c.compare(start, start);
        }
        return new SubSet(start, this.backingMap);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.backingMap.comparator());
        stream.writeInt(this.backingMap.size);
        if (this.backingMap.size > 0) {
            TreeMap.Entry node = TreeMap.minimum(this.backingMap.root);
            while (node != null) {
                stream.writeObject(node.key);
                node = TreeMap.successor(node);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.backingMap = new TreeMap((Comparator)stream.readObject());
        this.backingMap.size = stream.readInt();
        TreeMap.Entry last = null;
        int i = this.backingMap.size;
        while (--i >= 0) {
            TreeMap.Entry node = new TreeMap.Entry(stream.readObject());
            node.value = this;
            if (last == null) {
                this.backingMap.root = node;
            } else {
                node.parent = last;
                last.right = node;
                this.backingMap.balance(node);
            }
            last = node;
        }
    }

    private static final class SubSet
    extends TreeMap.SubMap.SubMapSet
    implements SortedSet {
        SubSet(TreeMap map) {
            super(map, new MapEntry.Type(){

                public Object get(MapEntry entry) {
                    return entry.key;
                }
            });
        }

        SubSet(Object start, TreeMap map) {
            this(map);
            this.hasStart = true;
            this.startKey = start;
        }

        SubSet(Object start, TreeMap map, Object end) {
            this(map);
            this.hasEnd = true;
            this.hasStart = true;
            this.startKey = start;
            this.endKey = end;
        }

        SubSet(TreeMap map, Object end) {
            this(map);
            this.hasEnd = true;
            this.endKey = end;
        }

        public boolean add(Object object) {
            this.checkRange(object);
            return this.backingMap.put(object, object) != null;
        }

        public Comparator comparator() {
            return this.backingMap.comparator();
        }

        public boolean contains(Object object) {
            if (this.checkRange(object, this.hasStart, this.hasEnd)) {
                return this.backingMap.containsKey(object);
            }
            return false;
        }

        public Object first() {
            if (!this.hasStart) {
                return this.backingMap.firstKey();
            }
            TreeMap.Entry node = this.backingMap.findAfter(this.startKey);
            if (node != null && this.checkRange(node.key, false, this.hasEnd)) {
                return node.key;
            }
            throw new NoSuchElementException();
        }

        public SortedSet headSet(Object end) {
            this.checkRange(end);
            if (this.hasStart) {
                return new SubSet(this.startKey, this.backingMap, end);
            }
            return new SubSet(this.backingMap, end);
        }

        public Object last() {
            if (!this.hasEnd) {
                return this.backingMap.lastKey();
            }
            TreeMap.Entry node = this.backingMap.findBefore(this.endKey);
            if (node != null && this.checkRange(node.key, this.hasStart, false)) {
                return node.key;
            }
            throw new NoSuchElementException();
        }

        public boolean remove(Object object) {
            if (this.checkRange(object, this.hasStart, this.hasEnd)) {
                return this.backingMap.remove(object) != null;
            }
            return false;
        }

        public SortedSet subSet(Object start, Object end) {
            this.checkRange(start);
            this.checkRange(end);
            Comparator c = this.backingMap.comparator();
            if (c == null ? ((Comparable)this.startKey).compareTo(this.endKey) <= 0 : c.compare(this.startKey, this.endKey) <= 0) {
                return new SubSet(start, this.backingMap, end);
            }
            throw new IllegalArgumentException();
        }

        public SortedSet tailSet(Object start) {
            this.checkRange(start);
            if (this.hasEnd) {
                return new SubSet(start, this.backingMap, this.endKey);
            }
            return new SubSet(start, this.backingMap);
        }
    }
}

