/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class Vector
extends AbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2767605614048989439L;
    protected int elementCount = 0;
    protected Object[] elementData;
    protected int capacityIncrement;
    private static final int DEFAULT_SIZE = 10;

    public Vector() {
        this(10, 0);
    }

    public Vector(int capacity) {
        this(capacity, 0);
    }

    public Vector(int capacity, int capacityIncrement) {
        try {
            this.elementData = new Object[capacity];
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new IllegalArgumentException();
        }
        this.capacityIncrement = capacityIncrement;
    }

    public Vector(Collection collection) {
        this(collection.size(), 0);
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.elementData[this.elementCount++] = it.next();
        }
    }

    public void add(int location, Object object) {
        this.insertElementAt(object, location);
    }

    public boolean add(Object object) {
        this.addElement(object);
        return true;
    }

    public synchronized boolean addAll(int location, Collection collection) {
        if (location >= 0 && location <= this.elementCount) {
            int count;
            int size = collection.size();
            if (size == 0) {
                return false;
            }
            int required = size - (this.elementData.length - this.elementCount);
            if (required > 0) {
                this.growBy(required);
            }
            if ((count = this.elementCount - location) > 0) {
                System.arraycopy((Object)this.elementData, location, (Object)this.elementData, location + size, count);
            }
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                this.elementData[location++] = it.next();
            }
            this.elementCount += size;
            ++this.modCount;
            return true;
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    public synchronized boolean addAll(Collection collection) {
        return this.addAll(this.elementCount, collection);
    }

    public synchronized void addElement(Object object) {
        if (this.elementCount == this.elementData.length) {
            this.growByOne();
        }
        this.elementData[this.elementCount++] = object;
        ++this.modCount;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    public void clear() {
        this.removeAllElements();
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) != -1;
    }

    public synchronized boolean containsAll(Collection collection) {
        return super.containsAll(collection);
    }

    public synchronized void copyInto(Object[] elements) {
        System.arraycopy((Object)this.elementData, 0, (Object)elements, 0, this.elementCount);
    }

    public synchronized Object elementAt(int location) {
        if (location < this.elementCount) {
            return this.elementData[location];
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    public Enumeration elements() {
        return new Enumeration(){
            int pos = 0;

            public boolean hasMoreElements() {
                return this.pos < Vector.this.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                Vector vector = Vector.this;
                synchronized (vector) {
                    if (this.pos < Vector.this.elementCount) {
                        return Vector.this.elementData[this.pos++];
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        if (this.elementData.length < minimumCapacity) {
            int next = (this.capacityIncrement <= 0 ? this.elementData.length : this.capacityIncrement) + this.elementData.length;
            this.grow(minimumCapacity > next ? minimumCapacity : next);
        }
    }

    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() != this.size()) {
                return false;
            }
            int index = 0;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Object e1 = this.elementData[index++];
                Object e2 = it.next();
                if (!(e1 == null ? e2 != null : !e1.equals(e2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized Object firstElement() {
        if (this.elementCount > 0) {
            return this.elementData[0];
        }
        throw new NoSuchElementException();
    }

    public Object get(int location) {
        return this.elementAt(location);
    }

    private void grow(int newCapacity) {
        Object[] newData = new Object[newCapacity];
        System.arraycopy((Object)this.elementData, 0, (Object)newData, 0, this.elementCount);
        this.elementData = newData;
    }

    private void growByOne() {
        int adding = 0;
        if (this.capacityIncrement <= 0) {
            adding = this.elementData.length;
            if (adding == 0) {
                adding = 1;
            }
        } else {
            adding = this.capacityIncrement;
        }
        Object[] newData = new Object[this.elementData.length + adding];
        System.arraycopy((Object)this.elementData, 0, (Object)newData, 0, this.elementCount);
        this.elementData = newData;
    }

    private void growBy(int required) {
        int adding = 0;
        if (this.capacityIncrement <= 0) {
            adding = this.elementData.length;
            if (adding == 0) {
                adding = required;
            }
            while (adding < required) {
                adding += adding;
            }
        } else {
            adding = required / this.capacityIncrement * this.capacityIncrement;
            if (adding < required) {
                adding += this.capacityIncrement;
            }
        }
        Object[] newData = new Object[this.elementData.length + adding];
        System.arraycopy((Object)this.elementData, 0, (Object)newData, 0, this.elementCount);
        this.elementData = newData;
    }

    public synchronized int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.elementCount) {
            result = 31 * result + (this.elementData[i] == null ? 0 : this.elementData[i].hashCode());
            ++i;
        }
        return result;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int location) {
        if (object != null) {
            int i = location;
            while (i < this.elementCount) {
                if (object.equals(this.elementData[i])) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = location;
            while (i < this.elementCount) {
                if (this.elementData[i] == null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public synchronized void insertElementAt(Object object, int location) {
        if (location >= 0 && location <= this.elementCount) {
            int count;
            if (this.elementCount == this.elementData.length) {
                this.growByOne();
            }
            if ((count = this.elementCount - location) > 0) {
                System.arraycopy((Object)this.elementData, location, (Object)this.elementData, location + 1, count);
            }
            this.elementData[location] = object;
            ++this.elementCount;
            ++this.modCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(location);
        }
    }

    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized Object lastElement() {
        try {
            return this.elementData[this.elementCount - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    public synchronized int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object object, int location) {
        if (location < this.elementCount) {
            if (object != null) {
                int i = location;
                while (i >= 0) {
                    if (object.equals(this.elementData[i])) {
                        return i;
                    }
                    --i;
                }
            } else {
                int i = location;
                while (i >= 0) {
                    if (this.elementData[i] == null) {
                        return i;
                    }
                    --i;
                }
            }
            return -1;
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    public synchronized Object remove(int location) {
        if (location < this.elementCount) {
            Object result = this.elementData[location];
            --this.elementCount;
            int size = this.elementCount - location;
            if (size > 0) {
                System.arraycopy((Object)this.elementData, location + 1, (Object)this.elementData, location, size);
            }
            this.elementData[this.elementCount] = null;
            ++this.modCount;
            return result;
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    public synchronized boolean removeAll(Collection collection) {
        return super.removeAll(collection);
    }

    public synchronized void removeAllElements() {
        Arrays.fill(this.elementData, 0, this.elementCount, null);
        ++this.modCount;
        this.elementCount = 0;
    }

    public synchronized boolean removeElement(Object object) {
        int index = this.indexOf(object, 0);
        if (index == -1) {
            return false;
        }
        this.removeElementAt(index);
        return true;
    }

    public synchronized void removeElementAt(int location) {
        if (location >= 0 && location < this.elementCount) {
            --this.elementCount;
            int size = this.elementCount - location;
            if (size > 0) {
                System.arraycopy((Object)this.elementData, location + 1, (Object)this.elementData, location, size);
            }
            this.elementData[this.elementCount] = null;
            ++this.modCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(location);
        }
    }

    protected void removeRange(int start, int end) {
        if (start >= 0 && start <= end && end <= this.size()) {
            if (start == end) {
                return;
            }
            if (end != this.elementCount) {
                System.arraycopy((Object)this.elementData, end, (Object)this.elementData, start, this.elementCount - end);
                int newCount = this.elementCount - (end - start);
                Arrays.fill(this.elementData, newCount, this.elementCount, null);
                this.elementCount = newCount;
            } else {
                Arrays.fill(this.elementData, start, this.elementCount, null);
                this.elementCount = start;
            }
            ++this.modCount;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public synchronized boolean retainAll(Collection collection) {
        return super.retainAll(collection);
    }

    public synchronized Object set(int location, Object object) {
        if (location < this.elementCount) {
            Object result = this.elementData[location];
            this.elementData[location] = object;
            return result;
        }
        throw new ArrayIndexOutOfBoundsException(location);
    }

    public synchronized void setElementAt(Object object, int location) {
        if (location >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(location);
        }
        this.elementData[location] = object;
    }

    public synchronized void setSize(int length) {
        if (length == this.elementCount) {
            return;
        }
        this.ensureCapacity(length);
        if (this.elementCount > length) {
            Arrays.fill(this.elementData, length, this.elementCount, null);
        }
        this.elementCount = length;
        ++this.modCount;
    }

    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized List subList(int start, int end) {
        return new Collections.SynchronizedRandomAccessList(super.subList(start, end), (Object)this);
    }

    public synchronized Object[] toArray() {
        Object[] result = new Object[this.elementCount];
        System.arraycopy((Object)this.elementData, 0, (Object)result, 0, this.elementCount);
        return result;
    }

    public synchronized Object[] toArray(Object[] contents) {
        if (this.elementCount > contents.length) {
            contents = (Object[])Array.newInstance(contents.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy((Object)this.elementData, 0, (Object)contents, 0, this.elementCount);
        if (this.elementCount < contents.length) {
            contents[this.elementCount] = null;
        }
        return contents;
    }

    public synchronized String toString() {
        if (this.elementCount == 0) {
            return "[]";
        }
        int length = this.elementCount - 1;
        StringBuffer buffer = new StringBuffer(this.size() * 16);
        buffer.append('[');
        int i = 0;
        while (i < length) {
            if (this.elementData[i] == this) {
                buffer.append("(this Collection)");
            } else {
                buffer.append(this.elementData[i]);
            }
            buffer.append(", ");
            ++i;
        }
        if (this.elementData[length] == this) {
            buffer.append("(this Collection)");
        } else {
            buffer.append(this.elementData[length]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public synchronized void trimToSize() {
        if (this.elementData.length != this.elementCount) {
            this.grow(this.elementCount);
        }
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }
}

