/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private Cipher cipher = null;

    public CipherOutputStream(OutputStream os, Cipher cipher) {
        super(os);
        if (cipher == null) {
            throw new NullPointerException();
        }
        this.cipher = cipher;
    }

    protected CipherOutputStream(OutputStream os) {
        super(os);
        this.cipher = new NullCipher();
    }

    public void write(int aByte) throws IOException {
        byte[] data = new byte[]{(byte)(aByte & 0xFF)};
        this.write(data, 0, 1);
    }

    public void write(byte[] output) throws IOException {
        this.write(output, 0, output.length);
    }

    public void write(byte[] output, int start, int len) throws IOException {
        byte[] processedData = this.cipher.update(output, start, len);
        if (processedData != null) {
            this.out.write(processedData);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        byte[] processedData = null;
        try {
            processedData = this.cipher.doFinal();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.out.write(processedData);
        this.out.flush();
        super.close();
    }
}

