/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import com.ibm.oti.jce.support.JCEClassValidator;
import com.ibm.oti.jce.support.Msg;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGenerator {
    private static String KEY_GENERATOR_SERVICE_PREFIX = "KeyGenerator.";
    private KeyGeneratorSpi implementation = null;
    private Provider provider = null;
    private String algorithm = null;

    protected KeyGenerator(KeyGeneratorSpi implementation, Provider provider, String algorithm) {
        this.implementation = implementation;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] providers;
        try {
            providers = Security.getProviders(String.valueOf(KEY_GENERATOR_SERVICE_PREFIX) + algorithm);
        }
        catch (InvalidParameterException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        if (providers == null) {
            throw new NoSuchAlgorithmException();
        }
        return KeyGenerator.getInstance(algorithm, providers[0]);
    }

    public static final KeyGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(Msg.getString("JCE003", provider));
        }
        return KeyGenerator.getInstance(algorithm, p);
    }

    public static final KeyGenerator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        String className = provider.getProperty(String.valueOf(KEY_GENERATOR_SERVICE_PREFIX) + algorithm);
        if (className == null) {
            throw new NoSuchAlgorithmException();
        }
        Class generatorClass = null;
        try {
            generatorClass = Class.forName(className, true, provider.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        JCEClassValidator validator = new JCEClassValidator(generatorClass);
        try {
            validator.validateJCEProviderClass();
        }
        catch (SecurityException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        KeyGeneratorSpi implementationClass = null;
        try {
            implementationClass = (KeyGeneratorSpi)generatorClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        return new KeyGenerator(implementationClass, provider, algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(SecureRandom random) {
        this.implementation.engineInit(random);
    }

    public final void init(AlgorithmParameterSpec parameters) throws InvalidAlgorithmParameterException {
        this.implementation.engineInit(parameters, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec parameters, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.implementation.engineInit(parameters, random);
    }

    public final void init(int keylen) {
        this.implementation.engineInit(keylen, new SecureRandom());
    }

    public final void init(int keylen, SecureRandom random) {
        this.implementation.engineInit(keylen, random);
    }

    public final SecretKey generateKey() {
        return this.implementation.engineGenerateKey();
    }
}

