/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.helpservice.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emt.helpservice.HelpServiceLog;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Display {
    private static final String ERICSSON_LOGO_FILE_NAME = "About.png";
    private static final String NEWLINE = System.getProperties().getProperty("line.separator", "\n");
    private Map<String, AboutDialog> myAboutDialogs = new Hashtable<String, AboutDialog>(10);

    public void displayAbout(final String applicationTitle, final TreeSet<String> executingAppRows, final JFrame ownerFrame, final String additionalText, final String copyRightYear, final String thirdPartyText) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Display.this.displayAbout(applicationTitle, executingAppRows, ownerFrame, additionalText, copyRightYear, thirdPartyText);
                }
            });
        } else {
            JTextArea destinationTextArea;
            HelpServiceLog.logger().info("Entering displayAbout");
            AboutDialog theAboutDialog = this.myAboutDialogs.get(applicationTitle);
            if (null == theAboutDialog) {
                JFrame frame = ownerFrame;
                theAboutDialog = new AboutDialog(frame, "About " + applicationTitle);
                theAboutDialog.initAboutDialog();
                theAboutDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        Display.this.myAboutDialogs.remove(applicationTitle);
                    }
                });
                destinationTextArea = theAboutDialog.getTextArea();
                this.myAboutDialogs.put(applicationTitle, theAboutDialog);
            } else {
                destinationTextArea = theAboutDialog.getTextArea();
                destinationTextArea.setText("");
            }
            this.fillAboutTextAreaWithContents(applicationTitle, additionalText, copyRightYear, thirdPartyText, executingAppRows, destinationTextArea);
            theAboutDialog.pack();
            this.makeAllOfTheAboutWindowVisible(theAboutDialog);
            theAboutDialog.setVisible(true);
        }
    }

    private void makeAllOfTheAboutWindowVisible(AboutDialog aboutDialog) {
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension aboutWindowDimension = aboutDialog.getSize();
        int x = (screenDimension.width - aboutWindowDimension.width) / 2;
        int y = (screenDimension.height - aboutWindowDimension.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        aboutDialog.setLocation(x, y);
    }

    public static void displayUsingHelp(final JFrame ownerFrame) {
        StringBuilder strB = new StringBuilder();
        strB.append("The Help consists of documents stored on an Active Library EXplorer (ALEX) server. It is displayed in a web browser.");
        strB.append(NEWLINE);
        strB.append(NEWLINE);
        strB.append(NEWLINE);
        strB.append("The ALEX server address and library are specified in the MO ManagedElement=1,ManagedElementData=1.");
        strB.append(NEWLINE);
        strB.append(NEWLINE);
        strB.append(NEWLINE);
        strB.append("The attribute documentServerAddress gives the address to the ALEX server, and the attribute docLibSystemDefined gives the ALEX library for this node.");
        strB.append(NEWLINE);
        strB.append(NEWLINE);
        strB.append("The settable attribute docLibUserDefined can be used to override the read-only value of docLibSystemDefined.");
        final String msg = strB.toString();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MessageDialogFactory.createMessageDialog("Using Help", msg, false, ownerFrame).setVisible(true);
            }
        });
    }

    public static JFrame getInvisibleFrame(String iconPath) {
        IconHelper helper = new IconHelper();
        JFrame invisibleFrame = new JFrame();
        invisibleFrame.setIconImage(helper.getIconImage(iconPath));
        return invisibleFrame;
    }

    private void fillAboutTextAreaWithContents(String applicationTitle, String additionalText, String copyRightYear, String thirdPartyText, TreeSet<String> executingAppRows, JTextArea textArea) {
        textArea.append(applicationTitle);
        textArea.append(NEWLINE);
        textArea.append(NEWLINE);
        if (null != additionalText && additionalText.trim().length() > 0) {
            textArea.append(additionalText);
            textArea.append(NEWLINE);
            textArea.append(NEWLINE);
        }
        textArea.append("Currently executing products and versions:" + NEWLINE);
        Iterator<String> rowIter = executingAppRows.iterator();
        while (rowIter.hasNext()) {
            textArea.append(rowIter.next());
            textArea.append(NEWLINE);
        }
        textArea.append(NEWLINE);
        char copyr = '\u00a9';
        StringBuilder copyrightInfo = new StringBuilder();
        copyrightInfo.append(NEWLINE);
        copyrightInfo.append(copyr);
        copyrightInfo.append(" Ericsson AB ");
        copyrightInfo.append(copyRightYear);
        copyrightInfo.append(". All rights reserved.");
        textArea.append(copyrightInfo.toString());
        if (thirdPartyText != null && thirdPartyText.trim().length() > 0) {
            textArea.append(NEWLINE);
            textArea.append(NEWLINE);
            textArea.append(thirdPartyText);
        }
        HelpServiceLog.logger().info("Displaying the following information in About window:" + NEWLINE + textArea.getText());
    }

    private static final class AboutDialog
    extends JDialog {
        private static final long serialVersionUID = 5076795264431858911L;
        private JTextArea myTextArea;
        private final JFrame myFrame;
        private final String myTitle;

        public AboutDialog(JFrame frame, String title) {
            super((Frame)frame, title);
            this.myFrame = frame;
            this.myTitle = title;
        }

        public void initAboutDialog() {
            this.setAlwaysOnTop(null == this.myFrame || !this.myFrame.isShowing());
            JPanel theDialogPanel = (JPanel)this.getContentPane();
            theDialogPanel.setLayout(new BorderLayout(10, 0));
            theDialogPanel.setOpaque(true);
            theDialogPanel.setBackground(Color.WHITE);
            JButton closeButton = new JButton("Close");
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            buttonPanel.setOpaque(true);
            this.addCloseListenerToAbout(this.myTitle, this, closeButton, buttonPanel);
            buttonPanel.add(closeButton);
            JPanel ericIconP = this.constructPanelAndEricssonIcon();
            this.myTextArea = new JTextArea();
            Font font = new JLabel().getFont();
            this.myTextArea.setEditable(false);
            this.myTextArea.setOpaque(true);
            this.myTextArea.setBackground(Color.WHITE);
            this.myTextArea.setFont(font);
            this.myTextArea.setBorder(BorderFactory.createEmptyBorder(8, 5, 5, 5));
            this.myTextArea.setColumns(24);
            this.getContentPane().add((Component)buttonPanel, "South");
            this.getContentPane().add((Component)this.myTextArea, "Center");
            this.getContentPane().add((Component)new JLabel(""), "East");
            if (ericIconP != null) {
                this.getContentPane().add((Component)ericIconP, "West");
            }
            this.setResizable(false);
        }

        public JTextArea getTextArea() {
            return this.myTextArea;
        }

        private JPanel constructPanelAndEricssonIcon() {
            ImageIcon ericssonIcon = null;
            JPanel ericIconP = null;
            try {
                URL imageUrl = Display.class.getResource(Display.ERICSSON_LOGO_FILE_NAME);
                if (null != imageUrl) {
                    Image ericssonImage = Toolkit.getDefaultToolkit().createImage(imageUrl);
                    ericssonIcon = new ImageIcon(ericssonImage);
                } else {
                    HelpServiceLog.logger().info("About window could not create the Ericsson logotype");
                }
            }
            catch (Throwable ex) {
                HelpServiceLog.logger().warning("About window could not create the pictures. " + ex.getMessage());
            }
            JLabel ericIconLabel = null;
            if (null != ericssonIcon) {
                ericIconLabel = new JLabel("", ericssonIcon, 2);
                ericIconP = new JPanel();
                ericIconP.setOpaque(true);
                ericIconP.setBackground(new Color(0, 40, 94));
                ericIconP.add(ericIconLabel);
            }
            return ericIconP;
        }

        private void addCloseListenerToAbout(String applicationTitle, AboutDialog theAboutDialog, JButton closeButton, JPanel buttonPanel) {
            final AboutDialog theDialog = theAboutDialog;
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    theDialog.dispose();
                }
            });
        }
    }
}

