/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.logservices.view;

import java.awt.Image;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import se.ericsson.cello.emt.logservices.view.Log;
import se.ericsson.emt.logservices.toolservice.ToolServices;
import se.ericsson.security.launcher.Launchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogServicesController {
    static final String GLOBAL = "global";
    static final String SETTINGS = "java.util.logging.config.file";
    static final String LOG_TO_FILE_PATH = "log.filepath";
    static final String LOG_TO_FILE = "log.file";
    static final String LOG_TO_CONSOLE = "log.console";
    static final String INPUT_SETTING = "log.inputSetting";
    static final String DEFAULT_LOG_FILEPATH = "%h/java%g.log";
    static final String SETTINGS_FILE_VARIABLE = "java.util.logging.FileHandler.pattern";
    private HashMap<String, Log> logs;
    private LogManager logManager;
    private ConsoleHandler consoleHandler;
    private FileHandler fileHandler;
    private String logFilePath = "%h/java%g.log";
    private String settingsFilePath = System.getProperty("user.dir");
    private boolean logToConsole = false;
    private boolean logToFile = false;
    private ToolServices toolServices;
    private Launchable launchable;
    private InputPreference inputSettings = InputPreference.NOT_SELECTED;

    public LogServicesController(ToolServices toolServices, Launchable launchable) {
        this.logManager = LogManager.getLogManager();
        this.loadFromSystem();
        this.logs = new HashMap();
        this.toolServices = toolServices;
        this.launchable = launchable;
        Enumeration<String> loggerNames = this.logManager.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            if (loggerName.equalsIgnoreCase(GLOBAL) || loggerName.equalsIgnoreCase("")) continue;
            Log log = new Log(Logger.getLogger(loggerName));
            this.logs.put(loggerName, log);
        }
        this.consoleHandler = new ConsoleHandler();
        this.consoleHandler.setLevel(Level.ALL);
    }

    public void set() {
        this.storeToSystem();
        if (this.logToConsole) {
            this.setConsoleHandler();
        } else {
            this.removeConsoleHandler();
        }
        if (this.logToFile && this.logFilePath != null) {
            this.setFileHandler(this.logFilePath);
        } else {
            this.removeFileHandler();
        }
        Collection<Log> allLogs = this.logs.values();
        for (Log log : allLogs) {
            log.set();
        }
    }

    public void applyLevel(String logName, String level) {
        Log log = this.logs.get(logName);
        log.setLevel(level);
    }

    public String getLevel(String logName) {
        Log log = this.logs.get(logName);
        return log.getLevel();
    }

    public ArrayList<String> getLoggerNames() {
        return this.sort(this.logs.keySet());
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String path) {
        this.logFilePath = path;
    }

    public void setInputSettings(InputPreference pref) {
        this.inputSettings = pref;
    }

    public InputPreference getInputSettings() {
        return this.inputSettings;
    }

    public void setSettingsFilePath(String path) {
        this.settingsFilePath = path;
    }

    public String getSettingsFilePath() {
        return this.settingsFilePath;
    }

    public void setLogToConsole(boolean value) {
        this.logToConsole = value;
    }

    public boolean getLogToConsole() {
        return this.logToConsole;
    }

    public void setLogToFile(boolean value) {
        this.logToFile = value;
    }

    public boolean getLogToFile() {
        return this.logToFile;
    }

    public void readSettingsFromFile() throws FileNotFoundException, SecurityException, IOException, IllegalArgumentException {
        this.logs.clear();
        Logger log = Logger.getLogger("");
        FileInputStream ins = new FileInputStream(this.settingsFilePath);
        if (ins != null) {
            try {
                LogManager.getLogManager().readConfiguration(ins);
            }
            catch (SecurityException e) {
                ins.close();
                throw e;
            }
            catch (IllegalArgumentException e) {
                ins.close();
                throw e;
            }
            catch (IOException e) {
                ins.close();
                throw e;
            }
            finally {
                try {
                    ins.close();
                }
                catch (IOException e) {}
            }
        }
        this.setLogFilePath(LogManager.getLogManager().getProperty(SETTINGS_FILE_VARIABLE));
        this.storeToSystem();
        Handler[] handlers = log.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Enumeration<String> loggerNames = this.logManager.getLoggerNames();
            while (loggerNames.hasMoreElements()) {
                String loggerName = loggerNames.nextElement();
                if (loggerName.equalsIgnoreCase(GLOBAL) || loggerName.equalsIgnoreCase("")) continue;
                this.logManager.getLogger(loggerName).addHandler(handlers[i]);
            }
        }
    }

    public void showHelp() {
        this.toolServices.runHelp();
    }

    public void exit() {
        this.launchable.exit();
    }

    public String getSelectedLog() {
        return this.toolServices.getConfiguration().getSelectedLog();
    }

    public String getTitle() {
        return this.toolServices.getHostName() + " - " + this.toolServices.getConfiguration().getTitle();
    }

    public Image getIconImage() {
        return this.toolServices.getConfiguration().getIconImage();
    }

    private void loadFromSystem() {
        if (System.getProperty(SETTINGS) != null) {
            this.settingsFilePath = System.getProperty(SETTINGS);
        }
        if (System.getProperty(LOG_TO_FILE_PATH) != null) {
            this.logFilePath = System.getProperty(LOG_TO_FILE_PATH);
        }
        this.logToConsole = Boolean.parseBoolean(System.getProperty(LOG_TO_CONSOLE, "false"));
        this.logToFile = Boolean.parseBoolean(System.getProperty(LOG_TO_FILE, "false"));
        this.inputSettings = InputPreference.valueOf(System.getProperty(INPUT_SETTING, InputPreference.NOT_SELECTED.toString()));
    }

    public void storeToSystem() {
        if (this.settingsFilePath != null) {
            System.setProperty(SETTINGS, this.settingsFilePath);
        }
        if (this.logFilePath != null) {
            System.setProperty(LOG_TO_FILE_PATH, this.logFilePath);
        }
        System.setProperty(LOG_TO_CONSOLE, String.valueOf(this.logToConsole));
        System.setProperty(LOG_TO_FILE, String.valueOf(this.logToFile));
        System.setProperty(INPUT_SETTING, this.inputSettings.toString());
    }

    void setConsoleHandler() {
        Collection<Log> allLogs = this.logs.values();
        this.consoleHandler.setLevel(Level.ALL);
        for (Log log : allLogs) {
            log.setConsoleHandler(this.consoleHandler);
        }
    }

    void removeConsoleHandler() {
        Collection<Log> allLogs = this.logs.values();
        for (Log log : allLogs) {
            log.removeConsoleHandler();
        }
    }

    ArrayList<String> sort(Set<String> loggerNames) {
        TreeSet<String> ericsson = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        TreeSet<String> other = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String name : loggerNames) {
            if (name.startsWith("se.ericsson")) {
                ericsson.add(name);
                continue;
            }
            other.add(name);
        }
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(ericsson);
        res.addAll(other);
        return res;
    }

    void setFileHandler(String filePath) {
        try {
            this.fileHandler = new FileHandler(filePath);
            this.fileHandler.setLevel(Level.ALL);
            this.fileHandler.setFormatter(new SimpleFormatter());
            Collection<Log> allLogs = this.logs.values();
            for (Log log : allLogs) {
                log.setFileHandler(this.fileHandler);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void removeFileHandler() {
        Collection<Log> allLogs = this.logs.values();
        for (Log log : allLogs) {
            log.removeFileHandler();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputPreference {
        FILE,
        MANUAL,
        NOT_SELECTED;

    }
}

