/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class NealRuntimeException
extends RuntimeException {
    private static final Method initCauseMethod = NealRuntimeException.getInitCauseMethod();
    private Throwable causingException;

    public NealRuntimeException(String string, Throwable throwable) {
        super(string);
        this.tryInitCause(throwable);
        this.causingException = throwable;
    }

    public NealRuntimeException(Throwable throwable) {
        this(throwable == null ? null : throwable.toString(), throwable);
    }

    public NealRuntimeException(String string) {
        super(string);
    }

    public NealRuntimeException() {
    }

    private static Method getInitCauseMethod() {
        try {
            Method method = Throwable.class.getDeclaredMethod("initCause", Throwable.class);
            return method;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void tryInitCause(Throwable throwable) {
        if (initCauseMethod == null) {
            return;
        }
        try {
            initCauseMethod.invoke((Object)this, throwable);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public Throwable getCause() {
        return this.causingException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            if (this.causingException != null && initCauseMethod == null) {
                printStream.println(this);
                printStream.print("Caused by: ");
                this.causingException.printStackTrace(printStream);
            } else {
                super.printStackTrace(printStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            if (this.causingException != null && initCauseMethod == null) {
                printWriter.println(this);
                printWriter.print("Caused by: ");
                this.causingException.printStackTrace(printWriter);
            } else {
                super.printStackTrace(printWriter);
            }
        }
    }
}

