/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal;

import se.ericsson.cello.neal.CelloNode;
import se.ericsson.cello.neal.CelloNodeConfig;
import se.ericsson.cello.neal.IorResolver;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeException;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.log.NealMessageLogger;
import se.ericsson.cello.support.corba.CelloOrb;

public class NodeFactory {
    private static final String IOR = "/cello/ior_files/nameroot.ior";
    private static final String DEFAULT_HTTP_ROOT = "/c/public_html";
    private static Node myMockNode = null;

    public static Node getNode() throws NodeException {
        return NodeFactory.getNode(true);
    }

    public static Node getNode(boolean bl) throws NodeException {
        NealLog.setLogger(new NealMessageLogger());
        if (myMockNode == null) {
            NealLog.fine("Creating configuration object");
            String string = System.getProperty("http.root", DEFAULT_HTTP_ROOT) + IOR;
            if (!string.startsWith("file://")) {
                string = "file://" + string;
            }
            if (!IorResolver.isIorFile(string)) {
                throw new NodeException("Could not find any valid IOR at " + string);
            }
            CelloNodeConfig celloNodeConfig = new CelloNodeConfig();
            celloNodeConfig.setAllServicesRequired(bl);
            celloNodeConfig.setConnectionInfo(string);
            celloNodeConfig.setExternalOrbAndPoa(CelloOrb.instance().getOrb(), CelloOrb.instance().getRootPOA(), CelloOrb.instance().getRootPOA());
            try {
                NealLog.fine("Create CelloNode object");
                return new CelloNode(celloNodeConfig);
            }
            catch (Exception exception) {
                NealLog.fine("Could not create CelloNode object", exception);
                throw new NodeException(exception.getCause());
            }
        }
        return myMockNode;
    }

    public static void setMockNode(Node node) {
        myMockNode = node;
    }

    private NodeFactory() {
    }
}

