/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import ConfigExtended.AVCNotification;
import ConfigExtended.AttributeNotificationInfo;
import ConfigExtended.ConfigNotification;
import ConfigExtended.DeltaNotificationInfo;
import ConfigExtended.MOInfo;
import ConfigExtended.NotificationKind;
import ConfigExtended.OverflowNotification;
import ConfigExtended.SequenceDeltaNotification;
import ConfigExtended.TopologyNotification;
import se.ericsson.cello.neal.cm.CelloNameValue;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmNotificationConsumer_v2;
import se.ericsson.cello.neal.cm.DeltaNotificationInformation;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.internal.NealLog;

class CmNotifier
implements Runnable {
    ConfigNotification[] _notifications;
    CmNotificationConsumer _consumer;

    CmNotifier(ConfigNotification[] configNotificationArray, CmNotificationConsumer cmNotificationConsumer) {
        this._notifications = configNotificationArray;
        this._consumer = cmNotificationConsumer;
    }

    public void run() {
        for (int i = 0; i < this._notifications.length; ++i) {
            ConfigNotification configNotification = this._notifications[i];
            NotificationKind notificationKind = configNotification.discriminator();
            if (notificationKind == NotificationKind.MOCreatedType) {
                NealLog.fine("Distribute MO created notification");
                this.sendMOCreatedNotif(configNotification.createdMO());
                continue;
            }
            if (notificationKind == NotificationKind.MODeletedType) {
                NealLog.fine("Distribute MO delted notification");
                this.sendMODeletedNotif(configNotification.deletedMO());
                continue;
            }
            if (notificationKind == NotificationKind.AVCType) {
                NealLog.fine("Distribute changed MO attribute namevalue notification");
                this.sendMOUpdatedNotif(configNotification.updatedMO());
                continue;
            }
            if (notificationKind == NotificationKind.OverflowType) {
                NealLog.fine("Distribute overflow type notification");
                this.sendOverflowNotif(configNotification.overflow());
                continue;
            }
            if (notificationKind != NotificationKind.SequenceDeltaType) continue;
            if (this._consumer instanceof CmNotificationConsumer_v2) {
                NealLog.fine("Distribute Sequence delta attribute notification");
                this.sendSequenceDeltaNotif(configNotification.sequenceAttributeChanged());
                continue;
            }
            NealLog.fine("No notification found for sequence delta attribute notification");
        }
    }

    private void sendMOCreatedNotif(TopologyNotification topologyNotification) {
        MOInfo mOInfo = topologyNotification.moInformation;
        this._consumer.moCreated(this.getFDN(mOInfo), topologyNotification.generationCount);
    }

    private void sendMODeletedNotif(TopologyNotification topologyNotification) {
        MOInfo mOInfo = topologyNotification.moInformation;
        this._consumer.moDeleted(this.getFDN(mOInfo), topologyNotification.generationCount);
    }

    private void sendMOUpdatedNotif(AVCNotification aVCNotification) {
        MOInfo mOInfo = aVCNotification.moInformation;
        AttributeNotificationInfo[] attributeNotificationInfoArray = aVCNotification.changedAttributes;
        NameValue[] nameValueArray = new CelloNameValue[attributeNotificationInfoArray.length];
        for (int i = 0; i < nameValueArray.length; ++i) {
            try {
                nameValueArray[i] = new CelloNameValue(attributeNotificationInfoArray[i].name, attributeNotificationInfoArray[i].newValue, null);
                continue;
            }
            catch (CmException cmException) {
                // empty catch block
            }
        }
        this._consumer.attributeValueChanged(this.getFDN(mOInfo), nameValueArray, aVCNotification.generationCount);
    }

    private void sendSequenceDeltaNotif(SequenceDeltaNotification sequenceDeltaNotification) {
        ((CmNotificationConsumer_v2)this._consumer).attributeChanged(this.getFDN(sequenceDeltaNotification.moInformation), this.getDeltaNotificationInfo(sequenceDeltaNotification.sequenceDeltas), sequenceDeltaNotification.generationCount);
    }

    private void sendOverflowNotif(OverflowNotification overflowNotification) {
        this._consumer.overflowOccurred(overflowNotification.time);
    }

    private String getFDN(MOInfo mOInfo) {
        if (mOInfo.prefix == null || mOInfo.prefix.length() == 0) {
            return mOInfo.localDN;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(mOInfo.prefix);
        stringBuffer.append(",");
        stringBuffer.append(mOInfo.localDN);
        return stringBuffer.toString();
    }

    private DeltaNotificationInformation[] getDeltaNotificationInfo(DeltaNotificationInfo[] deltaNotificationInfoArray) {
        DeltaNotificationInformation[] deltaNotificationInformationArray = new DeltaNotificationInformation[deltaNotificationInfoArray.length];
        for (int i = 0; i < deltaNotificationInfoArray.length; ++i) {
            deltaNotificationInformationArray[i] = new DeltaNotificationInformation(deltaNotificationInfoArray[i]);
        }
        return deltaNotificationInformationArray;
    }
}

