/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.fm;

import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;
import org.threegppsa5.AlarmIRPConstDefs.AlarmInformationIdSeqHolder;
import org.threegppsa5.CommonIRPConstDefs.Signal;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CorrelatedNotifications;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.UtcTime;
import se.ericsson.cello.neal.fm.Alarm;
import se.ericsson.cello.neal.fm.AlarmIrpTranslator;
import se.ericsson.cello.neal.fm.FmException;
import se.ericsson.cello.neal.fm.FmNotificationImpl;
import se.ericsson.cello.neal.internal.ServiceContext;
import se.ericsson.cello.neal.internal.omsi_version.StructuredEventAdapter;

class CelloAlarm
extends FmNotificationImpl
implements Alarm {
    CelloAlarm(StructuredEventAdapter structuredEventAdapter, ServiceContext serviceContext) {
        super(structuredEventAdapter, serviceContext);
    }

    public List getRelatedNotifications() {
        int n = this.getNotificationId();
        Node node = this.serviceContext.getNode();
        Alarm[] alarmArray = node.getFmService().getAlarmList();
        LinkedList<Alarm> linkedList = new LinkedList<Alarm>();
        for (int i = 0; i < alarmArray.length; ++i) {
            if (alarmArray[i].getNotificationId() != this.getNotificationId() || alarmArray[i].equals(this)) continue;
            linkedList.add(alarmArray[i]);
        }
        return linkedList;
    }

    public int getProbableCauseDef() {
        NameValue nameValue = this.getAttribute("g");
        return nameValue == null ? -1 : nameValue.getIntValue();
    }

    public int getPerceivedSeverityDef() {
        NameValue nameValue = this.getAttribute("h");
        return nameValue == null ? -1 : nameValue.getIntValue();
    }

    public String getSpecificProblem() {
        NameValue nameValue = this.getAttribute("i");
        return nameValue == null ? null : nameValue.getStringValue();
    }

    public CorrelatedNotifications getCorrelatedNotifications() {
        NameValue nameValue = this.getAttribute("b");
        return nameValue == null ? null : nameValue.getCorrelatedNotificationsValue();
    }

    public Boolean getBackedUpStatus() {
        NameValue nameValue = this.getAttribute("p");
        return nameValue == null ? null : (Boolean)nameValue.getValue();
    }

    public String getBackUpObject() {
        NameValue nameValue = this.getAttribute("q");
        return nameValue == null ? null : nameValue.getStringValue();
    }

    public String getProposedRepairActionsDef() {
        NameValue nameValue = this.getAttribute("v");
        return nameValue == null ? null : nameValue.getStringValue();
    }

    public String getAlarmId() {
        NameValue nameValue = this.getAttribute("k");
        String string = nameValue == null ? null : nameValue.getStringValue();
        return string;
    }

    public UtcTime getAckTime() {
        NameValue nameValue = this.getAttribute("m");
        return nameValue == null ? null : nameValue.getUtcTimeValue();
    }

    public String getAckUserId() {
        NameValue nameValue = this.getAttribute("l");
        return nameValue == null ? null : nameValue.getStringValue();
    }

    public String getAckSystemId() {
        NameValue nameValue = this.getAttribute("n");
        return nameValue == null ? null : nameValue.getStringValue();
    }

    public int getAckStateDef() {
        NameValue nameValue = this.getAttribute("o");
        return nameValue == null ? -1 : nameValue.getIntValue();
    }

    public String getAckState() {
        int n = this.getAckStateDef();
        String string = n == 1 ? "ACK_STATE_ACKNOWLEDGED" : (n == 2 ? "ACK_STATE_UNACKNOWLEDGED" : "BAD_STATE");
        return string;
    }

    public String getProbableCause() {
        return AlarmIrpTranslator.getInstance().translateProbableCause(new Integer(this.getProbableCauseDef()));
    }

    public String getPerceivedSeverity() {
        return AlarmIrpTranslator.getInstance().translatePerceivedSeverity(new Integer(this.getPerceivedSeverityDef()));
    }

    public boolean isAcked() {
        int n = this.getAckStateDef();
        return n == 1;
    }

    public boolean acknowledge(String string) {
        try {
            String[] stringArray = new String[]{this.getAlarmId()};
            AlarmInformationIdSeqHolder alarmInformationIdSeqHolder = new AlarmInformationIdSeqHolder(new String[0]);
            Signal signal = this.serviceContext.getAlarmIRPOps().acknowledge_alarms(stringArray, string, "", alarmInformationIdSeqHolder);
            return alarmInformationIdSeqHolder.value.length == 0 && signal.value() == 0;
        }
        catch (UserException userException) {
            throw new FmException(userException);
        }
    }

    public boolean unacknowledge(String string) {
        try {
            String[] stringArray = new String[]{this.getAlarmId()};
            AlarmInformationIdSeqHolder alarmInformationIdSeqHolder = new AlarmInformationIdSeqHolder(new String[0]);
            Signal signal = this.serviceContext.getAlarmIRPOps().unacknowledge_alarms(stringArray, string, "", alarmInformationIdSeqHolder);
            return alarmInformationIdSeqHolder.value.length == 0 && signal.value() == 0;
        }
        catch (UserException userException) {
            throw new FmException(userException);
        }
    }
}

