/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.fm;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.threegppsa5.AlarmIRPSystem.AlarmInformationIteratorHolder;
import org.threegppsa5.NotificationIRPConstDefs.SubscriptionStateHolder;
import org.threegppsa5.NotificationIRPSystem.InvalidParameter;
import se.ericsson.cello.neal.fm.Alarm;
import se.ericsson.cello.neal.fm.AlarmCounter;
import se.ericsson.cello.neal.fm.CelloAlarm;
import se.ericsson.cello.neal.fm.CelloEvent;
import se.ericsson.cello.neal.fm.CelloFmSubscription;
import se.ericsson.cello.neal.fm.Event;
import se.ericsson.cello.neal.fm.FmException;
import se.ericsson.cello.neal.fm.FmNotificationConsumer;
import se.ericsson.cello.neal.fm.FmNotificationImpl;
import se.ericsson.cello.neal.fm.FmService;
import se.ericsson.cello.neal.fm.FmSubscription;
import se.ericsson.cello.neal.fm.SeverityInfo;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.OamService;
import se.ericsson.cello.neal.internal.ServiceContext;
import se.ericsson.cello.neal.internal.TaskRunner;
import se.ericsson.cello.neal.internal.omsi_version.EventTypeAdapter;
import se.ericsson.cello.neal.internal.omsi_version.SequencePushConsumerOperationsAdapter;
import se.ericsson.cello.neal.internal.omsi_version.SequencePushConsumerPOATieAdapter;
import se.ericsson.cello.neal.internal.omsi_version.StructuredEventAdapter;

class CelloFmService
implements FmService,
SequencePushConsumerOperationsAdapter,
OamService {
    static final int LEASE_PERIOD = 60;
    static final int TICK_PERIOD = 300000;
    private ServiceContext serviceContext;
    private ClockDaemon _timer;
    private Object mySequencePushConsumer;
    private List consumers = new Vector();
    private TaskRunner taskRunner;
    private String mySubscriptionId;
    private boolean subscriptionLost = false;

    CelloFmService() {
    }

    public void init(ServiceContext serviceContext) throws NotFound, CannotProceed, InvalidName {
        this.serviceContext = serviceContext;
        this.taskRunner = serviceContext.getTaskRunner("FmNotification");
    }

    public void free() {
        this.disconnect_sequence_push_consumer();
        this.serviceContext = null;
    }

    public FmSubscription subscribe(FmNotificationConsumer fmNotificationConsumer) {
        try {
            if (this.mySequencePushConsumer == null) {
                SequencePushConsumerPOATieAdapter sequencePushConsumerPOATieAdapter = new SequencePushConsumerPOATieAdapter(this);
                this.serviceContext.connect(sequencePushConsumerPOATieAdapter);
                this.mySequencePushConsumer = this.serviceContext.servant_to_reference(sequencePushConsumerPOATieAdapter);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String[] stringArray = new String[]{"1f1"};
                this.mySubscriptionId = this.serviceContext.getNotificationIRPOps().attach_push(this.mySequencePushConsumer, 60, stringArray, "");
                NealLog.fine("Created FM Subscription with id: " + this.mySubscriptionId);
                this.subscriptionLost = false;
                this._timer = new ClockDaemon();
                TickerReceiver tickerReceiver = new TickerReceiver();
                this._timer.executePeriodically(300000L, tickerReceiver, true);
            }
            this.addConsumer(fmNotificationConsumer);
            return new CelloFmSubscription(this, fmNotificationConsumer);
        }
        catch (UserException userException) {
            NealLog.severe("Failed subscribing to FmNotifications!", userException);
            throw new FmException(userException);
        }
        catch (RuntimeException runtimeException) {
            NealLog.severe("Failed subscribing to FmNotifications!", runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            NealLog.severe("Failed subscribing to FmNotifications!", error);
            throw error;
        }
    }

    public void unsubscribe(FmNotificationConsumer fmNotificationConsumer) {
        this.removeConsumer(fmNotificationConsumer);
        if (!this.hasConsumers() && this.mySequencePushConsumer != null) {
            this.disconnect_sequence_push_consumer();
        }
    }

    public Alarm[] getAlarmList() {
        BooleanHolder booleanHolder = new BooleanHolder();
        AlarmInformationIteratorHolder alarmInformationIteratorHolder = new AlarmInformationIteratorHolder();
        try {
            StructuredEventAdapter[] structuredEventAdapterArray = this.serviceContext.getAlarmIRPAdapter().get_alarm_list("", booleanHolder, alarmInformationIteratorHolder);
            Alarm[] alarmArray = new Alarm[structuredEventAdapterArray.length];
            for (int i = 0; i < structuredEventAdapterArray.length; ++i) {
                alarmArray[i] = new CelloAlarm(structuredEventAdapterArray[i], this.serviceContext);
            }
            return alarmArray;
        }
        catch (UserException userException) {
            throw new FmException(userException);
        }
    }

    public AlarmCounter getAlarmCounter() {
        IntHolder intHolder = new IntHolder();
        IntHolder intHolder2 = new IntHolder();
        IntHolder intHolder3 = new IntHolder();
        IntHolder intHolder4 = new IntHolder();
        IntHolder intHolder5 = new IntHolder();
        IntHolder intHolder6 = new IntHolder();
        try {
            this.serviceContext.getAlarmIRPOps().get_alarm_count("", intHolder, intHolder2, intHolder3, intHolder4, intHolder5, intHolder6);
            AlarmCounter alarmCounter = new AlarmCounter(intHolder.value, intHolder2.value, intHolder3.value, intHolder4.value, intHolder5.value, intHolder6.value);
            return alarmCounter;
        }
        catch (UserException userException) {
            throw new FmException(userException);
        }
    }

    public void setSeverity(SeverityInfo severityInfo) {
        try {
            this.serviceContext.getAlarmIRPExtOps().set_severity(severityInfo.getSpecificProblem(), (short)severityInfo.getSeverityDef());
        }
        catch (UserException userException) {
            throw new FmException(userException);
        }
    }

    public void removeSeverityConfiguration(String[] stringArray) {
        try {
            this.serviceContext.getAlarmIRPExtOps().remove_severity_configuration(stringArray);
        }
        catch (UserException userException) {
            throw new FmException(userException);
        }
    }

    public SeverityInfo[] getAllModifiedSeverity() {
        ArrayList<SeverityInfo> arrayList = new ArrayList<SeverityInfo>();
        try {
            CelloAlarmIRPExtension.SeverityInfo[] severityInfoArray = this.serviceContext.getAlarmIRPExtOps().get_all_modified_severity();
            for (int i = 0; i < severityInfoArray.length; ++i) {
                arrayList.add(new SeverityInfo(severityInfoArray[i].specific_problem, severityInfoArray[i].severity));
            }
        }
        catch (UserException userException) {
            throw new FmException(userException);
        }
        return arrayList.toArray(new SeverityInfo[0]);
    }

    boolean isAlive() {
        NealLog.finest("Checking if subscription " + this.getSubscriptionId() + " is alive");
        if (this.mySequencePushConsumer == null) {
            return false;
        }
        try {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            StringHolder stringHolder = new StringHolder();
            SubscriptionStateHolder subscriptionStateHolder = new SubscriptionStateHolder();
            IntHolder intHolder = new IntHolder();
            this.serviceContext.getNotificationIRPOps().get_subscription_status(this.getSubscriptionId(), stringHolder, subscriptionStateHolder, intHolder);
            NealLog.finest("Subscription status for ID" + this.getSubscriptionId() + " is ok");
            return true;
        }
        catch (InvalidParameter invalidParameter) {
            NealLog.warning("FmService got Exception in isAlive() for id " + this.getSubscriptionId(), invalidParameter);
            this.subscriptionLost = true;
            return false;
        }
        catch (UserException userException) {
            NealLog.warning("FmService got Exception in isAlive() for id " + this.getSubscriptionId(), userException);
            return false;
        }
    }

    private void notifyDisconnected() {
        Vector vector = new Vector(this.consumers);
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            FmNotificationConsumer fmNotificationConsumer = (FmNotificationConsumer)listIterator.next();
            try {
                fmNotificationConsumer.notifyDisconnected();
            }
            catch (Throwable throwable) {
                NealLog.warning("NEAL FmNotificationConsumer client failed in notifyDisconnect!", throwable);
            }
        }
    }

    private void notifySubscriptionLost() {
        Vector vector = new Vector(this.consumers);
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            FmNotificationConsumer fmNotificationConsumer = (FmNotificationConsumer)listIterator.next();
            try {
                fmNotificationConsumer.notifySubscriptionLost();
            }
            catch (Throwable throwable) {
                NealLog.warning("NEAL FmNotificationConsumer client failed in notifySubscriptionLost!", throwable);
            }
        }
    }

    public void push_structured_events(final StructuredEventAdapter[] structuredEventAdapterArray) {
        NealLog.finest("Received notification");
        Runnable runnable = new Runnable(){

            public void run() {
                ListIterator listIterator = CelloFmService.this.consumers.listIterator();
                while (listIterator.hasNext()) {
                    FmNotificationConsumer fmNotificationConsumer = (FmNotificationConsumer)listIterator.next();
                    block7: for (int i = 0; i < structuredEventAdapterArray.length; ++i) {
                        FmNotificationImpl fmNotificationImpl;
                        String string = structuredEventAdapterArray[i].header.fixed_header.event_name;
                        if ("z1".equals(string)) {
                            fmNotificationImpl = new CelloEvent(structuredEventAdapterArray[i], CelloFmService.this.serviceContext);
                            fmNotificationConsumer.notifyEvent((Event)((java.lang.Object)fmNotificationImpl));
                            continue;
                        }
                        if ("x5".equals(string)) {
                            fmNotificationConsumer.alarmListRebuilt(CelloFmService.this.serviceContext.getNode());
                            continue;
                        }
                        fmNotificationImpl = new CelloAlarm(structuredEventAdapterArray[i], CelloFmService.this.serviceContext);
                        switch (fmNotificationImpl.getExtendedEventType().getValue()) {
                            case 1: {
                                fmNotificationConsumer.notifyNewAlarm((Alarm)((java.lang.Object)fmNotificationImpl));
                                continue block7;
                            }
                            case 2: {
                                fmNotificationConsumer.notifyChangedAlarm((Alarm)((java.lang.Object)fmNotificationImpl));
                                continue block7;
                            }
                            case 3: {
                                fmNotificationConsumer.notifyAckStateChanged((Alarm)((java.lang.Object)fmNotificationImpl));
                                continue block7;
                            }
                            case 4: {
                                fmNotificationConsumer.notifyClearedAlarm((Alarm)((java.lang.Object)fmNotificationImpl));
                                continue block7;
                            }
                            default: {
                                NealLog.warning("NEAL Received Event with unexpected eventName=" + string + " to push_structured_events!");
                            }
                        }
                    }
                }
            }
        };
        this.taskRunner.start(runnable);
    }

    public void disconnect_sequence_push_consumer() {
        if (this.mySequencePushConsumer != null) {
            try {
                this.serviceContext.getNotificationIRPOps().detach(this.mySequencePushConsumer, this.getSubscriptionId());
                NealLog.fine("Unsubscribed FM subscription with ID:" + this.getSubscriptionId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serviceContext.disconnect(this.serviceContext.reference_to_servant(this.mySequencePushConsumer));
            this.mySequencePushConsumer = null;
        }
        if (this._timer != null) {
            this._timer.shutDown();
        }
        if (this.subscriptionLost) {
            NealLog.fine("Subscription has been removed on the server-side.");
            this.notifySubscriptionLost();
        } else {
            NealLog.fine("Connection towards the node is lost.");
            this.notifyDisconnected();
        }
    }

    public void offer_change(EventTypeAdapter[] eventTypeAdapterArray, EventTypeAdapter[] eventTypeAdapterArray2) {
        NealLog.finest("offer_change to fmService");
    }

    synchronized void addConsumer(FmNotificationConsumer fmNotificationConsumer) {
        if (!this.consumers.contains(fmNotificationConsumer)) {
            this.consumers.add(fmNotificationConsumer);
        }
    }

    synchronized boolean removeConsumer(FmNotificationConsumer fmNotificationConsumer) {
        return this.consumers.remove(fmNotificationConsumer);
    }

    synchronized boolean hasConsumers() {
        return !this.consumers.isEmpty();
    }

    synchronized boolean includesConsumer(FmNotificationConsumer fmNotificationConsumer) {
        return this.consumers.contains(fmNotificationConsumer);
    }

    String getSubscriptionId() {
        return this.mySubscriptionId;
    }

    class TickerReceiver
    implements Runnable {
        TickerReceiver() {
        }

        public void run() {
            try {
                if (!CelloFmService.this.isAlive()) {
                    CelloFmService.this.disconnect_sequence_push_consumer();
                }
            }
            catch (Throwable throwable) {
                NealLog.warning("Lost NEAL's remote Fm subscription for " + CelloFmService.this + "!", throwable);
                CelloFmService.this.disconnect_sequence_push_consumer();
            }
        }
    }
}

