/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.internal;

import java.util.ArrayList;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.TaskRunner;
import se.ericsson.cello.neal.internal.TaskRunnerFactory;

public class DelayedTaskRunner
implements TaskRunner {
    public final String taskType;
    private int taskNum = 0;
    private ArrayList queue = new ArrayList();

    DelayedTaskRunner(String string) {
        this.taskType = string;
    }

    public synchronized void start(Runnable runnable) {
        this.queue.add(runnable);
        this.notify();
    }

    public synchronized int awaitTasks(long l, long l2) throws Exception {
        int n = 0;
        int n2 = 0;
        if (this.queue.size() == 0) {
            this.wait(l);
        }
        n2 = n = this.runTasks();
        while (n != 0) {
            this.wait(l2);
            n2 = n = this.runTasks();
        }
        return n2;
    }

    public synchronized int runTasks() throws Exception {
        int n = 0;
        while (this.queue.size() != 0) {
            Runnable runnable = (Runnable)this.queue.remove(0);
            ++n;
            this.runTask(runnable);
        }
        return n;
    }

    void runTask(Runnable runnable) {
        block3: {
            try {
                ++this.taskNum;
                runnable.run();
            }
            catch (Throwable throwable) {
                NealLog.warning("Failed executing " + this.taskType + " number " + this.taskNum + "!" + "\n   Task=" + runnable, throwable);
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (!(throwable instanceof Error)) break block3;
                throw (Error)throwable;
            }
        }
    }

    public static TaskRunnerFactory getFactory() {
        return new TaskRunnerFactory(){

            public TaskRunner createTaskRunner(String string) {
                return new DelayedTaskRunner(string);
            }
        };
    }
}

