/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.pm;

import PerformanceIRPConstDefs.Filter;
import PerformanceIRPConstDefs.ObservationObject;
import PerformanceIRPConstDefs.RecordingType;
import PmServiceExtended.DestinationAddress;
import PmServiceExtended.OutputMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import se.ericsson.cello.neal.pm.PmFilter;
import se.ericsson.cello.neal.pm.PmFilterInfo;
import se.ericsson.cello.neal.pm.PmObservationObject;

class PmFilterInfoImpl
implements PmFilterInfo {
    private RecordingType recordingType;
    private ObservationObject triggeringObject;
    private ArrayList observationObjectList = new ArrayList();
    private Filter filter;
    private int[] timeWindow;
    private int samplingRate;
    private String destinationAddress;
    private OutputMode outputMode;
    private String traceReference;
    private int destinationPort;

    PmFilterInfoImpl(PmFilterInfo.PmRecordingType pmRecordingType) {
        this.setRecordingType(pmRecordingType);
        this.setTriggeringObject(new String[0], new String[0]);
        this.setFilter(new String[0], new String[0]);
        this.setTimeWindow(new int[0]);
        this.setSamplingRate(0);
        this.setDestinationAddress("", 0);
        this.setTraceReference("");
        this.setOutputMode(PmFilterInfo.PmOutputMode.FILE);
    }

    PmFilterInfoImpl(RecordingType recordingType, ObservationObject observationObject, ObservationObject[] observationObjectArray, Filter filter, int[] nArray, int n) {
        this.recordingType = recordingType;
        this.triggeringObject = observationObject;
        this.observationObjectList.addAll(Arrays.asList(observationObjectArray));
        this.filter = filter;
        this.timeWindow = nArray;
        this.samplingRate = n;
    }

    PmFilterInfoImpl(RecordingType recordingType, ObservationObject observationObject, ObservationObject[] observationObjectArray, Filter filter, int[] nArray, int n, OutputMode outputMode, DestinationAddress destinationAddress, String string) {
        this.recordingType = recordingType;
        this.triggeringObject = observationObject;
        this.observationObjectList.addAll(Arrays.asList(observationObjectArray));
        this.filter = filter;
        this.timeWindow = nArray;
        this.samplingRate = n;
        this.outputMode = outputMode;
        this.destinationAddress = destinationAddress.ip_address;
        this.destinationPort = destinationAddress.port;
        this.traceReference = string;
    }

    public PmFilterInfo addObservationObject(String[] stringArray, String[] stringArray2) {
        this.observationObjectList.add(new ObservationObject(stringArray, stringArray2));
        return this;
    }

    public PmFilterInfo clearObservationObjectList() {
        this.observationObjectList.clear();
        return this;
    }

    public PmFilterInfo setFilter(String[] stringArray, String[] stringArray2) {
        this.filter = new Filter(stringArray, stringArray2);
        return this;
    }

    public PmFilterInfo setRecordingType(PmFilterInfo.PmRecordingType pmRecordingType) {
        this.recordingType = RecordingType.from_int((int)pmRecordingType.value);
        return this;
    }

    public PmFilterInfo setSamplingRate(int n) {
        this.samplingRate = n;
        return this;
    }

    public PmFilterInfo setTimeWindow(int[] nArray) {
        this.timeWindow = nArray;
        return this;
    }

    public PmFilterInfo setTriggeringObject(String[] stringArray, String[] stringArray2) {
        this.triggeringObject = new ObservationObject(stringArray, stringArray2);
        return this;
    }

    public PmFilterInfo.PmRecordingType getRecordingType() {
        int n = this.recordingType.value();
        PmFilterInfo.PmRecordingType pmRecordingType = PmFilterInfo.PmRecordingType.from_int(n);
        return pmRecordingType;
    }

    public PmObservationObject getTriggeringObject() {
        return PmFilterInfoImpl.toNealFormat(this.triggeringObject);
    }

    public PmObservationObject[] getObservationObjectList() {
        int n = this.observationObjectList.size();
        PmObservationObject[] pmObservationObjectArray = new PmObservationObject[n];
        int n2 = 0;
        Iterator iterator = this.observationObjectList.iterator();
        while (iterator.hasNext()) {
            pmObservationObjectArray[n2++] = PmFilterInfoImpl.toNealFormat((ObservationObject)iterator.next());
        }
        return pmObservationObjectArray;
    }

    public PmFilter getFilter() {
        PmFilterImpl pmFilterImpl = new PmFilterImpl(this.filter);
        return pmFilterImpl;
    }

    public int[] getTimeWindow() {
        return this.timeWindow;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public String getDestinationAddress() {
        return this.destinationAddress;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public PmFilterInfo.PmOutputMode getOutputMode() {
        return PmFilterInfo.PmOutputMode.from_int(this.outputMode.value());
    }

    public String getTraceReference() {
        return this.traceReference;
    }

    public PmFilterInfo setDestinationAddress(String string, int n) {
        this.destinationAddress = string;
        this.destinationPort = n;
        return this;
    }

    public PmFilterInfo setOutputMode(PmFilterInfo.PmOutputMode pmOutputMode) {
        this.outputMode = OutputMode.from_int((int)pmOutputMode.value);
        return this;
    }

    public PmFilterInfo setTraceReference(String string) {
        this.traceReference = string;
        return this;
    }

    private static PmObservationObject toNealFormat(ObservationObject observationObject) {
        PmObservationObjectImpl pmObservationObjectImpl = new PmObservationObjectImpl(observationObject);
        return pmObservationObjectImpl;
    }

    private static class PmFilterImpl
    implements PmFilter {
        private Filter omsiFilter;

        public PmFilterImpl(Filter filter) {
            this.omsiFilter = filter;
        }

        public String[] getAttributeName() {
            return this.omsiFilter.attribute_name;
        }

        public String[] getAttributeValue() {
            return this.omsiFilter.attribute_value;
        }
    }

    private static class PmObservationObjectImpl
    implements PmObservationObject {
        private ObservationObject omsiOO;

        public PmObservationObjectImpl(ObservationObject observationObject) {
            this.omsiOO = observationObject;
        }

        public String[] getInstanceAttributeList() {
            return this.omsiOO.instance_attribute_list;
        }

        public String[] getInstanceList() {
            return this.omsiOO.instance_list;
        }
    }
}

